/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.fdf;

import java.io.IOException;
import java.io.Writer;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.fdf.FDFDictionary;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.w3c.dom.Element;

public class FDFCatalog
implements COSObjectable {
    private final COSDictionary catalog;

    public FDFCatalog() {
        this.catalog = new COSDictionary();
    }

    public FDFCatalog(COSDictionary cat) {
        this.catalog = cat;
    }

    public FDFCatalog(Element element) {
        this();
        FDFDictionary fdfDict = new FDFDictionary(element);
        this.setFDF(fdfDict);
    }

    public void writeXML(Writer output) throws IOException {
        FDFDictionary fdf = this.getFDF();
        fdf.writeXML(output);
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.catalog;
    }

    public String getVersion() {
        return this.catalog.getNameAsString(COSName.VERSION);
    }

    public void setVersion(String version) {
        this.catalog.setName(COSName.VERSION, version);
    }

    public FDFDictionary getFDF() {
        FDFDictionary retval;
        COSDictionary fdf = this.catalog.getCOSDictionary(COSName.FDF);
        if (fdf != null) {
            retval = new FDFDictionary(fdf);
        } else {
            retval = new FDFDictionary();
            this.setFDF(retval);
        }
        return retval;
    }

    public final void setFDF(FDFDictionary fdf) {
        this.catalog.setItem(COSName.FDF, (COSObjectable)fdf);
    }

    public PDSignature getSignature() {
        COSDictionary sig = this.catalog.getCOSDictionary(COSName.SIG);
        return sig != null ? new PDSignature(sig) : null;
    }

    public void setSignature(PDSignature sig) {
        this.catalog.setItem(COSName.SIG, (COSObjectable)sig);
    }
}

