/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;

class PDFDOMUtil {
    PDFDOMUtil() {
    }

    static List<COSDictionary> findType(COSBase cosBase, Set<COSName> types, int maxDepth) {
        ArrayList<COSDictionary> found = new ArrayList<COSDictionary>();
        HashSet<COSBase> seen = new HashSet<COSBase>();
        PDFDOMUtil.find(cosBase, types, 0, maxDepth, seen, found);
        return found;
    }

    private static void find(COSBase cosBase, Set<COSName> types, int depth, int maxDepth, Set<COSBase> seen, List<COSDictionary> found) {
        block8: {
            block9: {
                block7: {
                    if (seen.contains(cosBase)) {
                        return;
                    }
                    if (depth >= maxDepth) {
                        return;
                    }
                    seen.add(cosBase);
                    if (!(cosBase instanceof COSObject)) break block7;
                    COSBase dereferencedBase = ((COSObject)cosBase).getObject();
                    PDFDOMUtil.find(dereferencedBase, types, depth + 1, maxDepth, seen, found);
                    break block8;
                }
                if (!(cosBase instanceof COSDictionary)) break block9;
                COSDictionary dict = (COSDictionary)cosBase;
                COSName value = dict.getCOSName(COSName.TYPE);
                if (value != null && types.contains(value)) {
                    found.add(dict);
                } else {
                    if (value != null && (value.equals(COSName.P) || value.equals(COSName.PAGE) || value.equals(COSName.PARENT))) {
                        return;
                    }
                    for (Map.Entry<COSName, COSBase> e : dict.entrySet()) {
                        PDFDOMUtil.find(e.getValue(), types, depth + 1, maxDepth, seen, found);
                    }
                }
                break block8;
            }
            if (!(cosBase instanceof COSArray)) break block8;
            for (COSBase item : (COSArray)cosBase) {
                PDFDOMUtil.find(item, types, depth + 1, maxDepth, seen, found);
            }
        }
    }
}

