/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.view.facelets.Facelet;
import java.io.IOException;
import java.util.Map;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.view.facelets.AbstractFacelet;
import org.apache.myfaces.view.facelets.DynamicComponentRefreshTransientBuildEvent;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.FaceletDynamicComponentRefreshTransientBuildEvent;
import org.apache.myfaces.view.facelets.FaceletFactory;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguageBase;
import org.apache.myfaces.view.facelets.LocationAwareFacesException;
import org.apache.myfaces.view.facelets.compiler.RefreshDynamicComponentListener;
import org.apache.myfaces.view.facelets.tag.faces.ComponentSupport;

public class CreateDynamicCompositeComponentListener
implements ComponentSystemEventListener,
StateHolder {
    private String taglibURI;
    private String tagName;
    private Map<String, Object> attributes;
    private String baseKey;

    public CreateDynamicCompositeComponentListener(String taglibURI, String tagName, Map<String, Object> attributes, String baseKey) {
        this.taglibURI = taglibURI;
        this.tagName = tagName;
        this.attributes = attributes;
        this.baseKey = baseKey;
    }

    public CreateDynamicCompositeComponentListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(ComponentSystemEvent event) {
        Facelet componentFacelet;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FaceletViewDeclarationLanguage vdl = (FaceletViewDeclarationLanguage)facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, facesContext.getViewRoot().getViewId());
        FaceletFactory faceletFactory = vdl.getFaceletFactory();
        FaceletFactory.setInstance(faceletFactory);
        try {
            componentFacelet = faceletFactory.compileComponentFacelet(this.taglibURI, this.tagName, this.attributes);
        }
        finally {
            FaceletFactory.setInstance(null);
        }
        UIComponent component = event.getComponent();
        Integer step = (Integer)component.getAttributes().get("oamf.cc.CREATE_CC_POST_ADD_TO_VIEW");
        if (step == null || step != 0) {
            return;
        }
        component.getAttributes().put("oamf.cc.CREATE_CC_POST_ADD_TO_VIEW", 1);
        try {
            facesContext.getAttributes().put("org.apache.myfaces.REFRESHING_TRANSIENT_BUILD", Boolean.TRUE);
            UIComponent parent = component.getParent();
            String facetName = null;
            if (parent.getFacetCount() > 0 && !parent.getChildren().contains(component)) {
                facetName = ComponentSupport.findFacetNameByComponentInstance(parent, component);
            }
            try {
                String markId;
                if (facetName != null) {
                    parent.getAttributes().put("facelets.FACET_NAME", facetName);
                }
                if ((markId = (String)component.getAttributes().get("oam.vf.GEN_MARK_ID")) == null) {
                    ((AbstractFacelet)componentFacelet).applyDynamicComponentHandler(facesContext, component, this.baseKey);
                } else {
                    try {
                        component.getAttributes().put("oam.vf.MARK_ID", markId);
                        ((AbstractFacelet)componentFacelet).applyDynamicComponentHandler(facesContext, component.getParent(), this.baseKey);
                    }
                    finally {
                        component.getAttributes().put("oam.vf.MARK_ID", null);
                    }
                }
                if (FaceletViewDeclarationLanguageBase.isDynamicComponentNeedsRefresh(facesContext)) {
                    FaceletCompositionContext fcc = FaceletCompositionContext.getCurrentInstance(facesContext);
                    if (fcc == null) {
                        FaceletViewDeclarationLanguageBase.activateDynamicComponentRefreshTransientBuild(facesContext);
                        FaceletViewDeclarationLanguageBase.resetDynamicComponentNeedsRefreshFlag(facesContext);
                        component.subscribeToEvent(DynamicComponentRefreshTransientBuildEvent.class, (ComponentSystemEventListener)new RefreshDynamicComponentListener(this.taglibURI, this.tagName, this.attributes, this.baseKey));
                        component.getAttributes().put("oam.vf.DYN_COMP_REFRESH_FLAG", Boolean.TRUE);
                    } else {
                        component.subscribeToEvent(FaceletDynamicComponentRefreshTransientBuildEvent.class, (ComponentSystemEventListener)new RefreshDynamicComponentListener(this.taglibURI, this.tagName, this.attributes, this.baseKey));
                    }
                }
            }
            finally {
                if (facetName != null) {
                    parent.getAttributes().remove("facelets.FACET_NAME");
                }
            }
        }
        catch (IOException e) {
            throw new LocationAwareFacesException((Throwable)e, component);
        }
        finally {
            facesContext.getAttributes().remove("org.apache.myfaces.REFRESHING_TRANSIENT_BUILD");
        }
    }

    public Object saveState(FacesContext context) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(context.getExternalContext());
        Integer tagId = runtimeConfig.getIdByNamespace().get(this.taglibURI);
        Object[] values = new Object[]{tagId != null ? tagId : (this.taglibURI.startsWith("jakarta.faces.composite/") ? new Object[]{0, this.taglibURI.substring("jakarta.faces.composite/".length())} : (this.taglibURI.startsWith("http://xmlns.jcp.org/jsf/composite/") ? new Object[]{1, this.taglibURI.substring("http://xmlns.jcp.org/jsf/composite/".length())} : (this.taglibURI.startsWith("http://java.sun.com/jsf/composite/") ? new Object[]{2, this.taglibURI.substring("http://java.sun.com/jsf/composite/".length())} : this.taglibURI))), this.tagName, this.attributes, this.baseKey};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        if (values[0] instanceof String) {
            this.taglibURI = (String)values[0];
        } else if (values[0] instanceof Integer) {
            RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(context.getExternalContext());
            this.taglibURI = runtimeConfig.getNamespaceById().get((Integer)values[0]);
        } else if (values[0] instanceof Object[]) {
            String ns;
            Object[] def = (Object[])values[0];
            int index = (Integer)def[0];
            switch (index) {
                case 0: {
                    ns = "jakarta.faces.composite/";
                    break;
                }
                case 1: {
                    ns = "http://xmlns.jcp.org/jsf/composite/";
                    break;
                }
                case 2: {
                    ns = "http://java.sun.com/jsf/composite/";
                    break;
                }
                default: {
                    ns = "";
                }
            }
            this.taglibURI = ns + ((Object[])values[0])[1];
        }
        this.tagName = (String)values[1];
        this.attributes = (Map)values[2];
        this.baseKey = (String)values[3];
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

