/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.annotation.Metric;

class MpMetadata
implements Metadata {
    final String name;
    String description;
    String unit;
    boolean dirty = false;

    public static MpMetadata sanitize(Metadata metadata) {
        if (metadata instanceof MpMetadata) {
            return (MpMetadata)metadata;
        }
        return new MpMetadata(metadata);
    }

    MpMetadata(String name) {
        this.name = name;
    }

    MpMetadata(Metric annotation) {
        this.name = annotation.name();
        this.description = this.stringOrNull(annotation.description());
        this.unit = this.stringOrNull(annotation.unit());
    }

    MpMetadata(String name, String description, String unit) {
        this.name = name;
        this.description = this.stringOrNull(description);
        this.unit = this.stringOrNull(unit);
    }

    MpMetadata(Metadata other) {
        this.name = other.getName();
        this.description = other.description().orElse(null);
        this.unit = other.unit().orElse(null);
    }

    public boolean mergeSameType(Metadata metadata) {
        if (this.description == null) {
            this.dirty = true;
            this.description = this.stringOrNull(metadata.description().orElse(null));
        }
        if (this.unit == null) {
            this.dirty = true;
            this.unit = this.stringOrNull(metadata.unit().orElse(null));
        }
        return true;
    }

    public MpMetadata merge(Metric annotation) {
        if (this.description == null) {
            this.dirty = true;
            this.description = this.stringOrNull(annotation.description());
        }
        if (this.unit == null) {
            this.dirty = true;
            this.unit = this.stringOrNull(annotation.unit());
        }
        return this;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> unit() {
        return Optional.ofNullable(this.unit);
    }

    public boolean cleanDirtyMetadata() {
        boolean precheck = this.dirty;
        this.dirty = false;
        return precheck;
    }

    String stringOrNull(String s) {
        if (s == null || s.isEmpty() || "none".equals(s)) {
            return null;
        }
        return s;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MpMetadata that = (MpMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.unit, that.unit);
    }

    public boolean equalsTimers(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MpMetadata that = (MpMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name + "[" + (String)(this.description == null ? "" : "description=" + this.description + " ") + (String)(this.unit == null ? "" : "unit=" + this.unit + " ") + "]";
    }
}

