/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import org.apache.activemq.ActiveMQContext;
import org.apache.activemq.util.JMSExceptionSupport;

public class ActiveMQConsumer
implements JMSConsumer {
    private final ActiveMQContext activemqContext;
    private final MessageConsumer activemqMessageConsumer;

    ActiveMQConsumer(ActiveMQContext activemqContext, MessageConsumer activemqMessageConsumer) {
        this.activemqContext = activemqContext;
        this.activemqMessageConsumer = activemqMessageConsumer;
    }

    public String getMessageSelector() {
        try {
            return this.activemqMessageConsumer.getMessageSelector();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public MessageListener getMessageListener() throws JMSRuntimeException {
        try {
            return this.activemqMessageConsumer.getMessageListener();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        try {
            this.activemqMessageConsumer.setMessageListener(listener);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public Message receive() {
        try {
            return this.activemqMessageConsumer.receive();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public Message receive(long timeout) {
        try {
            return this.activemqMessageConsumer.receive(timeout);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public Message receiveNoWait() {
        try {
            return this.activemqMessageConsumer.receiveNoWait();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public void close() {
        try {
            this.activemqMessageConsumer.close();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.convertToJMSRuntimeException(e);
        }
    }

    public <T> T receiveBody(Class<T> c) {
        throw new UnsupportedOperationException("receiveBody(Class<T>) is not supported");
    }

    public <T> T receiveBody(Class<T> c, long timeout) {
        throw new UnsupportedOperationException("receiveBody(Class<T>, long) is not supported");
    }

    public <T> T receiveBodyNoWait(Class<T> c) {
        throw new UnsupportedOperationException("receiveBodyNoWait(Class<T>) is not supported");
    }
}

