/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi.openid;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.authentication.mechanism.http.OpenIdAuthenticationMechanismDefinition;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import jakarta.security.enterprise.identitystore.openid.IdentityToken;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.security.cdi.openid.TomEEOpenIdContext;
import org.apache.tomee.security.cdi.openid.storage.OpenIdStorageHandler;
import org.apache.tomee.security.http.openid.JwtValidators;
import org.apache.tomee.security.http.openid.model.TokenResponse;
import org.apache.tomee.security.http.openid.model.TomEEAccesToken;
import org.apache.tomee.security.http.openid.model.TomEEIdentityToken;
import org.apache.tomee.security.http.openid.model.TomEEOpenIdCredential;
import org.apache.tomee.security.http.openid.model.TomEERefreshToken;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

@ApplicationScoped
public class OpenIdIdentityStore
implements IdentityStore {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.TOMEE_SECURITY, OpenIdIdentityStore.class);
    @Inject
    private OpenIdAuthenticationMechanismDefinition definition;
    @Inject
    private TomEEOpenIdContext openIdContext;
    @Inject
    private OpenIdStorageHandler storageHandler;

    public CredentialValidationResult validate(Credential credential) {
        if (!(credential instanceof TomEEOpenIdCredential)) {
            return CredentialValidationResult.NOT_VALIDATED_RESULT;
        }
        TomEEOpenIdCredential openIdCredential = (TomEEOpenIdCredential)credential;
        JwtConsumer defaultJwtConsumer = this.buildJwtConsumer(null);
        JwtConsumer idTokenJwtConsumer = this.buildJwtConsumer(builder -> {
            if (!this.definition.useNonce()) {
                return;
            }
            HttpMessageContext msgContext = openIdCredential.getMessageContext();
            String expectedNonce = this.storageHandler.getStoredNonce(msgContext.getRequest(), msgContext.getResponse());
            builder.registerValidator(JwtValidators.nonce(expectedNonce));
        });
        this.openIdContext.setAccessToken(this.createAccessToken(defaultJwtConsumer, openIdCredential.getTokenResponse()));
        this.openIdContext.setIdentityToken(this.createIdentityToken(idTokenJwtConsumer, openIdCredential.getTokenResponse()));
        this.openIdContext.setRefreshToken(openIdCredential.getTokenResponse().getRefreshToken().map(TomEERefreshToken::new));
        if (this.openIdContext.getIdentityToken() == null) {
            return CredentialValidationResult.INVALID_RESULT;
        }
        this.openIdContext.setUserInfoClaims(this.fetchUserinfoClaims(defaultJwtConsumer, this.openIdContext.getAccessToken().getToken()));
        String callerNameClaim = this.definition.claimsDefinition().callerNameClaim();
        String groupsClaim = this.definition.claimsDefinition().callerGroupsClaim();
        String callerName = null;
        List groups = Collections.emptyList();
        if (this.openIdContext.getAccessToken().isJWT()) {
            callerName = this.openIdContext.getAccessToken().getJwtClaims().getStringClaim(callerNameClaim).orElse(null);
            groups = this.openIdContext.getAccessToken().getJwtClaims().getArrayStringClaim(groupsClaim);
        }
        if (callerName == null) {
            callerName = this.openIdContext.getIdentityToken().getJwtClaims().getStringClaim(callerNameClaim).orElse(null);
        }
        if (groups.isEmpty()) {
            groups = this.openIdContext.getIdentityToken().getJwtClaims().getArrayStringClaim(groupsClaim);
        }
        if (callerName == null) {
            callerName = this.openIdContext.getClaims().getStringClaim(callerNameClaim).orElse(null);
        }
        if (groups.isEmpty()) {
            groups = this.openIdContext.getClaims().getArrayStringClaim(groupsClaim);
        }
        if (callerName == null) {
            callerName = this.openIdContext.getSubject();
        }
        return new CredentialValidationResult(callerName, new HashSet(groups));
    }

    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        return validationResult.getCallerGroups();
    }

    private AccessToken createAccessToken(JwtConsumer jwtConsumer, TokenResponse tokenResponse) {
        boolean validJwt = false;
        try {
            jwtConsumer.process(tokenResponse.getAccesToken());
            validJwt = true;
        }
        catch (InvalidJwtException e) {
            LOGGER.warning("access_token is invalid: " + e.getMessage());
        }
        return new TomEEAccesToken(validJwt, tokenResponse.getAccesToken(), "Bearer".equals(tokenResponse.getTokenType()) ? AccessToken.Type.BEARER : AccessToken.Type.MAC, tokenResponse.getScope(), tokenResponse.getExpiresIn(), this.definition.tokenMinValidity());
    }

    private IdentityToken createIdentityToken(JwtConsumer jwtConsumer, TokenResponse tokenResponse) {
        try {
            JwtContext idToken = jwtConsumer.process(tokenResponse.getIdToken());
            return new TomEEIdentityToken(idToken.getJwt(), this.definition.tokenMinValidity());
        }
        catch (InvalidJwtException e) {
            LOGGER.warning("id_token is invalid: " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonObject fetchUserinfoClaims(JwtConsumer jwtConsumer, String accessToken) {
        try (Client client = ClientBuilder.newClient();){
            JsonObject jsonObject;
            Response response = client.target(this.definition.providerMetadata().userinfoEndpoint()).request(new String[]{"application/json", "application/jwt"}).header("Authorization", (Object)("Bearer " + accessToken)).get();
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                LOGGER.warning("Could not fetch userinfo, response was " + response.getStatus() + "\n" + (String)response.readEntity(String.class));
                JsonObject jsonObject2 = null;
                return jsonObject2;
            }
            String contentType = response.getHeaderString("Content-Type");
            if (contentType == null || contentType.startsWith("application/json")) {
                JsonObject jsonObject3 = (JsonObject)response.readEntity(JsonObject.class);
                return jsonObject3;
            }
            if (!"application/jwt".startsWith(contentType)) throw new IllegalStateException("Illegal response from userinfo endpoint received with Content-Type " + contentType + ", supported values are application/json and application/jwt");
            JwtContext context = jwtConsumer.process((String)response.readEntity(String.class));
            JsonReader reader = Json.createReader((Reader)new StringReader(context.getJwtClaims().getRawJson()));
            try {
                jsonObject = reader.readObject();
                if (reader == null) return jsonObject;
            }
            catch (Throwable throwable) {
                try {
                    if (reader == null) throw throwable;
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (InvalidJwtException e) {
                    LOGGER.warning("userinfo endpoint response was of type application/jwt but jwt could not be verified", (Throwable)e);
                    JsonObject jsonObject4 = null;
                    if (client == null) return jsonObject4;
                    client.close();
                    return jsonObject4;
                }
            }
            reader.close();
            return jsonObject;
        }
    }

    protected JwtConsumer buildJwtConsumer(Consumer<JwtConsumerBuilder> enhancer) {
        HttpsJwks jwks = new HttpsJwks(this.definition.providerMetadata().jwksURI());
        Get get = new Get();
        get.setConnectTimeout(this.definition.jwksConnectTimeout());
        get.setReadTimeout(this.definition.jwksReadTimeout());
        jwks.setSimpleHttpGet((SimpleGet)get);
        HttpsJwksVerificationKeyResolver keyResolver = new HttpsJwksVerificationKeyResolver(jwks);
        JwtConsumerBuilder builder = new JwtConsumerBuilder().setRequireSubject().setRequireIssuedAt().setRequireExpirationTime().setVerificationKeyResolver((VerificationKeyResolver)keyResolver).setExpectedIssuer(this.definition.providerMetadata().issuer()).setExpectedAudience(new String[]{this.definition.clientId()}).registerValidator(JwtValidators.azp(this.definition.clientId())).registerValidator(JwtValidators.EXPIRATION).registerValidator(JwtValidators.ISSUED_AT).registerValidator(JwtValidators.NOT_BEOFRE);
        if (enhancer != null) {
            enhancer.accept(builder);
        }
        return builder.build();
    }
}

