/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.http.openid.model;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.security.enterprise.identitystore.openid.IdentityToken;
import jakarta.security.enterprise.identitystore.openid.JwtClaims;
import java.io.Reader;
import java.io.StringReader;
import java.util.Base64;
import java.util.Map;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.security.http.openid.model.TomEEJwtClaims;

public class TomEEIdentityToken
implements IdentityToken {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.TOMEE_SECURITY, TomEEIdentityToken.class);
    private final String token;
    private final long minValidity;
    private JwtClaims jwtClaims;
    private Map<String, Object> rawClaims;

    public TomEEIdentityToken(String token, long minValidity) {
        this.token = token;
        this.minValidity = minValidity;
        String json = new String(Base64.getUrlDecoder().decode(token.split("\\.")[1]));
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));
             Jsonb jsonb = JsonbBuilder.create();){
            this.jwtClaims = new TomEEJwtClaims(reader.readObject());
            this.rawClaims = (Map)jsonb.fromJson(json, Map.class);
        }
        catch (Exception e) {
            LOGGER.error("Could not parse idToken claims", (Throwable)e);
        }
    }

    public String getToken() {
        return this.token;
    }

    public JwtClaims getJwtClaims() {
        return this.jwtClaims;
    }

    public boolean isExpired() {
        return this.jwtClaims.getExpirationTime().map(it -> System.currentTimeMillis() + this.minValidity > it.toEpochMilli()).orElseThrow(() -> new IllegalStateException("No exp claim in identity token found"));
    }

    public Map<String, Object> getClaims() {
        return this.rawClaims;
    }
}

