/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.log;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XidImpl2
implements Xid,
Serializable {
    private static int HEADER_SIZE = 4;
    private static int ACTION_POS = 0;
    private static int GLOBALID_SIZE_POS = 1;
    private static int BRANCHID_SIZE_POS = 2;
    private static int FORMAT_ID = 1197822575;
    private static int FORMAT_SIZE = 4;
    private static byte[] FORMAT_ID_BYTES = "Gero".getBytes();
    private final byte[] buffer = new byte[HEADER_SIZE + FORMAT_SIZE + 64 + 64];
    private int hash;
    private Object key;

    public XidImpl2(byte[] globalId) {
        System.arraycopy(FORMAT_ID_BYTES, 0, this.buffer, HEADER_SIZE, FORMAT_SIZE);
        this.buffer[XidImpl2.GLOBALID_SIZE_POS] = (byte)globalId.length;
        System.arraycopy(globalId, 0, this.buffer, HEADER_SIZE + FORMAT_SIZE, 64);
        this.check();
    }

    private void check() {
        if (this.buffer[GLOBALID_SIZE_POS] > 64) {
            throw new IllegalStateException("Global ID too large: " + this.buffer[GLOBALID_SIZE_POS]);
        }
        if (this.buffer[BRANCHID_SIZE_POS] > 64) {
            throw new IllegalStateException("Branch ID too large: " + this.buffer[GLOBALID_SIZE_POS]);
        }
    }

    public XidImpl2(Xid global, byte[] branch) {
        if (global instanceof XidImpl2) {
            System.arraycopy(((XidImpl2)global).buffer, 0, this.buffer, 0, HEADER_SIZE + FORMAT_SIZE + 64);
        } else {
            System.arraycopy(FORMAT_ID_BYTES, 0, this.buffer, HEADER_SIZE, FORMAT_SIZE);
            byte[] globalId = global.getGlobalTransactionId();
            System.arraycopy(globalId, 0, this.buffer, HEADER_SIZE + FORMAT_SIZE, globalId.length);
        }
        this.buffer[XidImpl2.BRANCHID_SIZE_POS] = (byte)branch.length;
        System.arraycopy(branch, 0, this.buffer, HEADER_SIZE + FORMAT_SIZE + 64, 64);
        this.check();
    }

    public XidImpl2(int formatId, byte[] globalId, byte[] branch) {
        System.arraycopy(FORMAT_ID_BYTES, 0, this.buffer, HEADER_SIZE, FORMAT_SIZE);
        System.arraycopy(globalId, 0, this.buffer, HEADER_SIZE + FORMAT_SIZE, globalId.length);
        this.buffer[XidImpl2.BRANCHID_SIZE_POS] = (byte)branch.length;
        System.arraycopy(branch, 0, this.buffer, HEADER_SIZE + FORMAT_SIZE + 64, 64);
        this.check();
    }

    private int hash(byte[] id) {
        int hash = 0;
        for (int i = 0; i < id.length; ++i) {
            hash = hash * 37 + id[i];
        }
        return hash;
    }

    @Override
    public int getFormatId() {
        return FORMAT_ID;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        byte[] globalId = new byte[this.buffer[GLOBALID_SIZE_POS]];
        System.arraycopy(this.buffer, HEADER_SIZE + FORMAT_SIZE, globalId, 0, this.buffer[GLOBALID_SIZE_POS]);
        return globalId;
    }

    @Override
    public byte[] getBranchQualifier() {
        byte[] branchId = new byte[this.buffer[BRANCHID_SIZE_POS]];
        System.arraycopy(this.buffer, HEADER_SIZE + FORMAT_SIZE + 64, branchId, 0, this.buffer[BRANCHID_SIZE_POS]);
        return branchId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XidImpl2)) {
            return false;
        }
        XidImpl2 other = (XidImpl2)obj;
        return Arrays.equals(this.buffer, other.buffer);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.hash(this.buffer);
        }
        return this.hash;
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer("[XidImpl2:formatId=Gero,");
        s.append("globalId=");
        for (i = FORMAT_SIZE; i < FORMAT_SIZE + 64; ++i) {
            s.append(Integer.toHexString(this.buffer[i]));
        }
        s.append(",branchId=");
        for (i = FORMAT_SIZE + 64; i < this.buffer.length; ++i) {
            s.append(Integer.toHexString(this.buffer[i]));
        }
        s.append("]");
        return s.toString();
    }

    byte[] getBuffer(byte action) {
        this.buffer[XidImpl2.ACTION_POS] = action;
        return this.buffer;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Object getKey() {
        return this.key;
    }
}

