/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.jul.formatter.log;

import java.lang.reflect.Method;
import org.apache.juli.logging.Log;
import org.apache.tomee.jul.formatter.log.JULLogger;
import org.apache.tomee.jul.formatter.log.ReloadableLog;

public class TomEELog
implements Log {
    private static volatile boolean initialized;
    private static volatile String loggerClazz;
    private static volatile boolean defaultLogger;
    private final Log delegate;

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        if (!Boolean.getBoolean("tomee.skip-tomcat-log")) {
            Thread thread = Thread.currentThread();
            try {
                Method m;
                Class<?> logger;
                ClassLoader tccl = thread.getContextClassLoader();
                Class<?> systemInstance = tccl.loadClass("org.apache.openejb.loader.SystemInstance");
                if (!((Boolean)Boolean.class.cast(systemInstance.getMethod("isInitialized", new Class[0]).invoke(null, new Object[0]))).booleanValue()) {
                    logger = tccl.loadClass("org.apache.openejb.util.Logger");
                    m = logger.getDeclaredMethod("unsafeDelegateClass", new Class[0]);
                    loggerClazz = m.invoke(null, new Object[0]).getClass().getName();
                }
                if (loggerClazz == null) {
                    logger = tccl.loadClass("org.apache.openejb.util.Logger");
                    m = logger.getDeclaredMethod("delegateClass", new Class[0]);
                    loggerClazz = (String)m.invoke(null, new Object[0]);
                }
                switch (loggerClazz) {
                    case "org.apache.openejb.util.Log4j2LogStreamFactory": 
                    case "org.apache.openejb.util.Log4jLogStreamFactory": 
                    case "org.apache.openejb.util.Slf4jLogStreamFactory": 
                    case "org.apache.openejb.maven.util.MavenLogStreamFactory": {
                        defaultLogger = false;
                        break;
                    }
                    default: {
                        defaultLogger = true;
                    }
                }
                initialized = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static String getLoggerClazz() {
        return loggerClazz;
    }

    public TomEELog() {
        this.delegate = null;
    }

    public TomEELog(String name) {
        TomEELog.initialize();
        this.delegate = defaultLogger ? new JULLogger(name) : ReloadableLog.newLog(name, loggerClazz);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.delegate.isFatalEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    @Override
    public void trace(Object message) {
        this.delegate.trace(message);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.delegate.trace(message, t);
    }

    @Override
    public void debug(Object message) {
        this.delegate.debug(message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.delegate.debug(message, t);
    }

    @Override
    public void info(Object message) {
        this.delegate.info(message);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.delegate.info(message, t);
    }

    @Override
    public void warn(Object message) {
        this.delegate.warn(message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.delegate.warn(message, t);
    }

    @Override
    public void error(Object message) {
        this.delegate.error(message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.delegate.error(message, t);
    }

    @Override
    public void fatal(Object message) {
        this.delegate.fatal(message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.delegate.fatal(message, t);
    }
}

