/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.parameters;

import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.parameters.RequestBodyImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.ReferenceType;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class RequestBodyIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<RequestBody, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_REQUIRED = "required";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_CONTENT = "content";
    private static final String PROP_VALUE = "value";
    private final ContentIO<V, A, O, AB, OB> contentIO;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public RequestBodyIO(IOContext<V, A, O, AB, OB> context, ContentIO<V, A, O, AB, OB> contentIO, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.REQUEST_BODY, Names.create(RequestBody.class));
        this.contentIO = contentIO;
        this.extensionIO = extensionIO;
    }

    Stream<AnnotationInstance> getAnnotations(MethodInfo method, DotName annotation) {
        Stream<AnnotationInstance> methodAnnos = Stream.of(this.scannerContext().annotations().getAnnotation((AnnotationTarget)method, annotation));
        Stream<AnnotationInstance> paramAnnos = IntStream.range(0, method.parametersCount()).mapToObj(p -> this.scannerContext().annotations().getMethodParameterAnnotation(method, p, annotation));
        return Stream.concat(methodAnnos, paramAnnos).filter(Objects::nonNull);
    }

    @Override
    public List<AnnotationInstance> getRepeatableAnnotations(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            return this.getAnnotations(target.asMethod(), Names.REQUEST_BODY).collect(Collectors.toList());
        }
        return Collections.singletonList(this.scannerContext().annotations().getAnnotation(target, Names.REQUEST_BODY));
    }

    @Override
    public RequestBody read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@RequestBody");
        RequestBodyImpl requestBody = new RequestBodyImpl();
        requestBody.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        requestBody.setContent(this.contentIO.read(annotation.value(PROP_CONTENT), ContentIO.Direction.INPUT));
        requestBody.setRequired((Boolean)this.value(annotation, PROP_REQUIRED));
        requestBody.setRef(ReferenceType.REQUEST_BODY.refValue(annotation));
        requestBody.setExtensions(this.extensionIO.readExtensible(annotation));
        return requestBody;
    }

    public RequestBody readRequestSchema(MethodInfo target) {
        if (this.scannerContext().getCurrentConsumes() == null) {
            return null;
        }
        return this.getAnnotations(target, Names.REQUEST_BODY_SCHEMA).map(this::readRequestSchema).findFirst().orElse(null);
    }

    private RequestBody readRequestSchema(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@RequestBodySchema");
        ContentImpl content = new ContentImpl();
        for (String mediaType : this.scannerContext().getCurrentConsumes()) {
            MediaTypeImpl type = new MediaTypeImpl();
            type.setSchema(SchemaFactory.typeToSchema(this.scannerContext(), (Type)this.value(annotation, PROP_VALUE), null, this.scannerContext().getExtensions()));
            content.addMediaType(mediaType, type);
        }
        return new RequestBodyImpl().content(content);
    }

    @Override
    public RequestBody readObject(O node) {
        RequestBodyImpl requestBody = new RequestBodyImpl();
        requestBody.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        requestBody.setContent((Content)this.contentIO.readValue(this.jsonIO().getValue(node, PROP_CONTENT)));
        requestBody.setRequired(this.jsonIO().getBoolean(node, PROP_REQUIRED));
        requestBody.setRef(this.readReference(node));
        requestBody.setExtensions(this.extensionIO.readMap(node));
        return requestBody;
    }

    @Override
    public Optional<O> write(RequestBody model) {
        return this.optionalJsonObject(model).map(node -> {
            if (this.isReference((Reference<?>)model)) {
                this.setReference(node, (Reference<?>)model);
            } else {
                this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
                this.setIfPresent(node, PROP_CONTENT, this.contentIO.write(model.getContent()));
                this.setIfPresent(node, PROP_REQUIRED, this.jsonIO().toJson(model.getRequired()));
                this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            }
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

