/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin.model;

import com.github.tomakehurst.wiremock.admin.Paginator;
import java.util.List;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonInclude;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class PaginatedResult<T> {
    private final List<T> selection;
    private final Meta meta;

    protected PaginatedResult(Paginator<T> paginator) {
        this.selection = paginator.select();
        this.meta = new Meta(paginator.getTotal());
    }

    protected PaginatedResult(List<T> source, Meta meta) {
        this.selection = source;
        this.meta = meta;
    }

    public Meta getMeta() {
        return this.meta;
    }

    protected List<T> select() {
        return this.selection;
    }

    public static class Meta {
        public final int total;

        @JsonCreator
        public Meta(@JsonProperty(value="total") int total) {
            this.total = total;
        }
    }
}

