/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.tez.common.AsyncDispatcher;
import org.apache.tez.common.RssTezConfig;
import org.apache.tez.common.RssTezUtils;
import org.apache.tez.common.TezClassLoader;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.TezRemoteShuffleManager;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.state.OnStateChangedCallback;
import org.apache.tez.state.StateMachineTez;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.util.ClientUtils;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssDAGAppMaster
extends DAGAppMaster {
    private static final Logger LOG = LoggerFactory.getLogger(RssDAGAppMaster.class);
    public static final int RSS_SHUTDOWN_HOOK_PRIORITY = 50;
    private ShuffleWriteClient shuffleWriteClient;
    private TezRemoteShuffleManager tezRemoteShuffleManager;
    private Map<String, String> clusterClientConf;
    final ScheduledExecutorService heartBeatExecutorService = Executors.newSingleThreadScheduledExecutor(ThreadUtils.getThreadFactory("AppHeartbeat"));

    public RssDAGAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, Clock clock, long appSubmitTime, boolean isSession, String workingDirectory, String[] localDirs, String[] logDirs, String clientVersion, Credentials credentials, String jobUserName, DAGProtos.AMPluginDescriptorProto pluginDescriptorProto) {
        super(applicationAttemptId, containerId, nmHost, nmPort, nmHttpPort, clock, appSubmitTime, isSession, workingDirectory, localDirs, logDirs, clientVersion, credentials, jobUserName, pluginDescriptorProto);
    }

    public synchronized void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        if (conf.getBoolean("tez.rss.avoid.recompute.succeeded.task", false)) {
            this.overrideTaskAttemptEventDispatcher();
        }
        RssDAGAppMaster.initAndStartRSSClient(this, conf);
    }

    public ShuffleWriteClient getShuffleWriteClient() {
        return this.shuffleWriteClient;
    }

    public void setShuffleWriteClient(ShuffleWriteClient shuffleWriteClient) {
        this.shuffleWriteClient = shuffleWriteClient;
    }

    public TezRemoteShuffleManager getTezRemoteShuffleManager() {
        return this.tezRemoteShuffleManager;
    }

    public void setTezRemoteShuffleManager(TezRemoteShuffleManager tezRemoteShuffleManager) {
        this.tezRemoteShuffleManager = tezRemoteShuffleManager;
    }

    public Map<String, String> getClusterClientConf() {
        return this.clusterClientConf;
    }

    public static void initAndStartRSSClient(RssDAGAppMaster appMaster, Configuration conf) throws Exception {
        ShuffleWriteClient client = appMaster.getShuffleWriteClient();
        if (client == null) {
            client = RssTezUtils.createShuffleClient(conf);
            appMaster.setShuffleWriteClient(client);
        }
        String coordinators = conf.get("tez.rss.coordinator.quorum");
        LOG.info("Registering coordinators {}", (Object)coordinators);
        appMaster.getShuffleWriteClient().registerCoordinators(coordinators);
        String strAppAttemptId = appMaster.getAttemptID().toString();
        long heartbeatInterval = conf.getLong("tez.rss.heartbeat.interval", 10000L);
        long heartbeatTimeout = conf.getLong("tez.rss.heartbeat.timeout", heartbeatInterval / 2L);
        appMaster.getShuffleWriteClient().registerApplicationInfo(strAppAttemptId, heartbeatTimeout, "user");
        appMaster.heartBeatExecutorService.scheduleAtFixedRate(() -> {
            try {
                appMaster.getShuffleWriteClient().sendAppHeartbeat(strAppAttemptId, heartbeatTimeout);
                LOG.debug("Finish send heartbeat to coordinator and servers");
            }
            catch (Exception e) {
                LOG.warn("Fail to send heartbeat to coordinator and servers", (Throwable)e);
            }
        }, heartbeatInterval / 2L, heartbeatInterval, TimeUnit.MILLISECONDS);
        boolean dynamicConfEnabled = conf.getBoolean("tez.rss.dynamicClientConf.enabled", true);
        if (dynamicConfEnabled) {
            appMaster.clusterClientConf = client.fetchClientConf(conf.getInt("tez.rss.access.timeout.ms", 10000));
        }
        Configuration mergedConf = new Configuration(conf);
        RssTezUtils.applyDynamicClientConf(mergedConf, appMaster.getClusterClientConf());
        RemoteStorageInfo defaultRemoteStorage = new RemoteStorageInfo(mergedConf.get("tez.rss.remote.storage.path", ""), mergedConf.get("tez.rss.remote.storage.conf", ""));
        String storageType = mergedConf.get("tez.rss.storage.type", "MEMORY_LOCALFILE");
        boolean testMode = mergedConf.getBoolean("tez.rss.test.mode.enable", false);
        ClientUtils.validateTestModeConf(testMode, storageType);
        RemoteStorageInfo remoteStorage = ClientUtils.fetchRemoteStorage(appMaster.getAppID().toString(), defaultRemoteStorage, dynamicConfEnabled, storageType, client);
        appMaster.getClusterClientConf().put("tez.rss.remote.storage.path", remoteStorage.getPath());
        appMaster.getClusterClientConf().put("tez.rss.remote.storage.conf", remoteStorage.getConfString());
        Token sessionToken = TokenCache.getSessionToken((Credentials)appMaster.getContext().getAppCredentials());
        appMaster.setTezRemoteShuffleManager(new TezRemoteShuffleManager(appMaster.getAppID().toString(), (Token<JobTokenIdentifier>)sessionToken, mergedConf, strAppAttemptId, client, remoteStorage));
        appMaster.getTezRemoteShuffleManager().initialize();
        appMaster.getTezRemoteShuffleManager().start();
        RssDAGAppMaster.mayCloseTezSlowStart(conf);
    }

    protected DAG createDAG(DAGProtos.DAGPlan dagPB) {
        DAGImpl dag = this.createDAG(dagPB, null);
        RssDAGAppMaster.registerStateEnteredCallback(dag, this);
        return dag;
    }

    public void serviceStop() throws Exception {
        RssDAGAppMaster.releaseRssResources(this);
        super.serviceStop();
    }

    static void releaseRssResources(RssDAGAppMaster appMaster) {
        try {
            LOG.info("RssDAGAppMaster releaseRssResources invoked");
            appMaster.heartBeatExecutorService.shutdownNow();
            if (appMaster.tezRemoteShuffleManager != null) {
                appMaster.tezRemoteShuffleManager.shutdown();
                appMaster.tezRemoteShuffleManager = null;
            }
            if (appMaster.shuffleWriteClient != null) {
                appMaster.shuffleWriteClient.close();
                appMaster.shuffleWriteClient = null;
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to release Rss resources.", t);
        }
    }

    public static void main(String[] args) {
        try {
            String systemPropsToLog;
            boolean sessionModeCliOption = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-D")) {
                    String[] property = args[i].split("=");
                    if (property.length < 2) {
                        System.setProperty(property[0].substring(2), "");
                        continue;
                    }
                    System.setProperty(property[0].substring(2), property[1]);
                    continue;
                }
                if (!args[i].contains("--session") && !args[i].contains("-s")) continue;
                sessionModeCliOption = true;
            }
            RssDAGAppMaster.reconfigureLog4j();
            TezClassLoader.setupTezClassLoader();
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            String pid = System.getenv().get("JVM_PID");
            String containerIdStr = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
            String appSubmitTimeStr = System.getenv("APP_SUBMIT_TIME_ENV");
            String clientVersion = System.getenv("TEZ_CLIENT_VERSION");
            if (clientVersion == null) {
                clientVersion = "Unknown";
            }
            Objects.requireNonNull(appSubmitTimeStr, "APP_SUBMIT_TIME_ENV is null");
            ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
            ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
            String jobUserName = System.getenv(ApplicationConstants.Environment.USER.name());
            LOG.info("Creating RssDAGAppMaster for applicationId=" + applicationAttemptId.getApplicationId() + ", attemptNum=" + applicationAttemptId.getAttemptId() + ", AMContainerId=" + containerId + ", jvmPid=" + pid + ", userFromEnv=" + jobUserName + ", cliSessionOption=" + sessionModeCliOption + ", pwd=" + System.getenv(ApplicationConstants.Environment.PWD.name()) + ", localDirs=" + System.getenv(ApplicationConstants.Environment.LOCAL_DIRS.name()) + ", logDirs=" + System.getenv(ApplicationConstants.Environment.LOG_DIRS.name()));
            Configuration conf = new Configuration((Configuration)new YarnConfiguration());
            DAGProtos.ConfigurationProto confProto = TezUtilsInternal.readUserSpecifiedTezConfiguration((String)System.getenv(ApplicationConstants.Environment.PWD.name()));
            TezUtilsInternal.addUserSpecifiedTezConfiguration((Configuration)conf, (List)confProto.getConfKeyValuesList());
            DAGProtos.AMPluginDescriptorProto amPluginDescriptorProto = null;
            if (confProto.hasAmPluginDescriptor()) {
                amPluginDescriptorProto = confProto.getAmPluginDescriptor();
            }
            UserGroupInformation.setConfiguration((Configuration)conf);
            Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
            TezUtilsInternal.setSecurityUtilConfigration((Logger)LOG, (Configuration)conf);
            String nodeHostString = System.getenv(ApplicationConstants.Environment.NM_HOST.name());
            String nodePortString = System.getenv(ApplicationConstants.Environment.NM_PORT.name());
            String nodeHttpPortString = System.getenv(ApplicationConstants.Environment.NM_HTTP_PORT.name());
            long appSubmitTime = Long.parseLong(appSubmitTimeStr);
            RssDAGAppMaster appMaster = new RssDAGAppMaster(applicationAttemptId, containerId, nodeHostString, Integer.parseInt(nodePortString), Integer.parseInt(nodeHttpPortString), (Clock)new SystemClock(), appSubmitTime, sessionModeCliOption, System.getenv(ApplicationConstants.Environment.PWD.name()), TezCommonUtils.getTrimmedStrings((String)System.getenv(ApplicationConstants.Environment.LOCAL_DIRS.name())), TezCommonUtils.getTrimmedStrings((String)System.getenv(ApplicationConstants.Environment.LOG_DIRS.name())), clientVersion, credentials, jobUserName, amPluginDescriptorProto);
            ShutdownHookManager.get().addShutdownHook((Runnable)new DAGAppMaster.DAGAppMasterShutdownHook((DAGAppMaster)appMaster), 30);
            ShutdownHookManager.get().addShutdownHook((Runnable)new RssDAGAppMasterShutdownHook(appMaster), 50);
            if (LOG.isInfoEnabled() && (systemPropsToLog = TezCommonUtils.getSystemPropertiesToLog((Configuration)conf)) != null) {
                LOG.info(systemPropsToLog);
            }
            if (conf.getBoolean("tez.rss.avoid.recompute.succeeded.task", false) && conf.getBoolean("tez.am.node-unhealthy-reschedule-tasks", false)) {
                LOG.info("When rss.avoid.recompute.succeeded.task is enable, we can not rescheduler succeeded task on unhealthy node");
                conf.setBoolean("tez.am.node-unhealthy-reschedule-tasks", false);
            }
            RssDAGAppMaster.initAndStartAppMaster((DAGAppMaster)appMaster, (Configuration)conf);
        }
        catch (Throwable t) {
            LOG.error("Error starting RssDAGAppMaster", t);
            System.exit(1);
        }
    }

    static void mayCloseTezSlowStart(Configuration conf) {
        if (!conf.getBoolean("tez.rss.am.slow.start.enable", RssTezConfig.RSS_AM_SLOW_START_ENABLE_DEFAULT.booleanValue())) {
            conf.setFloat("tez.shuffle-vertex-manager.min-src-fraction", 1.0f);
            conf.setFloat("tez.shuffle-vertex-manager.max-src-fraction", 1.0f);
        }
    }

    @VisibleForTesting
    public static void registerStateEnteredCallback(DAGImpl dag, RssDAGAppMaster appMaster) {
        StateMachineTez stateMachine = (StateMachineTez)RssDAGAppMaster.getPrivateField(dag, "stateMachine");
        stateMachine.registerStateEnteredCallback((Enum)DAGState.INITED, (OnStateChangedCallback)new DagInitialCallback(appMaster));
        RssDAGAppMaster.overrideDAGFinalStateCallback(appMaster, (Map)RssDAGAppMaster.getPrivateField(stateMachine, "callbackMap"), Arrays.asList(DAGState.SUCCEEDED, DAGState.FAILED, DAGState.KILLED, DAGState.ERROR));
    }

    private static void overrideDAGFinalStateCallback(RssDAGAppMaster appMaster, Map callbackMap, List<DAGState> finalStates) {
        finalStates.forEach(finalState -> callbackMap.put(finalState, new DagFinalStateCallback(appMaster, (OnStateChangedCallback)callbackMap.get(finalState))));
    }

    private static Object getPrivateField(Object object, String name) {
        try {
            Field f = object.getClass().getDeclaredField(name);
            f.setAccessible(true);
            return f.get(object);
        }
        catch (Exception e) {
            throw new RssException(e);
        }
    }

    static void reconfigureLog4j() {
        String configuratorClassName = OptionConverter.getSystemProperty((String)"log4j.configuratorClass", null);
        String configurationOptionStr = OptionConverter.getSystemProperty((String)"log4j.configuration", null);
        URL url = Loader.getResource((String)configurationOptionStr);
        OptionConverter.selectAndConfigure((URL)url, (String)configuratorClassName, (LoggerRepository)LogManager.getLoggerRepository());
    }

    protected void overrideTaskAttemptEventDispatcher() throws NoSuchFieldException, IllegalAccessException {
        AsyncDispatcher dispatcher = (AsyncDispatcher)this.getDispatcher();
        Field field = dispatcher.getClass().getDeclaredField("eventHandlers");
        field.setAccessible(true);
        Map eventHandlers = (Map)field.get(dispatcher);
        eventHandlers.put(TaskAttemptEventType.class, new RssTaskAttemptEventDispatcher());
    }

    private class RssTaskAttemptEventDispatcher
    implements EventHandler<TaskAttemptEvent> {
        private RssTaskAttemptEventDispatcher() {
        }

        public void handle(TaskAttemptEvent event) {
            DAG dag = RssDAGAppMaster.this.getContext().getCurrentDAG();
            int eventDagIndex = event.getTaskAttemptID().getTaskID().getVertexID().getDAGId().getId();
            if (dag == null || eventDagIndex != dag.getID().getId()) {
                return;
            }
            Task task = dag.getVertex(event.getTaskAttemptID().getTaskID().getVertexID()).getTask(event.getTaskAttemptID().getTaskID());
            TaskAttempt attempt = task.getAttempt(event.getTaskAttemptID());
            if (attempt.getState() == TaskAttemptState.SUCCEEDED && event.getType() == TaskAttemptEventType.TA_NODE_FAILED) {
                LOG.info("We should not recompute the succeeded task attempt, though task attempt {} received event {}", (Object)attempt, (Object)event);
                return;
            }
            ((EventHandler)attempt).handle((Event)event);
        }
    }

    static class DagInitialCallback
    implements OnStateChangedCallback<DAGState, DAGImpl> {
        private RssDAGAppMaster appMaster;

        DagInitialCallback(RssDAGAppMaster appMaster) {
            this.appMaster = appMaster;
        }

        public void onStateChanged(DAGImpl dag, DAGState dagState) {
            try {
                Configuration filterRssConf = RssTezUtils.filterRssConf(this.appMaster.getConfig());
                Map edges = (Map)RssDAGAppMaster.getPrivateField(dag, "edges");
                for (Map.Entry entry : edges.entrySet()) {
                    Edge edge = (Edge)entry.getValue();
                    int sourceVertexId = dag.getVertex(edge.getSourceVertexName()).getVertexId().getId();
                    int destinationVertexId = dag.getVertex(edge.getDestinationVertexName()).getVertexId().getId();
                    Configuration edgeSourceConf = TezUtils.createConfFromUserPayload((UserPayload)edge.getEdgeProperty().getEdgeSource().getUserPayload());
                    edgeSourceConf.setInt("tez.rss.shuffle.source.vertex.id", sourceVertexId);
                    edgeSourceConf.setInt("tez.rss.shuffle.destination.vertex.id", destinationVertexId);
                    edgeSourceConf.set("tez.rss.am.shuffle.manager.address", this.appMaster.getTezRemoteShuffleManager().getAddress().getHostName());
                    edgeSourceConf.setInt("tez.rss.am.shuffle.manager.port", this.appMaster.getTezRemoteShuffleManager().getAddress().getPort());
                    edgeSourceConf.addResource(filterRssConf);
                    RssTezUtils.applyDynamicClientConf(edgeSourceConf, this.appMaster.getClusterClientConf());
                    edge.getEdgeProperty().getEdgeSource().setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)edgeSourceConf));
                    OutputDescriptor outputDescriptor = edge.getEdgeProperty().getEdgeSource();
                    Field outputClassNameField = outputDescriptor.getClass().getSuperclass().getDeclaredField("className");
                    outputClassNameField.setAccessible(true);
                    String outputClassName = (String)outputClassNameField.get(outputDescriptor);
                    String rssOutputClassName = RssTezUtils.replaceRssOutputClassName(outputClassName);
                    outputClassNameField.set(outputDescriptor, rssOutputClassName);
                    Configuration edgeDestinationConf = TezUtils.createConfFromUserPayload((UserPayload)edge.getEdgeProperty().getEdgeSource().getUserPayload());
                    edgeDestinationConf.setInt("tez.rss.shuffle.source.vertex.id", sourceVertexId);
                    edgeDestinationConf.setInt("tez.rss.shuffle.destination.vertex.id", destinationVertexId);
                    edgeDestinationConf.set("tez.rss.am.shuffle.manager.address", this.appMaster.getTezRemoteShuffleManager().getAddress().getHostName());
                    edgeDestinationConf.setInt("tez.rss.am.shuffle.manager.port", this.appMaster.getTezRemoteShuffleManager().getAddress().getPort());
                    edgeDestinationConf.addResource(filterRssConf);
                    RssTezUtils.applyDynamicClientConf(edgeDestinationConf, this.appMaster.getClusterClientConf());
                    edge.getEdgeProperty().getEdgeDestination().setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)edgeDestinationConf));
                    InputDescriptor inputDescriptor = edge.getEdgeProperty().getEdgeDestination();
                    Field inputClassNameField = outputDescriptor.getClass().getSuperclass().getDeclaredField("className");
                    inputClassNameField.setAccessible(true);
                    String inputClassName = (String)outputClassNameField.get(inputDescriptor);
                    String rssInputClassName = RssTezUtils.replaceRssInputClassName(inputClassName);
                    outputClassNameField.set(inputDescriptor, rssInputClassName);
                }
            }
            catch (IOException | IllegalAccessException | NoSuchFieldException e) {
                LOG.error("Reconfigure failed after dag was inited, caused by {}", (Throwable)e);
                throw new TezUncheckedException((Throwable)e);
            }
        }
    }

    static class DagFinalStateCallback
    implements OnStateChangedCallback<DAGState, DAGImpl> {
        private RssDAGAppMaster appMaster;
        private OnStateChangedCallback callback;

        DagFinalStateCallback(RssDAGAppMaster appMaster, OnStateChangedCallback callback) {
            this.appMaster = appMaster;
            this.callback = callback;
        }

        public void onStateChanged(DAGImpl dag, DAGState dagState) {
            this.callback.onStateChanged((Object)dag, (Enum)dagState);
            LOG.info("Receive a dag state change event, dagId={}, dagState={}", (Object)dag.getID(), (Object)dagState);
            long startTime = System.currentTimeMillis();
            this.appMaster.getTezRemoteShuffleManager().unregisterShuffleByDagId(dag.getID());
            LOG.info("Complete the task of unregister shuffle, dagId={}, cost={}ms ", (Object)dag.getID(), (Object)(System.currentTimeMillis() - startTime));
        }
    }

    static class RssDAGAppMasterShutdownHook
    implements Runnable {
        RssDAGAppMaster appMaster;

        RssDAGAppMasterShutdownHook(RssDAGAppMaster appMaster) {
            this.appMaster = appMaster;
        }

        @Override
        public void run() {
            LOG.info("RssDAGAppMaster received a signal. Signaling RMCommunicator and JobHistoryEventHandler.");
            this.appMaster.stop();
        }
    }
}

