/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.client.util.RssClientConfig;
import org.apache.uniffle.com.google.common.collect.ImmutableSet;
import org.apache.uniffle.common.config.RssConf;

public class RssMRConfig {
    public static final String MR_CONFIG_PREFIX = "mapreduce.";
    public static final String MR_RSS_CONFIG_PREFIX = "mapreduce.rss.";
    public static final String RSS_CLIENT_HEARTBEAT_THREAD_NUM = "mapreduce.rss.client.heartBeat.threadNum";
    public static final int RSS_CLIENT_HEARTBEAT_THREAD_NUM_DEFAULT_VALUE = 4;
    public static final String RSS_CLIENT_TYPE = "mapreduce.rss.client.type";
    public static final String RSS_CLIENT_TYPE_DEFAULT_VALUE = "GRPC";
    public static final String RSS_CLIENT_RETRY_MAX = "mapreduce.rss.client.retry.max";
    public static final int RSS_CLIENT_RETRY_MAX_DEFAULT_VALUE = 50;
    public static final String RSS_CLIENT_RETRY_INTERVAL_MAX = "mapreduce.rss.client.retry.interval.max";
    public static final long RSS_CLIENT_RETRY_INTERVAL_MAX_DEFAULT_VALUE = 10000L;
    public static final String RSS_COORDINATOR_QUORUM = "mapreduce.rss.coordinator.quorum";
    public static final String RSS_DATA_REPLICA = "mapreduce.rss.data.replica";
    public static final int RSS_DATA_REPLICA_DEFAULT_VALUE = 1;
    public static final String RSS_DATA_REPLICA_WRITE = "mapreduce.rss.data.replica.write";
    public static final int RSS_DATA_REPLICA_WRITE_DEFAULT_VALUE = 1;
    public static final String RSS_DATA_REPLICA_READ = "mapreduce.rss.data.replica.read";
    public static final int RSS_DATA_REPLICA_READ_DEFAULT_VALUE = 1;
    public static final String RSS_DATA_REPLICA_SKIP_ENABLED = "mapreduce.rss.data.replica.skip.enabled";
    public static final String RSS_DATA_TRANSFER_POOL_SIZE = "mapreduce.rss.client.data.transfer.pool.size";
    public static final int RSS_DATA_TRANSFER_POOL_SIZE_DEFAULT_VALUE = RssClientConfig.RSS_DATA_TRANFER_POOL_SIZE_DEFAULT_VALUE;
    public static final String RSS_DATA_COMMIT_POOL_SIZE = "mapreduce.rss.client.data.commit.pool.size";
    public static final int RSS_DATA_COMMIT_POOL_SIZE_DEFAULT_VALUE = -1;
    public static final String RSS_CLIENT_SEND_THREAD_NUM = "mapreduce.rss.client.send.thread.num";
    public static final int RSS_CLIENT_DEFAULT_SEND_THREAD_NUM = 5;
    public static final String RSS_CLIENT_SEND_THRESHOLD = "mapreduce.rss.client.send.threshold";
    public static final double RSS_CLIENT_DEFAULT_SEND_THRESHOLD = (double)0.2f;
    public static final boolean RSS_DATA_REPLICA_SKIP_ENABLED_DEFAULT_VALUE = true;
    public static final String RSS_HEARTBEAT_INTERVAL = "mapreduce.rss.heartbeat.interval";
    public static final long RSS_HEARTBEAT_INTERVAL_DEFAULT_VALUE = 10000L;
    public static final String RSS_HEARTBEAT_TIMEOUT = "mapreduce.rss.heartbeat.timeout";
    public static final String RSS_ASSIGNMENT_PREFIX = "mapreduce.rss.assignment.partition.";
    public static final String RSS_CLIENT_BATCH_TRIGGER_NUM = "mapreduce.rss.client.batch.trigger.num";
    public static final int RSS_CLIENT_DEFAULT_BATCH_TRIGGER_NUM = 50;
    public static final String RSS_CLIENT_SORT_MEMORY_USE_THRESHOLD = "mapreduce.rss.client.sort.memory.use.threshold";
    public static final String RSS_WRITER_BUFFER_SIZE = "mapreduce.rss.writer.buffer.size";
    public static final long RSS_WRITER_BUFFER_SIZE_DEFAULT_VALUE = 0xE00000L;
    public static final double RSS_CLIENT_DEFAULT_SORT_MEMORY_USE_THRESHOLD = (double)0.9f;
    public static final String RSS_CLIENT_MEMORY_THRESHOLD = "mapreduce.rss.client.memory.threshold";
    public static final double RSS_CLIENT_DEFAULT_MEMORY_THRESHOLD = (double)0.8f;
    public static final String RSS_CLIENT_SEND_CHECK_INTERVAL_MS = "mapreduce.rss.client.send.check.interval.ms";
    public static final long RSS_CLIENT_SEND_CHECK_INTERVAL_MS_DEFAULT_VALUE = 500L;
    public static final String RSS_CLIENT_SEND_CHECK_TIMEOUT_MS = "mapreduce.rss.client.send.check.timeout.ms";
    public static final long RSS_CLIENT_SEND_CHECK_TIMEOUT_MS_DEFAULT_VALUE = 600000L;
    public static final String RSS_CLIENT_BITMAP_NUM = "mapreduce.rss.client.bitmap.num";
    public static final int RSS_CLIENT_DEFAULT_BITMAP_NUM = 1;
    public static final String RSS_CLIENT_MAX_SEGMENT_SIZE = "mapreduce.rss.client.max.buffer.size";
    public static final long RSS_CLIENT_DEFAULT_MAX_SEGMENT_SIZE = 3072L;
    public static final String RSS_STORAGE_TYPE = "mapreduce.rss.storage.type";
    public static final String RSS_REDUCE_REMOTE_SPILL_ENABLED = "mapreduce.rss.reduce.remote.spill.enable";
    public static final boolean RSS_REDUCE_REMOTE_SPILL_ENABLED_DEFAULT = false;
    public static final String RSS_REDUCE_REMOTE_SPILL_ATTEMPT_INC = "mapreduce.rss.reduce.remote.spill.attempt.inc";
    public static final int RSS_REDUCE_REMOTE_SPILL_ATTEMPT_INC_DEFAULT = 1;
    public static final String RSS_REDUCE_REMOTE_SPILL_REPLICATION = "mapreduce.rss.reduce.remote.spill.replication";
    public static final int RSS_REDUCE_REMOTE_SPILL_REPLICATION_DEFAULT = 1;
    public static final String RSS_REDUCE_REMOTE_SPILL_RETRIES = "mapreduce.rss.reduce.remote.spill.retries";
    public static final int RSS_REDUCE_REMOTE_SPILL_RETRIES_DEFAULT = 5;
    public static final String RSS_PARTITION_NUM_PER_RANGE = "mapreduce.rss.partitionNum.per.range";
    public static final int RSS_PARTITION_NUM_PER_RANGE_DEFAULT_VALUE = 1;
    public static final String RSS_REMOTE_STORAGE_PATH = "mapreduce.rss.remote.storage.path";
    public static final String RSS_REMOTE_STORAGE_CONF = "mapreduce.rss.remote.storage.conf";
    public static final String RSS_INDEX_READ_LIMIT = "mapreduce.rss.index.read.limit";
    public static final int RSS_INDEX_READ_LIMIT_DEFAULT_VALUE = 500;
    public static final String RSS_CLIENT_READ_BUFFER_SIZE = "mapreduce.rss.client.read.buffer.size";
    public static final String RSS_CLIENT_READ_BUFFER_SIZE_DEFAULT_VALUE = "14m";
    public static final String RSS_DYNAMIC_CLIENT_CONF_ENABLED = "mapreduce.rss.dynamicClientConf.enabled";
    public static final boolean RSS_DYNAMIC_CLIENT_CONF_ENABLED_DEFAULT_VALUE = true;
    public static final String RSS_ACCESS_TIMEOUT_MS = "mapreduce.rss.access.timeout.ms";
    public static final int RSS_ACCESS_TIMEOUT_MS_DEFAULT_VALUE = 10000;
    public static final String RSS_CLIENT_ASSIGNMENT_TAGS = "mapreduce.rss.client.assignment.tags";
    public static final String RSS_CLIENT_ASSIGNMENT_SHUFFLE_SERVER_NUMBER = "rss.client.assignment.shuffle.nodes.max";
    public static final int RSS_CLIENT_ASSIGNMENT_SHUFFLE_SERVER_NUMBER_DEFAULT_VALUE = -1;
    public static final String RSS_CLIENT_ASSIGNMENT_RETRY_INTERVAL = "mapreduce.rss.client.assignment.retry.interval";
    public static final long RSS_CLIENT_ASSIGNMENT_RETRY_INTERVAL_DEFAULT_VALUE = 65000L;
    public static final String RSS_CLIENT_ASSIGNMENT_RETRY_TIMES = "mapreduce.rss.client.assignment.retry.times";
    public static final int RSS_CLIENT_ASSIGNMENT_RETRY_TIMES_DEFAULT_VALUE = 3;
    public static final String RSS_ESTIMATE_SERVER_ASSIGNMENT_ENABLED = "mapreduce.rss.estimate.server.assignment.enabled";
    public static final boolean RSS_ESTIMATE_SERVER_ASSIGNMENT_ENABLED_DEFAULT_VALUE = false;
    public static final String RSS_ESTIMATE_TASK_CONCURRENCY_DYNAMIC_FACTOR = "mapreduce.rss.estimate.task.concurrency.dynamic.factor";
    public static final double RSS_ESTIMATE_TASK_CONCURRENCY_DYNAMIC_FACTOR_DEFAULT_VALUE = 1.0;
    public static final String RSS_ESTIMATE_TASK_CONCURRENCY_PER_SERVER = "mapreduce.rss.estimate.task.concurrency.per.server";
    public static final int RSS_ESTIMATE_TASK_CONCURRENCY_PER_SERVER_DEFAULT_VALUE = 80;
    public static final String RSS_CONF_FILE = "rss_conf.xml";
    public static final Set<String> RSS_MANDATORY_CLUSTER_CONF = ImmutableSet.of("mapreduce.rss.storage.type", "mapreduce.rss.remote.storage.path");
    public static final String RSS_TEST_MODE_ENABLE = "mapreduce.rss.test.mode.enable";

    public static RssConf toRssConf(Configuration jobConf) {
        RssConf rssConf = new RssConf();
        for (Map.Entry entry : jobConf) {
            String key = (String)entry.getKey();
            if (!key.startsWith(MR_CONFIG_PREFIX)) continue;
            key = key.substring(MR_CONFIG_PREFIX.length());
            rssConf.setString(key, (String)entry.getValue());
        }
        return rssConf;
    }
}

