/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.security;

import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.security.HadoopSecurityContext;
import org.apache.uniffle.common.security.NoOpSecurityContext;
import org.apache.uniffle.common.security.SecurityConfig;
import org.apache.uniffle.common.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContextFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContextFactory.class);
    private SecurityContext securityContext = new NoOpSecurityContext();

    public static SecurityContextFactory get() {
        return LazyHolder.SECURITY_CONTEXT_FACTORY;
    }

    public void init(SecurityConfig securityConfig) throws Exception {
        if (securityConfig == null) {
            this.securityContext = new NoOpSecurityContext();
            return;
        }
        this.securityContext = new HadoopSecurityContext(securityConfig.getKrb5ConfPath(), securityConfig.getKeytabFilePath(), securityConfig.getPrincipal(), securityConfig.getReloginIntervalSec());
        LOGGER.info("Initialized security context: {}", (Object)this.securityContext.getClass().getSimpleName());
    }

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            throw new RssException("No initialized security context.");
        }
        return this.securityContext;
    }

    static class LazyHolder {
        static final SecurityContextFactory SECURITY_CONTEXT_FACTORY = new SecurityContextFactory();

        LazyHolder() {
        }
    }
}

