/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.util.ByteBufUtils;

public class ShuffleDataResult {
    private final ManagedBuffer buffer;
    private final List<BufferSegment> bufferSegments;

    public ShuffleDataResult() {
        this(new byte[0]);
    }

    public ShuffleDataResult(byte[] data) {
        this(data, (List<BufferSegment>)Lists.newArrayList());
    }

    public ShuffleDataResult(ManagedBuffer buffer) {
        this.buffer = buffer;
        this.bufferSegments = Lists.newArrayList();
    }

    public ShuffleDataResult(ByteBuffer data, List<BufferSegment> bufferSegments) {
        this.buffer = new NettyManagedBuffer(data != null ? Unpooled.wrappedBuffer((ByteBuffer)data) : Unpooled.EMPTY_BUFFER);
        this.bufferSegments = bufferSegments;
    }

    public ShuffleDataResult(ByteBuf data, List<BufferSegment> bufferSegments) {
        this.buffer = new NettyManagedBuffer(data);
        this.bufferSegments = bufferSegments;
    }

    public ShuffleDataResult(byte[] data, List<BufferSegment> bufferSegments) {
        this(data != null ? ByteBuffer.wrap(data) : null, bufferSegments);
    }

    public byte[] getData() {
        if (this.buffer == null) {
            return null;
        }
        if (this.buffer.nioByteBuffer().hasArray()) {
            return this.buffer.nioByteBuffer().array();
        }
        return ByteBufUtils.readBytes(this.buffer.byteBuf());
    }

    public int getDataLength() {
        if (this.buffer == null) {
            return 0;
        }
        if (this.buffer.nioByteBuffer().hasArray()) {
            return this.buffer.nioByteBuffer().array().length;
        }
        return this.buffer.nioByteBuffer().remaining();
    }

    public ByteBuf getDataBuf() {
        return this.buffer.byteBuf();
    }

    public ByteBuffer getDataBuffer() {
        return this.buffer.nioByteBuffer();
    }

    public ManagedBuffer getManagedBuffer() {
        return this.buffer;
    }

    public List<BufferSegment> getBufferSegments() {
        return this.bufferSegments;
    }

    public boolean isEmpty() {
        return this.bufferSegments == null || this.bufferSegments.isEmpty() || this.buffer == null || this.buffer.size() == 0;
    }

    public void release() {
        if (this.buffer != null) {
            this.buffer.release();
        }
    }
}

