/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.factory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.apache.uniffle.client.api.ShuffleServerClient;
import org.apache.uniffle.client.factory.ShuffleServerClientFactory;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.IdHelper;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.storage.handler.api.ClientReadHandler;
import org.apache.uniffle.storage.handler.api.ShuffleDeleteHandler;
import org.apache.uniffle.storage.handler.impl.ComposedClientReadHandler;
import org.apache.uniffle.storage.handler.impl.HadoopClientReadHandler;
import org.apache.uniffle.storage.handler.impl.HadoopShuffleDeleteHandler;
import org.apache.uniffle.storage.handler.impl.LocalFileClientReadHandler;
import org.apache.uniffle.storage.handler.impl.LocalFileDeleteHandler;
import org.apache.uniffle.storage.handler.impl.MemoryClientReadHandler;
import org.apache.uniffle.storage.handler.impl.MultiReplicaClientReadHandler;
import org.apache.uniffle.storage.request.CreateShuffleDeleteHandlerRequest;
import org.apache.uniffle.storage.request.CreateShuffleReadHandlerRequest;
import org.apache.uniffle.storage.util.StorageType;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class ShuffleHandlerFactory {
    private static ShuffleHandlerFactory INSTANCE;

    private ShuffleHandlerFactory() {
    }

    public static synchronized ShuffleHandlerFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ShuffleHandlerFactory();
        }
        return INSTANCE;
    }

    public ClientReadHandler createShuffleReadHandler(CreateShuffleReadHandlerRequest request) {
        if (CollectionUtils.isEmpty(request.getShuffleServerInfoList())) {
            throw new RssException("Shuffle servers should not be empty!");
        }
        if (request.getShuffleServerInfoList().size() > 1) {
            ArrayList handlers = Lists.newArrayList();
            request.getShuffleServerInfoList().forEach(ssi -> handlers.add(ShuffleHandlerFactory.getInstance().createSingleReplicaClientReadHandler(request, (ShuffleServerInfo)ssi)));
            return new MultiReplicaClientReadHandler(handlers, request.getShuffleServerInfoList(), request.getExpectBlockIds(), request.getProcessBlockIds());
        }
        ShuffleServerInfo serverInfo = request.getShuffleServerInfoList().get(0);
        return this.createSingleReplicaClientReadHandler(request, serverInfo);
    }

    public ClientReadHandler createSingleReplicaClientReadHandler(CreateShuffleReadHandlerRequest request, ShuffleServerInfo serverInfo) {
        String storageType = request.getStorageType();
        StorageType type = StorageType.valueOf(storageType);
        if (StorageType.MEMORY == type) {
            throw new UnsupportedOperationException("Doesn't support storage type for client read  :" + storageType);
        }
        if (StorageType.HDFS == type) {
            return this.getHadoopClientReadHandler(request, serverInfo);
        }
        if (StorageType.LOCALFILE == type) {
            return this.getLocalfileClientReaderHandler(request, serverInfo);
        }
        ArrayList<Supplier<ClientReadHandler>> handlers = new ArrayList<Supplier<ClientReadHandler>>();
        if (StorageType.withMemory(type)) {
            handlers.add(() -> this.getMemoryClientReadHandler(request, serverInfo));
        }
        if (StorageType.withLocalfile(type)) {
            handlers.add(() -> this.getLocalfileClientReaderHandler(request, serverInfo));
        }
        if (StorageType.withHadoop(type)) {
            handlers.add(() -> this.getHadoopClientReadHandler(request, serverInfo));
        }
        if (handlers.isEmpty()) {
            throw new RssException("This should not happen due to the unknown storage type: " + storageType);
        }
        return new ComposedClientReadHandler(serverInfo, handlers);
    }

    private ClientReadHandler getMemoryClientReadHandler(CreateShuffleReadHandlerRequest request, ShuffleServerInfo ssi) {
        ShuffleServerClient shuffleServerClient = ShuffleServerClientFactory.getInstance().getShuffleServerClient(ClientType.GRPC.name(), ssi, request.getClientConf());
        Roaring64NavigableMap expectTaskIds = null;
        if (request.isExpectedTaskIdsBitmapFilterEnable()) {
            Roaring64NavigableMap realExceptBlockIds = RssUtils.cloneBitMap((Roaring64NavigableMap)request.getExpectBlockIds());
            realExceptBlockIds.xor(request.getProcessBlockIds());
            expectTaskIds = RssUtils.generateTaskIdBitMap((Roaring64NavigableMap)realExceptBlockIds, (IdHelper)request.getIdHelper());
        }
        MemoryClientReadHandler memoryClientReadHandler = new MemoryClientReadHandler(request.getAppId(), request.getShuffleId(), request.getPartitionId(), request.getReadBufferSize(), shuffleServerClient, expectTaskIds);
        return memoryClientReadHandler;
    }

    private ClientReadHandler getLocalfileClientReaderHandler(CreateShuffleReadHandlerRequest request, ShuffleServerInfo ssi) {
        ShuffleServerClient shuffleServerClient = ShuffleServerClientFactory.getInstance().getShuffleServerClient(ClientType.GRPC.name(), ssi, request.getClientConf());
        return new LocalFileClientReadHandler(request.getAppId(), request.getShuffleId(), request.getPartitionId(), request.getIndexReadLimit(), request.getPartitionNumPerRange(), request.getPartitionNum(), request.getReadBufferSize(), request.getExpectBlockIds(), request.getProcessBlockIds(), shuffleServerClient, request.getDistributionType(), request.getExpectTaskIds());
    }

    private ClientReadHandler getHadoopClientReadHandler(CreateShuffleReadHandlerRequest request, ShuffleServerInfo ssi) {
        return new HadoopClientReadHandler(request.getAppId(), request.getShuffleId(), request.getPartitionId(), request.getIndexReadLimit(), request.getPartitionNumPerRange(), request.getPartitionNum(), request.getReadBufferSize(), request.getExpectBlockIds(), request.getProcessBlockIds(), request.getStorageBasePath(), request.getHadoopConf(), request.getDistributionType(), request.getExpectTaskIds(), ssi.getId(), request.isOffHeapEnabled());
    }

    public ShuffleDeleteHandler createShuffleDeleteHandler(CreateShuffleDeleteHandlerRequest request) {
        if (StorageType.HDFS.name().equals(request.getStorageType())) {
            return new HadoopShuffleDeleteHandler(request.getConf());
        }
        if (StorageType.LOCALFILE.name().equals(request.getStorageType())) {
            return new LocalFileDeleteHandler();
        }
        throw new UnsupportedOperationException("Doesn't support storage type for shuffle delete handler:" + request.getStorageType());
    }
}

