/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.netty.TransportFrameDecoder;
import org.apache.uniffle.common.netty.client.TransportConf;
import org.apache.uniffle.common.netty.client.TransportContext;
import org.apache.uniffle.common.netty.handle.BaseMessageHandler;
import org.apache.uniffle.common.rpc.ServerInterface;
import org.apache.uniffle.common.util.ExitUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.netty.ShuffleServerNettyHandler;
import org.apache.uniffle.server.netty.StreamServerMetricHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamServer
implements ServerInterface {
    private static final Logger LOG = LoggerFactory.getLogger(StreamServer.class);
    private ShuffleServer shuffleServer;
    private EventLoopGroup shuffleBossGroup;
    private EventLoopGroup shuffleWorkerGroup;
    private ShuffleServerConf shuffleServerConf;
    private ChannelFuture channelFuture;

    public StreamServer(ShuffleServer shuffleServer) {
        this.shuffleServer = shuffleServer;
        this.shuffleServerConf = shuffleServer.getShuffleServerConf();
        boolean isEpollEnable = this.shuffleServerConf.getBoolean(ShuffleServerConf.NETTY_SERVER_EPOLL_ENABLE);
        int acceptThreads = this.shuffleServerConf.getInteger(ShuffleServerConf.NETTY_SERVER_ACCEPT_THREAD);
        int workerThreads = this.shuffleServerConf.getInteger(ShuffleServerConf.NETTY_SERVER_WORKER_THREAD);
        if (isEpollEnable) {
            this.shuffleBossGroup = new EpollEventLoopGroup(acceptThreads);
            this.shuffleWorkerGroup = new EpollEventLoopGroup(workerThreads);
        } else {
            this.shuffleBossGroup = new NioEventLoopGroup(acceptThreads);
            this.shuffleWorkerGroup = new NioEventLoopGroup(workerThreads);
        }
    }

    private ServerBootstrap bootstrapChannel(EventLoopGroup bossGroup, EventLoopGroup workerGroup, int backlogSize, int timeoutMillis, int sendBuf, int receiveBuf) {
        ServerBootstrap serverBootstrap = new ServerBootstrap().group(bossGroup, workerGroup);
        if (bossGroup instanceof EpollEventLoopGroup) {
            serverBootstrap.channel(EpollServerSocketChannel.class);
        } else {
            serverBootstrap.channel(NioServerSocketChannel.class);
        }
        ShuffleServerNettyHandler serverNettyHandler = new ShuffleServerNettyHandler(this.shuffleServer);
        final TransportContext transportContext = new TransportContext(new TransportConf((RssConf)this.shuffleServerConf), (BaseMessageHandler)serverNettyHandler, true);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                transportContext.initializePipeline(ch, (ChannelInboundHandlerAdapter)new TransportFrameDecoder());
                ch.pipeline().addLast("metricHandler", (ChannelHandler)new StreamServerMetricHandler(StreamServer.this.shuffleServer.getNettyMetrics()));
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)backlogSize)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeoutMillis)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeoutMillis).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        if (sendBuf > 0) {
            serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)sendBuf);
        }
        if (receiveBuf > 0) {
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)receiveBuf);
        }
        return serverBootstrap;
    }

    public int start() throws IOException {
        int port = this.shuffleServerConf.getInteger(ShuffleServerConf.NETTY_SERVER_PORT);
        try {
            port = RssUtils.startServiceOnPort((ServerInterface)this, (String)"netty.rpc.server", (int)port, (RssBaseConf)this.shuffleServerConf);
        }
        catch (Exception e) {
            ExitUtils.terminate((int)1, (String)"Fail to start stream server", (Throwable)e, (Logger)LOG);
        }
        return port;
    }

    public void startOnPort(int port) throws Exception {
        ServerBootstrap serverBootstrap = this.bootstrapChannel(this.shuffleBossGroup, this.shuffleWorkerGroup, this.shuffleServerConf.getInteger(ShuffleServerConf.NETTY_SERVER_CONNECT_BACKLOG), this.shuffleServerConf.getInteger(ShuffleServerConf.NETTY_SERVER_CONNECT_TIMEOUT), this.shuffleServerConf.getInteger(ShuffleServerConf.NETTY_SERVER_SEND_BUF), this.shuffleServerConf.getInteger(ShuffleServerConf.NETTY_SERVER_RECEIVE_BUF));
        this.channelFuture = serverBootstrap.bind(port);
        this.channelFuture.syncUninterruptibly();
        LOG.info("bind localAddress is " + this.channelFuture.channel().localAddress());
        LOG.info("Start stream server successfully with port " + port);
    }

    public void stop() {
        if (this.channelFuture != null) {
            this.channelFuture.channel().close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
            this.channelFuture = null;
        }
        if (this.shuffleBossGroup != null) {
            this.shuffleBossGroup.shutdownGracefully();
            this.shuffleWorkerGroup.shutdownGracefully();
            this.shuffleBossGroup = null;
            this.shuffleWorkerGroup = null;
        }
    }

    public void blockUntilShutdown() throws InterruptedException {
    }
}

