/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

public class HttpInput
extends ServletInputStream
implements Runnable {
    private static final Logger LOG = Log.getLogger(HttpInput.class);
    private static final Content EOF_CONTENT = new EofContent("EOF");
    private static final Content EARLY_EOF_CONTENT = new EofContent("EARLY_EOF");
    private final byte[] _oneByteBuffer = new byte[1];
    private final Deque<Content> _inputQ = new ArrayDeque<Content>();
    private final HttpChannelState _channelState;
    private ReadListener _listener;
    private State _state = STREAM;
    private long _firstByteTimeStamp = -1L;
    private long _contentArrived;
    private long _contentConsumed;
    private long _blockUntil;
    private boolean _waitingForContent;
    protected static final State STREAM = new State(){

        @Override
        public boolean blockForContent(HttpInput input) throws IOException {
            input.blockForContent();
            return true;
        }

        public String toString() {
            return "STREAM";
        }
    };
    protected static final State ASYNC = new State(){

        @Override
        public int noContent() throws IOException {
            return 0;
        }

        public String toString() {
            return "ASYNC";
        }
    };
    protected static final State EARLY_EOF = new EOFState(){

        @Override
        public int noContent() throws IOException {
            throw new EofException("Early EOF");
        }

        public String toString() {
            return "EARLY_EOF";
        }
    };
    protected static final State EOF = new EOFState(){

        public String toString() {
            return "EOF";
        }
    };
    protected static final State AEOF = new EOFState(){

        public String toString() {
            return "AEOF";
        }
    };

    public HttpInput(HttpChannelState state) {
        this._channelState = state;
    }

    protected HttpChannelState getHttpChannelState() {
        return this._channelState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            Content item = this._inputQ.poll();
            while (item != null) {
                item.failed(null);
                item = this._inputQ.poll();
            }
            this._listener = null;
            this._state = STREAM;
            this._contentArrived = 0L;
            this._contentConsumed = 0L;
            this._firstByteTimeStamp = -1L;
            this._blockUntil = 0L;
            this._waitingForContent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        int available = 0;
        boolean woken = false;
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            Content content = this._inputQ.peek();
            if (content == null) {
                try {
                    this.produceContent();
                }
                catch (IOException e) {
                    woken = this.failed(e);
                }
                content = this._inputQ.peek();
            }
            if (content != null) {
                available = this.remaining(content);
            }
        }
        if (woken) {
            this.wake();
        }
        return available;
    }

    private void wake() {
        HttpChannel channel = this._channelState.getHttpChannel();
        ThreadPool executor = channel.getConnector().getServer().getThreadPool();
        executor.execute(channel);
    }

    private long getBlockingTimeout() {
        return this.getHttpChannelState().getHttpChannel().getHttpConfiguration().getBlockingTimeout();
    }

    public int read() throws IOException {
        int read = this.read(this._oneByteBuffer, 0, 1);
        if (read == 0) {
            throw new IllegalStateException("unready read=0");
        }
        return read < 0 ? -1 : this._oneByteBuffer[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            long minimum_data;
            long period;
            long minRequestDataRate;
            long blockingTimeout;
            if (!this.isAsync() && this._blockUntil == 0L && (blockingTimeout = this.getBlockingTimeout()) > 0L) {
                this._blockUntil = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(blockingTimeout);
            }
            if ((minRequestDataRate = this._channelState.getHttpChannel().getHttpConfiguration().getMinRequestDataRate()) > 0L && this._firstByteTimeStamp != -1L && (period = System.nanoTime() - this._firstByteTimeStamp) > 0L && this._contentArrived < (minimum_data = minRequestDataRate * TimeUnit.NANOSECONDS.toMillis(period) / TimeUnit.SECONDS.toMillis(1L))) {
                throw new BadMessageException(408, String.format("Request data rate < %d B/s", minRequestDataRate));
            }
            do {
                Content item;
                if ((item = this.nextContent()) == null) continue;
                int l = this.get(item, b, off, len);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} read {} from {}", new Object[]{this, l, item});
                }
                this.consumeNonContent();
                return l;
            } while (this._state.blockForContent(this));
            return this._state.noContent();
        }
    }

    protected void produceContent() throws IOException {
    }

    protected Content nextContent() throws IOException {
        Content content = this.pollContent();
        if (content == null && !this.isFinished()) {
            this.produceContent();
            content = this.pollContent();
        }
        return content;
    }

    protected Content pollContent() {
        Content content = this._inputQ.peek();
        while (content != null && this.remaining(content) == 0) {
            this._inputQ.poll();
            content.succeeded();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} consumed {}", new Object[]{this, content});
            }
            if (content == EOF_CONTENT) {
                if (this._listener == null) {
                    this._state = EOF;
                } else {
                    this._state = AEOF;
                    boolean woken = this._channelState.onReadReady();
                    if (woken) {
                        this.wake();
                    }
                }
            } else if (content == EARLY_EOF_CONTENT) {
                this._state = EARLY_EOF;
            }
            content = this._inputQ.peek();
        }
        return content;
    }

    protected void consumeNonContent() {
        Content content = this._inputQ.peek();
        while (content != null && this.remaining(content) == 0 && !(content instanceof EofContent)) {
            this._inputQ.poll();
            content.succeeded();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} consumed {}", new Object[]{this, content});
            }
            content = this._inputQ.peek();
        }
    }

    protected Content nextReadable() throws IOException {
        Content content = this.pollReadable();
        if (content == null && !this.isFinished()) {
            this.produceContent();
            content = this.pollReadable();
        }
        return content;
    }

    protected Content pollReadable() {
        Content content = this._inputQ.peek();
        while (content != null) {
            if (content == EOF_CONTENT || content == EARLY_EOF_CONTENT || this.remaining(content) > 0) {
                return content;
            }
            this._inputQ.poll();
            content.succeeded();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} consumed {}", new Object[]{this, content});
            }
            content = this._inputQ.peek();
        }
        return null;
    }

    protected int remaining(Content item) {
        return item.remaining();
    }

    protected int get(Content content, byte[] buffer, int offset, int length) {
        int l = Math.min(content.remaining(), length);
        content.getContent().get(buffer, offset, l);
        this._contentConsumed += (long)l;
        return l;
    }

    protected void skip(Content content, int length) {
        int l = Math.min(content.remaining(), length);
        ByteBuffer buffer = content.getContent();
        buffer.position(buffer.position() + l);
        this._contentConsumed += (long)l;
        if (l > 0 && !content.hasContent()) {
            this.pollContent();
        }
    }

    protected void blockForContent() throws IOException {
        try {
            this._waitingForContent = true;
            this._channelState.getHttpChannel().onBlockWaitForContent();
            boolean loop = false;
            long timeout = 0L;
            while (true) {
                if (this._blockUntil != 0L && (timeout = TimeUnit.NANOSECONDS.toMillis(this._blockUntil - System.nanoTime())) <= 0L) {
                    throw new TimeoutException(String.format("Blocking timeout %d ms", this.getBlockingTimeout()));
                }
                if (!loop) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} blocking for content timeout={}", new Object[]{this, timeout});
                    }
                    if (timeout > 0L) {
                        this._inputQ.wait(timeout);
                    } else {
                        this._inputQ.wait();
                    }
                    loop = true;
                    continue;
                }
                break;
            }
        }
        catch (Throwable x) {
            this._channelState.getHttpChannel().onBlockWaitForContentFailure(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addContent(Content item) {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            this._waitingForContent = false;
            if (this._firstByteTimeStamp == -1L) {
                this._firstByteTimeStamp = System.nanoTime();
            }
            if (this.isFinished()) {
                Throwable failure = this.isError() ? ((ErrorState)this._state).getError() : new EOFException("Content after EOF");
                item.failed(failure);
                return false;
            }
            this._contentArrived += (long)item.remaining();
            this._inputQ.offer(item);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} addContent {}", new Object[]{this, item});
            }
            return this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasContent() {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            return this._inputQ.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            this._inputQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentConsumed() {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            return this._contentConsumed;
        }
    }

    public boolean earlyEOF() {
        return this.addContent(EARLY_EOF_CONTENT);
    }

    public boolean eof() {
        return this.addContent(EOF_CONTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consumeAll() {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            try {
                Content item;
                while ((item = this.nextContent()) != null) {
                    this.skip(item, this.remaining(item));
                }
                return this.isFinished() && !this.isError();
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isError() {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            return this._state instanceof ErrorState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsync() {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            return this._state == ASYNC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            return this._state instanceof EOFState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        try {
            Deque<Content> deque = this._inputQ;
            synchronized (deque) {
                if (this._listener == null) {
                    return true;
                }
                if (this._state instanceof EOFState) {
                    return true;
                }
                if (this.nextReadable() != null) {
                    return true;
                }
                this._channelState.onReadUnready();
                this._waitingForContent = true;
            }
            return false;
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadListener(ReadListener readListener) {
        readListener = Objects.requireNonNull(readListener);
        boolean woken = false;
        try {
            Deque<Content> deque = this._inputQ;
            synchronized (deque) {
                boolean content;
                if (this._listener != null) {
                    throw new IllegalStateException("ReadListener already set");
                }
                if (this._state != STREAM) {
                    throw new IllegalStateException("State " + STREAM + " != " + this._state);
                }
                this._state = ASYNC;
                this._listener = readListener;
                boolean bl = content = this.nextContent() != null;
                if (content) {
                    woken = this._channelState.onReadReady();
                } else {
                    this._channelState.onReadUnready();
                    this._waitingForContent = true;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        if (woken) {
            this.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onIdleTimeout(Throwable x) {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            if (this._waitingForContent && !this.isError()) {
                x.addSuppressed(new Throwable("HttpInput idle timeout"));
                this._state = new ErrorState(x);
                return this.wakeup();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failed(Throwable x) {
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            if (this.isError()) {
                if (LOG.isDebugEnabled()) {
                    Throwable failure = new Throwable(((ErrorState)this._state).getError());
                    failure.addSuppressed(x);
                    LOG.debug(failure);
                }
            } else {
                x.addSuppressed(new Throwable("HttpInput failure"));
                this._state = new ErrorState(x);
            }
            return this.wakeup();
        }
    }

    private boolean wakeup() {
        if (this._listener != null) {
            return this._channelState.onReadPossible();
        }
        this._inputQ.notify();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable error;
        ReadListener listener;
        boolean aeof = false;
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            if (this._state == EOF) {
                return;
            }
            if (this._state == AEOF) {
                this._state = EOF;
                aeof = true;
            }
            listener = this._listener;
            error = this._state instanceof ErrorState ? ((ErrorState)this._state).getError() : null;
        }
        try {
            if (error != null) {
                this._channelState.getHttpChannel().getResponse().getHttpFields().add(HttpConnection.CONNECTION_CLOSE);
                listener.onError(error);
            } else if (aeof) {
                listener.onAllDataRead();
            } else {
                listener.onDataAvailable();
            }
        }
        catch (Throwable e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
            try {
                if (aeof || error == null) {
                    this._channelState.getHttpChannel().getResponse().getHttpFields().add(HttpConnection.CONNECTION_CLOSE);
                    listener.onError(e);
                }
            }
            catch (Throwable e2) {
                LOG.warn(e2.toString(), new Object[0]);
                LOG.debug(e2);
                throw new RuntimeIOException(e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Content content;
        int q;
        long consumed;
        State state;
        Deque<Content> deque = this._inputQ;
        synchronized (deque) {
            state = this._state;
            consumed = this._contentConsumed;
            q = this._inputQ.size();
            content = this._inputQ.peekFirst();
        }
        return String.format("%s@%x[c=%d,q=%d,[0]=%s,s=%s]", this.getClass().getSimpleName(), this.hashCode(), consumed, q, content, state);
    }

    protected class ErrorState
    extends EOFState {
        final Throwable _error;

        ErrorState(Throwable error) {
            this._error = error;
        }

        public Throwable getError() {
            return this._error;
        }

        @Override
        public int noContent() throws IOException {
            if (this._error instanceof IOException) {
                throw (IOException)this._error;
            }
            throw new IOException(this._error);
        }

        public String toString() {
            return "ERROR:" + this._error;
        }
    }

    protected static class EOFState
    extends State {
        protected EOFState() {
        }
    }

    protected static abstract class State {
        protected State() {
        }

        public boolean blockForContent(HttpInput in) throws IOException {
            return false;
        }

        public int noContent() throws IOException {
            return -1;
        }
    }

    public static class Content
    implements Callback {
        private final ByteBuffer _content;

        public Content(ByteBuffer content) {
            this._content = content;
        }

        public boolean isNonBlocking() {
            return true;
        }

        public ByteBuffer getContent() {
            return this._content;
        }

        public boolean hasContent() {
            return this._content.hasRemaining();
        }

        public int remaining() {
            return this._content.remaining();
        }

        public String toString() {
            return String.format("Content@%x{%s}", this.hashCode(), BufferUtil.toDetailString((ByteBuffer)this._content));
        }
    }

    public static class EofContent
    extends PoisonPillContent {
        EofContent(String name) {
            super(name);
        }
    }

    public static class PoisonPillContent
    extends Content {
        private final String _name;

        public PoisonPillContent(String name) {
            super(BufferUtil.EMPTY_BUFFER);
            this._name = name;
        }

        @Override
        public String toString() {
            return this._name;
        }
    }
}

