/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.MemoryFetchedInput;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapOutput;
import org.apache.uniffle.com.google.common.primitives.Ints;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.ChecksumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssTezBypassWriter {
    private static final Logger LOG = LoggerFactory.getLogger(RssTezBypassWriter.class);
    private static final byte[] HEADER = new byte[]{84, 73, 70, 0};

    public static void write(MapOutput mapOutput, byte[] buffer) {
        LOG.info("RssTezBypassWriter write mapOutput, type:{}, buffer length:{}", (Object)mapOutput.getType(), (Object)buffer.length);
        if (mapOutput.getType() != MapOutput.Type.MEMORY) {
            if (mapOutput.getType() == MapOutput.Type.DISK) {
                throw new RssException("RSS does not support OnDiskMapOutput as shuffle ouput, try to reduce mapreduce.reduce.shuffle.memory.limit.percent");
            }
            throw new RssException("Merger reserve unknown type of MapOutput: " + mapOutput.getClass().getCanonicalName());
        }
        byte[] memory = mapOutput.getMemory();
        System.arraycopy(buffer, 0, memory, 0, buffer.length);
    }

    public static void write(FetchedInput mapOutput, byte[] buffer) throws IOException {
        LOG.info("RssTezBypassWriter write mapOutput, type:{}, buffer length:{}", (Object)mapOutput.getType(), (Object)buffer.length);
        if (mapOutput.getType() == FetchedInput.Type.MEMORY) {
            byte[] memory = ((MemoryFetchedInput)mapOutput).getBytes();
            System.arraycopy(buffer, 0, memory, 0, buffer.length);
        } else if (mapOutput.getType() == FetchedInput.Type.DISK) {
            OutputStream output = mapOutput.getOutputStream();
            output.write(HEADER);
            output.write(buffer);
            output.write(Ints.toByteArray((int)ChecksumUtils.getCrc32(buffer)));
            output.flush();
            output.close();
        } else {
            throw new RssException("Merger reserve unknown type of MapOutput: " + mapOutput.getClass().getCanonicalName());
        }
    }
}

