/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.lang;

import java.io.Serializable;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.serialize.java.JavaSerializer;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketObjects {
    private static final Logger log = LoggerFactory.getLogger(WicketObjects.class);
    private static IObjectSizeOfStrategy objectSizeOfStrategy = new SerializingObjectSizeOfStrategy();

    private WicketObjects() {
    }

    public static <T> Class<T> resolveClass(String className) {
        Class<?> resolved = null;
        try {
            if (Application.exists()) {
                resolved = Application.get().getApplicationSettings().getClassResolver().resolveClass(className);
            }
            if (resolved == null) {
                resolved = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException cnfx) {
            log.warn("Could not resolve class [" + className + "]", cnfx);
        }
        return resolved;
    }

    public static <T> T cloneObject(T object) {
        byte[] serialized;
        if (object == null) {
            return null;
        }
        ISerializer serializer = null;
        if (Application.exists()) {
            serializer = Application.get().getFrameworkSettings().getSerializer();
        }
        if (serializer == null || serializer instanceof JavaSerializer) {
            serializer = new JavaSerializer(SerializingObjectSizeOfStrategy.class.getName());
        }
        if ((serialized = serializer.serialize(object)) == null) {
            throw new IllegalStateException("A problem occurred while serializing an object. Please check the earlier logs for more details. Problematic object: " + String.valueOf(object));
        }
        Object deserialized = serializer.deserialize(serialized);
        return (T)deserialized;
    }

    public static <T> T newInstance(String className) {
        if (!Strings.isEmpty(className)) {
            try {
                Class<T> c = WicketObjects.resolveClass(className);
                return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new WicketRuntimeException("Unable to create " + className, e);
            }
        }
        return null;
    }

    public static void setObjectSizeOfStrategy(IObjectSizeOfStrategy objectSizeOfStrategy) {
        WicketObjects.objectSizeOfStrategy = objectSizeOfStrategy == null ? new SerializingObjectSizeOfStrategy() : objectSizeOfStrategy;
        log.info("using " + String.valueOf(objectSizeOfStrategy) + " for calculating object sizes");
    }

    public static long sizeof(Serializable object) {
        Serializable target = object;
        if (object instanceof Component) {
            Component clone = (Component)WicketObjects.cloneObject(object);
            clone.detach();
            target = clone;
        } else if (object instanceof IDetachable) {
            IDetachable clone = (IDetachable)WicketObjects.cloneObject(object);
            clone.detach();
            target = clone;
        }
        return objectSizeOfStrategy.sizeOf(target);
    }

    public static final class SerializingObjectSizeOfStrategy
    implements IObjectSizeOfStrategy {
        @Override
        public long sizeOf(Serializable object) {
            if (object == null) {
                return 0L;
            }
            ISerializer serializer = null;
            if (Application.exists()) {
                serializer = Application.get().getFrameworkSettings().getSerializer();
            }
            if (serializer == null || serializer instanceof JavaSerializer) {
                serializer = new JavaSerializer(SerializingObjectSizeOfStrategy.class.getName());
            }
            byte[] serialized = serializer.serialize(object);
            int size = -1;
            if (serialized != null) {
                size = serialized.length;
            }
            return size;
        }
    }

    public static interface IObjectSizeOfStrategy {
        public long sizeOf(Serializable var1);
    }
}

