
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *      This method declares the attribute specified by node to be of type ID. If the value of the specified attribute 
 *      is unique then this element node can later be retrieved using getElementById on Document. Note, however, 
 *      that this simply affects this node and does not change any grammar that may be in use. 
 *      
 *      Invoke setIdAttributeNode on the 2nd acronym element and 3rd p element using the title and xmlns:dmstc attributes respectively
 *      as parameters .  Verify by calling isID on the attribute node and getElementById on document node.  
 *     
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttrNode">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttrNode</a>
*/
public final class elementsetidattributenode08 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public elementsetidattributenode08(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elemList1;
      NodeList elemList2;
      Element acronymElem;
      Element pElem;
      NamedNodeMap attributesMap;
      Attr attr;
      boolean id = false;
      Element elem;
      String elemName;
      doc = (Document) load("hc_staff", false);
      elemList1 = doc.getElementsByTagNameNS("*", "acronym");
      elemList2 = doc.getElementsByTagNameNS("*", "p");
      acronymElem = (Element) elemList1.item(1);
      pElem = (Element) elemList2.item(2);
      attributesMap = acronymElem.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("title");
      acronymElem.setIdAttributeNode(attr, true);
      id = attr.isId();
      assertTrue("elementsetidattributenodeIsId1True08", id);
      attributesMap = pElem.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("xmlns:dmstc");
      pElem.setIdAttributeNode(attr, true);
      id = attr.isId();
      assertTrue("elementsetidattributenodeIsId2True08", id);
      elem = doc.getElementById("Yes");
      elemName = elem.getTagName();
      assertEquals("elementsetidattributenode1GetElementById08", "acronym", elemName);
      elem = doc.getElementById("http://www.netzero.com");
      elemName = elem.getTagName();
      assertEquals("elementsetidattributenode2GetElementById08", "p", elemName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/elementsetidattributenode08";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(elementsetidattributenode08.class, args);
   }
}

