/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import org.apache.fop.util.bitmap.BitmapImageUtil;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;

public final class PSPainterUtil {
    private PSPainterUtil() {
    }

    public static void drawTransparency(PSGenerator generator, Rectangle rect, Paint fill) {
        PSGraphics2D graphics = new PSGraphics2D(true, generator);
        graphics.setGraphicContext(new GraphicContext());
        BufferedImage image = PSPainterUtil.buildImage((Color)fill, rect.width / 1000, rect.height / 1000);
        RenderedImage mask = PSPainterUtil.buildMaskImage(image, rect.width / 1000, rect.height / 1000);
        graphics.drawImage((Image)image, rect.x / 1000, rect.y / 1000, null, null, mask);
    }

    private static BufferedImage buildImage(Color color, int width, int height) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Color alpha = new Color(color.getAlpha(), color.getAlpha(), color.getAlpha());
        graphics.setColor(alpha);
        graphics.fillRect(0, 0, width, height);
        graphics.dispose();
        return bufferedImage;
    }

    private static RenderedImage buildMaskImage(BufferedImage image, int width, int height) {
        return BitmapImageUtil.convertToMonochrome((RenderedImage)image, (Dimension)new Dimension(width, height), (float)1.0f);
    }
}

