/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
/**
 * A read only store of text attributes as returned by {@link
 * TextIter#getAttributes(TextAttributes)}.
 */
public class TextAttributes extends Boxed 
{
	/**
	 */
	protected TextAttributes (Handle handle){
		super(handle);
	}
    
    /**
     * Internal static factory method to be used by Java-Gnome only.
     */
    protected static TextAttributes getTextAttributes(Handle handle) {
        if (handle == null)
            return null;
        
        TextAttributes textAttributes = (TextAttributes)
            Boxed.getBoxedFromHandle(handle);
        
        if (textAttributes == null)
            textAttributes = new TextAttributes(handle);
        
        return textAttributes;
    }

	/**
	 */
	public TextAppearance getAppearance(){
        Handle handle = getAppearance(getHandle());
        return TextAppearance.getTextAppearance(handle);
	}

	/**
	 */
	public Justification getJustification(){
		return Justification.intern( getJustification(getHandle()) );
	}

	/**
	 */
	public TextDirection getDirection(){
		return TextDirection.intern( getDirection(getHandle()) );
	}

	/**
	 */
	public org.gnu.pango.FontDescription getFontDescription(){
		return new org.gnu.pango.FontDescription( getFont(getHandle()) );
	}

	/**
	 */
	public double getFontScale(){
		return getFontScale(getHandle());
	}

	/**
	 */
	public int getLeftMargin(){
		return getLeftMargin(getHandle());
	}

	/**
	 */
	public int getIndent(){
		return getIndent(getHandle());
	}

	/**
	 */
	public int getRightMargin(){
		return getRightMargin(getHandle());
	}

	/**
	 */
	public int getPixelsAboveLines(){
		return getPixelsAboveLines(getHandle());
	}

	/**
	 */
	public int getPixelsBelowLines(){
		return getPixelsBelowLines(getHandle());
	}

	/**
	 */
	public int getPixelsInsideWrap(){
		return getPixelsInsideWrap(getHandle());
	}

	/**
	 */
	public org.gnu.pango.TabArray getTabArray(){
		return new org.gnu.pango.TabArray( getTabs(getHandle()) );
	}

	/**
	 */
	public WrapMode getWrapMode(){
		return WrapMode.intern( getWrapMode(getHandle()) );
	}

	/**
	 */
	public org.gnu.pango.Language getLanguage(){
		return new org.gnu.pango.Language( getLanguage(getHandle()) );
	}

	/**
	 */
	public boolean getInvisible(){
		return getInvisible(getHandle());
	}

	/**
	 */
	public boolean getBgFullHeight(){
		return getBgFullHeight(getHandle());
	}

	/**
	 */
	public boolean getEditable(){
		return getEditable(getHandle());
	}

	/**
	 */
	public boolean getRealized(){
		return getRealized(getHandle());
	}

    native static final protected Handle getAppearance (Handle cptr);
    native static final protected int getJustification (Handle cptr);
    native static final protected int getDirection (Handle cptr);
    native static final protected Handle getFont (Handle cptr);
    native static final protected double getFontScale (Handle cptr);
    native static final protected int getLeftMargin (Handle cptr);
    native static final protected int getIndent (Handle cptr);
    native static final protected int getRightMargin (Handle cptr);
    native static final protected int getPixelsAboveLines (Handle cptr);
    native static final protected int getPixelsBelowLines (Handle cptr);
    native static final protected int getPixelsInsideWrap (Handle cptr);
    native static final protected Handle getTabs (Handle cptr);
    native static final protected int getWrapMode (Handle cptr);
    native static final protected Handle getLanguage (Handle cptr);
    native static final protected boolean getInvisible (Handle cptr);
    native static final protected boolean getBgFullHeight (Handle cptr);
    native static final protected boolean getEditable (Handle cptr);
    native static final protected boolean getRealized (Handle cptr);
    native static final protected boolean getPad1 (Handle cptr);
    native static final protected boolean getPad2 (Handle cptr);
    native static final protected boolean getPad3 (Handle cptr);
    native static final protected boolean getPad4 (Handle cptr);
    native static final protected Handle gtk_text_attributes_new ();
    native static final protected Handle gtk_text_attributes_copy (Handle src);
    native static final protected void gtk_text_attributes_unref (Handle values);
    native static final protected void gtk_text_attributes_ref (Handle values);
}

