/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.Handle;

/**
 *
 */
public class EventProperty extends Event
{
    /**
     * Promotion constructor. Construct the specific event object by
     * promoting (sharing the <tt>Handle</tt> object of) the base
     * <tt>Event</tt>.
     */
    public EventProperty( Event evt ) {
        // We share the handle with both instances.  This avoids
        // copying the event (via the constructor ( super( evt ) ).
        // It is more of a "promotion" constructor.
        super( evt.getHandle() );
    }

    native static final protected Handle getWindow (Handle obj);
    native static final protected boolean getSendEvent (Handle obj);
    native static final protected int getAtom (Handle obj);
    native static final protected int getTime (Handle obj);
    native static final protected int getState (Handle obj);
}

