/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * This is the listener interface for receiving container events on a
 * Container.  Objects that are interested in container events should 
 * implement this interface and then register with the 
 * <code>Container</code> using the <code>addContainerListener()</code> method.
 * 
 * @see ContainerEvent
 *
 * @author Tom Ball
 */
public interface ContainerListener {
	
	/**
	 * Indicates that the <code>Container</code> has changed.
	 * 
	 * @param event The event that identifies the details of the event
	 */	
	public void containerEvent(ContainerEvent event);
	
}
