/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.Handle;
import org.gnu.pango.Attribute;

/**
 *
 */
public class PangoAttrEmbossed extends Attribute
{
    public PangoAttrEmbossed( boolean embossed ) {
        super( gdk_pango_attr_embossed_new( embossed ) );
    }

    public boolean getEmbossed() {
        return getEmbossed( getHandle() );
    }

    native static final protected boolean getEmbossed (Handle obj);
    native static final protected Handle gdk_pango_attr_embossed_new (boolean embossed);
}

