/*
 * Java-Gnome Bindings Library
 *
 * Copyright 2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

/**
 * Interface used in filtering the visible rows of a {@link TreeModel}.
 */
public interface TreeModelFilterVisibleMethod {
    /**
     * Determine whether the given row (<tt>iter</tt>) in the given 
     * <tt>TreeModel</tt> should be visible.
     * 
     * @return <tt>true</tt> if the row should be visible, <tt>false</tt> 
     * otherwise.
     */
    public boolean filter( TreeModel model, TreeIter iter );
}
