/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-01 07:00:31 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gdk.PixbufLoader
     * Method:    gdk_pixbuf_loader_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1get_1type (JNIEnv 
        *env, jclass cls) 
    {
        {
            return (jint)gdk_pixbuf_loader_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gdk.PixbufLoader
     * Method:    gdk_pixbuf_loader_new
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1new (JNIEnv *env, 
        jclass cls) 
    {
        {
            return (jint)gdk_pixbuf_loader_new ();
        }
    }

    /*
     * Class:     org.gnu.gdk.PixbufLoader
     * Method:    gdk_pixbuf_loader_new_with_type
     * Signature: (java.lang.String;I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1new_1with_1type (
        JNIEnv *env, jclass cls, jstring imageType, jint error) 
    {
        const gchar* imageType_g = (*env)->GetStringUTFChars(env, imageType, 0);
        jint result = (jint)gdk_pixbuf_loader_new_with_type (imageType_g, (GError**)error);
        (*env)->ReleaseStringUTFChars(env, imageType, imageType_g);
        return result;
    }

    /*
     * Class:     org.gnu.gdk.PixbufLoader
     * Method:    gdk_pixbuf_loader_write
     * Signature: (I[BII)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1write (JNIEnv 
        *env, jclass cls, jint loader, jbyteArray buf, jint count, jint error) 
    {
        GdkPixbufLoader *loader_g = (GdkPixbufLoader *)loader;
        jint buf_len = (*env)->GetArrayLength(env, buf);
        gchar* buf_g = (gchar*)g_malloc(buf_len + 1);
        gint32 count_g = (gint32) count;
        GError **error_g = (GError **)error;
        (*env)->GetByteArrayRegion(env, buf, 0, buf_len, (jbyte*)buf_g);
        buf_g[buf_len] = 0;
        {
            jboolean result_j = (jboolean) (gdk_pixbuf_loader_write (loader_g, buf_g, count_g, 
                    error_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gdk.PixbufLoader
     * Method:    gdk_pixbuf_loader_get_pixbuf
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1get_1pixbuf (JNIEnv 
        *env, jclass cls, jint loader) 
    {
        GdkPixbufLoader *loader_g = (GdkPixbufLoader *)loader;
        {
            return (jint)gdk_pixbuf_loader_get_pixbuf (loader_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.PixbufLoader
     * Method:    gdk_pixbuf_loader_get_animation
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1get_1animation (
        JNIEnv *env, jclass cls, jint loader) 
    {
        GdkPixbufLoader *loader_g = (GdkPixbufLoader *)loader;
        {
            return (jint)gdk_pixbuf_loader_get_animation (loader_g);
        }
    }

    /*
     * Class:     org.gnu.gdk.PixbufLoader
     * Method:    gdk_pixbuf_loader_close
     * Signature: (II)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1close (JNIEnv 
        *env, jclass cls, jint loader, jint error) 
    {
        GdkPixbufLoader *loader_g = (GdkPixbufLoader *)loader;
        GError *error_g = (GError *)error;
        {
            jboolean result_j = (jboolean) (gdk_pixbuf_loader_close (loader_g, &error_g));
            return result_j;
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
