// -*- c++ -*-
// Generated by gmmproc 2.39.92 -- DO NOT MODIFY!
#ifndef _GTKMM_POPOVER_H
#define _GTKMM_POPOVER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2013 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/bin.h>
#include <giomm/menumodel.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkPopover GtkPopover;
typedef struct _GtkPopoverClass GtkPopoverClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Popover_Class; } // namespace Gtk
namespace Gtk
{

/** Context dependent bubbles.
 *
 * Gtk::Popover is a bubble-like context window, primarily meant to
 * provide context-dependent information or options. Popovers are
 * attached to a widget, passed at construction time on Gtk::Popover(),
 * or updated afterwards through Gtk::Popover::set_relative_to(), by
 * default they will point to the whole widget area, although this
 * behavior can be changed through Gtk::Popover::set_pointing_to().
 *
 * The position of a popover relative to the widget it is attached to
 * can also be changed through Gtk::Popover::set_position().
 *
 * By default, Gtk::Popover performs a GTK+ grab, in order to ensure
 * input events get redirected to it while it is shown, and also so
 * the popover is dismissed in the expected situations (clicks outside
 * the popover, or the Esc key being pressed). If no such modal behavior
 * is desired on a popover, Gtk::Popover::set_modal() may be called on it
 * to tweak its behavior.
 *
 * @ingroup Widgets
 * @newin{3,12}
 */

class Popover
  : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Popover CppObjectType;
  typedef Popover_Class CppClassType;
  typedef GtkPopover BaseObjectType;
  typedef GtkPopoverClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Popover();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Popover_Class;
  static CppClassType popover_class_;

  // noncopyable
  Popover(const Popover&);
  Popover& operator=(const Popover&);

protected:
  explicit Popover(const Glib::ConstructParams& construct_params);
  explicit Popover(GtkPopover* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkPopover*       gobj()       { return reinterpret_cast<GtkPopover*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkPopover* gobj() const { return reinterpret_cast<GtkPopover*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_closed().
  virtual void on_closed();


private:

public:

  /** Creates a new popover to point to @a relative_to
   *
   * @param relative_to The Gtk::Widget the popover is related to
   */
    explicit Popover(const Widget& relative_to);


  /// A Popover() convenience overload.
  explicit Popover();


  //This is custom-implemented because the gtk_popover_new_from_model() does more
  //than just call g_object_new. MenuBar and Menu have both them same issue.
  //See https://bugzilla.gnome.org/show_bug.cgi?id=704671
  /** Creates a Popover and populates it according to
   * @a model. The popover is pointed to the @a relative_to widget.
   *
   * The created buttons are connected to actions found in the
   * ApplicationWindow to which the popover belongs - typically
   * by means of being attached to a widget that is contained within
   * the ApplicationWindow widget hierarchy.
   *
   * Actions can also be added using Widget::insert_action_group()
   * on the menu's attached widget or on any of its parent widgets.
   *
   * @param relative_to: Widget the popover is related to
   * @param model: a Gio::MenuModel
   *
   * @newin{3,12}
   */
  explicit Popover(const Widget& relative_to, const Glib::RefPtr<Gio::MenuModel>& model);

  /** Creates a Popover and populates it according to
   * @a model.
   *
   * The created buttons are connected to actions found in the
   * ApplicationWindow to which the popover belongs - typically
   * by means of being attached to a widget that is contained within
   * the ApplicationWindow widget hierarchy.
   *
   * Actions can also be added using Widget::insert_action_group()
   * on the menu's attached widget or on any of its parent widgets.
   *
   * @param model: a Gio::MenuModel
   *
   * @newin{3,12}
   */
  explicit Popover(const Glib::RefPtr<Gio::MenuModel>& model);

  
  /** Sets a new widget to be attached to @a popover. If @a popover is
   * visible, the position will be updated.
   * 
   * @note the ownership of popovers is always given to their @a relative_to
   * widget, so if @a relative_to is set to <tt>0</tt> on an attached @a popover, it
   * will be detached from its previous widget, and consequently destroyed
   * unless extra references are kept.
   * 
   * @newin{3,12}
   * @param relative_to A Gtk::Widget.
   */
  void set_relative_to(const Widget& relative_to);
  // transfer none
  
  /** Returns the widget @a popover is currently attached to
   * 
   * @newin{3,12}
   * @return A Gtk::Widget.
   */
  Widget* get_relative_to();
  
  /** Returns the widget @a popover is currently attached to
   * 
   * @newin{3,12}
   * @return A Gtk::Widget.
   */
  const Widget* get_relative_to() const;

  //This cannot take NULL to mean unset.
 

  /** Sets the rectangle that @a popover will point to, in the
   * coordinate space of the widget @a popover is attached to,
   * see set_relative_to().
   * 
   * @newin{3,12}
   * @param rect Rectangle to point to.
   */
  void set_pointing_to(const Gdk::Rectangle& rect);
 

  /** If a rectangle to point to has been set, this function will
   * return <tt>true</tt> and fill in @a rect with such rectangle, otherwise
   * it will return <tt>false</tt> and fill in @a rect with the attached
   * widget coordinates.
   * @param rect Location to store the rectangle.
   * @return <tt>true</tt> if a rectangle to point to was set.
   */
  bool get_pointing_to(Gdk::Rectangle& rect) const;

  
  /** Sets the preferred position for @a popover to appear. If the @a popover
   * is currently visible, it will be immediately updated.
   * 
   * This preference will be respected where possible, although
   * on lack of space (eg. if close to the window edges), the
   * Gtk::Popover may choose to appear on the opposite side
   * 
   * @newin{3,12}
   * @param position Preferred popover position.
   */
  void set_position(PositionType position =  POS_TOP);
  
  /** Returns the preferred position of @a popover.
   * @return The preferred position.
   */
  PositionType get_position() const;

  
  /** Sets whether @a popover is modal, a modal popover will grab all input
   * within the toplevel and grab the keyboard focus on it when being
   * displayed. Clicking outside the popover area or pressing Esc will
   * dismiss the popover and ungrab input.
   * 
   * @newin{3,12}
   * @param modal #<tt>true</tt> to make popover claim all input within the toplevel.
   */
  void set_modal(bool modal =  true);
  
  /** Returns whether the popover is modal, see gtk_popover_set_modal to
   * see the implications of this.
   * 
   * @newin{3,12}
   * @return #<tt>true</tt> if @a popover is modal.
   */
  bool get_modal() const;

  
  /** Establishes a binding between a Gtk::Popover and a MenuModel.
   * 
   * The contents of @a popover are removed and then refilled with menu items
   * according to @a model.  When @a model changes, @a popover is updated.
   * Calling this function twice on @a popover with different @a model will
   * cause the first binding to be replaced with a binding to the new
   * model. If @a model is <tt>0</tt> then any previous binding is undone and
   * all children are removed.
   * 
   * If @a action_namespace is non-<tt>0</tt> then the effect is as if all
   * actions mentioned in the @a model have their names prefixed with the
   * namespace, plus a dot.  For example, if the action “quit” is
   * mentioned and @a action_namespace is “app” then the effective action
   * name is “app.quit”.
   * 
   * This function uses Gtk::Actionable to define the action name and
   * target values on the created menu items.  If you want to use an
   * action group other than “app” and “win”, or if you want to use a
   * Gtk::MenuShell outside of a Gtk::ApplicationWindow, then you will need
   * to attach your own action group to the widget hierarchy using
   * Gtk::Widget::insert_action_group().  As an example, if you created a
   * group with a “quit” action and inserted it with the name “mygroup”
   * then you would use the action name “mygroup.quit” in your
   * MenuModel.
   * 
   * @newin{3,12}
   * @param model The MenuModel to bind to or <tt>0</tt> to remove
   * binding.
   * @param action_namespace The namespace for actions in @a model.
   */
  void bind_model(const Glib::RefPtr<Gio::MenuModel>& model, const Glib::ustring& action_namespace);

  /// A bind_model() convenience overload.
  void bind_model(const Glib::RefPtr<Gio::MenuModel>& model);


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Widget the bubble window points to.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_relative_to() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Widget the bubble window points to.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_relative_to() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

// TODO
//  _WRAP_PROPERTY("pointing-to", Gdk::Rectangle)
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Position to place the bubble window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< PositionType > property_position() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Position to place the bubble window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< PositionType > property_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the popover is modal.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_modal() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the popover is modal.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_modal() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%closed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_closed();


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Popover
   */
  Gtk::Popover* wrap(GtkPopover* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_POPOVER_H */

