/* baobab-ringschart.c generated by valac 0.24.0.145-7a3bd, the Vala compiler
 * generated from baobab-ringschart.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2008  Igalia
 * Copyright (C) 2013  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *
 * Authors of the original code:
 *   Felipe Erias <femorandeira@igalia.com>
 *   Pablo Santamaria <psantamaria@igalia.com>
 *   Jacobo Aragunde <jaragunde@igalia.com>
 *   Eduardo Lima <elima@igalia.com>
 *   Mario Sanchez <msanchez@igalia.com>
 *   Miguel Gomez <magomez@igalia.com>
 *   Henrique Ferreiro <hferreiro@igalia.com>
 *   Alejandro Pinheiro <apinheiro@igalia.com>
 *   Carlos Sanmartin <csanmartin@igalia.com>
 *   Alejandro Garcia <alex@igalia.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <pango/pango.h>


#define BAOBAB_TYPE_CHART_ITEM (baobab_chart_item_get_type ())
#define BAOBAB_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItem))
#define BAOBAB_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))
#define BAOBAB_IS_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_IS_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_CHART_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))

typedef struct _BaobabChartItem BaobabChartItem;
typedef struct _BaobabChartItemClass BaobabChartItemClass;
typedef struct _BaobabChartItemPrivate BaobabChartItemPrivate;

#define BAOBAB_TYPE_RINGSCHART_ITEM (baobab_ringschart_item_get_type ())
#define BAOBAB_RINGSCHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItem))
#define BAOBAB_RINGSCHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItemClass))
#define BAOBAB_IS_RINGSCHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_RINGSCHART_ITEM))
#define BAOBAB_IS_RINGSCHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_RINGSCHART_ITEM))
#define BAOBAB_RINGSCHART_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItemClass))

typedef struct _BaobabRingschartItem BaobabRingschartItem;
typedef struct _BaobabRingschartItemClass BaobabRingschartItemClass;
typedef struct _BaobabRingschartItemPrivate BaobabRingschartItemPrivate;

#define BAOBAB_TYPE_CHART (baobab_chart_get_type ())
#define BAOBAB_CHART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART, BaobabChart))
#define BAOBAB_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART, BaobabChartClass))
#define BAOBAB_IS_CHART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART))
#define BAOBAB_IS_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART))
#define BAOBAB_CHART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART, BaobabChartClass))

typedef struct _BaobabChart BaobabChart;
typedef struct _BaobabChartClass BaobabChartClass;
typedef struct _BaobabChartPrivate BaobabChartPrivate;

#define BAOBAB_TYPE_RINGSCHART (baobab_ringschart_get_type ())
#define BAOBAB_RINGSCHART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_RINGSCHART, BaobabRingschart))
#define BAOBAB_RINGSCHART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_RINGSCHART, BaobabRingschartClass))
#define BAOBAB_IS_RINGSCHART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_RINGSCHART))
#define BAOBAB_IS_RINGSCHART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_RINGSCHART))
#define BAOBAB_RINGSCHART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_RINGSCHART, BaobabRingschartClass))

typedef struct _BaobabRingschart BaobabRingschart;
typedef struct _BaobabRingschartClass BaobabRingschartClass;
typedef struct _BaobabRingschartPrivate BaobabRingschartPrivate;
#define __g_list_free__baobab_chart_item_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__baobab_chart_item_unref0_ (var), NULL)))
#define _baobab_chart_item_unref0(var) ((var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BaobabChartItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BaobabChartItemPrivate * priv;
	gchar* name;
	gchar* size;
	guint depth;
	gdouble rel_start;
	gdouble rel_size;
	GtkTreeIter iter;
	gboolean visible;
	gboolean has_any_child;
	gboolean has_visible_children;
	GdkRectangle rect;
	GList* parent;
};

struct _BaobabChartItemClass {
	GTypeClass parent_class;
	void (*finalize) (BaobabChartItem *self);
};

struct _BaobabRingschartItem {
	BaobabChartItem parent_instance;
	BaobabRingschartItemPrivate * priv;
	gdouble min_radius;
	gdouble max_radius;
	gdouble start_angle;
	gdouble angle;
	gboolean continued;
};

struct _BaobabRingschartItemClass {
	BaobabChartItemClass parent_class;
};

struct _BaobabChart {
	GtkDrawingArea parent_instance;
	BaobabChartPrivate * priv;
};

struct _BaobabChartClass {
	GtkDrawingAreaClass parent_class;
	void (*post_draw) (BaobabChart* self, cairo_t* cr);
	void (*draw_item) (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
	void (*calculate_item_geometry) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*is_point_over_item) (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y);
	void (*get_item_rectangle) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*can_zoom_in) (BaobabChart* self);
	gboolean (*can_zoom_out) (BaobabChart* self);
	BaobabChartItem* (*create_new_chartitem) (BaobabChart* self);
	void (*item_activated) (BaobabChart* self, GtkTreeIter* iter);
};

struct _BaobabRingschart {
	BaobabChart parent_instance;
	BaobabRingschartPrivate * priv;
};

struct _BaobabRingschartClass {
	BaobabChartClass parent_class;
};

struct _BaobabRingschartPrivate {
	guint tips_timeout_id;
	gboolean drawing_subtips;
	GList* subtip_items;
};


static gpointer baobab_ringschart_item_parent_class = NULL;
static gpointer baobab_ringschart_parent_class = NULL;

gpointer baobab_chart_item_ref (gpointer instance);
void baobab_chart_item_unref (gpointer instance);
GParamSpec* baobab_param_spec_chart_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_chart_item (GValue* value, gpointer v_object);
void baobab_value_take_chart_item (GValue* value, gpointer v_object);
gpointer baobab_value_get_chart_item (const GValue* value);
GType baobab_chart_item_get_type (void) G_GNUC_CONST;
GType baobab_ringschart_item_get_type (void) G_GNUC_CONST;
enum  {
	BAOBAB_RINGSCHART_ITEM_DUMMY_PROPERTY
};
BaobabRingschartItem* baobab_ringschart_item_new (void);
BaobabRingschartItem* baobab_ringschart_item_construct (GType object_type);
BaobabChartItem* baobab_chart_item_construct (GType object_type);
static void baobab_ringschart_item_finalize (BaobabChartItem* obj);
GType baobab_chart_get_type (void) G_GNUC_CONST;
GType baobab_ringschart_get_type (void) G_GNUC_CONST;
#define BAOBAB_RINGSCHART_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_RINGSCHART, BaobabRingschartPrivate))
enum  {
	BAOBAB_RINGSCHART_DUMMY_PROPERTY
};
static void _baobab_chart_item_unref0_ (gpointer var);
static void _g_list_free__baobab_chart_item_unref0_ (GList* self);
#define BAOBAB_RINGSCHART_ITEM_BORDER_WIDTH 1
#define BAOBAB_RINGSCHART_ITEM_MIN_ANGLE 0.03
#define BAOBAB_RINGSCHART_EDGE_ANGLE 0.004
#define BAOBAB_RINGSCHART_SUBTIP_TIMEOUT 1000
static void baobab_ringschart_subtips_update (BaobabRingschart* self);
BaobabChartItem* baobab_chart_get_highlighted_item (BaobabChart* self);
static gboolean ___lambda22_ (BaobabRingschart* self);
static gboolean ____lambda22__gsource_func (gpointer self);
static BaobabChartItem* baobab_ringschart_real_create_new_chartitem (BaobabChart* base);
static void baobab_ringschart_real_post_draw (BaobabChart* base, cairo_t* cr);
static void baobab_ringschart_real_draw_item (BaobabChart* base, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
void baobab_chart_get_item_color (BaobabChart* self, gdouble rel_position, guint depth, gboolean highlighted, GdkRGBA* result);
static void baobab_ringschart_real_calculate_item_geometry (BaobabChart* base, BaobabChartItem* item);
guint baobab_chart_get_max_depth (BaobabChart* self);
void baobab_chart_get_item_rectangle (BaobabChart* self, BaobabChartItem* item);
static void baobab_ringschart_get_point_min_rect (BaobabRingschart* self, gdouble cx, gdouble cy, gdouble radius, gdouble angle, GdkRectangle* r);
static void baobab_ringschart_real_get_item_rectangle (BaobabChart* base, BaobabChartItem* item);
static gboolean baobab_ringschart_real_is_point_over_item (BaobabChart* base, BaobabChartItem* item, gdouble x, gdouble y);
static gboolean baobab_ringschart_real_can_zoom_out (BaobabChart* base);
#define BAOBAB_CHART_MAX_DEPTH ((guint) 5)
static gboolean baobab_ringschart_real_can_zoom_in (BaobabChart* base);
#define BAOBAB_CHART_MIN_DEPTH ((guint) 1)
BaobabRingschart* baobab_ringschart_new (void);
BaobabRingschart* baobab_ringschart_construct (GType object_type);
BaobabChart* baobab_chart_construct (GType object_type);
static GObject * baobab_ringschart_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _baobab_ringschart_subtips_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void baobab_ringschart_finalize (GObject* obj);


BaobabRingschartItem* baobab_ringschart_item_construct (GType object_type) {
	BaobabRingschartItem* self = NULL;
	self = (BaobabRingschartItem*) baobab_chart_item_construct (object_type);
	return self;
}


BaobabRingschartItem* baobab_ringschart_item_new (void) {
	return baobab_ringschart_item_construct (BAOBAB_TYPE_RINGSCHART_ITEM);
}


static void baobab_ringschart_item_class_init (BaobabRingschartItemClass * klass) {
	baobab_ringschart_item_parent_class = g_type_class_peek_parent (klass);
	((BaobabChartItemClass *) klass)->finalize = baobab_ringschart_item_finalize;
}


static void baobab_ringschart_item_instance_init (BaobabRingschartItem * self) {
}


static void baobab_ringschart_item_finalize (BaobabChartItem* obj) {
	BaobabRingschartItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItem);
	BAOBAB_CHART_ITEM_CLASS (baobab_ringschart_item_parent_class)->finalize (obj);
}


GType baobab_ringschart_item_get_type (void) {
	static volatile gsize baobab_ringschart_item_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_ringschart_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabRingschartItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_ringschart_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabRingschartItem), 0, (GInstanceInitFunc) baobab_ringschart_item_instance_init, NULL };
		GType baobab_ringschart_item_type_id;
		baobab_ringschart_item_type_id = g_type_register_static (BAOBAB_TYPE_CHART_ITEM, "BaobabRingschartItem", &g_define_type_info, 0);
		g_once_init_leave (&baobab_ringschart_item_type_id__volatile, baobab_ringschart_item_type_id);
	}
	return baobab_ringschart_item_type_id__volatile;
}


static void _baobab_chart_item_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL));
}


static void _g_list_free__baobab_chart_item_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _baobab_chart_item_unref0_, NULL);
	g_list_free (self);
}


static gboolean ___lambda22_ (BaobabRingschart* self) {
	gboolean result = FALSE;
	self->priv->drawing_subtips = TRUE;
	self->priv->tips_timeout_id = (guint) 0;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean ____lambda22__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda22_ ((BaobabRingschart*) self);
	return result;
}


static void baobab_ringschart_subtips_update (BaobabRingschart* self) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	BaobabChartItem* _tmp3_ = NULL;
	BaobabChartItem* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->drawing_subtips;
	if (_tmp0_) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	self->priv->drawing_subtips = FALSE;
	_tmp1_ = self->priv->tips_timeout_id;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->tips_timeout_id;
		g_source_remove (_tmp2_);
		self->priv->tips_timeout_id = (guint) 0;
	}
	__g_list_free__baobab_chart_item_unref0_0 (self->priv->subtip_items);
	self->priv->subtip_items = NULL;
	_tmp3_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		guint _tmp5_ = 0U;
		_tmp5_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BAOBAB_RINGSCHART_SUBTIP_TIMEOUT, ____lambda22__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->tips_timeout_id = _tmp5_;
	}
}


static BaobabChartItem* baobab_ringschart_real_create_new_chartitem (BaobabChart* base) {
	BaobabRingschart * self;
	BaobabChartItem* result = NULL;
	BaobabRingschartItem* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_ringschart_item_new ();
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_CHART_ITEM) ? ((BaobabChartItem*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_baobab_chart_item_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _baobab_chart_item_ref0 (gpointer self) {
	return self ? baobab_chart_item_ref (self) : NULL;
}


static void baobab_ringschart_real_post_draw (BaobabChart* base, cairo_t* cr) {
	BaobabRingschart * self;
	gboolean _tmp0_ = FALSE;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp6_ = {0};
	gint q_width = 0;
	GtkAllocation _tmp7_ = {0};
	gint _tmp8_ = 0;
	gint q_height = 0;
	GtkAllocation _tmp9_ = {0};
	gint _tmp10_ = 0;
	gdouble q_angle = 0.0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gdouble _tmp13_ = 0.0;
	GdkRectangle last_rect = {0};
	GtkBorder padding = {0};
	GtkStyleContext* _tmp14_ = NULL;
	GtkBorder _tmp15_ = {0};
	gint16 vpadding = 0;
	GtkBorder _tmp16_ = {0};
	gint16 _tmp17_ = 0;
	GtkBorder _tmp18_ = {0};
	gint16 _tmp19_ = 0;
	gint16 hpadding = 0;
	GtkBorder _tmp20_ = {0};
	gint16 _tmp21_ = 0;
	GtkBorder _tmp22_ = {0};
	gint16 _tmp23_ = 0;
	GList* _tmp24_ = NULL;
	GtkStyleContext* _tmp209_ = NULL;
	self = (BaobabRingschart*) base;
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->drawing_subtips;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	_tmp3_ = context;
	gtk_style_context_save (_tmp3_);
	_tmp4_ = context;
	gtk_style_context_add_class (_tmp4_, "subfolder-tip");
	_tmp5_ = context;
	gtk_style_context_add_class (_tmp5_, "tooltip");
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp6_);
	allocation = _tmp6_;
	_tmp7_ = allocation;
	_tmp8_ = _tmp7_.width;
	q_width = _tmp8_ / 2;
	_tmp9_ = allocation;
	_tmp10_ = _tmp9_.height;
	q_height = _tmp10_ / 2;
	_tmp11_ = q_height;
	_tmp12_ = q_width;
	_tmp13_ = atan2 ((gdouble) _tmp11_, (gdouble) _tmp12_);
	q_angle = _tmp13_;
	memset (&last_rect, 0, sizeof (GdkRectangle));
	_tmp14_ = context;
	gtk_style_context_get_padding (_tmp14_, GTK_STATE_FLAG_NORMAL, &_tmp15_);
	padding = _tmp15_;
	_tmp16_ = padding;
	_tmp17_ = _tmp16_.top;
	_tmp18_ = padding;
	_tmp19_ = _tmp18_.bottom;
	vpadding = _tmp17_ + _tmp19_;
	_tmp20_ = padding;
	_tmp21_ = _tmp20_.left;
	_tmp22_ = padding;
	_tmp23_ = _tmp22_.right;
	hpadding = _tmp21_ + _tmp23_;
	_tmp24_ = self->priv->subtip_items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp24_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			BaobabChartItem* _tmp25_ = NULL;
			BaobabChartItem* item = NULL;
			_tmp25_ = _baobab_chart_item_ref0 ((BaobabChartItem*) item_it->data);
			item = _tmp25_;
			{
				BaobabRingschartItem* ringsitem = NULL;
				BaobabChartItem* _tmp26_ = NULL;
				BaobabRingschartItem* _tmp27_ = NULL;
				gdouble middle_angle = 0.0;
				BaobabRingschartItem* _tmp28_ = NULL;
				gdouble _tmp29_ = 0.0;
				BaobabRingschartItem* _tmp30_ = NULL;
				gdouble _tmp31_ = 0.0;
				gdouble middle_angle_n = 0.0;
				gdouble _tmp32_ = 0.0;
				gdouble _tmp35_ = 0.0;
				gdouble _tmp36_ = 0.0;
				PangoLayout* layout = NULL;
				PangoLayout* _tmp37_ = NULL;
				gchar* markup = NULL;
				BaobabChartItem* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				PangoLayout* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				PangoLayout* _tmp48_ = NULL;
				PangoLayout* _tmp49_ = NULL;
				PangoLayout* _tmp50_ = NULL;
				gint _tmp51_ = 0;
				PangoLayout* _tmp52_ = NULL;
				PangoRectangle layout_rect = {0};
				PangoLayout* _tmp53_ = NULL;
				PangoRectangle _tmp54_ = {0};
				gdouble tip_x = 0.0;
				gdouble tip_y = 0.0;
				gdouble _tmp55_ = 0.0;
				gdouble _tmp56_ = 0.0;
				cairo_rectangle_t tooltip_rect = {0};
				gint _tmp71_ = 0;
				gdouble _tmp72_ = 0.0;
				PangoRectangle _tmp73_ = {0};
				gint _tmp74_ = 0;
				GtkBorder _tmp75_ = {0};
				gint16 _tmp76_ = 0;
				gint _tmp77_ = 0;
				gdouble _tmp78_ = 0.0;
				PangoRectangle _tmp79_ = {0};
				gint _tmp80_ = 0;
				GtkBorder _tmp81_ = {0};
				gint16 _tmp82_ = 0;
				PangoRectangle _tmp83_ = {0};
				gint _tmp84_ = 0;
				gint16 _tmp85_ = 0;
				PangoRectangle _tmp86_ = {0};
				gint _tmp87_ = 0;
				gint16 _tmp88_ = 0;
				gdouble a = 0.0;
				gdouble _tmp89_ = 0.0;
				gint i = 0;
				GdkRectangle _rect = {0};
				cairo_rectangle_t _tmp106_ = {0};
				gdouble _tmp107_ = 0.0;
				cairo_rectangle_t _tmp108_ = {0};
				gdouble _tmp109_ = 0.0;
				cairo_rectangle_t _tmp110_ = {0};
				gdouble _tmp111_ = 0.0;
				cairo_rectangle_t _tmp112_ = {0};
				gdouble _tmp113_ = 0.0;
				GdkRectangle _tmp114_ = {0};
				gboolean _tmp115_ = FALSE;
				_tmp26_ = item;
				_tmp27_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp26_) : NULL);
				ringsitem = _tmp27_;
				_tmp28_ = ringsitem;
				_tmp29_ = _tmp28_->start_angle;
				_tmp30_ = ringsitem;
				_tmp31_ = _tmp30_->angle;
				middle_angle = _tmp29_ + (_tmp31_ / 2);
				_tmp32_ = middle_angle;
				middle_angle_n = _tmp32_;
				while (TRUE) {
					gdouble _tmp33_ = 0.0;
					gdouble _tmp34_ = 0.0;
					_tmp33_ = middle_angle_n;
					if (!(_tmp33_ > (G_PI / 2))) {
						break;
					}
					_tmp34_ = middle_angle_n;
					middle_angle_n = _tmp34_ - G_PI;
				}
				_tmp35_ = middle_angle_n;
				_tmp36_ = fabs (_tmp35_);
				middle_angle_n = _tmp36_;
				_tmp37_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
				layout = _tmp37_;
				_tmp38_ = item;
				_tmp39_ = _tmp38_->name;
				_tmp40_ = g_markup_escape_text (_tmp39_, (gssize) (-1));
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strconcat ("<span size=\"small\">", _tmp41_, NULL);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strconcat (_tmp43_, "</span>", NULL);
				_tmp45_ = _tmp44_;
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				markup = _tmp45_;
				_tmp46_ = layout;
				_tmp47_ = markup;
				pango_layout_set_markup (_tmp46_, _tmp47_, -1);
				_tmp48_ = layout;
				pango_layout_set_indent (_tmp48_, 0);
				_tmp49_ = layout;
				pango_layout_set_spacing (_tmp49_, 0);
				_tmp50_ = layout;
				_tmp51_ = q_width;
				pango_layout_set_width (_tmp50_, (PANGO_SCALE * _tmp51_) / 2);
				_tmp52_ = layout;
				pango_layout_set_ellipsize (_tmp52_, PANGO_ELLIPSIZE_END);
				_tmp53_ = layout;
				pango_layout_get_pixel_extents (_tmp53_, NULL, &_tmp54_);
				layout_rect = _tmp54_;
				_tmp55_ = middle_angle_n;
				_tmp56_ = q_angle;
				if (_tmp55_ < _tmp56_) {
					gint _tmp57_ = 0;
					PangoRectangle _tmp58_ = {0};
					gint _tmp59_ = 0;
					gint16 _tmp60_ = 0;
					gdouble _tmp61_ = 0.0;
					gdouble _tmp62_ = 0.0;
					gdouble _tmp63_ = 0.0;
					_tmp57_ = q_width;
					_tmp58_ = layout_rect;
					_tmp59_ = _tmp58_.width;
					_tmp60_ = hpadding;
					tip_x = (gdouble) ((_tmp57_ - (_tmp59_ / 2)) - _tmp60_);
					_tmp61_ = middle_angle_n;
					_tmp62_ = tan (_tmp61_);
					_tmp63_ = tip_x;
					tip_y = _tmp62_ * _tmp63_;
				} else {
					gint _tmp64_ = 0;
					PangoRectangle _tmp65_ = {0};
					gint _tmp66_ = 0;
					gint16 _tmp67_ = 0;
					gdouble _tmp68_ = 0.0;
					gdouble _tmp69_ = 0.0;
					gdouble _tmp70_ = 0.0;
					_tmp64_ = q_height;
					_tmp65_ = layout_rect;
					_tmp66_ = _tmp65_.height;
					_tmp67_ = vpadding;
					tip_y = (gdouble) ((_tmp64_ - (_tmp66_ / 2)) - _tmp67_);
					_tmp68_ = tip_y;
					_tmp69_ = middle_angle_n;
					_tmp70_ = tan (_tmp69_);
					tip_x = _tmp68_ / _tmp70_;
				}
				memset (&tooltip_rect, 0, sizeof (cairo_rectangle_t));
				_tmp71_ = q_width;
				_tmp72_ = tip_x;
				_tmp73_ = layout_rect;
				_tmp74_ = _tmp73_.width;
				_tmp75_ = padding;
				_tmp76_ = _tmp75_.left;
				tooltip_rect.x = ((_tmp71_ + _tmp72_) - (_tmp74_ / 2)) - _tmp76_;
				_tmp77_ = q_height;
				_tmp78_ = tip_y;
				_tmp79_ = layout_rect;
				_tmp80_ = _tmp79_.height;
				_tmp81_ = padding;
				_tmp82_ = _tmp81_.top;
				tooltip_rect.y = ((_tmp77_ + _tmp78_) - (_tmp80_ / 2)) - _tmp82_;
				_tmp83_ = layout_rect;
				_tmp84_ = _tmp83_.width;
				_tmp85_ = hpadding;
				tooltip_rect.width = (gdouble) (_tmp84_ + _tmp85_);
				_tmp86_ = layout_rect;
				_tmp87_ = _tmp86_.height;
				_tmp88_ = vpadding;
				tooltip_rect.height = (gdouble) (_tmp87_ + _tmp88_);
				_tmp89_ = middle_angle;
				a = _tmp89_;
				i = 0;
				while (TRUE) {
					gdouble _tmp90_ = 0.0;
					gint _tmp91_ = 0;
					gint _tmp104_ = 0;
					gdouble _tmp105_ = 0.0;
					_tmp90_ = a;
					if (!(_tmp90_ > (G_PI / 2))) {
						break;
					}
					_tmp91_ = i;
					if ((_tmp91_ % 2) == 0) {
						GtkAllocation _tmp92_ = {0};
						gint _tmp93_ = 0;
						cairo_rectangle_t _tmp94_ = {0};
						gdouble _tmp95_ = 0.0;
						cairo_rectangle_t _tmp96_ = {0};
						gdouble _tmp97_ = 0.0;
						_tmp92_ = allocation;
						_tmp93_ = _tmp92_.width;
						_tmp94_ = tooltip_rect;
						_tmp95_ = _tmp94_.x;
						_tmp96_ = tooltip_rect;
						_tmp97_ = _tmp96_.width;
						tooltip_rect.x = (_tmp93_ - _tmp95_) - _tmp97_;
					} else {
						GtkAllocation _tmp98_ = {0};
						gint _tmp99_ = 0;
						cairo_rectangle_t _tmp100_ = {0};
						gdouble _tmp101_ = 0.0;
						cairo_rectangle_t _tmp102_ = {0};
						gdouble _tmp103_ = 0.0;
						_tmp98_ = allocation;
						_tmp99_ = _tmp98_.height;
						_tmp100_ = tooltip_rect;
						_tmp101_ = _tmp100_.y;
						_tmp102_ = tooltip_rect;
						_tmp103_ = _tmp102_.height;
						tooltip_rect.y = (_tmp99_ - _tmp101_) - _tmp103_;
					}
					_tmp104_ = i;
					i = _tmp104_ + 1;
					_tmp105_ = a;
					a = _tmp105_ - (G_PI / 2);
				}
				memset (&_rect, 0, sizeof (GdkRectangle));
				_tmp106_ = tooltip_rect;
				_tmp107_ = _tmp106_.x;
				_rect.x = (gint) (_tmp107_ - 1);
				_tmp108_ = tooltip_rect;
				_tmp109_ = _tmp108_.y;
				_rect.y = (gint) (_tmp109_ - 1);
				_tmp110_ = tooltip_rect;
				_tmp111_ = _tmp110_.width;
				_rect.width = (gint) (_tmp111_ + 2);
				_tmp112_ = tooltip_rect;
				_tmp113_ = _tmp112_.height;
				_rect.height = (gint) (_tmp113_ + 2);
				_tmp114_ = last_rect;
				_tmp115_ = gdk_rectangle_intersect (&_rect, &_tmp114_, NULL);
				if (!_tmp115_) {
					GdkRectangle _tmp116_ = {0};
					cairo_rectangle_t _tmp117_ = {0};
					gdouble _tmp118_ = 0.0;
					gdouble _tmp119_ = 0.0;
					cairo_rectangle_t _tmp120_ = {0};
					gdouble _tmp121_ = 0.0;
					gdouble _tmp122_ = 0.0;
					gdouble middle_radius = 0.0;
					BaobabRingschartItem* _tmp123_ = NULL;
					gdouble _tmp124_ = 0.0;
					BaobabRingschartItem* _tmp125_ = NULL;
					gdouble _tmp126_ = 0.0;
					BaobabRingschartItem* _tmp127_ = NULL;
					gdouble _tmp128_ = 0.0;
					gdouble sector_center_x = 0.0;
					gint _tmp129_ = 0;
					gdouble _tmp130_ = 0.0;
					gdouble _tmp131_ = 0.0;
					gdouble _tmp132_ = 0.0;
					gdouble sector_center_y = 0.0;
					gint _tmp133_ = 0;
					gdouble _tmp134_ = 0.0;
					gdouble _tmp135_ = 0.0;
					gdouble _tmp136_ = 0.0;
					cairo_t* _tmp137_ = NULL;
					cairo_t* _tmp138_ = NULL;
					GtkAllocation _tmp139_ = {0};
					gint _tmp140_ = 0;
					GtkAllocation _tmp141_ = {0};
					gint _tmp142_ = 0;
					cairo_t* _tmp143_ = NULL;
					cairo_rectangle_t _tmp144_ = {0};
					gdouble _tmp145_ = 0.0;
					cairo_rectangle_t _tmp146_ = {0};
					gdouble _tmp147_ = 0.0;
					cairo_rectangle_t _tmp148_ = {0};
					gdouble _tmp149_ = 0.0;
					cairo_rectangle_t _tmp150_ = {0};
					gdouble _tmp151_ = 0.0;
					cairo_rectangle_t _tmp152_ = {0};
					gdouble _tmp153_ = 0.0;
					cairo_t* _tmp154_ = NULL;
					GdkRGBA bg_color = {0};
					GtkStyleContext* _tmp155_ = NULL;
					GdkRGBA _tmp156_ = {0};
					cairo_t* _tmp157_ = NULL;
					cairo_t* _tmp158_ = NULL;
					gdouble _tmp159_ = 0.0;
					gdouble _tmp160_ = 0.0;
					cairo_t* _tmp161_ = NULL;
					GdkRGBA _tmp162_ = {0};
					cairo_t* _tmp163_ = NULL;
					cairo_rectangle_t _tmp164_ = {0};
					gdouble _tmp165_ = 0.0;
					cairo_rectangle_t _tmp166_ = {0};
					gdouble _tmp167_ = 0.0;
					cairo_rectangle_t _tmp168_ = {0};
					gdouble _tmp169_ = 0.0;
					cairo_rectangle_t _tmp170_ = {0};
					gdouble _tmp171_ = 0.0;
					cairo_t* _tmp172_ = NULL;
					cairo_t* _tmp173_ = NULL;
					cairo_t* _tmp174_ = NULL;
					gdouble _tmp175_ = 0.0;
					gdouble _tmp176_ = 0.0;
					cairo_t* _tmp177_ = NULL;
					GtkStyleContext* _tmp178_ = NULL;
					cairo_t* _tmp179_ = NULL;
					cairo_rectangle_t _tmp180_ = {0};
					gdouble _tmp181_ = 0.0;
					cairo_rectangle_t _tmp182_ = {0};
					gdouble _tmp183_ = 0.0;
					cairo_rectangle_t _tmp184_ = {0};
					gdouble _tmp185_ = 0.0;
					cairo_rectangle_t _tmp186_ = {0};
					gdouble _tmp187_ = 0.0;
					GtkStyleContext* _tmp188_ = NULL;
					cairo_t* _tmp189_ = NULL;
					cairo_rectangle_t _tmp190_ = {0};
					gdouble _tmp191_ = 0.0;
					cairo_rectangle_t _tmp192_ = {0};
					gdouble _tmp193_ = 0.0;
					cairo_rectangle_t _tmp194_ = {0};
					gdouble _tmp195_ = 0.0;
					cairo_rectangle_t _tmp196_ = {0};
					gdouble _tmp197_ = 0.0;
					GtkStyleContext* _tmp198_ = NULL;
					cairo_t* _tmp199_ = NULL;
					cairo_rectangle_t _tmp200_ = {0};
					gdouble _tmp201_ = 0.0;
					GtkBorder _tmp202_ = {0};
					gint16 _tmp203_ = 0;
					cairo_rectangle_t _tmp204_ = {0};
					gdouble _tmp205_ = 0.0;
					GtkBorder _tmp206_ = {0};
					gint16 _tmp207_ = 0;
					PangoLayout* _tmp208_ = NULL;
					_tmp116_ = _rect;
					last_rect = _tmp116_;
					_tmp117_ = tooltip_rect;
					_tmp118_ = _tmp117_.x;
					_tmp119_ = floor (_tmp118_);
					tooltip_rect.x = _tmp119_;
					_tmp120_ = tooltip_rect;
					_tmp121_ = _tmp120_.y;
					_tmp122_ = floor (_tmp121_);
					tooltip_rect.y = _tmp122_;
					_tmp123_ = ringsitem;
					_tmp124_ = _tmp123_->min_radius;
					_tmp125_ = ringsitem;
					_tmp126_ = _tmp125_->max_radius;
					_tmp127_ = ringsitem;
					_tmp128_ = _tmp127_->min_radius;
					middle_radius = _tmp124_ + ((_tmp126_ - _tmp128_) / 2);
					_tmp129_ = q_width;
					_tmp130_ = middle_radius;
					_tmp131_ = middle_angle;
					_tmp132_ = cos (_tmp131_);
					sector_center_x = _tmp129_ + (_tmp130_ * _tmp132_);
					_tmp133_ = q_height;
					_tmp134_ = middle_radius;
					_tmp135_ = middle_angle;
					_tmp136_ = sin (_tmp135_);
					sector_center_y = _tmp133_ + (_tmp134_ * _tmp136_);
					_tmp137_ = cr;
					cairo_save (_tmp137_);
					_tmp138_ = cr;
					_tmp139_ = allocation;
					_tmp140_ = _tmp139_.width;
					_tmp141_ = allocation;
					_tmp142_ = _tmp141_.height;
					cairo_rectangle (_tmp138_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp140_, (gdouble) _tmp142_);
					_tmp143_ = cr;
					_tmp144_ = tooltip_rect;
					_tmp145_ = _tmp144_.x;
					_tmp146_ = tooltip_rect;
					_tmp147_ = _tmp146_.width;
					_tmp148_ = tooltip_rect;
					_tmp149_ = _tmp148_.y;
					_tmp150_ = tooltip_rect;
					_tmp151_ = _tmp150_.width;
					_tmp152_ = tooltip_rect;
					_tmp153_ = _tmp152_.height;
					cairo_rectangle (_tmp143_, _tmp145_ + _tmp147_, _tmp149_, -_tmp151_, _tmp153_);
					_tmp154_ = cr;
					cairo_clip (_tmp154_);
					_tmp155_ = context;
					gtk_style_context_get_background_color (_tmp155_, GTK_STATE_FLAG_NORMAL, &_tmp156_);
					bg_color = _tmp156_;
					_tmp157_ = cr;
					cairo_set_line_width (_tmp157_, (gdouble) 1);
					_tmp158_ = cr;
					_tmp159_ = sector_center_x;
					_tmp160_ = sector_center_y;
					cairo_move_to (_tmp158_, _tmp159_, _tmp160_);
					_tmp161_ = cr;
					_tmp162_ = bg_color;
					gdk_cairo_set_source_rgba (_tmp161_, &_tmp162_);
					_tmp163_ = cr;
					_tmp164_ = tooltip_rect;
					_tmp165_ = _tmp164_.x;
					_tmp166_ = tooltip_rect;
					_tmp167_ = _tmp166_.width;
					_tmp168_ = tooltip_rect;
					_tmp169_ = _tmp168_.y;
					_tmp170_ = tooltip_rect;
					_tmp171_ = _tmp170_.height;
					cairo_line_to (_tmp163_, _tmp165_ + (_tmp167_ / 2), _tmp169_ + (_tmp171_ / 2));
					_tmp172_ = cr;
					cairo_stroke (_tmp172_);
					_tmp173_ = cr;
					cairo_restore (_tmp173_);
					_tmp174_ = cr;
					_tmp175_ = sector_center_x;
					_tmp176_ = sector_center_y;
					cairo_arc (_tmp174_, _tmp175_, _tmp176_, 1.0, (gdouble) 0, 2 * G_PI);
					_tmp177_ = cr;
					cairo_stroke (_tmp177_);
					_tmp178_ = context;
					_tmp179_ = cr;
					_tmp180_ = tooltip_rect;
					_tmp181_ = _tmp180_.x;
					_tmp182_ = tooltip_rect;
					_tmp183_ = _tmp182_.y;
					_tmp184_ = tooltip_rect;
					_tmp185_ = _tmp184_.width;
					_tmp186_ = tooltip_rect;
					_tmp187_ = _tmp186_.height;
					gtk_render_background (_tmp178_, _tmp179_, _tmp181_, _tmp183_, _tmp185_, _tmp187_);
					_tmp188_ = context;
					_tmp189_ = cr;
					_tmp190_ = tooltip_rect;
					_tmp191_ = _tmp190_.x;
					_tmp192_ = tooltip_rect;
					_tmp193_ = _tmp192_.y;
					_tmp194_ = tooltip_rect;
					_tmp195_ = _tmp194_.width;
					_tmp196_ = tooltip_rect;
					_tmp197_ = _tmp196_.height;
					gtk_render_frame (_tmp188_, _tmp189_, _tmp191_, _tmp193_, _tmp195_, _tmp197_);
					_tmp198_ = context;
					_tmp199_ = cr;
					_tmp200_ = tooltip_rect;
					_tmp201_ = _tmp200_.x;
					_tmp202_ = padding;
					_tmp203_ = _tmp202_.left;
					_tmp204_ = tooltip_rect;
					_tmp205_ = _tmp204_.y;
					_tmp206_ = padding;
					_tmp207_ = _tmp206_.top;
					_tmp208_ = layout;
					gtk_render_layout (_tmp198_, _tmp199_, _tmp201_ + _tmp203_, _tmp205_ + _tmp207_, _tmp208_);
				}
				_g_free0 (markup);
				_g_object_unref0 (layout);
				_baobab_chart_item_unref0 (ringsitem);
				_baobab_chart_item_unref0 (item);
			}
		}
	}
	_tmp209_ = context;
	gtk_style_context_restore (_tmp209_);
	_g_object_unref0 (context);
}


static void baobab_ringschart_real_draw_item (BaobabChart* base, cairo_t* cr, BaobabChartItem* item, gboolean highlighted) {
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_ = NULL;
	BaobabRingschartItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	cairo_t* _tmp16_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp17_ = {0};
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp18_ = NULL;
	GtkStyleContext* _tmp19_ = NULL;
	GdkRGBA border_color = {0};
	GtkStyleContext* _tmp20_ = NULL;
	GdkRGBA _tmp21_ = {0};
	gint center_x = 0;
	GtkAllocation _tmp22_ = {0};
	gint _tmp23_ = 0;
	gint center_y = 0;
	GtkAllocation _tmp24_ = {0};
	gint _tmp25_ = 0;
	gdouble final_angle = 0.0;
	BaobabRingschartItem* _tmp26_ = NULL;
	gdouble _tmp27_ = 0.0;
	BaobabRingschartItem* _tmp28_ = NULL;
	gdouble _tmp29_ = 0.0;
	BaobabChartItem* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
	self = (BaobabRingschart*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	_tmp2_ = self->priv->drawing_subtips;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		BaobabChartItem* _tmp5_ = NULL;
		BaobabChartItem* _tmp6_ = NULL;
		_tmp5_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != NULL) {
			BaobabChartItem* _tmp7_ = NULL;
			GList* _tmp8_ = NULL;
			_tmp7_ = item;
			_tmp8_ = _tmp7_->parent;
			_tmp4_ = _tmp8_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			BaobabChartItem* _tmp9_ = NULL;
			GList* _tmp10_ = NULL;
			gconstpointer _tmp11_ = NULL;
			BaobabChartItem* _tmp12_ = NULL;
			BaobabChartItem* _tmp13_ = NULL;
			_tmp9_ = item;
			_tmp10_ = _tmp9_->parent;
			_tmp11_ = _tmp10_->data;
			_tmp12_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
			_tmp13_ = _tmp12_;
			_tmp3_ = ((BaobabChartItem*) _tmp11_) == _tmp13_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			BaobabChartItem* _tmp14_ = NULL;
			BaobabChartItem* _tmp15_ = NULL;
			_tmp14_ = item;
			_tmp15_ = _baobab_chart_item_ref0 (_tmp14_);
			self->priv->subtip_items = g_list_append (self->priv->subtip_items, _tmp15_);
		}
	}
	_tmp16_ = cr;
	cairo_set_line_width (_tmp16_, (gdouble) BAOBAB_RINGSCHART_ITEM_BORDER_WIDTH);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp17_);
	allocation = _tmp17_;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	context = _tmp19_;
	_tmp20_ = context;
	gtk_style_context_get_border_color (_tmp20_, GTK_STATE_FLAG_NORMAL, &_tmp21_);
	border_color = _tmp21_;
	_tmp22_ = allocation;
	_tmp23_ = _tmp22_.width;
	center_x = _tmp23_ / 2;
	_tmp24_ = allocation;
	_tmp25_ = _tmp24_.height;
	center_y = _tmp25_ / 2;
	_tmp26_ = ringsitem;
	_tmp27_ = _tmp26_->start_angle;
	_tmp28_ = ringsitem;
	_tmp29_ = _tmp28_->angle;
	final_angle = _tmp27_ + _tmp29_;
	_tmp30_ = item;
	_tmp31_ = _tmp30_->depth;
	if (_tmp31_ == ((guint) 0)) {
		PangoLayout* layout = NULL;
		PangoLayout* _tmp32_ = NULL;
		gchar* markup = NULL;
		BaobabChartItem* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		PangoLayout* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		PangoLayout* _tmp43_ = NULL;
		PangoLayout* _tmp44_ = NULL;
		PangoRectangle layout_rect = {0};
		PangoLayout* _tmp45_ = NULL;
		PangoRectangle _tmp46_ = {0};
		PangoRectangle _tmp47_ = {0};
		gint _tmp48_ = 0;
		BaobabRingschartItem* _tmp49_ = NULL;
		gdouble _tmp50_ = 0.0;
		cairo_t* _tmp65_ = NULL;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		BaobabRingschartItem* _tmp68_ = NULL;
		gdouble _tmp69_ = 0.0;
		cairo_t* _tmp70_ = NULL;
		GdkRGBA _tmp71_ = {0};
		cairo_t* _tmp72_ = NULL;
		_tmp32_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
		layout = _tmp32_;
		_tmp33_ = item;
		_tmp34_ = _tmp33_->size;
		_tmp35_ = g_markup_escape_text (_tmp34_, (gssize) (-1));
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat ("<span size=\"small\">", _tmp36_, NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_tmp38_, "</span>", NULL);
		_tmp40_ = _tmp39_;
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		markup = _tmp40_;
		_tmp41_ = layout;
		_tmp42_ = markup;
		pango_layout_set_markup (_tmp41_, _tmp42_, -1);
		_tmp43_ = layout;
		pango_layout_set_indent (_tmp43_, 0);
		_tmp44_ = layout;
		pango_layout_set_spacing (_tmp44_, 0);
		_tmp45_ = layout;
		pango_layout_get_pixel_extents (_tmp45_, NULL, &_tmp46_);
		layout_rect = _tmp46_;
		_tmp47_ = layout_rect;
		_tmp48_ = _tmp47_.width;
		_tmp49_ = ringsitem;
		_tmp50_ = _tmp49_->max_radius;
		if (((gdouble) _tmp48_) < (2 * _tmp50_)) {
			GtkStyleContext* _tmp51_ = NULL;
			cairo_t* _tmp52_ = NULL;
			gint _tmp53_ = 0;
			PangoRectangle _tmp54_ = {0};
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			PangoRectangle _tmp57_ = {0};
			gint _tmp58_ = 0;
			PangoLayout* _tmp59_ = NULL;
			cairo_t* _tmp60_ = NULL;
			gint _tmp61_ = 0;
			BaobabRingschartItem* _tmp62_ = NULL;
			gdouble _tmp63_ = 0.0;
			gint _tmp64_ = 0;
			_tmp51_ = context;
			_tmp52_ = cr;
			_tmp53_ = center_x;
			_tmp54_ = layout_rect;
			_tmp55_ = _tmp54_.width;
			_tmp56_ = center_y;
			_tmp57_ = layout_rect;
			_tmp58_ = _tmp57_.height;
			_tmp59_ = layout;
			gtk_render_layout (_tmp51_, _tmp52_, (gdouble) (_tmp53_ - (_tmp55_ / 2)), (gdouble) (_tmp56_ - (_tmp58_ / 2)), _tmp59_);
			_tmp60_ = cr;
			_tmp61_ = center_x;
			_tmp62_ = ringsitem;
			_tmp63_ = _tmp62_->max_radius;
			_tmp64_ = center_y;
			cairo_move_to (_tmp60_, (_tmp61_ + _tmp63_) + 1, (gdouble) _tmp64_);
		}
		_tmp65_ = cr;
		_tmp66_ = center_x;
		_tmp67_ = center_y;
		_tmp68_ = ringsitem;
		_tmp69_ = _tmp68_->max_radius;
		cairo_arc (_tmp65_, (gdouble) _tmp66_, (gdouble) _tmp67_, _tmp69_ + 1, (gdouble) 0, 2 * G_PI);
		_tmp70_ = cr;
		_tmp71_ = border_color;
		gdk_cairo_set_source_rgba (_tmp70_, &_tmp71_);
		_tmp72_ = cr;
		cairo_stroke (_tmp72_);
		_g_free0 (markup);
		_g_object_unref0 (layout);
	} else {
		GdkRGBA fill_color = {0};
		BaobabRingschartItem* _tmp73_ = NULL;
		gdouble _tmp74_ = 0.0;
		BaobabChartItem* _tmp75_ = NULL;
		guint _tmp76_ = 0U;
		gboolean _tmp77_ = FALSE;
		GdkRGBA _tmp78_ = {0};
		cairo_t* _tmp79_ = NULL;
		gint _tmp80_ = 0;
		gint _tmp81_ = 0;
		BaobabRingschartItem* _tmp82_ = NULL;
		gdouble _tmp83_ = 0.0;
		BaobabRingschartItem* _tmp84_ = NULL;
		gdouble _tmp85_ = 0.0;
		gdouble _tmp86_ = 0.0;
		cairo_t* _tmp87_ = NULL;
		gint _tmp88_ = 0;
		gint _tmp89_ = 0;
		BaobabRingschartItem* _tmp90_ = NULL;
		gdouble _tmp91_ = 0.0;
		gdouble _tmp92_ = 0.0;
		BaobabRingschartItem* _tmp93_ = NULL;
		gdouble _tmp94_ = 0.0;
		cairo_t* _tmp95_ = NULL;
		cairo_t* _tmp96_ = NULL;
		GdkRGBA _tmp97_ = {0};
		cairo_t* _tmp98_ = NULL;
		cairo_t* _tmp99_ = NULL;
		cairo_t* _tmp100_ = NULL;
		cairo_t* _tmp101_ = NULL;
		BaobabRingschartItem* _tmp102_ = NULL;
		gboolean _tmp103_ = FALSE;
		_tmp73_ = ringsitem;
		_tmp74_ = _tmp73_->start_angle;
		_tmp75_ = item;
		_tmp76_ = _tmp75_->depth;
		_tmp77_ = highlighted;
		baobab_chart_get_item_color ((BaobabChart*) self, (_tmp74_ / G_PI) * 99, _tmp76_, _tmp77_, &_tmp78_);
		fill_color = _tmp78_;
		_tmp79_ = cr;
		_tmp80_ = center_x;
		_tmp81_ = center_y;
		_tmp82_ = ringsitem;
		_tmp83_ = _tmp82_->min_radius;
		_tmp84_ = ringsitem;
		_tmp85_ = _tmp84_->start_angle;
		_tmp86_ = final_angle;
		cairo_arc (_tmp79_, (gdouble) _tmp80_, (gdouble) _tmp81_, _tmp83_, _tmp85_, _tmp86_);
		_tmp87_ = cr;
		_tmp88_ = center_x;
		_tmp89_ = center_y;
		_tmp90_ = ringsitem;
		_tmp91_ = _tmp90_->max_radius;
		_tmp92_ = final_angle;
		_tmp93_ = ringsitem;
		_tmp94_ = _tmp93_->start_angle;
		cairo_arc_negative (_tmp87_, (gdouble) _tmp88_, (gdouble) _tmp89_, _tmp91_, _tmp92_, _tmp94_);
		_tmp95_ = cr;
		cairo_close_path (_tmp95_);
		_tmp96_ = cr;
		_tmp97_ = fill_color;
		gdk_cairo_set_source_rgba (_tmp96_, &_tmp97_);
		_tmp98_ = cr;
		cairo_fill_preserve (_tmp98_);
		_tmp99_ = cr;
		cairo_set_operator (_tmp99_, CAIRO_OPERATOR_CLEAR);
		_tmp100_ = cr;
		cairo_stroke (_tmp100_);
		_tmp101_ = cr;
		cairo_set_operator (_tmp101_, CAIRO_OPERATOR_OVER);
		_tmp102_ = ringsitem;
		_tmp103_ = _tmp102_->continued;
		if (_tmp103_) {
			cairo_t* _tmp104_ = NULL;
			GdkRGBA _tmp105_ = {0};
			cairo_t* _tmp106_ = NULL;
			cairo_t* _tmp107_ = NULL;
			gint _tmp108_ = 0;
			gint _tmp109_ = 0;
			BaobabRingschartItem* _tmp110_ = NULL;
			gdouble _tmp111_ = 0.0;
			BaobabRingschartItem* _tmp112_ = NULL;
			gdouble _tmp113_ = 0.0;
			gdouble _tmp114_ = 0.0;
			cairo_t* _tmp115_ = NULL;
			_tmp104_ = cr;
			_tmp105_ = border_color;
			gdk_cairo_set_source_rgba (_tmp104_, &_tmp105_);
			_tmp106_ = cr;
			cairo_set_line_width (_tmp106_, (gdouble) 3);
			_tmp107_ = cr;
			_tmp108_ = center_x;
			_tmp109_ = center_y;
			_tmp110_ = ringsitem;
			_tmp111_ = _tmp110_->max_radius;
			_tmp112_ = ringsitem;
			_tmp113_ = _tmp112_->start_angle;
			_tmp114_ = final_angle;
			cairo_arc (_tmp107_, (gdouble) _tmp108_, (gdouble) _tmp109_, _tmp111_ + 4, _tmp113_ + BAOBAB_RINGSCHART_EDGE_ANGLE, _tmp114_ - BAOBAB_RINGSCHART_EDGE_ANGLE);
			_tmp115_ = cr;
			cairo_stroke (_tmp115_);
		}
	}
	_g_object_unref0 (context);
	_baobab_chart_item_unref0 (ringsitem);
}


static void baobab_ringschart_real_calculate_item_geometry (BaobabChart* base, BaobabChartItem* item) {
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_ = NULL;
	BaobabRingschartItem* _tmp1_ = NULL;
	BaobabRingschartItem* _tmp2_ = NULL;
	BaobabRingschartItem* _tmp3_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp4_ = {0};
	GtkBorder padding = {0};
	GtkStyleContext* _tmp5_ = NULL;
	GtkBorder _tmp6_ = {0};
	gint max_radius = 0;
	GtkAllocation _tmp7_ = {0};
	gint _tmp8_ = 0;
	GtkAllocation _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GtkBorder _tmp12_ = {0};
	gint16 _tmp13_ = 0;
	guint thickness = 0U;
	gint _tmp14_ = 0;
	guint _tmp15_ = 0U;
	guint _tmp16_ = 0U;
	BaobabRingschartItem* _tmp17_ = NULL;
	GList* _tmp18_ = NULL;
	BaobabRingschartItem* _tmp64_ = NULL;
	BaobabChartItem* _tmp65_ = NULL;
	self = (BaobabRingschart*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	_tmp2_ = ringsitem;
	_tmp2_->continued = FALSE;
	_tmp3_ = ringsitem;
	((BaobabChartItem*) _tmp3_)->visible = FALSE;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp4_);
	allocation = _tmp4_;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_get_padding (_tmp5_, GTK_STATE_FLAG_NORMAL, &_tmp6_);
	padding = _tmp6_;
	_tmp7_ = allocation;
	_tmp8_ = _tmp7_.width;
	_tmp9_ = allocation;
	_tmp10_ = _tmp9_.height;
	_tmp11_ = MIN (_tmp8_ / 2, _tmp10_ / 2);
	_tmp12_ = padding;
	_tmp13_ = _tmp12_.left;
	max_radius = _tmp11_ - _tmp13_;
	_tmp14_ = max_radius;
	_tmp15_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp16_ = _tmp15_;
	thickness = _tmp14_ / (_tmp16_ + 1);
	_tmp17_ = ringsitem;
	_tmp18_ = ((BaobabChartItem*) _tmp17_)->parent;
	if (_tmp18_ == NULL) {
		BaobabRingschartItem* _tmp19_ = NULL;
		BaobabRingschartItem* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		BaobabRingschartItem* _tmp22_ = NULL;
		BaobabRingschartItem* _tmp23_ = NULL;
		_tmp19_ = ringsitem;
		_tmp19_->min_radius = (gdouble) 0;
		_tmp20_ = ringsitem;
		_tmp21_ = thickness;
		_tmp20_->max_radius = (gdouble) _tmp21_;
		_tmp22_ = ringsitem;
		_tmp22_->start_angle = (gdouble) 0;
		_tmp23_ = ringsitem;
		_tmp23_->angle = 2 * G_PI;
	} else {
		BaobabRingschartItem* parent = NULL;
		BaobabChartItem* _tmp24_ = NULL;
		GList* _tmp25_ = NULL;
		gconstpointer _tmp26_ = NULL;
		BaobabChartItem* _tmp27_ = NULL;
		BaobabRingschartItem* _tmp28_ = NULL;
		BaobabRingschartItem* _tmp29_ = NULL;
		BaobabRingschartItem* _tmp30_ = NULL;
		guint _tmp31_ = 0U;
		guint _tmp32_ = 0U;
		BaobabRingschartItem* _tmp33_ = NULL;
		guint _tmp34_ = 0U;
		guint _tmp35_ = 0U;
		guint _tmp36_ = 0U;
		BaobabRingschartItem* _tmp41_ = NULL;
		BaobabRingschartItem* _tmp42_ = NULL;
		gdouble _tmp43_ = 0.0;
		BaobabRingschartItem* _tmp44_ = NULL;
		gdouble _tmp45_ = 0.0;
		BaobabRingschartItem* _tmp46_ = NULL;
		gdouble _tmp47_ = 0.0;
		BaobabRingschartItem* _tmp48_ = NULL;
		BaobabRingschartItem* _tmp49_ = NULL;
		gdouble _tmp50_ = 0.0;
		BaobabRingschartItem* _tmp51_ = NULL;
		gdouble _tmp52_ = 0.0;
		BaobabRingschartItem* _tmp53_ = NULL;
		gdouble _tmp54_ = 0.0;
		gboolean _tmp55_ = FALSE;
		BaobabRingschartItem* _tmp56_ = NULL;
		gboolean _tmp57_ = FALSE;
		BaobabRingschartItem* _tmp62_ = NULL;
		BaobabRingschartItem* _tmp63_ = NULL;
		_tmp24_ = item;
		_tmp25_ = _tmp24_->parent;
		_tmp26_ = _tmp25_->data;
		_tmp27_ = (BaobabChartItem*) _tmp26_;
		_tmp28_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp27_) : NULL);
		parent = _tmp28_;
		_tmp29_ = ringsitem;
		_tmp30_ = ringsitem;
		_tmp31_ = ((BaobabChartItem*) _tmp30_)->depth;
		_tmp32_ = thickness;
		_tmp29_->min_radius = (gdouble) (_tmp31_ * _tmp32_);
		_tmp33_ = ringsitem;
		_tmp34_ = ((BaobabChartItem*) _tmp33_)->depth;
		_tmp35_ = baobab_chart_get_max_depth ((BaobabChart*) self);
		_tmp36_ = _tmp35_;
		if (_tmp34_ > _tmp36_) {
			_baobab_chart_item_unref0 (parent);
			_baobab_chart_item_unref0 (ringsitem);
			return;
		} else {
			BaobabRingschartItem* _tmp37_ = NULL;
			BaobabRingschartItem* _tmp38_ = NULL;
			gdouble _tmp39_ = 0.0;
			guint _tmp40_ = 0U;
			_tmp37_ = ringsitem;
			_tmp38_ = ringsitem;
			_tmp39_ = _tmp38_->min_radius;
			_tmp40_ = thickness;
			_tmp37_->max_radius = _tmp39_ + _tmp40_;
		}
		_tmp41_ = ringsitem;
		_tmp42_ = parent;
		_tmp43_ = _tmp42_->angle;
		_tmp44_ = ringsitem;
		_tmp45_ = ((BaobabChartItem*) _tmp44_)->rel_size;
		_tmp41_->angle = (_tmp43_ * _tmp45_) / 100;
		_tmp46_ = ringsitem;
		_tmp47_ = _tmp46_->angle;
		if (_tmp47_ < BAOBAB_RINGSCHART_ITEM_MIN_ANGLE) {
			_baobab_chart_item_unref0 (parent);
			_baobab_chart_item_unref0 (ringsitem);
			return;
		}
		_tmp48_ = ringsitem;
		_tmp49_ = parent;
		_tmp50_ = _tmp49_->start_angle;
		_tmp51_ = parent;
		_tmp52_ = _tmp51_->angle;
		_tmp53_ = ringsitem;
		_tmp54_ = ((BaobabChartItem*) _tmp53_)->rel_start;
		_tmp48_->start_angle = _tmp50_ + ((_tmp52_ * _tmp54_) / 100);
		_tmp56_ = ringsitem;
		_tmp57_ = ((BaobabChartItem*) _tmp56_)->has_any_child;
		if (_tmp57_) {
			BaobabRingschartItem* _tmp58_ = NULL;
			guint _tmp59_ = 0U;
			guint _tmp60_ = 0U;
			guint _tmp61_ = 0U;
			_tmp58_ = ringsitem;
			_tmp59_ = ((BaobabChartItem*) _tmp58_)->depth;
			_tmp60_ = baobab_chart_get_max_depth ((BaobabChart*) self);
			_tmp61_ = _tmp60_;
			_tmp55_ = _tmp59_ == _tmp61_;
		} else {
			_tmp55_ = FALSE;
		}
		_tmp62_ = ringsitem;
		_tmp62_->continued = _tmp55_;
		_tmp63_ = parent;
		((BaobabChartItem*) _tmp63_)->has_visible_children = TRUE;
		_baobab_chart_item_unref0 (parent);
	}
	_tmp64_ = ringsitem;
	((BaobabChartItem*) _tmp64_)->visible = TRUE;
	_tmp65_ = item;
	baobab_chart_get_item_rectangle ((BaobabChart*) self, _tmp65_);
	_baobab_chart_item_unref0 (ringsitem);
}


static void baobab_ringschart_get_point_min_rect (BaobabRingschart* self, gdouble cx, gdouble cy, gdouble radius, gdouble angle, GdkRectangle* r) {
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	GdkRectangle _tmp8_ = {0};
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GdkRectangle _tmp11_ = {0};
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GdkRectangle _tmp14_ = {0};
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GdkRectangle _tmp17_ = {0};
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_tmp0_ = cx;
	_tmp1_ = angle;
	_tmp2_ = cos (_tmp1_);
	_tmp3_ = radius;
	x = _tmp0_ + (_tmp2_ * _tmp3_);
	_tmp4_ = cy;
	_tmp5_ = angle;
	_tmp6_ = sin (_tmp5_);
	_tmp7_ = radius;
	y = _tmp4_ + (_tmp6_ * _tmp7_);
	_tmp8_ = *r;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = MIN (_tmp9_, (gint) x);
	(*r).x = _tmp10_;
	_tmp11_ = *r;
	_tmp12_ = _tmp11_.y;
	_tmp13_ = MIN (_tmp12_, (gint) y);
	(*r).y = _tmp13_;
	_tmp14_ = *r;
	_tmp15_ = _tmp14_.width;
	_tmp16_ = MAX (_tmp15_, (gint) x);
	(*r).width = _tmp16_;
	_tmp17_ = *r;
	_tmp18_ = _tmp17_.height;
	_tmp19_ = MAX (_tmp18_, (gint) y);
	(*r).height = _tmp19_;
}


static void baobab_ringschart_real_get_item_rectangle (BaobabChart* base, BaobabChartItem* item) {
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_ = NULL;
	BaobabRingschartItem* _tmp1_ = NULL;
	GdkRectangle rect = {0};
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	gdouble r1 = 0.0;
	gdouble r2 = 0.0;
	gdouble a1 = 0.0;
	gdouble a2 = 0.0;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp2_ = {0};
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	BaobabRingschartItem* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	BaobabRingschartItem* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	BaobabRingschartItem* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	BaobabRingschartItem* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	BaobabRingschartItem* _tmp15_ = NULL;
	gdouble _tmp16_ = 0.0;
	GtkAllocation _tmp17_ = {0};
	gint _tmp18_ = 0;
	GtkAllocation _tmp19_ = {0};
	gint _tmp20_ = 0;
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_ = 0.0;
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_ = 0.0;
	gboolean _tmp37_ = FALSE;
	gdouble _tmp38_ = 0.0;
	gboolean _tmp46_ = FALSE;
	gdouble _tmp47_ = 0.0;
	gboolean _tmp55_ = FALSE;
	gdouble _tmp56_ = 0.0;
	gboolean _tmp64_ = FALSE;
	gdouble _tmp65_ = 0.0;
	gint _tmp73_ = 0;
	GdkRectangle _tmp74_ = {0};
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	GdkRectangle _tmp77_ = {0};
	gint _tmp78_ = 0;
	BaobabRingschartItem* _tmp79_ = NULL;
	GdkRectangle _tmp80_ = {0};
	self = (BaobabRingschart*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	memset (&rect, 0, sizeof (GdkRectangle));
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	allocation = _tmp2_;
	_tmp3_ = allocation;
	_tmp4_ = _tmp3_.width;
	cx = (gdouble) (_tmp4_ / 2);
	_tmp5_ = allocation;
	_tmp6_ = _tmp5_.height;
	cy = (gdouble) (_tmp6_ / 2);
	_tmp7_ = ringsitem;
	_tmp8_ = _tmp7_->min_radius;
	r1 = _tmp8_;
	_tmp9_ = ringsitem;
	_tmp10_ = _tmp9_->max_radius;
	r2 = _tmp10_;
	_tmp11_ = ringsitem;
	_tmp12_ = _tmp11_->start_angle;
	a1 = _tmp12_;
	_tmp13_ = ringsitem;
	_tmp14_ = _tmp13_->start_angle;
	_tmp15_ = ringsitem;
	_tmp16_ = _tmp15_->angle;
	a2 = _tmp14_ + _tmp16_;
	_tmp17_ = allocation;
	_tmp18_ = _tmp17_.width;
	rect.x = _tmp18_;
	_tmp19_ = allocation;
	_tmp20_ = _tmp19_.height;
	rect.y = _tmp20_;
	rect.width = 0;
	rect.height = 0;
	_tmp21_ = cx;
	_tmp22_ = cy;
	_tmp23_ = r1;
	_tmp24_ = a1;
	baobab_ringschart_get_point_min_rect (self, _tmp21_, _tmp22_, _tmp23_, _tmp24_, &rect);
	_tmp25_ = cx;
	_tmp26_ = cy;
	_tmp27_ = r2;
	_tmp28_ = a1;
	baobab_ringschart_get_point_min_rect (self, _tmp25_, _tmp26_, _tmp27_, _tmp28_, &rect);
	_tmp29_ = cx;
	_tmp30_ = cy;
	_tmp31_ = r1;
	_tmp32_ = a2;
	baobab_ringschart_get_point_min_rect (self, _tmp29_, _tmp30_, _tmp31_, _tmp32_, &rect);
	_tmp33_ = cx;
	_tmp34_ = cy;
	_tmp35_ = r2;
	_tmp36_ = a2;
	baobab_ringschart_get_point_min_rect (self, _tmp33_, _tmp34_, _tmp35_, _tmp36_, &rect);
	_tmp38_ = a1;
	if (_tmp38_ <= (G_PI / 2)) {
		gdouble _tmp39_ = 0.0;
		_tmp39_ = a2;
		_tmp37_ = _tmp39_ >= (G_PI / 2);
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		GdkRectangle _tmp40_ = {0};
		gint _tmp41_ = 0;
		gdouble _tmp42_ = 0.0;
		gdouble _tmp43_ = 0.0;
		gdouble _tmp44_ = 0.0;
		gdouble _tmp45_ = 0.0;
		_tmp40_ = rect;
		_tmp41_ = _tmp40_.height;
		_tmp42_ = cy;
		_tmp43_ = sin (G_PI / 2);
		_tmp44_ = r2;
		_tmp45_ = MAX ((gdouble) _tmp41_, _tmp42_ + (_tmp43_ * _tmp44_));
		rect.height = (gint) _tmp45_;
	}
	_tmp47_ = a1;
	if (_tmp47_ <= G_PI) {
		gdouble _tmp48_ = 0.0;
		_tmp48_ = a2;
		_tmp46_ = _tmp48_ >= G_PI;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		GdkRectangle _tmp49_ = {0};
		gint _tmp50_ = 0;
		gdouble _tmp51_ = 0.0;
		gdouble _tmp52_ = 0.0;
		gdouble _tmp53_ = 0.0;
		gdouble _tmp54_ = 0.0;
		_tmp49_ = rect;
		_tmp50_ = _tmp49_.x;
		_tmp51_ = cx;
		_tmp52_ = cos (G_PI);
		_tmp53_ = r2;
		_tmp54_ = MIN ((gdouble) _tmp50_, _tmp51_ + (_tmp52_ * _tmp53_));
		rect.x = (gint) _tmp54_;
	}
	_tmp56_ = a1;
	if (_tmp56_ <= (G_PI * 1.5)) {
		gdouble _tmp57_ = 0.0;
		_tmp57_ = a2;
		_tmp55_ = _tmp57_ >= (G_PI * 1.5);
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		GdkRectangle _tmp58_ = {0};
		gint _tmp59_ = 0;
		gdouble _tmp60_ = 0.0;
		gdouble _tmp61_ = 0.0;
		gdouble _tmp62_ = 0.0;
		gdouble _tmp63_ = 0.0;
		_tmp58_ = rect;
		_tmp59_ = _tmp58_.y;
		_tmp60_ = cy;
		_tmp61_ = sin (G_PI * 1.5);
		_tmp62_ = r2;
		_tmp63_ = MIN ((gdouble) _tmp59_, _tmp60_ + (_tmp61_ * _tmp62_));
		rect.y = (gint) _tmp63_;
	}
	_tmp65_ = a1;
	if (_tmp65_ <= (G_PI * 2)) {
		gdouble _tmp66_ = 0.0;
		_tmp66_ = a2;
		_tmp64_ = _tmp66_ >= (G_PI * 2);
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		GdkRectangle _tmp67_ = {0};
		gint _tmp68_ = 0;
		gdouble _tmp69_ = 0.0;
		gdouble _tmp70_ = 0.0;
		gdouble _tmp71_ = 0.0;
		gdouble _tmp72_ = 0.0;
		_tmp67_ = rect;
		_tmp68_ = _tmp67_.width;
		_tmp69_ = cx;
		_tmp70_ = cos (G_PI * 2);
		_tmp71_ = r2;
		_tmp72_ = MAX ((gdouble) _tmp68_, _tmp69_ + (_tmp70_ * _tmp71_));
		rect.width = (gint) _tmp72_;
	}
	_tmp73_ = rect.width;
	_tmp74_ = rect;
	_tmp75_ = _tmp74_.x;
	rect.width = _tmp73_ - _tmp75_;
	_tmp76_ = rect.height;
	_tmp77_ = rect;
	_tmp78_ = _tmp77_.y;
	rect.height = _tmp76_ - _tmp78_;
	_tmp79_ = ringsitem;
	_tmp80_ = rect;
	((BaobabChartItem*) _tmp79_)->rect = _tmp80_;
	_baobab_chart_item_unref0 (ringsitem);
}


static gboolean baobab_ringschart_real_is_point_over_item (BaobabChart* base, BaobabChartItem* item, gdouble x, gdouble y) {
	BaobabRingschart * self;
	gboolean result = FALSE;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_ = NULL;
	BaobabRingschartItem* _tmp1_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp2_ = {0};
	gdouble _tmp3_ = 0.0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	gdouble _tmp6_ = 0.0;
	GtkAllocation _tmp7_ = {0};
	gint _tmp8_ = 0;
	gdouble radius = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble angle = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gdouble _tmp24_ = 0.0;
	BaobabRingschartItem* _tmp25_ = NULL;
	gdouble _tmp26_ = 0.0;
	self = (BaobabRingschart*) base;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	allocation = _tmp2_;
	_tmp3_ = x;
	_tmp4_ = allocation;
	_tmp5_ = _tmp4_.width;
	x = _tmp3_ - (_tmp5_ / 2);
	_tmp6_ = y;
	_tmp7_ = allocation;
	_tmp8_ = _tmp7_.height;
	y = _tmp6_ - (_tmp8_ / 2);
	_tmp9_ = x;
	_tmp10_ = x;
	_tmp11_ = y;
	_tmp12_ = y;
	_tmp13_ = sqrt ((_tmp9_ * _tmp10_) + (_tmp11_ * _tmp12_));
	radius = _tmp13_;
	_tmp14_ = y;
	_tmp15_ = x;
	_tmp16_ = atan2 (_tmp14_, _tmp15_);
	angle = _tmp16_;
	_tmp18_ = angle;
	if (_tmp18_ > ((gdouble) 0)) {
		gdouble _tmp19_ = 0.0;
		_tmp19_ = angle;
		_tmp17_ = _tmp19_;
	} else {
		gdouble _tmp20_ = 0.0;
		_tmp20_ = angle;
		_tmp17_ = _tmp20_ + (2 * G_PI);
	}
	angle = _tmp17_;
	_tmp24_ = radius;
	_tmp25_ = ringsitem;
	_tmp26_ = _tmp25_->min_radius;
	if (_tmp24_ >= _tmp26_) {
		gdouble _tmp27_ = 0.0;
		BaobabRingschartItem* _tmp28_ = NULL;
		gdouble _tmp29_ = 0.0;
		_tmp27_ = radius;
		_tmp28_ = ringsitem;
		_tmp29_ = _tmp28_->max_radius;
		_tmp23_ = _tmp27_ <= _tmp29_;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		gdouble _tmp30_ = 0.0;
		BaobabRingschartItem* _tmp31_ = NULL;
		gdouble _tmp32_ = 0.0;
		_tmp30_ = angle;
		_tmp31_ = ringsitem;
		_tmp32_ = _tmp31_->start_angle;
		_tmp22_ = _tmp30_ >= _tmp32_;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		gdouble _tmp33_ = 0.0;
		BaobabRingschartItem* _tmp34_ = NULL;
		gdouble _tmp35_ = 0.0;
		BaobabRingschartItem* _tmp36_ = NULL;
		gdouble _tmp37_ = 0.0;
		_tmp33_ = angle;
		_tmp34_ = ringsitem;
		_tmp35_ = _tmp34_->start_angle;
		_tmp36_ = ringsitem;
		_tmp37_ = _tmp36_->angle;
		_tmp21_ = _tmp33_ <= (_tmp35_ + _tmp37_);
	} else {
		_tmp21_ = FALSE;
	}
	result = _tmp21_;
	_baobab_chart_item_unref0 (ringsitem);
	return result;
}


static gboolean baobab_ringschart_real_can_zoom_out (BaobabChart* base) {
	BaobabRingschart * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ < BAOBAB_CHART_MAX_DEPTH;
	return result;
}


static gboolean baobab_ringschart_real_can_zoom_in (BaobabChart* base) {
	BaobabRingschart * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ > BAOBAB_CHART_MIN_DEPTH;
	return result;
}


BaobabRingschart* baobab_ringschart_construct (GType object_type) {
	BaobabRingschart * self = NULL;
	self = (BaobabRingschart*) baobab_chart_construct (object_type);
	return self;
}


BaobabRingschart* baobab_ringschart_new (void) {
	return baobab_ringschart_construct (BAOBAB_TYPE_RINGSCHART);
}


static void _baobab_ringschart_subtips_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	baobab_ringschart_subtips_update ((BaobabRingschart*) self);
}


static GObject * baobab_ringschart_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BaobabRingschart * self;
	parent_class = G_OBJECT_CLASS (baobab_ringschart_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART, BaobabRingschart);
	g_signal_connect_object ((GObject*) self, "notify::max-depth", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::highlighted-item", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::root", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	return obj;
}


static void baobab_ringschart_class_init (BaobabRingschartClass * klass) {
	baobab_ringschart_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabRingschartPrivate));
	((BaobabChartClass *) klass)->create_new_chartitem = baobab_ringschart_real_create_new_chartitem;
	((BaobabChartClass *) klass)->post_draw = baobab_ringschart_real_post_draw;
	((BaobabChartClass *) klass)->draw_item = baobab_ringschart_real_draw_item;
	((BaobabChartClass *) klass)->calculate_item_geometry = baobab_ringschart_real_calculate_item_geometry;
	((BaobabChartClass *) klass)->get_item_rectangle = baobab_ringschart_real_get_item_rectangle;
	((BaobabChartClass *) klass)->is_point_over_item = baobab_ringschart_real_is_point_over_item;
	((BaobabChartClass *) klass)->can_zoom_out = baobab_ringschart_real_can_zoom_out;
	((BaobabChartClass *) klass)->can_zoom_in = baobab_ringschart_real_can_zoom_in;
	G_OBJECT_CLASS (klass)->constructor = baobab_ringschart_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_ringschart_finalize;
}


static void baobab_ringschart_instance_init (BaobabRingschart * self) {
	self->priv = BAOBAB_RINGSCHART_GET_PRIVATE (self);
	self->priv->tips_timeout_id = (guint) 0;
	self->priv->drawing_subtips = FALSE;
}


static void baobab_ringschart_finalize (GObject* obj) {
	BaobabRingschart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART, BaobabRingschart);
	__g_list_free__baobab_chart_item_unref0_0 (self->priv->subtip_items);
	G_OBJECT_CLASS (baobab_ringschart_parent_class)->finalize (obj);
}


GType baobab_ringschart_get_type (void) {
	static volatile gsize baobab_ringschart_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_ringschart_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabRingschartClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_ringschart_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabRingschart), 0, (GInstanceInitFunc) baobab_ringschart_instance_init, NULL };
		GType baobab_ringschart_type_id;
		baobab_ringschart_type_id = g_type_register_static (BAOBAB_TYPE_CHART, "BaobabRingschart", &g_define_type_info, 0);
		g_once_init_leave (&baobab_ringschart_type_id__volatile, baobab_ringschart_type_id);
	}
	return baobab_ringschart_type_id__volatile;
}



