// -*- c++ -*-
// Generated by gmmproc 2.41.4 -- DO NOT MODIFY!
#ifndef _GTKMM_SCROLLEDWINDOW_H
#define _GTKMM_SCROLLEDWINDOW_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkScrolledWindow GtkScrolledWindow;
typedef struct _GtkScrolledWindowClass GtkScrolledWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ScrolledWindow_Class; } // namespace Gtk
namespace Gtk
{

class Adjustment;
class Scrollbar;

/** Adds scrollbars to its child widget.
 *
 * This container accepts a single child widget. It adds scrollbars to the child widget and optionally draws a beveled frame around the child widget.
 * The scrolled window can work in two ways:
 * <OL>
 * <LI>Some widgets have native scrolling support; these widgets handle certain Gtk::Adjustment signals. Widgets with native scroll support include Gtk::TreeView, Gtk::TextView, and Gtk::Layout.</LI>
 * <LI>For widgets that lack native scrolling support, such as Gtk::Grid, Gtk::Box, and so on, the widget will be placed inside a Gtk::Viewport.</LI>
 * </OL>
 *
 * The position of the scrollbars is controlled by the scroll adjustments. See Gtk::Adjustment for the fields in an adjustment - for Gtk::Scrollbar, used by Gtk::ScrolledWindow,
 * the "value" field represents the position of the scrollbar, which must be between the "lower" field and "upper - page_size."
 * The "page_size" field represents the size of the visible scrollable area.
 * The "step_increment" and "page_increment" fields are used when the user asks to step down (using the small stepper arrows) or page down (using for example the PageDown key).
 *
 * If a Gtk::ScrolledWindow doesn't behave quite as you would like, or doesn't have exactly the right layout, it's very possible to set up your own scrolling with Gtk::Scrollbar and, for example, a Gtk::Grid.
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class ScrolledWindow : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ScrolledWindow CppObjectType;
  typedef ScrolledWindow_Class CppClassType;
  typedef GtkScrolledWindow BaseObjectType;
  typedef GtkScrolledWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ScrolledWindow();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ScrolledWindow_Class;
  static CppClassType scrolledwindow_class_;

  // noncopyable
  ScrolledWindow(const ScrolledWindow&);
  ScrolledWindow& operator=(const ScrolledWindow&);

protected:
  explicit ScrolledWindow(const Glib::ConstructParams& construct_params);
  explicit ScrolledWindow(GtkScrolledWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkScrolledWindow*       gobj()       { return reinterpret_cast<GtkScrolledWindow*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkScrolledWindow* gobj() const { return reinterpret_cast<GtkScrolledWindow*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:


public:
  ScrolledWindow();
    explicit ScrolledWindow(const Glib::RefPtr<Adjustment>& hadjustment, const Glib::RefPtr<Adjustment>& vadjustment);


  //TODO: Add unset_*adjustment().
  //But the C API does not do that. murrayc.
  
  /** Sets the Gtk::Adjustment for the horizontal scrollbar.
   * 
   * @param hadjustment Horizontal scroll adjustment.
   */
  void set_hadjustment(const Glib::RefPtr<Adjustment>& hadjustment);
  
  /** Sets the Gtk::Adjustment for the vertical scrollbar.
   * 
   * @param vadjustment Vertical scroll adjustment.
   */
  void set_vadjustment(const Glib::RefPtr<Adjustment>& vadjustment);

  
  /** Returns the horizontal scrollbar’s adjustment, used to connect the
   * horizontal scrollbar to the child widget’s horizontal scroll
   * functionality.
   * 
   * @return The horizontal Gtk::Adjustment.
   */
  Glib::RefPtr<Adjustment> get_hadjustment();
  
  /** Returns the horizontal scrollbar’s adjustment, used to connect the
   * horizontal scrollbar to the child widget’s horizontal scroll
   * functionality.
   * 
   * @return The horizontal Gtk::Adjustment.
   */
  Glib::RefPtr<const Adjustment> get_hadjustment() const;
  
  /** Returns the vertical scrollbar’s adjustment, used to connect the
   * vertical scrollbar to the child widget’s vertical scroll functionality.
   * 
   * @return The vertical Gtk::Adjustment.
   */
  Glib::RefPtr<Adjustment> get_vadjustment();
  
  /** Returns the vertical scrollbar’s adjustment, used to connect the
   * vertical scrollbar to the child widget’s vertical scroll functionality.
   * 
   * @return The vertical Gtk::Adjustment.
   */
  Glib::RefPtr<const Adjustment> get_vadjustment() const;

  
  /** Sets the scrollbar policy for the horizontal and vertical scrollbars.
   * 
   * The policy determines when the scrollbar should appear; it is a value
   * from the Gtk::PolicyType enumeration. If Gtk::POLICY_ALWAYS, the
   * scrollbar is always present; if Gtk::POLICY_NEVER, the scrollbar is
   * never present; if Gtk::POLICY_AUTOMATIC, the scrollbar is present only
   * if needed (that is, if the slider part of the bar would be smaller
   * than the trough - the display is larger than the page size).
   * 
   * @param hscrollbar_policy Policy for horizontal bar.
   * @param vscrollbar_policy Policy for vertical bar.
   */
  void set_policy(PolicyType hscrollbar_policy, PolicyType vscrollbar_policy);
  
  /** Retrieves the current policy values for the horizontal and vertical
   * scrollbars. See set_policy().
   * 
   * @param hscrollbar_policy Location to store the policy 
   * for the horizontal scrollbar, or <tt>0</tt>.
   * @param vscrollbar_policy Location to store the policy
   * for the vertical scrollbar, or <tt>0</tt>.
   */
  void get_policy(PolicyType& hscrollbar_policy, PolicyType& vscrollbar_policy) const;

  
  /** Sets the placement of the contents with respect to the scrollbars
   * for the scrolled window.
   * 
   * The default is Gtk::CORNER_TOP_LEFT, meaning the child is
   * in the top left, with the scrollbars underneath and to the right.
   * Other values in Gtk::CornerType are Gtk::CORNER_TOP_RIGHT,
   * Gtk::CORNER_BOTTOM_LEFT, and Gtk::CORNER_BOTTOM_RIGHT.
   * 
   * See also get_placement() and
   * unset_placement().
   * 
   * @param window_placement Position of the child window.
   */
  void set_placement(CornerType window_placement);
  
  /** Unsets the placement of the contents with respect to the scrollbars
   * for the scrolled window. If no window placement is set for a scrolled
   * window, it defaults to GTK_CORNER_TOP_LEFT.
   * 
   * See also set_placement() and
   * get_placement().
   * 
   * @newin{2,10}
   * 
   */
  void unset_placement();
  
  /** Gets the placement of the contents with respect to the scrollbars
   * for the scrolled window. See set_placement().
   * 
   * @return The current placement value.
   * 
   * See also set_placement() and
   * unset_placement().
   */
  CornerType get_placement() const;

  
  /** Changes the type of shadow drawn around the contents of
   *  @a scrolled_window.
   * 
   * @param type Kind of shadow to draw around scrolled window contents.
   */
  void set_shadow_type(ShadowType type);
  
  /** Gets the shadow type of the scrolled window. See 
   * set_shadow_type().
   * 
   * @return The current shadow type.
   */
  ShadowType get_shadow_type() const;

  ///Puts the child inside a Gtk::Viewport if it doesn't have native scrolling capability.
  virtual void add(Gtk::Widget& widget);
  

  //TODO: When we can break ABI/API, make Bin::remove() virtual and delete remove_with_viewport().
  //      Add a ScrolledWindow::remove() override, and let it do approximately
  //      what remove_with_viewport() does. https://bugzilla.gnome.org/show_bug.cgi?id=685739#c2
  /** Remove the contained object, possibly also a Gtk::Viewport.
   * Since this can only hold one object it is not necessary to specify which
   * object to remove, like containers that don't derive from Gtk::Bin.
   *
   * This method is useful if you have added a widget without native scrolling
   * capability, and ScrolledWindow::add() has created a Gtk::Viewport.
   *
   * If the child of the ScrolledWindow is a Gtk::Viewport, remove_with_viewport()
   * removes the Viewport's child from the Viewport, and removes the Viewport from the
   * ScrolledWindow. The Viewport is destroyed in two cases.
   * <OL>
   * <LI>If it was created by ScrolledWindow::add().</LI>
   * <LI>If it was created as a managed widget
   *     (<code>Gtk::Viewport* vp = Gtk::manage(new Gtk::Viewport(hadj, vadj));</code>).</LI>
   * </OL>
   *
   * @newin{3,8}
   */
  void remove_with_viewport();

 
  /** Returns the vertical scrollbar of @a scrolled_window.
   * 
   * @newin{2,8}
   * 
   * @return The vertical scrollbar of the scrolled window.
   */
  Scrollbar* get_vscrollbar();
  
  /** Returns the vertical scrollbar of @a scrolled_window.
   * 
   * @newin{2,8}
   * 
   * @return The vertical scrollbar of the scrolled window.
   */
  const Scrollbar* get_vscrollbar() const;

  
  /** Returns the horizontal scrollbar of @a scrolled_window.
   * 
   * @newin{2,8}
   * 
   * @return The horizontal scrollbar of the scrolled window.
   */
  Scrollbar* get_hscrollbar();
  
  /** Returns the horizontal scrollbar of @a scrolled_window.
   * 
   * @newin{2,8}
   * 
   * @return The horizontal scrollbar of the scrolled window.
   */
  const Scrollbar* get_hscrollbar() const;

  
  /** Gets the minimum content width of @a scrolled_window, or -1 if not set.
   * 
   * @newin{3,0}
   * 
   * @return The minimum content width.
   */
  int get_min_content_width() const;
  
  /** Sets the minimum width that @a scrolled_window should keep visible.
   * Note that this can and (usually will) be smaller than the minimum
   * size of the content.
   * 
   * @newin{3,0}
   * 
   * @param width The minimal content width.
   */
  void set_min_content_width(int width);
  
  /** Gets the minimal content height of @a scrolled_window, or -1 if not set.
   * 
   * @newin{3,0}
   * 
   * @return The minimal content height.
   */
  int get_min_content_height() const;
  
  /** Sets the minimum height that @a scrolled_window should keep visible.
   * Note that this can and (usually will) be smaller than the minimum
   * size of the content.
   * 
   * @newin{3,0}
   * 
   * @param height The minimal content height.
   */
  void set_min_content_height(int height);

  
  /** Turns kinetic scrolling on or off.
   * Kinetic scrolling only applies to devices with source
   * Gdk::SOURCE_TOUCHSCREEN.
   * 
   * @newin{3,4}
   * 
   * @param kinetic_scrolling <tt>true</tt> to enable kinetic scrolling.
   */
  void set_kinetic_scrolling(bool kinetic_scrolling =  true);
  
  /** Returns the specified kinetic scrolling behavior.
   * 
   * @newin{3,4}
   * 
   * @return The scrolling behavior flags.
   */
  bool get_kinetic_scrolling() const;

  
  /** Changes the behaviour of @a scrolled_window wrt. to the initial
   * event that possibly starts kinetic scrolling. When @a capture_button_press
   * is set to <tt>true</tt>, the event is captured by the scrolled window, and
   * then later replayed if it is meant to go to the child widget.
   * 
   * This should be enabled if any child widgets perform non-reversible
   * actions on Gtk::Widget::signal_button_press_event(). If they don't, and handle
   * additionally handle Gtk::Widget::signal_grab_broken_event(), it might be better
   * to set @a capture_button_press to <tt>false</tt>.
   * 
   * This setting only has an effect if kinetic scrolling is enabled.
   * 
   * @newin{3,4}
   * 
   * @param capture_button_press <tt>true</tt> to capture button presses.
   */
  void set_capture_button_press(bool capture_button_press);
  
  /** Return whether button presses are captured during kinetic
   * scrolling. See set_capture_button_press().
   * 
   * @newin{3,4}
   * 
   * @return <tt>true</tt> if button presses are captured during kinetic scrolling.
   */
  bool get_capture_button_press() const;

  //Keybinding signals:
  
  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkAdjustment for the horizontal position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Adjustment> > property_hadjustment() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkAdjustment for the horizontal position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Adjustment> > property_hadjustment() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkAdjustment for the vertical position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Adjustment> > property_vadjustment() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkAdjustment for the vertical position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Adjustment> > property_vadjustment() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** When the horizontal scrollbar is displayed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< PolicyType > property_hscrollbar_policy() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** When the horizontal scrollbar is displayed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< PolicyType > property_hscrollbar_policy() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** When the vertical scrollbar is displayed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< PolicyType > property_vscrollbar_policy() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** When the vertical scrollbar is displayed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< PolicyType > property_vscrollbar_policy() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Where the contents are located with respect to the scrollbars.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< CornerType > property_window_placement() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Where the contents are located with respect to the scrollbars.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< CornerType > property_window_placement() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
#ifndef GTKMM_DISABLE_DEPRECATED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether 'window-placement' should be used to determine the location of the contents with respect to the scrollbars.
   * @deprecated This value is ignored and the property_window_placement() value is always honored.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_window_placement_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether 'window-placement' should be used to determine the location of the contents with respect to the scrollbars.
   * @deprecated This value is ignored and the property_window_placement() value is always honored.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_window_placement_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

#endif // GTKMM_DISABLE_DEPRECATED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Style of bevel around the contents.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ShadowType > property_shadow_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Style of bevel around the contents.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ShadowType > property_shadow_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The minimum width that the scrolled window will allocate to its content.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_min_content_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The minimum width that the scrolled window will allocate to its content.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_min_content_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The minimum height that the scrolled window will allocate to its content.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_min_content_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The minimum height that the scrolled window will allocate to its content.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_min_content_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Kinetic scrolling mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_kinetic_scrolling() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Kinetic scrolling mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_kinetic_scrolling() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} //namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ScrolledWindow
   */
  Gtk::ScrolledWindow* wrap(GtkScrolledWindow* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_SCROLLEDWINDOW_H */

