#!/bin/sh
# Run this to generate all the initial makefiles, etc.
set -e
srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

PKG_NAME="pygobject"

(test -f $srcdir/configure.ac \
  && test -f $srcdir/$PKG_NAME.doap) || {
    echo -n "**Error**: Directory "\`$srcdir\'" does not look like the"
    echo " top-level $PKG_NAME directory"
    exit 1
}

if type lcov >/dev/null 2>&1; then
    EXTRA_ARGS="--enable-code-coverage"
else
    echo "lcov not installed, not enabling code coverage"
fi


which gnome-autogen.sh || {
    echo "You need to install gnome-common."
    exit 1
}

. gnome-autogen.sh "$EXTRA_ARGS" "$@"

