// Generated by gmmproc 2.48.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gdkmm/seat.h>
#include <gdkmm/private/seat_p.h>


/* Copyright (C) 2015 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gdkmm/display.h>
#include <gdkmm/window.h>

namespace
{

void Seat_grab_callback(GdkSeat*, GdkWindow* window, gpointer user_data)
{
  auto slot = static_cast<Gdk::Seat::SlotGrabPrepare*>(user_data);

  try
  {
    (*slot)(Glib::wrap(window, true));
  }
  catch(...)
  {
     Glib::exception_handlers_invoke();
  }
}

} // anonymous namespace

namespace
{


static void Seat_signal_device_added_callback(GdkSeat* self, GdkDevice* p0,void* data)
{
  using namespace Gdk;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Device>& >;

  auto obj = dynamic_cast<Seat*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Seat_signal_device_added_info =
{
  "device-added",
  (GCallback) &Seat_signal_device_added_callback,
  (GCallback) &Seat_signal_device_added_callback
};


static void Seat_signal_device_removed_callback(GdkSeat* self, GdkDevice* p0,void* data)
{
  using namespace Gdk;
  using SlotType = sigc::slot< void,const Glib::RefPtr<Device>& >;

  auto obj = dynamic_cast<Seat*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Seat_signal_device_removed_info =
{
  "device-removed",
  (GCallback) &Seat_signal_device_removed_callback,
  (GCallback) &Seat_signal_device_removed_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gdk::SeatCapabilities>::value_type()
{
  return gdk_seat_capabilities_get_type();
}


namespace Glib
{

Glib::RefPtr<Gdk::Seat> wrap(GdkSeat* object, bool take_copy)
{
  return Glib::RefPtr<Gdk::Seat>( dynamic_cast<Gdk::Seat*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

const Glib::Class& Seat_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Seat_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gdk_seat_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Seat_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Seat_Class::wrap_new(GObject* object)
{
  return new Seat((GdkSeat*)object);
}


/* The implementation: */

GdkSeat* Seat::gobj_copy()
{
  reference();
  return gobj();
}

Seat::Seat(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Seat::Seat(GdkSeat* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Seat::Seat(Seat&& src) noexcept
: Glib::Object(std::move(src))
{}

Seat& Seat::operator=(Seat&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  return *this;
}


Seat::~Seat() noexcept
{}


Seat::CppClassType Seat::seat_class_; // initialize static member

GType Seat::get_type()
{
  return seat_class_.init().get_type();
}


GType Seat::get_base_type()
{
  return gdk_seat_get_type();
}


Seat::Seat()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(seat_class_.init()))
{
  

}

GrabStatus Seat::grab(const Glib::RefPtr<Window>& window, SeatCapabilities capabilities, bool owner_events, const Glib::RefPtr<Cursor>& cursor, const GdkEvent* event, const SlotGrabPrepare& slot)
{
  // Use the original slot (not a copy).
  auto slot_copy = const_cast<SlotGrabPrepare*>(&slot);

  return ((GrabStatus)(gdk_seat_grab(gobj(), Glib::unwrap(window), ((GdkSeatCapabilities)(capabilities)), static_cast<int>(owner_events), Glib::unwrap(cursor), event, &Seat_grab_callback, slot_copy)));
}

void Seat::ungrab()
{
  gdk_seat_ungrab(gobj());
}

Glib::RefPtr<Display> Seat::get_display()
{
  Glib::RefPtr<Display> retvalue = Glib::wrap(gdk_seat_get_display(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Display> Seat::get_display() const
{
  return const_cast<Seat*>(this)->get_display();
}

SeatCapabilities Seat::get_capabilities() const
{
  return ((SeatCapabilities)(gdk_seat_get_capabilities(const_cast<GdkSeat*>(gobj()))));
}

std::vector<Glib::RefPtr<Device>> Seat::get_slaves(SeatCapabilities capabilities)
{
  return Glib::ListHandler<Glib::RefPtr<Device>>::list_to_vector(gdk_seat_get_slaves(gobj(), ((GdkSeatCapabilities)(capabilities))), Glib::OWNERSHIP_SHALLOW);
}

std::vector<Glib::RefPtr<const Device>> Seat::get_slaves(SeatCapabilities capabilities) const
{
  return Glib::ListHandler<Glib::RefPtr<const Device>>::list_to_vector(gdk_seat_get_slaves(const_cast<GdkSeat*>(gobj()), ((GdkSeatCapabilities)(capabilities))), Glib::OWNERSHIP_SHALLOW);
}

Glib::RefPtr<Device> Seat::get_pointer()
{
  Glib::RefPtr<Device> retvalue = Glib::wrap(gdk_seat_get_pointer(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Device> Seat::get_pointer() const
{
  return const_cast<Seat*>(this)->get_pointer();
}

Glib::RefPtr<Device> Seat::get_keyboard()
{
  Glib::RefPtr<Device> retvalue = Glib::wrap(gdk_seat_get_keyboard(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Device> Seat::get_keyboard() const
{
  return const_cast<Seat*>(this)->get_keyboard();
}


Glib::SignalProxy< void,const Glib::RefPtr<Device>& > Seat::signal_device_added()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Device>& >(this, &Seat_signal_device_added_info);
}


Glib::SignalProxy< void,const Glib::RefPtr<Device>& > Seat::signal_device_removed()
{
  return Glib::SignalProxy< void,const Glib::RefPtr<Device>& >(this, &Seat_signal_device_removed_info);
}


Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> > Seat::property_display() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> >(this, "display");
}


} // namespace Gdk


