/*
 * Clutter.
 *
 * An OpenGL based 'interactive canvas' library.
 *
 * Authored By Matthew Allum  <mallum@openedhand.com>
 *
 * Copyright (C) 2006 OpenedHand
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */

#ifndef __CLUTTER_H__
#define __CLUTTER_H__

#define __CLUTTER_H_INSIDE__

#include "clutter-config.h"
#include "clutter-types.h"

#include "clutter-action.h"
#include "clutter-actor.h"
#include "clutter-actor-meta.h"
#include "clutter-align-constraint.h"
#include "clutter-animatable.h"
#include "clutter-backend.h"
#include "clutter-bind-constraint.h"
#include "clutter-binding-pool.h"
#include "clutter-bin-layout.h"
#include "clutter-blur-effect.h"
#include "clutter-box-layout.h"
#include "clutter-brightness-contrast-effect.h"
#include "clutter-cairo.h"
#include "clutter-canvas.h"
#include "clutter-child-meta.h"
#include "clutter-click-action.h"
#include "clutter-clone.h"
#include "clutter-color.h"
#include "clutter-color-static.h"
#include "clutter-colorize-effect.h"
#include "clutter-constraint.h"
#include "clutter-container.h"
#include "clutter-content.h"
#include "clutter-deform-effect.h"
#include "clutter-desaturate-effect.h"
#include "clutter-device-manager.h"
#include "clutter-drag-action.h"
#include "clutter-drop-action.h"
#include "clutter-effect.h"
#include "clutter-enums.h"
#include "clutter-enum-types.h"
#include "clutter-event.h"
#include "clutter-feature.h"
#include "clutter-fixed-layout.h"
#include "clutter-flow-layout.h"
#include "clutter-gesture-action.h"
#include "clutter-grid-layout.h"
#include "clutter-group.h"
#include "clutter-image.h"
#include "clutter-input-device.h"
#include "clutter-input-device-tool.h"
#include "clutter-interval.h"
#include "clutter-keyframe-transition.h"
#include "clutter-keysyms.h"
#include "clutter-layout-manager.h"
#include "clutter-layout-meta.h"
#include "clutter-macros.h"
#include "clutter-main.h"
#include "clutter-offscreen-effect.h"
#include "clutter-page-turn-effect.h"
#include "clutter-paint-nodes.h"
#include "clutter-paint-node.h"
#include "clutter-pan-action.h"
#include "clutter-path-constraint.h"
#include "clutter-path.h"
#include "clutter-property-transition.h"
#include "clutter-rotate-action.h"
#include "clutter-scriptable.h"
#include "clutter-script.h"
#include "clutter-scroll-actor.h"
#include "clutter-settings.h"
#include "clutter-shader-effect.h"
#include "clutter-shader-types.h"
#include "clutter-swipe-action.h"
#include "clutter-snap-constraint.h"
#include "clutter-stage.h"
#include "clutter-stage-manager.h"
#include "clutter-tap-action.h"
#include "clutter-test-utils.h"
#include "clutter-texture.h"
#include "clutter-text.h"
#include "clutter-timeline.h"
#include "clutter-transition-group.h"
#include "clutter-transition.h"
#include "clutter-units.h"
#include "clutter-version.h"
#include "clutter-zoom-action.h"

#include "clutter-deprecated.h"

#include "clutter-autocleanups.h"

#undef __CLUTTER_H_INSIDE__

#endif /* __CLUTTER_H__ */
