/* valaexpression.c generated by valac, the Vala compiler
 * generated from valaexpression.vala, do not modify */

/* valaexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaExpressionPrivate ValaExpressionPrivate;

#define VALA_TYPE_TARGET_VALUE (vala_target_value_get_type ())
#define VALA_TARGET_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TARGET_VALUE, ValaTargetValue))
#define VALA_TARGET_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TARGET_VALUE, ValaTargetValueClass))
#define VALA_IS_TARGET_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TARGET_VALUE))
#define VALA_IS_TARGET_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TARGET_VALUE))
#define VALA_TARGET_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TARGET_VALUE, ValaTargetValueClass))

typedef struct _ValaTargetValue ValaTargetValue;
typedef struct _ValaTargetValueClass ValaTargetValueClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_STATEMENT (vala_statement_get_type ())
#define VALA_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STATEMENT, ValaStatement))
#define VALA_IS_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STATEMENT))
#define VALA_STATEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_STATEMENT, ValaStatementIface))

typedef struct _ValaStatement ValaStatement;
typedef struct _ValaStatementIface ValaStatementIface;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_MEMBER_INITIALIZER (vala_member_initializer_get_type ())
#define VALA_MEMBER_INITIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer))
#define VALA_MEMBER_INITIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializerClass))
#define VALA_IS_MEMBER_INITIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_INITIALIZER))
#define VALA_IS_MEMBER_INITIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_INITIALIZER))
#define VALA_MEMBER_INITIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializerClass))

typedef struct _ValaMemberInitializer ValaMemberInitializer;
typedef struct _ValaMemberInitializerClass ValaMemberInitializerClass;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaExpression {
	ValaCodeNode parent_instance;
	ValaExpressionPrivate * priv;
};

struct _ValaExpressionClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_constant) (ValaExpression* self);
	gboolean (*is_pure) (ValaExpression* self);
	gboolean (*is_non_null) (ValaExpression* self);
	gboolean (*is_accessible) (ValaExpression* self, ValaSymbol* sym);
};

struct _ValaExpressionPrivate {
	ValaDataType* _value_type;
	ValaDataType* _formal_value_type;
	ValaDataType* _target_type;
	ValaDataType* _formal_target_type;
	ValaSymbol* _symbol_reference;
	gboolean _lvalue;
	ValaTargetValue* _target_value;
};

struct _ValaStatementIface {
	GTypeInterface parent_iface;
};


static gpointer vala_expression_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
gpointer vala_target_value_ref (gpointer instance);
void vala_target_value_unref (gpointer instance);
GParamSpec* vala_param_spec_target_value (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_target_value (GValue* value, gpointer v_object);
void vala_value_take_target_value (GValue* value, gpointer v_object);
gpointer vala_value_get_target_value (const GValue* value);
GType vala_target_value_get_type (void) G_GNUC_CONST;
#define VALA_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_EXPRESSION, ValaExpressionPrivate))
enum  {
	VALA_EXPRESSION_DUMMY_PROPERTY
};
gboolean vala_expression_is_constant (ValaExpression* self);
static gboolean vala_expression_real_is_constant (ValaExpression* self);
gboolean vala_expression_is_pure (ValaExpression* self);
static gboolean vala_expression_real_is_pure (ValaExpression* self);
gboolean vala_expression_is_non_null (ValaExpression* self);
static gboolean vala_expression_real_is_non_null (ValaExpression* self);
gboolean vala_expression_is_accessible (ValaExpression* self, ValaSymbol* sym);
static gboolean vala_expression_real_is_accessible (ValaExpression* self, ValaSymbol* sym);
GType vala_block_get_type (void) G_GNUC_CONST;
GType vala_statement_get_type (void) G_GNUC_CONST;
void vala_expression_insert_statement (ValaExpression* self, ValaBlock* block, ValaStatement* stmt);
void vala_block_insert_before (ValaBlock* self, ValaStatement* stmt, ValaStatement* new_stmt);
ValaStatement* vala_expression_get_parent_statement (ValaExpression* self);
ValaExpression* vala_expression_construct (GType object_type);
ValaCodeNode* vala_code_node_construct (GType object_type);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
void vala_expression_set_value_type (ValaExpression* self, ValaDataType* value);
ValaDataType* vala_expression_get_formal_value_type (ValaExpression* self);
void vala_expression_set_formal_value_type (ValaExpression* self, ValaDataType* value);
ValaDataType* vala_expression_get_target_type (ValaExpression* self);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
ValaDataType* vala_expression_get_formal_target_type (ValaExpression* self);
void vala_expression_set_formal_target_type (ValaExpression* self, ValaDataType* value);
ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self);
void vala_expression_set_symbol_reference (ValaExpression* self, ValaSymbol* value);
gboolean vala_expression_get_lvalue (ValaExpression* self);
void vala_expression_set_lvalue (ValaExpression* self, gboolean value);
ValaTargetValue* vala_expression_get_target_value (ValaExpression* self);
void vala_expression_set_target_value (ValaExpression* self, ValaTargetValue* value);
ValaCodeNode* vala_code_node_get_parent_node (ValaCodeNode* self);
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_member_initializer_get_type (void) G_GNUC_CONST;
static void vala_expression_finalize (ValaCodeNode * obj);


/**
 * Returns whether this expression is constant, i.e. whether this
 * expression only consists of literals and other constants.
 */
static gboolean vala_expression_real_is_constant (ValaExpression* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean vala_expression_is_constant (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_EXPRESSION_GET_CLASS (self)->is_constant (self);
}


/**
 * Returns whether this expression is pure, i.e. whether this expression
 * is free of side-effects.
 */
static gboolean vala_expression_real_is_pure (ValaExpression* self) {
	g_critical ("Type `%s' does not implement abstract method `vala_expression_is_pure'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean vala_expression_is_pure (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_EXPRESSION_GET_CLASS (self)->is_pure (self);
}


/**
 * Returns whether this expression is guaranteed to be non-null.
 */
static gboolean vala_expression_real_is_non_null (ValaExpression* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean vala_expression_is_non_null (ValaExpression* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_EXPRESSION_GET_CLASS (self)->is_non_null (self);
}


/**
 * Check whether symbol_references in this expression are at least
 * as accessible as the specified symbol.
 */
static gboolean vala_expression_real_is_accessible (ValaExpression* self, ValaSymbol* sym) {
	gboolean result = FALSE;
	g_return_val_if_fail (sym != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean vala_expression_is_accessible (ValaExpression* self, ValaSymbol* sym) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_EXPRESSION_GET_CLASS (self)->is_accessible (self, sym);
}


void vala_expression_insert_statement (ValaExpression* self, ValaBlock* block, ValaStatement* stmt) {
	ValaBlock* _tmp0_;
	ValaStatement* _tmp1_;
	ValaStatement* _tmp2_;
	ValaStatement* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	g_return_if_fail (stmt != NULL);
	_tmp0_ = block;
	_tmp1_ = vala_expression_get_parent_statement (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = stmt;
	vala_block_insert_before (_tmp0_, _tmp2_, _tmp3_);
}


ValaExpression* vala_expression_construct (GType object_type) {
	ValaExpression* self = NULL;
	self = (ValaExpression*) vala_code_node_construct (object_type);
	return self;
}


ValaDataType* vala_expression_get_value_type (ValaExpression* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_type;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_expression_set_value_type (ValaExpression* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_value_type);
	self->priv->_value_type = _tmp1_;
}


ValaDataType* vala_expression_get_formal_value_type (ValaExpression* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_formal_value_type;
	result = _tmp0_;
	return result;
}


void vala_expression_set_formal_value_type (ValaExpression* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_formal_value_type);
	self->priv->_formal_value_type = _tmp1_;
}


ValaDataType* vala_expression_get_target_type (ValaExpression* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target_type;
	result = _tmp0_;
	return result;
}


void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_target_type);
	self->priv->_target_type = _tmp1_;
}


ValaDataType* vala_expression_get_formal_target_type (ValaExpression* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_formal_target_type;
	result = _tmp0_;
	return result;
}


void vala_expression_set_formal_target_type (ValaExpression* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_formal_target_type);
	self->priv->_formal_target_type = _tmp1_;
}


ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self) {
	ValaSymbol* result;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbol_reference;
	result = _tmp0_;
	return result;
}


void vala_expression_set_symbol_reference (ValaExpression* self, ValaSymbol* value) {
	ValaSymbol* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_symbol_reference = _tmp0_;
}


gboolean vala_expression_get_lvalue (ValaExpression* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_lvalue;
	result = _tmp0_;
	return result;
}


void vala_expression_set_lvalue (ValaExpression* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_lvalue = _tmp0_;
}


ValaTargetValue* vala_expression_get_target_value (ValaExpression* self) {
	ValaTargetValue* result;
	ValaTargetValue* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target_value;
	result = _tmp0_;
	return result;
}


static gpointer _vala_target_value_ref0 (gpointer self) {
	return self ? vala_target_value_ref (self) : NULL;
}


void vala_expression_set_target_value (ValaExpression* self, ValaTargetValue* value) {
	ValaTargetValue* _tmp0_;
	ValaTargetValue* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_target_value_ref0 (_tmp0_);
	_vala_target_value_unref0 (self->priv->_target_value);
	self->priv->_target_value = _tmp1_;
}


ValaStatement* vala_expression_get_parent_statement (ValaExpression* self) {
	ValaStatement* result;
	ValaExpression* expr;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaExpression* _tmp2_;
	ValaStatement* stmt;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	ValaStatement* _tmp5_;
	ValaLocalVariable* local;
	ValaCodeNode* _tmp6_;
	ValaCodeNode* _tmp7_;
	ValaLocalVariable* _tmp8_;
	ValaMemberInitializer* initializer;
	ValaCodeNode* _tmp9_;
	ValaCodeNode* _tmp10_;
	ValaMemberInitializer* _tmp11_;
	ValaStatement* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_EXPRESSION) ? ((ValaExpression*) _tmp1_) : NULL);
	expr = _tmp2_;
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_STATEMENT) ? ((ValaStatement*) _tmp4_) : NULL);
	stmt = _tmp5_;
	_tmp6_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp7_) : NULL);
	local = _tmp8_;
	_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_MEMBER_INITIALIZER) ? ((ValaMemberInitializer*) _tmp10_) : NULL);
	initializer = _tmp11_;
	_tmp12_ = stmt;
	if (_tmp12_ != NULL) {
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		_tmp13_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp14_ = _tmp13_;
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_STATEMENT, ValaStatement);
		_vala_code_node_unref0 (initializer);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (expr);
		return result;
	} else {
		ValaExpression* _tmp15_;
		_tmp15_ = expr;
		if (_tmp15_ != NULL) {
			ValaExpression* _tmp16_;
			ValaStatement* _tmp17_;
			ValaStatement* _tmp18_;
			_tmp16_ = expr;
			_tmp17_ = vala_expression_get_parent_statement (_tmp16_);
			_tmp18_ = _tmp17_;
			result = _tmp18_;
			_vala_code_node_unref0 (initializer);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (expr);
			return result;
		} else {
			ValaLocalVariable* _tmp19_;
			_tmp19_ = local;
			if (_tmp19_ != NULL) {
				ValaLocalVariable* _tmp20_;
				ValaCodeNode* _tmp21_;
				ValaCodeNode* _tmp22_;
				_tmp20_ = local;
				_tmp21_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp20_);
				_tmp22_ = _tmp21_;
				result = G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_STATEMENT, ValaStatement);
				_vala_code_node_unref0 (initializer);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (expr);
				return result;
			} else {
				ValaMemberInitializer* _tmp23_;
				_tmp23_ = initializer;
				if (_tmp23_ != NULL) {
					ValaMemberInitializer* _tmp24_;
					ValaCodeNode* _tmp25_;
					ValaCodeNode* _tmp26_;
					ValaStatement* _tmp27_;
					ValaStatement* _tmp28_;
					_tmp24_ = initializer;
					_tmp25_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = vala_expression_get_parent_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_EXPRESSION, ValaExpression));
					_tmp28_ = _tmp27_;
					result = _tmp28_;
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (local);
					_vala_code_node_unref0 (stmt);
					_vala_code_node_unref0 (expr);
					return result;
				} else {
					result = NULL;
					_vala_code_node_unref0 (initializer);
					_vala_code_node_unref0 (local);
					_vala_code_node_unref0 (stmt);
					_vala_code_node_unref0 (expr);
					return result;
				}
			}
		}
	}
	_vala_code_node_unref0 (initializer);
	_vala_code_node_unref0 (local);
	_vala_code_node_unref0 (stmt);
	_vala_code_node_unref0 (expr);
}


static void vala_expression_class_init (ValaExpressionClass * klass) {
	vala_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaExpressionPrivate));
	((ValaExpressionClass *) klass)->is_constant = vala_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = vala_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = vala_expression_real_is_non_null;
	((ValaExpressionClass *) klass)->is_accessible = vala_expression_real_is_accessible;
}


static void vala_expression_instance_init (ValaExpression * self) {
	self->priv = VALA_EXPRESSION_GET_PRIVATE (self);
}


static void vala_expression_finalize (ValaCodeNode * obj) {
	ValaExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_EXPRESSION, ValaExpression);
	_vala_code_node_unref0 (self->priv->_value_type);
	_vala_code_node_unref0 (self->priv->_formal_value_type);
	_vala_code_node_unref0 (self->priv->_target_type);
	_vala_code_node_unref0 (self->priv->_formal_target_type);
	_vala_target_value_unref0 (self->priv->_target_value);
	VALA_CODE_NODE_CLASS (vala_expression_parent_class)->finalize (obj);
}


/**
 * Base class for all code nodes that might be used as an expression.
 */
GType vala_expression_get_type (void) {
	static volatile gsize vala_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaExpression), 0, (GInstanceInitFunc) vala_expression_instance_init, NULL };
		GType vala_expression_type_id;
		vala_expression_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaExpression", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&vala_expression_type_id__volatile, vala_expression_type_id);
	}
	return vala_expression_type_id__volatile;
}



