/* swf-persona-store.c generated by valac 0.17.5.1-049a7, the Vala compiler
 * generated from swf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>
#include <gio/gio.h>
#include <folks-internal.h>
#include <glib/gi18n-lib.h>


#define SWF_TYPE_PERSONA_STORE (swf_persona_store_get_type ())
#define SWF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStore))
#define SWF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))
#define SWF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA_STORE))
#define SWF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA_STORE))
#define SWF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))

typedef struct _SwfPersonaStore SwfPersonaStore;
typedef struct _SwfPersonaStoreClass SwfPersonaStoreClass;
typedef struct _SwfPersonaStorePrivate SwfPersonaStorePrivate;

#define SWF_TYPE_PERSONA (swf_persona_get_type ())
#define SWF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA, SwfPersona))
#define SWF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA, SwfPersonaClass))
#define SWF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA))
#define SWF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA))
#define SWF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA, SwfPersonaClass))

typedef struct _SwfPersona SwfPersona;
typedef struct _SwfPersonaClass SwfPersonaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _SwfPersonaStoreAddPersonaFromDetailsData SwfPersonaStoreAddPersonaFromDetailsData;
typedef struct _SwfPersonaStoreRemovePersonaData SwfPersonaStoreRemovePersonaData;
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SwfPersonaStoreGetStaticCapabilitiesData SwfPersonaStoreGetStaticCapabilitiesData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
typedef struct _SwfPersonaStoreContactsQueryOpenViewData SwfPersonaStoreContactsQueryOpenViewData;
typedef struct _SwfPersonaStorePrepareData SwfPersonaStorePrepareData;

struct _SwfPersonaStore {
	FolksPersonaStore parent_instance;
	SwfPersonaStorePrivate * priv;
};

struct _SwfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _SwfPersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	SwClientContactView* _contact_view;
	SwClientService* _service;
};

struct _SwfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _SwfPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	FolksPersona* persona;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	SwfPersonaStore * self;
	gboolean received_callback;
	gboolean has_yielded;
	gchar** caps;
	gint caps_length1;
	gint _caps_size_;
	GError* _error_;
	gpointer _async_data_;
};

struct _SwfPersonaStoreGetStaticCapabilitiesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	gchar** result;
	gint result_length1;
	Block1Data* _data1_;
	SwClientService* _tmp0_;
	gboolean _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	SwfPersonaStore * self;
	gboolean received_callback;
	gboolean has_yielded;
	SwClientContactView* contact_view;
	gpointer _async_data_;
};

struct _SwfPersonaStoreContactsQueryOpenViewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	gchar* query;
	GHashTable* parameters;
	SwClientContactView* result;
	Block2Data* _data2_;
	SwClientService* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	gboolean _tmp3_;
	SwClientContactView* _tmp4_;
	SwClientContactView* _tmp5_;
};

struct _SwfPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gchar** caps;
	gint caps_length1;
	gint _caps_size_;
	gint _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gint __tmp8__size_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	GError* e1;
	GError* _tmp15_;
	GError* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gboolean _tmp18_;
	gboolean has_contacts;
	gboolean _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	GHashFunc _tmp23_;
	GEqualFunc _tmp24_;
	GHashTable* _tmp25_;
	GHashTable* _tmp26_;
	SwClientContactView* _tmp27_;
	SwClientContactView* _tmp28_;
	SwClientContactView* contact_view;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	SwClientContactView* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GError* _tmp34_;
	SwClientContactView* _tmp35_;
	SwClientContactView* _tmp36_;
	SwClientContactView* _tmp37_;
	SwClientContactView* _tmp38_;
	SwClientContactView* _tmp39_;
	SwClientContactView* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	GError * _inner_error_;
};


static gpointer swf_persona_store_parent_class = NULL;
static gchar** swf_persona_store__always_writeable_properties;
static gint swf_persona_store__always_writeable_properties_length1;
static gchar** swf_persona_store__always_writeable_properties = NULL;
static gint swf_persona_store__always_writeable_properties_length1 = 0;
static gint _swf_persona_store__always_writeable_properties_size_ = 0;

GType swf_persona_store_get_type (void) G_GNUC_CONST;
GType swf_persona_get_type (void) G_GNUC_CONST;
#define SWF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SWF_TYPE_PERSONA_STORE, SwfPersonaStorePrivate))
enum  {
	SWF_PERSONA_STORE_DUMMY_PROPERTY,
	SWF_PERSONA_STORE_TYPE_ID,
	SWF_PERSONA_STORE_CAN_ADD_PERSONAS,
	SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	SWF_PERSONA_STORE_CAN_GROUP_PERSONAS,
	SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	SWF_PERSONA_STORE_IS_PREPARED,
	SWF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES,
	SWF_PERSONA_STORE_IS_QUIESCENT,
	SWF_PERSONA_STORE_PERSONAS,
	SWF_PERSONA_STORE_SERVICE
};
static void swf_persona_store_contacts_added_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added (SwClientContactView* _sender, GList* contacts, gpointer self);
static void swf_persona_store_contacts_changed_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed (SwClientContactView* _sender, GList* contacts, gpointer self);
static void swf_persona_store_contacts_removed_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed (SwClientContactView* _sender, GList* contacts, gpointer self);
SwfPersonaStore* swf_persona_store_new (SwClientService* service);
SwfPersonaStore* swf_persona_store_construct (GType object_type, SwClientService* service);
static void swf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void swf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_add_persona_from_details_co (SwfPersonaStoreAddPersonaFromDetailsData* _data_);
static void swf_persona_store_real_remove_persona_data_free (gpointer _data);
static void swf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_remove_persona_co (SwfPersonaStoreRemovePersonaData* _data_);
static void _swf_persona_store_get_static_capabilities_data_free (gpointer _data);
static void _swf_persona_store_get_static_capabilities (SwfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** _swf_persona_store_get_static_capabilities_finish (SwfPersonaStore* self, GAsyncResult* _res_, int* result_length1, GError** error);
static gboolean _swf_persona_store_get_static_capabilities_co (SwfPersonaStoreGetStaticCapabilitiesData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
SwClientService* swf_persona_store_get_service (SwfPersonaStore* self);
static void __lambda2_ (Block1Data* _data1_, SwClientService* service, gchar** _caps, int _caps_length1, GError* _error);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void ___lambda2__sw_client_service_get_capabilities_callback (SwClientService* service, gchar** caps, GError* _error_, gpointer self);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void _swf_persona_store_contacts_query_open_view_data_free (gpointer _data);
static void _swf_persona_store_contacts_query_open_view (SwfPersonaStore* self, const gchar* query, GHashTable* parameters, GAsyncReadyCallback _callback_, gpointer _user_data_);
static SwClientContactView* _swf_persona_store_contacts_query_open_view_finish (SwfPersonaStore* self, GAsyncResult* _res_);
static gboolean _swf_persona_store_contacts_query_open_view_co (SwfPersonaStoreContactsQueryOpenViewData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda3_ (Block2Data* _data2_, SwClientService* service, SwClientContactView* _contact_view);
static void ___lambda3__sw_client_service_contacts_query_open_view_callback (SwClientService* query, SwClientContactView* contact_view, gpointer self);
static void swf_persona_store_real_prepare_data_free (gpointer _data);
static void swf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_prepare_co (SwfPersonaStorePrepareData* _data_);
static void swf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact);
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact);
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id);
gchar* swf_persona_get_contact_id (SwContact* contact);
void swf_persona_update (SwfPersona* self, SwContact* contact);
static void swf_persona_store_set_service (SwfPersonaStore* self, SwClientService* value);
static GObject * swf_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void swf_persona_store_finalize (GObject* obj);
static void _vala_swf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_swf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added (SwClientContactView* _sender, GList* contacts, gpointer self) {
	swf_persona_store_contacts_added_cb (self, contacts);
}


static void _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed (SwClientContactView* _sender, GList* contacts, gpointer self) {
	swf_persona_store_contacts_changed_cb (self, contacts);
}


static void _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed (SwClientContactView* _sender, GList* contacts, gpointer self) {
	swf_persona_store_contacts_removed_cb (self, contacts);
}


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to store the {@link Persona}s for the contacts
   * provided by the ``service``.
   *
   * @param service the libsocialweb service being represented by the new
   * persona store
   */
SwfPersonaStore* swf_persona_store_construct (GType object_type, SwClientService* service) {
	SwfPersonaStore * self = NULL;
	SwClientService* _tmp0_;
	const gchar* _tmp1_ = NULL;
	SwClientService* _tmp2_;
	const gchar* _tmp3_ = NULL;
	SwClientService* _tmp4_;
	g_return_val_if_fail (service != NULL, NULL);
	_tmp0_ = service;
	_tmp1_ = sw_client_service_get_display_name (_tmp0_);
	_tmp2_ = service;
	_tmp3_ = sw_client_service_get_name (_tmp2_);
	_tmp4_ = service;
	self = (SwfPersonaStore*) g_object_new (object_type, "display-name", _tmp1_, "id", _tmp3_, "service", _tmp4_, NULL);
	return self;
}


SwfPersonaStore* swf_persona_store_new (SwClientService* service) {
	return swf_persona_store_construct (SWF_TYPE_PERSONA_STORE, service);
}


static void swf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	SwfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SwfPersonaStoreAddPersonaFromDetailsData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void swf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStoreAddPersonaFromDetailsData* _data_;
	SwfPersonaStore* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	self = (SwfPersonaStore*) base;
	_data_ = g_slice_new0 (SwfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	_data_->details = _tmp2_;
	swf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* swf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	SwfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * @throws Folks.PersonaStoreError.READ_ONLY every time — libsocialweb is
   * read-only
   */
static gboolean swf_persona_store_real_add_persona_from_details_co (SwfPersonaStoreAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be added to this store.");
	_data_->_inner_error_ = _data_->_tmp0_;
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void swf_persona_store_real_remove_persona_data_free (gpointer _data) {
	SwfPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (SwfPersonaStoreRemovePersonaData, _data_);
}


static void swf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStoreRemovePersonaData* _data_;
	SwfPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	self = (SwfPersonaStore*) base;
	_data_ = g_slice_new0 (SwfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	swf_persona_store_real_remove_persona_co (_data_);
}


static void swf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	SwfPersonaStoreRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   *
   * @throws Folks.PersonaStoreError.READ_ONLY every time — libsocialweb is
   * read-only
   */
static gboolean swf_persona_store_real_remove_persona_co (SwfPersonaStoreRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be removed from this store.");
	_data_->_inner_error_ = _data_->_tmp0_;
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _swf_persona_store_get_static_capabilities_data_free (gpointer _data) {
	SwfPersonaStoreGetStaticCapabilitiesData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (SwfPersonaStoreGetStaticCapabilitiesData, _data_);
}


static void _swf_persona_store_get_static_capabilities (SwfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStoreGetStaticCapabilitiesData* _data_;
	SwfPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (SwfPersonaStoreGetStaticCapabilitiesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _swf_persona_store_get_static_capabilities);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _swf_persona_store_get_static_capabilities_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_swf_persona_store_get_static_capabilities_co (_data_);
}


static gchar** _swf_persona_store_get_static_capabilities_finish (SwfPersonaStore* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	gchar** result;
	SwfPersonaStoreGetStaticCapabilitiesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SwfPersonaStore * self;
		self = _data1_->self;
		_g_error_free0 (_data1_->_error_);
		_data1_->caps = (_vala_array_free (_data1_->caps, _data1_->caps_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void __lambda2_ (Block1Data* _data1_, SwClientService* service, gchar** _caps, int _caps_length1, GError* _error) {
	SwfPersonaStore * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GError* _tmp2_;
	GError* _tmp3_;
	gboolean _tmp4_;
	self = _data1_->self;
	g_return_if_fail (service != NULL);
	_data1_->received_callback = TRUE;
	_tmp0_ = _caps;
	_tmp0__length1 = _caps_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_data1_->caps = (_vala_array_free (_data1_->caps, _data1_->caps_length1, (GDestroyNotify) g_free), NULL);
	_data1_->caps = _tmp1_;
	_data1_->caps_length1 = _tmp1__length1;
	_data1_->_caps_size_ = _data1_->caps_length1;
	_tmp2_ = _error;
	_tmp3_ = _g_error_copy0 (_tmp2_);
	_g_error_free0 (_data1_->_error_);
	_data1_->_error_ = _tmp3_;
	_tmp4_ = _data1_->has_yielded;
	if (_tmp4_ == TRUE) {
		_swf_persona_store_get_static_capabilities_co (_data1_->_async_data_);
	}
}


static void ___lambda2__sw_client_service_get_capabilities_callback (SwClientService* service, gchar** caps, GError* _error_, gpointer self) {
	__lambda2_ (self, service, caps, _vala_array_length (caps), _error_);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean _swf_persona_store_get_static_capabilities_co (SwfPersonaStoreGetStaticCapabilitiesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	g_object_ref ((GObject*) _data_->self);
	_data_->_data1_->received_callback = FALSE;
	_data_->_data1_->has_yielded = FALSE;
	_data_->_data1_->caps = NULL;
	_data_->_data1_->caps_length1 = 0;
	_data_->_data1_->_caps_size_ = _data_->_data1_->caps_length1;
	_data_->_data1_->_error_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_service;
	sw_client_service_get_static_capabilities (_data_->_tmp0_, ___lambda2__sw_client_service_get_capabilities_callback, _data_->_data1_);
	_data_->_tmp1_ = _data_->_data1_->received_callback;
	if (_data_->_tmp1_ == FALSE) {
		_data_->_data1_->has_yielded = TRUE;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	g_object_unref ((GObject*) _data_->self);
	_data_->_tmp2_ = _data_->_data1_->_error_;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->_data1_->_error_;
		_data_->_tmp4_ = _g_error_copy0 (_data_->_tmp3_);
		_data_->_inner_error_ = _data_->_tmp4_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_data1_->caps;
	_data_->_tmp5__length1 = _data_->_data1_->caps_length1;
	_data_->_tmp6_ = (_data_->_tmp5_ != NULL) ? _vala_array_dup2 (_data_->_tmp5_, _data_->_tmp5__length1) : ((gpointer) _data_->_tmp5_);
	_data_->_tmp6__length1 = _data_->_tmp5__length1;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp7__length1 = _data_->_tmp6__length1;
	_data_->result_length1 = _data_->_tmp7__length1;
	_data_->result = _data_->_tmp7_;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _swf_persona_store_contacts_query_open_view_data_free (gpointer _data) {
	SwfPersonaStoreContactsQueryOpenViewData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query);
	_g_hash_table_unref0 (_data_->parameters);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SwfPersonaStoreContactsQueryOpenViewData, _data_);
}


static void _swf_persona_store_contacts_query_open_view (SwfPersonaStore* self, const gchar* query, GHashTable* parameters, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStoreContactsQueryOpenViewData* _data_;
	SwfPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	_data_ = g_slice_new0 (SwfPersonaStoreContactsQueryOpenViewData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _swf_persona_store_contacts_query_open_view);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _swf_persona_store_contacts_query_open_view_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = query;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->query = _tmp2_;
	_tmp3_ = parameters;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->parameters = _tmp4_;
	_swf_persona_store_contacts_query_open_view_co (_data_);
}


static SwClientContactView* _swf_persona_store_contacts_query_open_view_finish (SwfPersonaStore* self, GAsyncResult* _res_) {
	SwClientContactView* result;
	SwfPersonaStoreContactsQueryOpenViewData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SwfPersonaStore * self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->contact_view);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda3_ (Block2Data* _data2_, SwClientService* service, SwClientContactView* _contact_view) {
	SwfPersonaStore * self;
	SwClientContactView* _tmp0_;
	SwClientContactView* _tmp1_;
	gboolean _tmp2_;
	self = _data2_->self;
	g_return_if_fail (service != NULL);
	_data2_->received_callback = TRUE;
	_tmp0_ = _contact_view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data2_->contact_view);
	_data2_->contact_view = _tmp1_;
	_tmp2_ = _data2_->has_yielded;
	if (_tmp2_ == TRUE) {
		_swf_persona_store_contacts_query_open_view_co (_data2_->_async_data_);
	}
}


static void ___lambda3__sw_client_service_contacts_query_open_view_callback (SwClientService* query, SwClientContactView* contact_view, gpointer self) {
	__lambda3_ (self, query, contact_view);
}


static gboolean _swf_persona_store_contacts_query_open_view_co (SwfPersonaStoreContactsQueryOpenViewData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	g_object_ref ((GObject*) _data_->self);
	_data_->_data2_->received_callback = FALSE;
	_data_->_data2_->has_yielded = FALSE;
	_data_->_data2_->contact_view = NULL;
	_data_->_tmp0_ = _data_->self->priv->_service;
	_data_->_tmp1_ = _data_->query;
	_data_->_tmp2_ = _data_->parameters;
	sw_client_service_contacts_query_open_view (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, ___lambda3__sw_client_service_contacts_query_open_view_callback, _data_->_data2_);
	_data_->_tmp3_ = _data_->_data2_->received_callback;
	if (_data_->_tmp3_ == FALSE) {
		_data_->_data2_->has_yielded = TRUE;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	g_object_unref ((GObject*) _data_->self);
	_data_->_tmp4_ = _data_->_data2_->contact_view;
	_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
	_data_->result = _data_->_tmp5_;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void swf_persona_store_real_prepare_data_free (gpointer _data) {
	SwfPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SwfPersonaStorePrepareData, _data_);
}


static void swf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStorePrepareData* _data_;
	SwfPersonaStore* _tmp0_;
	self = (SwfPersonaStore*) base;
	_data_ = g_slice_new0 (SwfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	swf_persona_store_real_prepare_co (_data_);
}


static void swf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	SwfPersonaStorePrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the PersonaStore for use.
   *
   * See {@link Folks.PersonaStore.prepare}.
   *
   * @throws Folks.PersonaStoreError.INVALID_ARGUMENT if the libsocialweb
   * service capabilities couldn’t be retrieved, or if the ‘contacts’ capability
   * wasn’t found, or if a view couldn’t be opened
   */
static void swf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SwfPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	swf_persona_store_real_prepare_co (_data_);
}


static gboolean swf_persona_store_real_prepare_co (SwfPersonaStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	folks_internal_profiling_start ("preparing Swf.PersonaStore (ID: %s)", _data_->_tmp1_, NULL);
	_data_->_tmp3_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp3_) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp2_ = _data_->_tmp4_;
	}
	_data_->_tmp5_ = _data_->_tmp2_;
	if (_data_->_tmp5_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->caps = NULL;
		_data_->caps_length1 = 0;
		_data_->_caps_size_ = _data_->caps_length1;
		{
			_data_->_tmp6_ = 0;
			_data_->_state_ = 1;
			_swf_persona_store_get_static_capabilities (_data_->self, swf_persona_store_prepare_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = _swf_persona_store_get_static_capabilities_finish (_data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp8__length1 = _data_->_tmp6_;
			_data_->__tmp8__size_ = _data_->_tmp8__length1;
			if (_data_->_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_data_->caps = (_vala_array_free (_data_->caps, _data_->caps_length1, (GDestroyNotify) g_free), NULL);
			_data_->caps = _data_->_tmp8_;
			_data_->caps_length1 = _data_->_tmp8__length1;
			_data_->_caps_size_ = _data_->caps_length1;
			_data_->_tmp9_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
			_data_->_tmp10_ = _data_->_tmp9_;
			folks_internal_profiling_point ("got capabilities in " "Swf.PersonaStore (ID: %s)", _data_->_tmp10_, NULL);
			_data_->_tmp11_ = _data_->caps;
			_data_->_tmp11__length1 = _data_->caps_length1;
			if (_data_->_tmp11_ == NULL) {
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = _ ("Couldn’t prepare libsocialweb service: %s");
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = _ ("No capabilities were found.");
				_data_->_tmp14_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, _data_->_tmp12_, _data_->_tmp13_);
				_data_->_inner_error_ = _data_->_tmp14_;
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			g_signal_emit_by_name ((FolksPersonaStore*) _data_->self, "removed");
			_data_->_tmp15_ = _data_->e1;
			_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
			_data_->_inner_error_ = _data_->_tmp16_;
			_g_error_free0 (_data_->e1);
			goto __finally3;
		}
		__finally3:
		if (_data_->_inner_error_ != NULL) {
			_data_->caps = (_vala_array_free (_data_->caps, _data_->caps_length1, (GDestroyNotify) g_free), NULL);
			goto __finally2;
		}
		_data_->_tmp17_ = _data_->caps;
		_data_->_tmp17__length1 = _data_->caps_length1;
		_data_->_tmp18_ = FALSE;
		_data_->_tmp18_ = sw_client_service_has_cap (_data_->_tmp17_, "has-contacts-query-iface");
		_data_->has_contacts = _data_->_tmp18_;
		_data_->_tmp19_ = _data_->has_contacts;
		if (!_data_->_tmp19_) {
			g_signal_emit_by_name ((FolksPersonaStore*) _data_->self, "removed");
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _ ("Couldn’t prepare libsocialweb service: %s");
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _ ("No contacts capability was found.");
			_data_->_tmp22_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, _data_->_tmp20_, _data_->_tmp21_);
			_data_->_inner_error_ = _data_->_tmp22_;
			_data_->caps = (_vala_array_free (_data_->caps, _data_->caps_length1, (GDestroyNotify) g_free), NULL);
			goto __finally2;
		}
		_data_->_tmp23_ = g_str_hash;
		_data_->_tmp24_ = g_str_equal;
		_data_->_tmp25_ = g_hash_table_new_full (_data_->_tmp23_, _data_->_tmp24_, NULL, NULL);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_state_ = 2;
		_swf_persona_store_contacts_query_open_view (_data_->self, "people", _data_->_tmp26_, swf_persona_store_prepare_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _swf_persona_store_contacts_query_open_view_finish (_data_->self, _data_->_res_);
		_data_->_tmp28_ = _data_->_tmp27_;
		_g_hash_table_unref0 (_data_->_tmp26_);
		_data_->contact_view = _data_->_tmp28_;
		_data_->_tmp29_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp30_ = _data_->_tmp29_;
		folks_internal_profiling_point ("opened view in Swf.PersonaStore " "(ID: %s)", _data_->_tmp30_, NULL);
		_data_->_tmp31_ = _data_->contact_view;
		if (_data_->_tmp31_ == NULL) {
			g_signal_emit_by_name ((FolksPersonaStore*) _data_->self, "removed");
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = _ ("Couldn’t prepare libsocialweb service: %s");
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = _ ("Error opening contacts view.");
			_data_->_tmp34_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, _data_->_tmp32_, _data_->_tmp33_);
			_data_->_inner_error_ = _data_->_tmp34_;
			_g_object_unref0 (_data_->contact_view);
			_data_->caps = (_vala_array_free (_data_->caps, _data_->caps_length1, (GDestroyNotify) g_free), NULL);
			goto __finally2;
		}
		_data_->_tmp35_ = _data_->contact_view;
		g_signal_connect_object (_data_->_tmp35_, "contacts-added", (GCallback) _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added, _data_->self, 0);
		_data_->_tmp36_ = _data_->contact_view;
		g_signal_connect_object (_data_->_tmp36_, "contacts-changed", (GCallback) _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed, _data_->self, 0);
		_data_->_tmp37_ = _data_->contact_view;
		g_signal_connect_object (_data_->_tmp37_, "contacts-removed", (GCallback) _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed, _data_->self, 0);
		_data_->_tmp38_ = _data_->contact_view;
		_data_->_tmp39_ = _g_object_ref0 (_data_->_tmp38_);
		_g_object_unref0 (_data_->self->priv->_contact_view);
		_data_->self->priv->_contact_view = _data_->_tmp39_;
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->_tmp40_ = _data_->self->priv->_contact_view;
		sw_client_contact_view_start (_data_->_tmp40_);
		_g_object_unref0 (_data_->contact_view);
		_data_->caps = (_vala_array_free (_data_->caps, _data_->caps_length1, (GDestroyNotify) g_free), NULL);
	}
	__finally2:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp41_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp42_ = _data_->_tmp41_;
	folks_internal_profiling_end ("preparing Swf.PersonaStore (ID: %s)", _data_->_tmp42_, NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void swf_persona_store_contacts_added_cb (SwfPersonaStore* self, GList* contacts) {
	GeeHashSet* _tmp0_;
	GeeHashSet* added_personas;
	GList* _tmp1_;
	GeeHashSet* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (SWF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	added_personas = _tmp0_;
	_tmp1_ = contacts;
	{
		GList* contact_collection = NULL;
		GList* contact_it = NULL;
		contact_collection = _tmp1_;
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
			SwContact* contact = NULL;
			contact = (SwContact*) contact_it->data;
			{
				SwContact* _tmp2_;
				SwfPersona* _tmp3_;
				SwfPersona* persona;
				GeeHashMap* _tmp4_;
				SwfPersona* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				SwfPersona* _tmp8_;
				GeeHashSet* _tmp9_;
				SwfPersona* _tmp10_;
				_tmp2_ = contact;
				_tmp3_ = swf_persona_new (self, _tmp2_);
				persona = _tmp3_;
				_tmp4_ = self->priv->_personas;
				_tmp5_ = persona;
				_tmp6_ = folks_persona_get_iid ((FolksPersona*) _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = persona;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, _tmp7_, _tmp8_);
				_tmp9_ = added_personas;
				_tmp10_ = persona;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
				_g_object_unref0 (persona);
			}
		}
	}
	_tmp11_ = added_personas;
	_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ > 0) {
		GeeHashSet* _tmp14_;
		_tmp14_ = added_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp14_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_tmp15_ = self->priv->_is_quiescent;
	if (_tmp15_ == FALSE) {
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
	}
	_g_object_unref0 (added_personas);
}


static void swf_persona_store_contacts_changed_cb (SwfPersonaStore* self, GList* contacts) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = contacts;
	{
		GList* contact_collection = NULL;
		GList* contact_it = NULL;
		contact_collection = _tmp0_;
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
			SwContact* contact = NULL;
			contact = (SwContact*) contact_it->data;
			{
				SwClientService* _tmp1_;
				const gchar* _tmp2_ = NULL;
				SwContact* _tmp3_;
				const gchar* _tmp4_;
				SwContact* _tmp5_;
				const gchar* _tmp6_;
				SwContact* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* iid;
				GeeHashMap* _tmp12_;
				const gchar* _tmp13_;
				gpointer _tmp14_ = NULL;
				SwfPersona* persona;
				SwfPersona* _tmp15_;
				_tmp1_ = self->priv->_service;
				_tmp2_ = sw_client_service_get_name (_tmp1_);
				_tmp3_ = contact;
				_tmp4_ = _tmp3_->service;
				if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
					continue;
				}
				_tmp5_ = contact;
				_tmp6_ = _tmp5_->service;
				_tmp7_ = contact;
				_tmp8_ = swf_persona_get_contact_id (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _swf_persona_build_iid (_tmp6_, _tmp9_);
				_tmp11_ = _tmp10_;
				_g_free0 (_tmp9_);
				iid = _tmp11_;
				_tmp12_ = self->priv->_personas;
				_tmp13_ = iid;
				_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
				persona = (SwfPersona*) _tmp14_;
				_tmp15_ = persona;
				if (_tmp15_ != NULL) {
					SwfPersona* _tmp16_;
					SwContact* _tmp17_;
					_tmp16_ = persona;
					_tmp17_ = contact;
					swf_persona_update (_tmp16_, _tmp17_);
				}
				_g_object_unref0 (persona);
				_g_free0 (iid);
			}
		}
	}
}


static void swf_persona_store_contacts_removed_cb (SwfPersonaStore* self, GList* contacts) {
	GeeHashSet* _tmp0_;
	GeeHashSet* removed_personas;
	GList* _tmp1_;
	GeeHashSet* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (SWF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	removed_personas = _tmp0_;
	_tmp1_ = contacts;
	{
		GList* contact_collection = NULL;
		GList* contact_it = NULL;
		contact_collection = _tmp1_;
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
			SwContact* contact = NULL;
			contact = (SwContact*) contact_it->data;
			{
				SwClientService* _tmp2_;
				const gchar* _tmp3_ = NULL;
				SwContact* _tmp4_;
				const gchar* _tmp5_;
				SwContact* _tmp6_;
				const gchar* _tmp7_;
				SwContact* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* iid;
				GeeHashMap* _tmp13_;
				const gchar* _tmp14_;
				gpointer _tmp15_ = NULL;
				SwfPersona* persona;
				SwfPersona* _tmp16_;
				_tmp2_ = self->priv->_service;
				_tmp3_ = sw_client_service_get_name (_tmp2_);
				_tmp4_ = contact;
				_tmp5_ = _tmp4_->service;
				if (g_strcmp0 (_tmp3_, _tmp5_) != 0) {
					continue;
				}
				_tmp6_ = contact;
				_tmp7_ = _tmp6_->service;
				_tmp8_ = contact;
				_tmp9_ = swf_persona_get_contact_id (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _swf_persona_build_iid (_tmp7_, _tmp10_);
				_tmp12_ = _tmp11_;
				_g_free0 (_tmp10_);
				iid = _tmp12_;
				_tmp13_ = self->priv->_personas;
				_tmp14_ = iid;
				_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp14_);
				persona = (SwfPersona*) _tmp15_;
				_tmp16_ = persona;
				if (_tmp16_ != NULL) {
					GeeHashSet* _tmp17_;
					SwfPersona* _tmp18_;
					GeeHashMap* _tmp19_;
					SwfPersona* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					_tmp17_ = removed_personas;
					_tmp18_ = persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
					_tmp19_ = self->priv->_personas;
					_tmp20_ = persona;
					_tmp21_ = folks_persona_get_iid ((FolksPersona*) _tmp20_);
					_tmp22_ = _tmp21_;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp19_, _tmp22_, NULL);
				}
				_g_object_unref0 (persona);
				_g_free0 (iid);
			}
		}
	}
	_tmp23_ = removed_personas;
	_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ > 0) {
		GeeHashSet* _tmp26_;
		_tmp26_ = removed_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp26_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_g_object_unref0 (removed_personas);
}


static const gchar* swf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static gboolean swf_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	SwfPersonaStore* self;
	gboolean _tmp0_;
	self = (SwfPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gchar** swf_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base, int* result_length1) {
	gchar** result;
	SwfPersonaStore* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (SwfPersonaStore*) base;
	_tmp0_ = swf_persona_store__always_writeable_properties;
	_tmp0__length1 = swf_persona_store__always_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gboolean swf_persona_store_real_get_is_quiescent (FolksPersonaStore* base) {
	gboolean result;
	SwfPersonaStore* self;
	gboolean _tmp0_;
	self = (SwfPersonaStore*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static GeeMap* swf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	SwfPersonaStore* self;
	GeeMap* _tmp0_;
	self = (SwfPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}


SwClientService* swf_persona_store_get_service (SwfPersonaStore* self) {
	SwClientService* result;
	SwClientService* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_service;
	result = _tmp0_;
	return result;
}


static void swf_persona_store_set_service (SwfPersonaStore* self, SwClientService* value) {
	SwClientService* _tmp0_;
	SwClientService* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_service);
	self->priv->_service = _tmp1_;
	g_object_notify ((GObject *) self, "service");
}


static GObject * swf_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SwfPersonaStore * self;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	parent_class = G_OBJECT_CLASS (swf_persona_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWF_TYPE_PERSONA_STORE, SwfPersonaStore);
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_PARTIAL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, SWF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp0_;
	_tmp1_ = self->priv->_personas;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp3_;
	return obj;
}


static void swf_persona_store_class_init (SwfPersonaStoreClass * klass) {
	gchar** _tmp0_ = NULL;
	swf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SwfPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = swf_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = swf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = swf_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = swf_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = swf_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = swf_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = swf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = swf_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = swf_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = swf_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = swf_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = swf_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = swf_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = swf_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = swf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_swf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_swf_persona_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = swf_persona_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = swf_persona_store_finalize;
	/**
	   * The type of persona store this is.
	   *
	   * See {@link Folks.PersonaStore.type_id}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_ADD_PERSONAS, g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS, g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_GROUP_PERSONAS, g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS, g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * See {@link Folks.PersonaStore.personas}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_PERSONAS, g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The libsocialweb {@link SocialWebClient.ClientService} associated with the
	   * persona store.
	   *
	   * @since 0.6.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_SERVICE, g_param_spec_object ("service", "service", "service", sw_client_service_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	swf_persona_store__always_writeable_properties = _tmp0_;
	swf_persona_store__always_writeable_properties_length1 = 0;
}


static void swf_persona_store_instance_init (SwfPersonaStore * self) {
	self->priv = SWF_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
}


static void swf_persona_store_finalize (GObject* obj) {
	SwfPersonaStore * self;
	SwClientContactView* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWF_TYPE_PERSONA_STORE, SwfPersonaStore);
	_tmp0_ = self->priv->_contact_view;
	if (_tmp0_ != NULL) {
		SwClientContactView* _tmp1_;
		guint _tmp2_ = 0U;
		SwClientContactView* _tmp3_;
		guint _tmp4_ = 0U;
		SwClientContactView* _tmp5_;
		guint _tmp6_ = 0U;
		_tmp1_ = self->priv->_contact_view;
		g_signal_parse_name ("contacts-added", sw_client_contact_view_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added, self);
		_tmp3_ = self->priv->_contact_view;
		g_signal_parse_name ("contacts-changed", sw_client_contact_view_get_type (), &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed, self);
		_tmp5_ = self->priv->_contact_view;
		g_signal_parse_name ("contacts-removed", sw_client_contact_view_get_type (), &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed, self);
	}
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_object_unref0 (self->priv->_contact_view);
	_g_object_unref0 (self->priv->_service);
	G_OBJECT_CLASS (swf_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single libsocialweb service.
 *
 * It will create {@link Persona}s for each of the contacts known to that
 * service.
 */
GType swf_persona_store_get_type (void) {
	static volatile gsize swf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&swf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) swf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwfPersonaStore), 0, (GInstanceInitFunc) swf_persona_store_instance_init, NULL };
		GType swf_persona_store_type_id;
		swf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "SwfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&swf_persona_store_type_id__volatile, swf_persona_store_type_id);
	}
	return swf_persona_store_type_id__volatile;
}


static void _vala_swf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SwfPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWF_TYPE_PERSONA_STORE, SwfPersonaStore);
	switch (property_id) {
		case SWF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case SWF_PERSONA_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_SERVICE:
		g_value_set_object (value, swf_persona_store_get_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_swf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SwfPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWF_TYPE_PERSONA_STORE, SwfPersonaStore);
	switch (property_id) {
		case SWF_PERSONA_STORE_SERVICE:
		swf_persona_store_set_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



