/* test-serializer.c generated by valac 0.18.1, the Vala compiler
 * generated from test-serializer.vala, do not modify */

/*
 * Copyright (C) 2012 Arth Patel
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>


#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;


extern gint fail_count;
gint fail_count = 0;
extern gint pass_count;
gint pass_count = 0;

#define thousand_separator ","
#define radix_string "."
void pass (const gchar* text);
void fail (const gchar* text);
GType serializer_get_type (void) G_GNUC_CONST;
void test_number (Serializer* s, const gchar* number, gint base_value, const gchar* expected_string);
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
Number* mp_set_from_string (const gchar* str, gint default_base);
void serializer_set_base (Serializer* self, gint number_base);
gchar* serializer_to_string (Serializer* self, Number* x);
void test_fixed (Serializer* s);
GType display_format_get_type (void) G_GNUC_CONST;
void serializer_set_number_format (Serializer* self, DisplayFormat format);
void test_automatic (Serializer* s);
void test_scientific (Serializer* s);
void test_engineering (Serializer* s);
gint _vala_main (gchar** args, int args_length1);
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
void serializer_set_thousands_separator (Serializer* self, gunichar separator);
void serializer_set_radix (Serializer* self, gunichar radix);
void serializer_set_show_thousands_separators (Serializer* self, gboolean visible);
void serializer_set_thousands_separator_count (Serializer* self, gint count);


void pass (const gchar* text) {
	gint _tmp0_;
	_tmp0_ = pass_count;
	pass_count = _tmp0_ + 1;
}


void fail (const gchar* text) {
	FILE* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	g_return_if_fail (text != NULL);
	_tmp0_ = stdout;
	_tmp1_ = text;
	fprintf (_tmp0_, "*FAIL: %s\n", _tmp1_);
	_tmp2_ = fail_count;
	fail_count = _tmp2_ + 1;
}


void test_number (Serializer* s, const gchar* number, gint base_value, const gchar* expected_string) {
	const gchar* _tmp0_;
	gint _tmp1_;
	Number* _tmp2_ = NULL;
	Number* n;
	Serializer* _tmp3_;
	gint _tmp4_;
	Serializer* _tmp5_;
	Number* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (number != NULL);
	g_return_if_fail (expected_string != NULL);
	_tmp0_ = number;
	_tmp1_ = base_value;
	_tmp2_ = mp_set_from_string (_tmp0_, _tmp1_);
	n = _tmp2_;
	_tmp3_ = s;
	_tmp4_ = base_value;
	serializer_set_base (_tmp3_, _tmp4_);
	_tmp5_ = s;
	_tmp6_ = n;
	_tmp7_ = serializer_to_string (_tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = expected_string;
	_tmp10_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
	_g_free0 (_tmp8_);
	if (_tmp10_) {
		pass (NULL);
	} else {
		Serializer* _tmp11_;
		Number* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp11_ = s;
		_tmp12_ = n;
		_tmp13_ = serializer_to_string (_tmp11_, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = expected_string;
		_tmp16_ = g_strdup_printf ("Serializer returned (%s) => expected value (%s)", _tmp14_, _tmp15_);
		_tmp17_ = _tmp16_;
		fail (_tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
	}
	_number_unref0 (n);
}


void test_fixed (Serializer* s) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	Serializer* _tmp6_;
	Serializer* _tmp7_;
	Serializer* _tmp8_;
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_FIXED);
	_tmp1_ = s;
	test_number (_tmp1_, "123456789012345678901234", 10, "123,456,789,012,345,678,901,234");
	_tmp2_ = s;
	test_number (_tmp2_, "0.1234567890123456789012", 10, "0.123456789");
	_tmp3_ = s;
	test_number (_tmp3_, "101010101010101010101010", 2, "101010101010101010101010");
	_tmp4_ = s;
	test_number (_tmp4_, "0.1010101010101010101010", 2, "0.101010101");
	_tmp5_ = s;
	test_number (_tmp5_, "123456701234567012345670", 8, "123456701234567012345670");
	_tmp6_ = s;
	test_number (_tmp6_, "0.1234567012345670123456", 8, "0.123456701");
	_tmp7_ = s;
	test_number (_tmp7_, "123456789ABCDEF012345678", 16, "123456789ABCDEF012345678");
	_tmp8_ = s;
	test_number (_tmp8_, "0.ABCDEF0123456789ABCDEF", 16, "0.ABCDEF012");
}


void test_automatic (Serializer* s) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	Serializer* _tmp6_;
	Serializer* _tmp7_;
	Serializer* _tmp8_;
	Serializer* _tmp9_;
	Serializer* _tmp10_;
	Serializer* _tmp11_;
	Serializer* _tmp12_;
	Serializer* _tmp13_;
	Serializer* _tmp14_;
	Serializer* _tmp15_;
	Serializer* _tmp16_;
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_AUTOMATIC);
	_tmp1_ = s;
	test_number (_tmp1_, "0.10", 10, "0.1");
	_tmp2_ = s;
	test_number (_tmp2_, "0.12345678901234567890", 10, "0.123456789");
	_tmp3_ = s;
	test_number (_tmp3_, "123456789012", 10, "123,456,789,012");
	_tmp4_ = s;
	test_number (_tmp4_, "12345678901234567890", 10, "1.23456789×10¹⁹");
	_tmp5_ = s;
	test_number (_tmp5_, ".10", 2, "0.1");
	_tmp6_ = s;
	test_number (_tmp6_, "0.10101010101010101010", 2, "0.101010101");
	_tmp7_ = s;
	test_number (_tmp7_, "1010101010101010101010101010101010101010101010101010101010101010", 2, "1010101010101010101010101010101010101010101010101010101010101010");
	_tmp8_ = s;
	test_number (_tmp8_, "10101010101010101010101010101010101010101010101010101010101010101", 2, "1.010101011×10⁶⁴");
	_tmp9_ = s;
	test_number (_tmp9_, "0.10", 8, "0.1");
	_tmp10_ = s;
	test_number (_tmp10_, "0.12345670123456701234", 8, "0.123456701");
	_tmp11_ = s;
	test_number (_tmp11_, "1234567012345670123456", 8, "1234567012345670123456");
	_tmp12_ = s;
	test_number (_tmp12_, "12345670123456701234567", 8, "1.234567012×10²²");
	_tmp13_ = s;
	test_number (_tmp13_, "0.10", 16, "0.1");
	_tmp14_ = s;
	test_number (_tmp14_, "0.123456789ABCDEF01234", 16, "0.12345678A");
	_tmp15_ = s;
	test_number (_tmp15_, "123456789ABCDEF0", 16, "123456789ABCDEF0");
	_tmp16_ = s;
	test_number (_tmp16_, "123456789ABCEDF01", 16, "1.23456789B×10¹⁶");
}


void test_scientific (Serializer* s) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_SCIENTIFIC);
	_tmp1_ = s;
	test_number (_tmp1_, "1", 10, "1");
	_tmp2_ = s;
	test_number (_tmp2_, "10", 10, "1×10¹");
	_tmp3_ = s;
	test_number (_tmp3_, "1234567890", 10, "1.23456789×10⁹");
	_tmp4_ = s;
	test_number (_tmp4_, "0.1", 10, "1×10⁻¹");
	_tmp5_ = s;
	test_number (_tmp5_, "0.1234567890", 10, "1.23456789×10⁻¹");
}


void test_engineering (Serializer* s) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_ENGINEERING);
	_tmp1_ = s;
	test_number (_tmp1_, "1", 10, "1");
	_tmp2_ = s;
	test_number (_tmp2_, "10", 10, "10");
	_tmp3_ = s;
	test_number (_tmp3_, "1234567890", 10, "1.23456789×10⁹");
	_tmp4_ = s;
	test_number (_tmp4_, "0.1", 10, "100×10⁻³");
	_tmp5_ = s;
	test_number (_tmp5_, "0.1234567890", 10, "123.456789×10⁻³");
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	Serializer* _tmp0_;
	Serializer* serializer;
	Serializer* _tmp1_;
	gunichar _tmp2_ = 0U;
	Serializer* _tmp3_;
	gunichar _tmp4_ = 0U;
	Serializer* _tmp5_;
	Serializer* _tmp6_;
	Serializer* _tmp7_;
	Serializer* _tmp8_;
	Serializer* _tmp9_;
	Serializer* _tmp10_;
	gint _tmp11_;
	gint _tmp18_;
	setlocale (LC_ALL, "C");
	_tmp0_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
	serializer = _tmp0_;
	_tmp1_ = serializer;
	_tmp2_ = string_get_char (thousand_separator, (glong) 0);
	serializer_set_thousands_separator (_tmp1_, _tmp2_);
	_tmp3_ = serializer;
	_tmp4_ = string_get_char (radix_string, (glong) 0);
	serializer_set_radix (_tmp3_, _tmp4_);
	_tmp5_ = serializer;
	serializer_set_show_thousands_separators (_tmp5_, TRUE);
	_tmp6_ = serializer;
	serializer_set_thousands_separator_count (_tmp6_, 3);
	_tmp7_ = serializer;
	test_fixed (_tmp7_);
	_tmp8_ = serializer;
	test_automatic (_tmp8_);
	_tmp9_ = serializer;
	test_scientific (_tmp9_);
	_tmp10_ = serializer;
	test_engineering (_tmp10_);
	_tmp11_ = fail_count;
	if (_tmp11_ == 0) {
		FILE* _tmp12_;
		gint _tmp13_;
		_tmp12_ = stdout;
		_tmp13_ = pass_count;
		fprintf (_tmp12_, "Passed all %i tests\n", _tmp13_);
	} else {
		FILE* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp14_ = stdout;
		_tmp15_ = fail_count;
		_tmp16_ = pass_count;
		_tmp17_ = fail_count;
		fprintf (_tmp14_, "Failed %i/%d tests\n", _tmp15_, _tmp16_ + _tmp17_);
	}
	_tmp18_ = fail_count;
	result = _tmp18_;
	_g_object_unref0 (serializer);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



