/* Evolution calendar - iCalendar file backend
 *
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 * Author: Federico Mena-Quintero <federico@ximian.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef E_CAL_BACKEND_HTTP_H
#define E_CAL_BACKEND_HTTP_H

#include <libedata-cal/libedata-cal.h>

#define E_TYPE_CAL_BACKEND_HTTP \
	(e_cal_backend_http_get_type ())
#define E_CAL_BACKEND_HTTP(obj) \
	(G_TYPE_CHECK_INSTANCE_CAST \
	((obj), E_TYPE_CAL_BACKEND_HTTP, ECalBackendHttp))
#define E_CAL_BACKEND_HTTP_CLASS(cls) \
	(G_TYPE_CHECK_CLASS_CAST \
	((cls), E_TYPE_CAL_BACKEND_HTTP, ECalBackendHttpClass))
#define E_IS_CAL_BACKEND_HTTP(obj) \
	(G_TYPE_CHECK_INSTANCE_TYPE \
	((obj), E_TYPE_CAL_BACKEND_HTTP))
#define E_IS_CAL_BACKEND_HTTP_CLASS(cls) \
	(G_TYPE_CHECK_CLASS_TYPE \
	((cls), E_TYPE_CAL_BACKEND_HTTP))
#define E_CAL_BACKEND_HTTP_GET_CLASS(obj) \
	(G_TYPE_INSTANCE_GET_CLASS \
	((obj), E_TYPE_CAL_BACKEND_HTTP, ECalBackendHttpClass))

G_BEGIN_DECLS

typedef struct _ECalBackendHttp ECalBackendHttp;
typedef struct _ECalBackendHttpClass ECalBackendHttpClass;
typedef struct _ECalBackendHttpPrivate ECalBackendHttpPrivate;

struct _ECalBackendHttp {
	ECalBackendSync backend;
	ECalBackendHttpPrivate *priv;
};

struct _ECalBackendHttpClass {
	ECalBackendSyncClass parent_class;
};

GType		e_cal_backend_http_get_type	(void);

G_END_DECLS

#endif /* E_CAL_BACKEND_HTTP_H */
