
/* autogenerated from gstvolumeorc.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <glib.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union
{
  orc_int16 i;
  orc_int8 x2[2];
} orc_union16;
typedef union
{
  orc_int32 i;
  float f;
  orc_int16 x2[2];
  orc_int8 x4[4];
} orc_union32;
typedef union
{
  orc_int64 i;
  double f;
  orc_int32 x2[2];
  float x2f[2];
  orc_int16 x4[4];
} orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void volume_orc_scalarmultiply_f64_ns (double *ORC_RESTRICT d1, double p1,
    int n);
void volume_orc_scalarmultiply_f32_ns (float *ORC_RESTRICT d1, float p1, int n);
void volume_orc_process_int32 (gint32 * ORC_RESTRICT d1, int p1, int n);
void volume_orc_process_int32_clamp (gint32 * ORC_RESTRICT d1, int p1, int n);
void volume_orc_process_int16 (gint16 * ORC_RESTRICT d1, int p1, int n);
void volume_orc_process_int16_clamp (gint16 * ORC_RESTRICT d1, int p1, int n);
void volume_orc_process_int8 (gint8 * ORC_RESTRICT d1, int p1, int n);
void volume_orc_process_int8_clamp (gint8 * ORC_RESTRICT d1, int p1, int n);
void volume_orc_memset_f64 (gdouble * ORC_RESTRICT d1, double p1, int n);
void volume_orc_prepare_volumes (gdouble * ORC_RESTRICT d1,
    const gboolean * ORC_RESTRICT s1, int n);
void volume_orc_process_controlled_f64_1ch (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void volume_orc_process_controlled_f32_1ch (gfloat * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void volume_orc_process_controlled_f32_2ch (gfloat * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void volume_orc_process_controlled_int32_1ch (gint32 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void volume_orc_process_controlled_int16_1ch (gint16 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void volume_orc_process_controlled_int16_2ch (gint16 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void volume_orc_process_controlled_int8_1ch (gint8 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);
void volume_orc_process_controlled_int8_2ch (gint8 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* volume_orc_scalarmultiply_f64_ns */
#ifdef DISABLE_ORC
void
volume_orc_scalarmultiply_f64_ns (double *ORC_RESTRICT d1, double p1, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *) d1;

  /* 1: loadpq */
  var33.f = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr0[i];
    /* 2: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var32.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest1.f = _src1.f * _src2.f;
      var34.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_volume_orc_scalarmultiply_f64_ns (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *) ex->arrays[0];

  /* 1: loadpq */
  var33.i =
      (ex->params[24] & 0xffffffff) | ((orc_uint64) (ex->params[24 +
              (ORC_VAR_T1 - ORC_VAR_P1)]) << 32);

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr0[i];
    /* 2: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var32.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest1.f = _src1.f * _src2.f;
      var34.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
volume_orc_scalarmultiply_f64_ns (double *ORC_RESTRICT d1, double p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_scalarmultiply_f64_ns");
      orc_program_set_backup_function (p,
          _backup_volume_orc_scalarmultiply_f64_ns);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_parameter_double (p, 8, "p1");

      orc_program_append_2 (p, "muld", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  {
    orc_union64 tmp;
    tmp.f = p1;
    ex->params[ORC_VAR_P1] = tmp.x2[0];
    ex->params[ORC_VAR_T1] = tmp.x2[1];
  }

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_scalarmultiply_f32_ns */
#ifdef DISABLE_ORC
void
volume_orc_scalarmultiply_f32_ns (float *ORC_RESTRICT d1, float p1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) d1;

  /* 1: loadpl */
  var33.f = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 2: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var32.i);
      _src2.i = ORC_DENORMAL (var33.i);
      _dest1.f = _src1.f * _src2.f;
      var34.i = ORC_DENORMAL (_dest1.i);
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_volume_orc_scalarmultiply_f32_ns (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var32;
  orc_union32 var33;
  orc_union32 var34;

  ptr0 = (orc_union32 *) ex->arrays[0];

  /* 1: loadpl */
  var33.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr0[i];
    /* 2: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var32.i);
      _src2.i = ORC_DENORMAL (var33.i);
      _dest1.f = _src1.f * _src2.f;
      var34.i = ORC_DENORMAL (_dest1.i);
    }
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
volume_orc_scalarmultiply_f32_ns (float *ORC_RESTRICT d1, float p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_scalarmultiply_f32_ns");
      orc_program_set_backup_function (p,
          _backup_volume_orc_scalarmultiply_f32_ns);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_parameter_float (p, 4, "p1");

      orc_program_append_2 (p, "mulf", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  {
    orc_union32 tmp;
    tmp.f = p1;
    ex->params[ORC_VAR_P1] = tmp.i;
  }

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_int32 */
#ifdef DISABLE_ORC
void
volume_orc_process_int32 (gint32 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union64 var36;
  orc_union64 var37;

  ptr0 = (orc_union32 *) d1;

  /* 1: loadpl */
  var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 2: mulslq */
    var36.i = ((orc_int64) var33.i) * ((orc_int64) var34.i);
    /* 3: shrsq */
    var37.i = var36.i >> 27;
    /* 4: convql */
    var35.i = var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_volume_orc_process_int32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union64 var36;
  orc_union64 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];

  /* 1: loadpl */
  var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 2: mulslq */
    var36.i = ((orc_int64) var33.i) * ((orc_int64) var34.i);
    /* 3: shrsq */
    var37.i = var36.i >> 27;
    /* 4: convql */
    var35.i = var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
volume_orc_process_int32 (gint32 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_int32");
      orc_program_set_backup_function (p, _backup_volume_orc_process_int32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_constant (p, 4, 0x0000001b, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_temporary (p, 8, "t1");

      orc_program_append_2 (p, "mulslq", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsq", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convql", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_int32_clamp */
#ifdef DISABLE_ORC
void
volume_orc_process_int32_clamp (gint32 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union64 var36;
  orc_union64 var37;

  ptr0 = (orc_union32 *) d1;

  /* 1: loadpl */
  var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 2: mulslq */
    var36.i = ((orc_int64) var33.i) * ((orc_int64) var34.i);
    /* 3: shrsq */
    var37.i = var36.i >> 27;
    /* 4: convsssql */
    var35.i = ORC_CLAMP_SL (var37.i);
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_volume_orc_process_int32_clamp (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union64 var36;
  orc_union64 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];

  /* 1: loadpl */
  var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 2: mulslq */
    var36.i = ((orc_int64) var33.i) * ((orc_int64) var34.i);
    /* 3: shrsq */
    var37.i = var36.i >> 27;
    /* 4: convsssql */
    var35.i = ORC_CLAMP_SL (var37.i);
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
volume_orc_process_int32_clamp (gint32 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_int32_clamp");
      orc_program_set_backup_function (p,
          _backup_volume_orc_process_int32_clamp);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_constant (p, 4, 0x0000001b, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_temporary (p, 8, "t1");

      orc_program_append_2 (p, "mulslq", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsq", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsssql", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_int16 */
#ifdef DISABLE_ORC
void
volume_orc_process_int16 (gint16 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union16 *) d1;

  /* 1: loadpw */
  var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr0[i];
    /* 2: mulswl */
    var36.i = var33.i * var34.i;
    /* 3: shrsl */
    var37.i = var36.i >> 11;
    /* 4: convlw */
    var35.i = var37.i;
    /* 5: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_volume_orc_process_int16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union16 *) ex->arrays[0];

  /* 1: loadpw */
  var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr0[i];
    /* 2: mulswl */
    var36.i = var33.i * var34.i;
    /* 3: shrsl */
    var37.i = var36.i >> 11;
    /* 4: convlw */
    var35.i = var37.i;
    /* 5: storew */
    ptr0[i] = var35;
  }

}

void
volume_orc_process_int16 (gint16 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_int16");
      orc_program_set_backup_function (p, _backup_volume_orc_process_int16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 4, 0x0000000b, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_int16_clamp */
#ifdef DISABLE_ORC
void
volume_orc_process_int16_clamp (gint16 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union16 *) d1;

  /* 1: loadpw */
  var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr0[i];
    /* 2: mulswl */
    var36.i = var33.i * var34.i;
    /* 3: shrsl */
    var37.i = var36.i >> 11;
    /* 4: convssslw */
    var35.i = ORC_CLAMP_SW (var37.i);
    /* 5: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_volume_orc_process_int16_clamp (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union16 *) ex->arrays[0];

  /* 1: loadpw */
  var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr0[i];
    /* 2: mulswl */
    var36.i = var33.i * var34.i;
    /* 3: shrsl */
    var37.i = var36.i >> 11;
    /* 4: convssslw */
    var35.i = ORC_CLAMP_SW (var37.i);
    /* 5: storew */
    ptr0[i] = var35;
  }

}

void
volume_orc_process_int16_clamp (gint16 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_int16_clamp");
      orc_program_set_backup_function (p,
          _backup_volume_orc_process_int16_clamp);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 4, 0x0000000b, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssslw", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_int8 */
#ifdef DISABLE_ORC
void
volume_orc_process_int8 (gint8 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_int8 *) d1;

  /* 1: loadpb */
  var34 = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr0[i];
    /* 2: mulsbw */
    var36.i = var33 * var34;
    /* 3: shrsw */
    var37.i = var36.i >> 3;
    /* 4: convwb */
    var35 = var37.i;
    /* 5: storeb */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_volume_orc_process_int8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_int8 *) ex->arrays[0];

  /* 1: loadpb */
  var34 = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr0[i];
    /* 2: mulsbw */
    var36.i = var33 * var34;
    /* 3: shrsw */
    var37.i = var36.i >> 3;
    /* 4: convwb */
    var35 = var37.i;
    /* 5: storeb */
    ptr0[i] = var35;
  }

}

void
volume_orc_process_int8 (gint8 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_int8");
      orc_program_set_backup_function (p, _backup_volume_orc_process_int8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_constant (p, 4, 0x00000003, "c1");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mulsbw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_int8_clamp */
#ifdef DISABLE_ORC
void
volume_orc_process_int8_clamp (gint8 * ORC_RESTRICT d1, int p1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_int8 *) d1;

  /* 1: loadpb */
  var34 = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr0[i];
    /* 2: mulsbw */
    var36.i = var33 * var34;
    /* 3: shrsw */
    var37.i = var36.i >> 3;
    /* 4: convssswb */
    var35 = ORC_CLAMP_SB (var37.i);
    /* 5: storeb */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_volume_orc_process_int8_clamp (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_int8 *) ex->arrays[0];

  /* 1: loadpb */
  var34 = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr0[i];
    /* 2: mulsbw */
    var36.i = var33 * var34;
    /* 3: shrsw */
    var37.i = var36.i >> 3;
    /* 4: convssswb */
    var35 = ORC_CLAMP_SB (var37.i);
    /* 5: storeb */
    ptr0[i] = var35;
  }

}

void
volume_orc_process_int8_clamp (gint8 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_int8_clamp");
      orc_program_set_backup_function (p,
          _backup_volume_orc_process_int8_clamp);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_constant (p, 4, 0x00000003, "c1");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mulsbw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_memset_f64 */
#ifdef DISABLE_ORC
void
volume_orc_memset_f64 (gdouble * ORC_RESTRICT d1, double p1, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) d1;

  /* 0: loadpq */
  var32.f = p1;

  for (i = 0; i < n; i++) {
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_volume_orc_memset_f64 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  orc_union64 var32;
  orc_union64 var33;

  ptr0 = (orc_union64 *) ex->arrays[0];

  /* 0: loadpq */
  var32.i =
      (ex->params[24] & 0xffffffff) | ((orc_uint64) (ex->params[24 +
              (ORC_VAR_T1 - ORC_VAR_P1)]) << 32);

  for (i = 0; i < n; i++) {
    /* 1: copyq */
    var33.i = var32.i;
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
volume_orc_memset_f64 (gdouble * ORC_RESTRICT d1, double p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_memset_f64");
      orc_program_set_backup_function (p, _backup_volume_orc_memset_f64);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_parameter_double (p, 8, "p1");

      orc_program_append_2 (p, "copyq", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  {
    orc_union64 tmp;
    tmp.f = p1;
    ex->params[ORC_VAR_P1] = tmp.x2[0];
    ex->params[ORC_VAR_T1] = tmp.x2[1];
  }

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_prepare_volumes */
#ifdef DISABLE_ORC
void
volume_orc_prepare_volumes (gdouble * ORC_RESTRICT d1,
    const gboolean * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union64 var34;
  orc_union64 var35;
  orc_union64 var36;
  orc_union64 var37;
  orc_union64 var38;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 2: loadpq */
  var34.i = ORC_UINT64_C (0x3ff0000000000000);  /* 1f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: convld */
    var37.f = var33.i;
    /* 3: subd */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var34.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var37.i);
      _dest1.f = _src1.f - _src2.f;
      var38.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 4: loadq */
    var35 = ptr0[i];
    /* 5: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var35.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var38.i);
      _dest1.f = _src1.f * _src2.f;
      var36.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 6: storeq */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_volume_orc_prepare_volumes (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union64 var34;
  orc_union64 var35;
  orc_union64 var36;
  orc_union64 var37;
  orc_union64 var38;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 2: loadpq */
  var34.i = ORC_UINT64_C (0x3ff0000000000000);  /* 1f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: convld */
    var37.f = var33.i;
    /* 3: subd */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var34.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var37.i);
      _dest1.f = _src1.f - _src2.f;
      var38.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 4: loadq */
    var35 = ptr0[i];
    /* 5: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var35.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var38.i);
      _dest1.f = _src1.f * _src2.f;
      var36.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 6: storeq */
    ptr0[i] = var36;
  }

}

void
volume_orc_prepare_volumes (gdouble * ORC_RESTRICT d1,
    const gboolean * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_prepare_volumes");
      orc_program_set_backup_function (p, _backup_volume_orc_prepare_volumes);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant_int64 (p, 8, 0x3ff0000000000000ULL, "c1");
      orc_program_add_temporary (p, 8, "t1");

      orc_program_append_2 (p, "convld", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subd", 0, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "muld", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_controlled_f64_1ch */
#ifdef DISABLE_ORC
void
volume_orc_process_controlled_f64_1ch (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr0[i];
    /* 1: loadq */
    var33 = ptr4[i];
    /* 2: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var32.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest1.f = _src1.f * _src2.f;
      var34.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_volume_orc_process_controlled_f64_1ch (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var32;
  orc_union64 var33;
  orc_union64 var34;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var32 = ptr0[i];
    /* 1: loadq */
    var33 = ptr4[i];
    /* 2: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var32.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest1.f = _src1.f * _src2.f;
      var34.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
volume_orc_process_controlled_f64_1ch (gdouble * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_controlled_f64_1ch");
      orc_program_set_backup_function (p,
          _backup_volume_orc_process_controlled_f64_1ch);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");

      orc_program_append_2 (p, "muld", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_controlled_f32_1ch */
#ifdef DISABLE_ORC
void
volume_orc_process_controlled_f32_1ch (gfloat * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 1: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest.f = _src1.f;
      var36.i = ORC_DENORMAL (_dest.i);
    }
    /* 2: loadl */
    var34 = ptr0[i];
    /* 3: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var34.i);
      _src2.i = ORC_DENORMAL (var36.i);
      _dest1.f = _src1.f * _src2.f;
      var35.i = ORC_DENORMAL (_dest1.i);
    }
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_volume_orc_process_controlled_f32_1ch (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var33 = ptr4[i];
    /* 1: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var33.i);
      _dest.f = _src1.f;
      var36.i = ORC_DENORMAL (_dest.i);
    }
    /* 2: loadl */
    var34 = ptr0[i];
    /* 3: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var34.i);
      _src2.i = ORC_DENORMAL (var36.i);
      _dest1.f = _src1.f * _src2.f;
      var35.i = ORC_DENORMAL (_dest1.i);
    }
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
volume_orc_process_controlled_f32_1ch (gfloat * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_controlled_f32_1ch");
      orc_program_set_backup_function (p,
          _backup_volume_orc_process_controlled_f32_1ch);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "convdf", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulf", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_controlled_f32_2ch */
#ifdef DISABLE_ORC
void
volume_orc_process_controlled_f32_2ch (gfloat * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var34;
  orc_union64 var35;
  orc_union64 var36;
  orc_union32 var37;
  orc_union64 var38;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var34 = ptr4[i];
    /* 1: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var34.i);
      _dest.f = _src1.f;
      var37.i = ORC_DENORMAL (_dest.i);
    }
    /* 2: mergelq */
    {
      orc_union64 _dest;
      _dest.x2[0] = var37.i;
      _dest.x2[1] = var37.i;
      var38.i = _dest.i;
    }
    /* 3: loadq */
    var35 = ptr0[i];
    /* 4: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var35.x2[0]);
      _src2.i = ORC_DENORMAL (var38.x2[0]);
      _dest1.f = _src1.f * _src2.f;
      var36.x2[0] = ORC_DENORMAL (_dest1.i);
    }
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var35.x2[1]);
      _src2.i = ORC_DENORMAL (var38.x2[1]);
      _dest1.f = _src1.f * _src2.f;
      var36.x2[1] = ORC_DENORMAL (_dest1.i);
    }
    /* 5: storeq */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_volume_orc_process_controlled_f32_2ch (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var34;
  orc_union64 var35;
  orc_union64 var36;
  orc_union32 var37;
  orc_union64 var38;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var34 = ptr4[i];
    /* 1: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var34.i);
      _dest.f = _src1.f;
      var37.i = ORC_DENORMAL (_dest.i);
    }
    /* 2: mergelq */
    {
      orc_union64 _dest;
      _dest.x2[0] = var37.i;
      _dest.x2[1] = var37.i;
      var38.i = _dest.i;
    }
    /* 3: loadq */
    var35 = ptr0[i];
    /* 4: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var35.x2[0]);
      _src2.i = ORC_DENORMAL (var38.x2[0]);
      _dest1.f = _src1.f * _src2.f;
      var36.x2[0] = ORC_DENORMAL (_dest1.i);
    }
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var35.x2[1]);
      _src2.i = ORC_DENORMAL (var38.x2[1]);
      _dest1.f = _src1.f * _src2.f;
      var36.x2[1] = ORC_DENORMAL (_dest1.i);
    }
    /* 5: storeq */
    ptr0[i] = var36;
  }

}

void
volume_orc_process_controlled_f32_2ch (gfloat * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_controlled_f32_2ch");
      orc_program_set_backup_function (p,
          _backup_volume_orc_process_controlled_f32_2ch);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 8, "t2");

      orc_program_append_2 (p, "convdf", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulf", 1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T2,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_controlled_int32_1ch */
#ifdef DISABLE_ORC
void
volume_orc_process_controlled_int32_1ch (gint32 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union64 var34;
  orc_union32 var35;
  orc_union64 var36;
  orc_union64 var37;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 1: convld */
    var36.f = var33.i;
    /* 2: loadq */
    var34 = ptr4[i];
    /* 3: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var36.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var34.i);
      _dest1.f = _src1.f * _src2.f;
      var37.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 4: convdl */
    {
      int tmp;
      tmp = var37.f;
      if (tmp == 0x80000000 && !(var37.i & ORC_UINT64_C (0x8000000000000000)))
        tmp = 0x7fffffff;
      var35.i = tmp;
    }
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_volume_orc_process_controlled_int32_1ch (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union64 var34;
  orc_union32 var35;
  orc_union64 var36;
  orc_union64 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr0[i];
    /* 1: convld */
    var36.f = var33.i;
    /* 2: loadq */
    var34 = ptr4[i];
    /* 3: muld */
    {
      orc_union64 _src1;
      orc_union64 _src2;
      orc_union64 _dest1;
      _src1.i = ORC_DENORMAL_DOUBLE (var36.i);
      _src2.i = ORC_DENORMAL_DOUBLE (var34.i);
      _dest1.f = _src1.f * _src2.f;
      var37.i = ORC_DENORMAL_DOUBLE (_dest1.i);
    }
    /* 4: convdl */
    {
      int tmp;
      tmp = var37.f;
      if (tmp == 0x80000000 && !(var37.i & ORC_UINT64_C (0x8000000000000000)))
        tmp = 0x7fffffff;
      var35.i = tmp;
    }
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
volume_orc_process_controlled_int32_1ch (gint32 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_controlled_int32_1ch");
      orc_program_set_backup_function (p,
          _backup_volume_orc_process_controlled_int32_1ch);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 8, "t1");

      orc_program_append_2 (p, "convld", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "muld", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convdl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_controlled_int16_1ch */
#ifdef DISABLE_ORC
void
volume_orc_process_controlled_int16_1ch (gint16 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union64 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union16 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr0[i];
    /* 1: convswl */
    var37.i = var34.i;
    /* 2: convlf */
    var38.f = var37.i;
    /* 3: loadq */
    var35 = ptr4[i];
    /* 4: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var35.i);
      _dest.f = _src1.f;
      var39.i = ORC_DENORMAL (_dest.i);
    }
    /* 5: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var38.i);
      _src2.i = ORC_DENORMAL (var39.i);
      _dest1.f = _src1.f * _src2.f;
      var40.i = ORC_DENORMAL (_dest1.i);
    }
    /* 6: convfl */
    {
      int tmp;
      tmp = (int) var40.f;
      if (tmp == 0x80000000 && !(var40.i & 0x80000000))
        tmp = 0x7fffffff;
      var41.i = tmp;
    }
    /* 7: convssslw */
    var36.i = ORC_CLAMP_SW (var41.i);
    /* 8: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_volume_orc_process_controlled_int16_1ch (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union64 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr0[i];
    /* 1: convswl */
    var37.i = var34.i;
    /* 2: convlf */
    var38.f = var37.i;
    /* 3: loadq */
    var35 = ptr4[i];
    /* 4: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var35.i);
      _dest.f = _src1.f;
      var39.i = ORC_DENORMAL (_dest.i);
    }
    /* 5: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var38.i);
      _src2.i = ORC_DENORMAL (var39.i);
      _dest1.f = _src1.f * _src2.f;
      var40.i = ORC_DENORMAL (_dest1.i);
    }
    /* 6: convfl */
    {
      int tmp;
      tmp = (int) var40.f;
      if (tmp == 0x80000000 && !(var40.i & 0x80000000))
        tmp = 0x7fffffff;
      var41.i = tmp;
    }
    /* 7: convssslw */
    var36.i = ORC_CLAMP_SW (var41.i);
    /* 8: storew */
    ptr0[i] = var36;
  }

}

void
volume_orc_process_controlled_int16_1ch (gint16 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_controlled_int16_1ch");
      orc_program_set_backup_function (p,
          _backup_volume_orc_process_controlled_int16_1ch);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlf", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convdf", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulf", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convfl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssslw", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_controlled_int16_2ch */
#ifdef DISABLE_ORC
void
volume_orc_process_controlled_int16_2ch (gint16 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union64 var36;
  orc_union32 var37;
  orc_union64 var38;
  orc_union64 var39;
  orc_union32 var40;
  orc_union64 var41;
  orc_union64 var42;
  orc_union64 var43;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr0[i];
    /* 1: convswl */
    var38.x2[0] = var35.x2[0];
    var38.x2[1] = var35.x2[1];
    /* 2: convlf */
    var39.x2f[0] = var38.x2[0];
    var39.x2f[1] = var38.x2[1];
    /* 3: loadq */
    var36 = ptr4[i];
    /* 4: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var36.i);
      _dest.f = _src1.f;
      var40.i = ORC_DENORMAL (_dest.i);
    }
    /* 5: mergelq */
    {
      orc_union64 _dest;
      _dest.x2[0] = var40.i;
      _dest.x2[1] = var40.i;
      var41.i = _dest.i;
    }
    /* 6: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var41.x2[0]);
      _src2.i = ORC_DENORMAL (var39.x2[0]);
      _dest1.f = _src1.f * _src2.f;
      var42.x2[0] = ORC_DENORMAL (_dest1.i);
    }
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var41.x2[1]);
      _src2.i = ORC_DENORMAL (var39.x2[1]);
      _dest1.f = _src1.f * _src2.f;
      var42.x2[1] = ORC_DENORMAL (_dest1.i);
    }
    /* 7: convfl */
    {
      int tmp;
      tmp = (int) var42.x2f[0];
      if (tmp == 0x80000000 && !(var42.x2[0] & 0x80000000))
        tmp = 0x7fffffff;
      var43.x2[0] = tmp;
    }
    {
      int tmp;
      tmp = (int) var42.x2f[1];
      if (tmp == 0x80000000 && !(var42.x2[1] & 0x80000000))
        tmp = 0x7fffffff;
      var43.x2[1] = tmp;
    }
    /* 8: convssslw */
    var37.x2[0] = ORC_CLAMP_SW (var43.x2[0]);
    var37.x2[1] = ORC_CLAMP_SW (var43.x2[1]);
    /* 9: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_volume_orc_process_controlled_int16_2ch (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union64 var36;
  orc_union32 var37;
  orc_union64 var38;
  orc_union64 var39;
  orc_union32 var40;
  orc_union64 var41;
  orc_union64 var42;
  orc_union64 var43;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr0[i];
    /* 1: convswl */
    var38.x2[0] = var35.x2[0];
    var38.x2[1] = var35.x2[1];
    /* 2: convlf */
    var39.x2f[0] = var38.x2[0];
    var39.x2f[1] = var38.x2[1];
    /* 3: loadq */
    var36 = ptr4[i];
    /* 4: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var36.i);
      _dest.f = _src1.f;
      var40.i = ORC_DENORMAL (_dest.i);
    }
    /* 5: mergelq */
    {
      orc_union64 _dest;
      _dest.x2[0] = var40.i;
      _dest.x2[1] = var40.i;
      var41.i = _dest.i;
    }
    /* 6: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var41.x2[0]);
      _src2.i = ORC_DENORMAL (var39.x2[0]);
      _dest1.f = _src1.f * _src2.f;
      var42.x2[0] = ORC_DENORMAL (_dest1.i);
    }
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var41.x2[1]);
      _src2.i = ORC_DENORMAL (var39.x2[1]);
      _dest1.f = _src1.f * _src2.f;
      var42.x2[1] = ORC_DENORMAL (_dest1.i);
    }
    /* 7: convfl */
    {
      int tmp;
      tmp = (int) var42.x2f[0];
      if (tmp == 0x80000000 && !(var42.x2[0] & 0x80000000))
        tmp = 0x7fffffff;
      var43.x2[0] = tmp;
    }
    {
      int tmp;
      tmp = (int) var42.x2f[1];
      if (tmp == 0x80000000 && !(var42.x2[1] & 0x80000000))
        tmp = 0x7fffffff;
      var43.x2[1] = tmp;
    }
    /* 8: convssslw */
    var37.x2[0] = ORC_CLAMP_SW (var43.x2[0]);
    var37.x2[1] = ORC_CLAMP_SW (var43.x2[1]);
    /* 9: storel */
    ptr0[i] = var37;
  }

}

void
volume_orc_process_controlled_int16_2ch (gint16 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_controlled_int16_2ch");
      orc_program_set_backup_function (p,
          _backup_volume_orc_process_controlled_int16_2ch);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 8, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 8, "t3");

      orc_program_append_2 (p, "convswl", 1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlf", 1, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convdf", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulf", 1, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convfl", 1, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssslw", 1, ORC_VAR_D1, ORC_VAR_T3,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_controlled_int8_1ch */
#ifdef DISABLE_ORC
void
volume_orc_process_controlled_int8_1ch (gint8 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_int8 var35;
  orc_union64 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr0[i];
    /* 1: convsbw */
    var38.i = var35;
    /* 2: convswl */
    var39.i = var38.i;
    /* 3: convlf */
    var40.f = var39.i;
    /* 4: loadq */
    var36 = ptr4[i];
    /* 5: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var36.i);
      _dest.f = _src1.f;
      var41.i = ORC_DENORMAL (_dest.i);
    }
    /* 6: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var40.i);
      _src2.i = ORC_DENORMAL (var41.i);
      _dest1.f = _src1.f * _src2.f;
      var42.i = ORC_DENORMAL (_dest1.i);
    }
    /* 7: convfl */
    {
      int tmp;
      tmp = (int) var42.f;
      if (tmp == 0x80000000 && !(var42.i & 0x80000000))
        tmp = 0x7fffffff;
      var43.i = tmp;
    }
    /* 8: convlw */
    var44.i = var43.i;
    /* 9: convssswb */
    var37 = ORC_CLAMP_SB (var44.i);
    /* 10: storeb */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_volume_orc_process_controlled_int8_1ch (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_int8 var35;
  orc_union64 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr0[i];
    /* 1: convsbw */
    var38.i = var35;
    /* 2: convswl */
    var39.i = var38.i;
    /* 3: convlf */
    var40.f = var39.i;
    /* 4: loadq */
    var36 = ptr4[i];
    /* 5: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var36.i);
      _dest.f = _src1.f;
      var41.i = ORC_DENORMAL (_dest.i);
    }
    /* 6: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var40.i);
      _src2.i = ORC_DENORMAL (var41.i);
      _dest1.f = _src1.f * _src2.f;
      var42.i = ORC_DENORMAL (_dest1.i);
    }
    /* 7: convfl */
    {
      int tmp;
      tmp = (int) var42.f;
      if (tmp == 0x80000000 && !(var42.i & 0x80000000))
        tmp = 0x7fffffff;
      var43.i = tmp;
    }
    /* 8: convlw */
    var44.i = var43.i;
    /* 9: convssswb */
    var37 = ORC_CLAMP_SB (var44.i);
    /* 10: storeb */
    ptr0[i] = var37;
  }

}

void
volume_orc_process_controlled_int8_1ch (gint8 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_controlled_int8_1ch");
      orc_program_set_backup_function (p,
          _backup_volume_orc_process_controlled_int8_1ch);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlf", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convdf", 0, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulf", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convfl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif


/* volume_orc_process_controlled_int8_2ch */
#ifdef DISABLE_ORC
void
volume_orc_process_controlled_int8_2ch (gint8 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union16 var35;
  orc_union64 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union64 var39;
  orc_union64 var40;
  orc_union32 var41;
  orc_union64 var42;
  orc_union64 var43;
  orc_union64 var44;
  orc_union32 var45;

  ptr0 = (orc_union16 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr0[i];
    /* 1: convsbw */
    var38.x2[0] = var35.x2[0];
    var38.x2[1] = var35.x2[1];
    /* 2: convswl */
    var39.x2[0] = var38.x2[0];
    var39.x2[1] = var38.x2[1];
    /* 3: convlf */
    var40.x2f[0] = var39.x2[0];
    var40.x2f[1] = var39.x2[1];
    /* 4: loadq */
    var36 = ptr4[i];
    /* 5: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var36.i);
      _dest.f = _src1.f;
      var41.i = ORC_DENORMAL (_dest.i);
    }
    /* 6: mergelq */
    {
      orc_union64 _dest;
      _dest.x2[0] = var41.i;
      _dest.x2[1] = var41.i;
      var42.i = _dest.i;
    }
    /* 7: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var40.x2[0]);
      _src2.i = ORC_DENORMAL (var42.x2[0]);
      _dest1.f = _src1.f * _src2.f;
      var43.x2[0] = ORC_DENORMAL (_dest1.i);
    }
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var40.x2[1]);
      _src2.i = ORC_DENORMAL (var42.x2[1]);
      _dest1.f = _src1.f * _src2.f;
      var43.x2[1] = ORC_DENORMAL (_dest1.i);
    }
    /* 8: convfl */
    {
      int tmp;
      tmp = (int) var43.x2f[0];
      if (tmp == 0x80000000 && !(var43.x2[0] & 0x80000000))
        tmp = 0x7fffffff;
      var44.x2[0] = tmp;
    }
    {
      int tmp;
      tmp = (int) var43.x2f[1];
      if (tmp == 0x80000000 && !(var43.x2[1] & 0x80000000))
        tmp = 0x7fffffff;
      var44.x2[1] = tmp;
    }
    /* 9: convlw */
    var45.x2[0] = var44.x2[0];
    var45.x2[1] = var44.x2[1];
    /* 10: convssswb */
    var37.x2[0] = ORC_CLAMP_SB (var45.x2[0]);
    var37.x2[1] = ORC_CLAMP_SB (var45.x2[1]);
    /* 11: storew */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_volume_orc_process_controlled_int8_2ch (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union16 var35;
  orc_union64 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union64 var39;
  orc_union64 var40;
  orc_union32 var41;
  orc_union64 var42;
  orc_union64 var43;
  orc_union64 var44;
  orc_union32 var45;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr0[i];
    /* 1: convsbw */
    var38.x2[0] = var35.x2[0];
    var38.x2[1] = var35.x2[1];
    /* 2: convswl */
    var39.x2[0] = var38.x2[0];
    var39.x2[1] = var38.x2[1];
    /* 3: convlf */
    var40.x2f[0] = var39.x2[0];
    var40.x2f[1] = var39.x2[1];
    /* 4: loadq */
    var36 = ptr4[i];
    /* 5: convdf */
    {
      orc_union64 _src1;
      orc_union32 _dest;
      _src1.i = ORC_DENORMAL_DOUBLE (var36.i);
      _dest.f = _src1.f;
      var41.i = ORC_DENORMAL (_dest.i);
    }
    /* 6: mergelq */
    {
      orc_union64 _dest;
      _dest.x2[0] = var41.i;
      _dest.x2[1] = var41.i;
      var42.i = _dest.i;
    }
    /* 7: mulf */
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var40.x2[0]);
      _src2.i = ORC_DENORMAL (var42.x2[0]);
      _dest1.f = _src1.f * _src2.f;
      var43.x2[0] = ORC_DENORMAL (_dest1.i);
    }
    {
      orc_union32 _src1;
      orc_union32 _src2;
      orc_union32 _dest1;
      _src1.i = ORC_DENORMAL (var40.x2[1]);
      _src2.i = ORC_DENORMAL (var42.x2[1]);
      _dest1.f = _src1.f * _src2.f;
      var43.x2[1] = ORC_DENORMAL (_dest1.i);
    }
    /* 8: convfl */
    {
      int tmp;
      tmp = (int) var43.x2f[0];
      if (tmp == 0x80000000 && !(var43.x2[0] & 0x80000000))
        tmp = 0x7fffffff;
      var44.x2[0] = tmp;
    }
    {
      int tmp;
      tmp = (int) var43.x2f[1];
      if (tmp == 0x80000000 && !(var43.x2[1] & 0x80000000))
        tmp = 0x7fffffff;
      var44.x2[1] = tmp;
    }
    /* 9: convlw */
    var45.x2[0] = var44.x2[0];
    var45.x2[1] = var44.x2[1];
    /* 10: convssswb */
    var37.x2[0] = ORC_CLAMP_SB (var45.x2[0]);
    var37.x2[1] = ORC_CLAMP_SB (var45.x2[1]);
    /* 11: storew */
    ptr0[i] = var37;
  }

}

void
volume_orc_process_controlled_int8_2ch (gint8 * ORC_RESTRICT d1,
    const gdouble * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "volume_orc_process_controlled_int8_2ch");
      orc_program_set_backup_function (p,
          _backup_volume_orc_process_controlled_int8_2ch);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 8, "t2");
      orc_program_add_temporary (p, 8, "t3");

      orc_program_append_2 (p, "convsbw", 1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlf", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convdf", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mulf", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convfl", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = c->exec;
  func (ex);
}
#endif
