/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <config.h>
#include <version.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda2_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda2__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[49] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gint _tmp4_ = 0;
	gboolean _tmp9_;
	gboolean _tmp10_ = FALSE;
	ValaCodeContext* _tmp11_;
	ValaReport* _tmp12_;
	ValaReport* _tmp13_;
	gint _tmp14_ = 0;
	gboolean _tmp22_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_;
		ValaReport* _tmp6_;
		ValaReport* _tmp7_;
		gint _tmp8_ = 0;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		result = 0;
		return result;
	}
	_tmp11_ = self->priv->context;
	_tmp12_ = vala_code_context_get_report (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_report_get_errors (_tmp13_);
	if (_tmp14_ == 0) {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
		gboolean _tmp21_;
		_tmp16_ = vala_compiler_fatal_warnings;
		if (!_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			ValaCodeContext* _tmp17_;
			ValaReport* _tmp18_;
			ValaReport* _tmp19_;
			gint _tmp20_ = 0;
			_tmp17_ = self->priv->context;
			_tmp18_ = vala_code_context_get_report (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_report_get_warnings (_tmp19_);
			_tmp15_ = _tmp20_ == 0;
		}
		_tmp21_ = _tmp15_;
		_tmp10_ = _tmp21_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp22_ = _tmp10_;
	if (_tmp22_) {
		gboolean _tmp23_;
		_tmp23_ = vala_compiler_quiet_mode;
		if (!_tmp23_) {
			FILE* _tmp24_;
			ValaCodeContext* _tmp25_;
			ValaReport* _tmp26_;
			ValaReport* _tmp27_;
			gint _tmp28_ = 0;
			_tmp24_ = stdout;
			_tmp25_ = self->priv->context;
			_tmp26_ = vala_code_context_get_report (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = vala_report_get_warnings (_tmp27_);
			fprintf (_tmp24_, "Compilation succeeded - %d warning(s)\n", _tmp28_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp29_;
		_tmp29_ = vala_compiler_quiet_mode;
		if (!_tmp29_) {
			FILE* _tmp30_;
			ValaCodeContext* _tmp31_;
			ValaReport* _tmp32_;
			ValaReport* _tmp33_;
			gint _tmp34_ = 0;
			ValaCodeContext* _tmp35_;
			ValaReport* _tmp36_;
			ValaReport* _tmp37_;
			gint _tmp38_ = 0;
			_tmp30_ = stdout;
			_tmp31_ = self->priv->context;
			_tmp32_ = vala_code_context_get_report (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_report_get_errors (_tmp33_);
			_tmp35_ = self->priv->context;
			_tmp36_ = vala_code_context_get_report (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_report_get_warnings (_tmp37_);
			fprintf (_tmp30_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp34_, _tmp38_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	ValaCodeContext* _tmp21_;
	gboolean _tmp22_;
	ValaCodeContext* _tmp23_;
	gboolean _tmp24_;
	ValaCodeContext* _tmp25_;
	gboolean _tmp26_;
	ValaCodeContext* _tmp27_;
	gboolean _tmp28_;
	ValaCodeContext* _tmp29_;
	gboolean _tmp30_;
	ValaCodeContext* _tmp31_;
	gboolean _tmp32_;
	ValaCodeContext* _tmp33_;
	ValaReport* _tmp34_;
	ValaReport* _tmp35_;
	gboolean _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaReport* _tmp38_;
	ValaReport* _tmp39_;
	gboolean _tmp40_;
	ValaCodeContext* _tmp41_;
	gboolean _tmp42_;
	ValaCodeContext* _tmp43_;
	gboolean _tmp44_;
	ValaCodeContext* _tmp45_;
	gboolean _tmp46_;
	ValaCodeContext* _tmp47_;
	gboolean _tmp48_;
	ValaCodeContext* _tmp49_;
	const gchar* _tmp50_;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp52_;
	gboolean _tmp54_;
	ValaCodeContext* _tmp55_;
	gboolean _tmp56_;
	ValaCodeContext* _tmp57_;
	const gchar* _tmp58_;
	ValaCodeContext* _tmp59_;
	const gchar* _tmp60_;
	ValaCodeContext* _tmp61_;
	const gchar* _tmp62_;
	ValaCodeContext* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp73_;
	ValaCodeContext* _tmp82_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	gchar** _tmp84_;
	gint _tmp84__length1;
	ValaCodeContext* _tmp85_;
	gchar** _tmp86_;
	gint _tmp86__length1;
	gchar** _tmp87_;
	gint _tmp87__length1;
	ValaCodeContext* _tmp88_;
	gchar** _tmp89_;
	gint _tmp89__length1;
	gchar** _tmp90_;
	gint _tmp90__length1;
	ValaCodeContext* _tmp91_;
	gboolean _tmp92_;
	ValaCodeContext* _tmp93_;
	gboolean _tmp94_;
	ValaCodeContext* _tmp95_;
	gboolean _tmp96_;
	ValaCodeContext* _tmp97_;
	gboolean _tmp98_;
	gboolean _tmp99_ = FALSE;
	gboolean _tmp100_ = FALSE;
	const gchar* _tmp101_;
	gboolean _tmp103_;
	gboolean _tmp105_;
	gboolean _tmp111_;
	const gchar* _tmp112_;
	ValaCodeContext* _tmp113_;
	gboolean _tmp114_;
	ValaCodeContext* _tmp115_;
	const gchar* _tmp116_;
	ValaCodeContext* _tmp117_;
	gboolean _tmp118_;
	gchar** _tmp119_;
	gint _tmp119__length1;
	gint glib_major;
	gint glib_minor;
	gboolean _tmp132_ = FALSE;
	const gchar* _tmp133_;
	gboolean _tmp136_;
	ValaCodeContext* _tmp137_;
	gint _tmp138_;
	ValaCodeContext* _tmp139_;
	gint _tmp140_;
	ValaCodeContext* _tmp141_;
	gint _tmp142_;
	gint _tmp143_;
	gboolean _tmp153_;
	gchar** _tmp156_;
	gint _tmp156__length1;
	gchar** _tmp161_;
	gint _tmp161__length1;
	gboolean _tmp172_ = FALSE;
	ValaCodeContext* _tmp173_;
	ValaReport* _tmp174_;
	ValaReport* _tmp175_;
	gint _tmp176_ = 0;
	gboolean _tmp184_;
	ValaCodeContext* _tmp186_;
	ValaGDBusServerModule* _tmp187_;
	ValaGDBusServerModule* _tmp188_;
	gboolean has_c_files;
	gchar** _tmp189_;
	gint _tmp189__length1;
	gboolean _tmp197_ = FALSE;
	ValaCodeContext* _tmp198_;
	ValaReport* _tmp199_;
	ValaReport* _tmp200_;
	gint _tmp201_ = 0;
	gboolean _tmp209_;
	ValaParser* _tmp211_;
	ValaParser* parser;
	ValaParser* _tmp212_;
	ValaCodeContext* _tmp213_;
	ValaGenieParser* _tmp214_;
	ValaGenieParser* genie_parser;
	ValaGenieParser* _tmp215_;
	ValaCodeContext* _tmp216_;
	ValaGirParser* _tmp217_;
	ValaGirParser* gir_parser;
	ValaGirParser* _tmp218_;
	ValaCodeContext* _tmp219_;
	gboolean _tmp220_ = FALSE;
	ValaCodeContext* _tmp221_;
	ValaReport* _tmp222_;
	ValaReport* _tmp223_;
	gint _tmp224_ = 0;
	gboolean _tmp232_;
	const gchar* _tmp234_;
	ValaCodeContext* _tmp240_;
	gboolean _tmp241_ = FALSE;
	ValaCodeContext* _tmp242_;
	ValaReport* _tmp243_;
	ValaReport* _tmp244_;
	gint _tmp245_ = 0;
	gboolean _tmp253_;
	gboolean _tmp255_ = FALSE;
	gboolean _tmp256_ = FALSE;
	gboolean _tmp257_;
	gboolean _tmp259_;
	gboolean _tmp261_;
	const gchar* _tmp268_;
	gboolean _tmp273_ = FALSE;
	ValaCodeContext* _tmp274_;
	ValaReport* _tmp275_;
	ValaReport* _tmp276_;
	gint _tmp277_ = 0;
	gboolean _tmp285_;
	ValaCodeContext* _tmp287_;
	ValaCodeGenerator* _tmp288_;
	ValaCodeGenerator* _tmp289_;
	ValaCodeContext* _tmp290_;
	gboolean _tmp291_ = FALSE;
	ValaCodeContext* _tmp292_;
	ValaReport* _tmp293_;
	ValaReport* _tmp294_;
	gint _tmp295_ = 0;
	gboolean _tmp303_;
	gboolean _tmp305_ = FALSE;
	const gchar* _tmp306_;
	gboolean _tmp308_;
	const gchar* _tmp311_;
	const gchar* _tmp364_;
	const gchar* _tmp379_;
	const gchar* _tmp404_;
	gboolean _tmp407_;
	gint _tmp425_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp4_ = vala_compiler_ccode_only;
	if (!_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = vala_compiler_compile_only;
		_tmp3_ = !_tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = vala_compiler_output;
		_tmp2_ = _tmp7_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gint _tmp11_ = 0;
		_tmp9_ = vala_compiler_sources;
		_tmp9__length1 = _vala_array_length (vala_compiler_sources);
		_tmp10_ = _tmp9_[0];
		_tmp11_ = string_last_index_of_char (_tmp10_, (gunichar) '.', 0);
		if (_tmp11_ != (-1)) {
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			gint _tmp14_ = 0;
			gint dot;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			gint _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_ = NULL;
			_tmp12_ = vala_compiler_sources;
			_tmp12__length1 = _vala_array_length (vala_compiler_sources);
			_tmp13_ = _tmp12_[0];
			_tmp14_ = string_last_index_of_char (_tmp13_, (gunichar) '.', 0);
			dot = _tmp14_;
			_tmp15_ = vala_compiler_sources;
			_tmp15__length1 = _vala_array_length (vala_compiler_sources);
			_tmp16_ = _tmp15_[0];
			_tmp17_ = dot;
			_tmp18_ = string_substring (_tmp16_, (glong) 0, (glong) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_path_get_basename (_tmp19_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp20_;
			_g_free0 (_tmp19_);
		}
	}
	_tmp21_ = self->priv->context;
	_tmp22_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp21_, !_tmp22_);
	_tmp23_ = self->priv->context;
	_tmp24_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp23_, _tmp24_);
	_tmp25_ = self->priv->context;
	_tmp26_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->context;
	_tmp28_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp27_, _tmp28_);
	_tmp29_ = self->priv->context;
	_tmp30_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp29_, _tmp30_);
	_tmp31_ = self->priv->context;
	_tmp32_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->context;
	_tmp34_ = vala_code_context_get_report (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp35_, !_tmp36_);
	_tmp37_ = self->priv->context;
	_tmp38_ = vala_code_context_get_report (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp39_, !_tmp40_);
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp43_, !_tmp44_);
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp45_, _tmp46_);
	_tmp47_ = self->priv->context;
	_tmp48_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp47_, _tmp48_);
	_tmp49_ = self->priv->context;
	_tmp50_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp49_, _tmp50_);
	_tmp52_ = vala_compiler_header_filename;
	if (_tmp52_ == NULL) {
		gboolean _tmp53_;
		_tmp53_ = vala_compiler_use_header;
		_tmp51_ = _tmp53_;
	} else {
		_tmp51_ = FALSE;
	}
	_tmp54_ = _tmp51_;
	if (_tmp54_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp55_ = self->priv->context;
	_tmp56_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->context;
	_tmp58_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp57_, _tmp58_);
	_tmp59_ = self->priv->context;
	_tmp60_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp59_, _tmp60_);
	_tmp61_ = self->priv->context;
	_tmp62_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp61_, _tmp62_);
	_tmp63_ = self->priv->context;
	_tmp64_ = vala_compiler_output;
	vala_code_context_set_output (_tmp63_, _tmp64_);
	_tmp65_ = vala_compiler_basedir;
	if (_tmp65_ == NULL) {
		ValaCodeContext* _tmp66_;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_;
		_tmp66_ = self->priv->context;
		_tmp67_ = vala_code_context_realpath (".");
		_tmp68_ = _tmp67_;
		vala_code_context_set_basedir (_tmp66_, _tmp68_);
		_g_free0 (_tmp68_);
	} else {
		ValaCodeContext* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_;
		_tmp69_ = self->priv->context;
		_tmp70_ = vala_compiler_basedir;
		_tmp71_ = vala_code_context_realpath (_tmp70_);
		_tmp72_ = _tmp71_;
		vala_code_context_set_basedir (_tmp69_, _tmp72_);
		_g_free0 (_tmp72_);
	}
	_tmp73_ = vala_compiler_directory;
	if (_tmp73_ != NULL) {
		ValaCodeContext* _tmp74_;
		const gchar* _tmp75_;
		gchar* _tmp76_ = NULL;
		gchar* _tmp77_;
		_tmp74_ = self->priv->context;
		_tmp75_ = vala_compiler_directory;
		_tmp76_ = vala_code_context_realpath (_tmp75_);
		_tmp77_ = _tmp76_;
		vala_code_context_set_directory (_tmp74_, _tmp77_);
		_g_free0 (_tmp77_);
	} else {
		ValaCodeContext* _tmp78_;
		ValaCodeContext* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		_tmp78_ = self->priv->context;
		_tmp79_ = self->priv->context;
		_tmp80_ = vala_code_context_get_basedir (_tmp79_);
		_tmp81_ = _tmp80_;
		vala_code_context_set_directory (_tmp78_, _tmp81_);
	}
	_tmp82_ = self->priv->context;
	_tmp83_ = vala_compiler_vapi_directories;
	_tmp83__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp84_ = (_tmp83_ != NULL) ? _vala_array_dup1 (_tmp83_, _tmp83__length1) : ((gpointer) _tmp83_);
	_tmp84__length1 = _tmp83__length1;
	_tmp82_->vapi_directories = (_vala_array_free (_tmp82_->vapi_directories, _tmp82_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp82_->vapi_directories = _tmp84_;
	_tmp82_->vapi_directories_length1 = _tmp84__length1;
	_tmp85_ = self->priv->context;
	_tmp86_ = vala_compiler_gir_directories;
	_tmp86__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp87_ = (_tmp86_ != NULL) ? _vala_array_dup2 (_tmp86_, _tmp86__length1) : ((gpointer) _tmp86_);
	_tmp87__length1 = _tmp86__length1;
	_tmp85_->gir_directories = (_vala_array_free (_tmp85_->gir_directories, _tmp85_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp85_->gir_directories = _tmp87_;
	_tmp85_->gir_directories_length1 = _tmp87__length1;
	_tmp88_ = self->priv->context;
	_tmp89_ = vala_compiler_metadata_directories;
	_tmp89__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp90_ = (_tmp89_ != NULL) ? _vala_array_dup3 (_tmp89_, _tmp89__length1) : ((gpointer) _tmp89_);
	_tmp90__length1 = _tmp89__length1;
	_tmp88_->metadata_directories = (_vala_array_free (_tmp88_->metadata_directories, _tmp88_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp88_->metadata_directories = _tmp90_;
	_tmp88_->metadata_directories_length1 = _tmp90__length1;
	_tmp91_ = self->priv->context;
	_tmp92_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp91_, _tmp92_);
	_tmp93_ = self->priv->context;
	_tmp94_ = vala_compiler_thread;
	vala_code_context_set_thread (_tmp93_, _tmp94_);
	_tmp95_ = self->priv->context;
	_tmp96_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp95_, _tmp96_);
	_tmp97_ = self->priv->context;
	_tmp98_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp97_, _tmp98_);
	_tmp101_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp101_, "gobject-2.0") == 0) {
		_tmp100_ = TRUE;
	} else {
		const gchar* _tmp102_;
		_tmp102_ = vala_compiler_profile;
		_tmp100_ = g_strcmp0 (_tmp102_, "gobject") == 0;
	}
	_tmp103_ = _tmp100_;
	if (_tmp103_) {
		_tmp99_ = TRUE;
	} else {
		const gchar* _tmp104_;
		_tmp104_ = vala_compiler_profile;
		_tmp99_ = _tmp104_ == NULL;
	}
	_tmp105_ = _tmp99_;
	if (_tmp105_) {
		ValaCodeContext* _tmp106_;
		ValaCodeContext* _tmp107_;
		_tmp106_ = self->priv->context;
		vala_code_context_set_profile (_tmp106_, VALA_PROFILE_GOBJECT);
		_tmp107_ = self->priv->context;
		vala_code_context_add_define (_tmp107_, "GOBJECT");
	} else {
		const gchar* _tmp108_;
		gchar* _tmp109_ = NULL;
		gchar* _tmp110_;
		_tmp108_ = vala_compiler_profile;
		_tmp109_ = g_strdup_printf ("Unknown profile %s", _tmp108_);
		_tmp110_ = _tmp109_;
		vala_report_error (NULL, _tmp110_);
		_g_free0 (_tmp110_);
	}
	_tmp111_ = vala_compiler_nostdpkg;
	_tmp112_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp111_ | (_tmp112_ != NULL);
	_tmp113_ = self->priv->context;
	_tmp114_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp113_, _tmp114_);
	_tmp115_ = self->priv->context;
	_tmp116_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp115_, _tmp116_);
	_tmp117_ = self->priv->context;
	_tmp118_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp117_, _tmp118_);
	_tmp119_ = vala_compiler_defines;
	_tmp119__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp119_ != NULL) {
		gchar** _tmp120_;
		gint _tmp120__length1;
		_tmp120_ = vala_compiler_defines;
		_tmp120__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp120_;
			define_collection_length1 = _tmp120__length1;
			for (define_it = 0; define_it < _tmp120__length1; define_it = define_it + 1) {
				gchar* _tmp121_;
				gchar* define = NULL;
				_tmp121_ = g_strdup (define_collection[define_it]);
				define = _tmp121_;
				{
					ValaCodeContext* _tmp122_;
					const gchar* _tmp123_;
					_tmp122_ = self->priv->context;
					_tmp123_ = define;
					vala_code_context_add_define (_tmp122_, _tmp123_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i;
		i = 2;
		{
			gboolean _tmp124_;
			_tmp124_ = TRUE;
			while (TRUE) {
				gboolean _tmp125_;
				gint _tmp127_;
				ValaCodeContext* _tmp128_;
				gint _tmp129_;
				gchar* _tmp130_ = NULL;
				gchar* _tmp131_;
				_tmp125_ = _tmp124_;
				if (!_tmp125_) {
					gint _tmp126_;
					_tmp126_ = i;
					i = _tmp126_ + 2;
				}
				_tmp124_ = FALSE;
				_tmp127_ = i;
				if (!(_tmp127_ <= 20)) {
					break;
				}
				_tmp128_ = self->priv->context;
				_tmp129_ = i;
				_tmp130_ = g_strdup_printf ("VALA_0_%d", _tmp129_);
				_tmp131_ = _tmp130_;
				vala_code_context_add_define (_tmp128_, _tmp131_);
				_g_free0 (_tmp131_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 18;
	_tmp133_ = vala_compiler_target_glib;
	if (_tmp133_ != NULL) {
		const gchar* _tmp134_;
		gint _tmp135_ = 0;
		_tmp134_ = vala_compiler_target_glib;
		_tmp135_ = sscanf (_tmp134_, "%d.%d", &glib_major, &glib_minor);
		_tmp132_ = _tmp135_ != 2;
	} else {
		_tmp132_ = FALSE;
	}
	_tmp136_ = _tmp132_;
	if (_tmp136_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp137_ = self->priv->context;
	_tmp138_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp137_, _tmp138_);
	_tmp139_ = self->priv->context;
	_tmp140_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp139_, _tmp140_);
	_tmp141_ = self->priv->context;
	_tmp142_ = vala_code_context_get_target_glib_major (_tmp141_);
	_tmp143_ = _tmp142_;
	if (_tmp143_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i;
		i = 16;
		{
			gboolean _tmp144_;
			_tmp144_ = TRUE;
			while (TRUE) {
				gboolean _tmp145_;
				gint _tmp147_;
				gint _tmp148_;
				ValaCodeContext* _tmp149_;
				gint _tmp150_;
				gchar* _tmp151_ = NULL;
				gchar* _tmp152_;
				_tmp145_ = _tmp144_;
				if (!_tmp145_) {
					gint _tmp146_;
					_tmp146_ = i;
					i = _tmp146_ + 2;
				}
				_tmp144_ = FALSE;
				_tmp147_ = i;
				_tmp148_ = glib_minor;
				if (!(_tmp147_ <= _tmp148_)) {
					break;
				}
				_tmp149_ = self->priv->context;
				_tmp150_ = i;
				_tmp151_ = g_strdup_printf ("GLIB_2_%d", _tmp150_);
				_tmp152_ = _tmp151_;
				vala_code_context_add_define (_tmp149_, _tmp152_);
				_g_free0 (_tmp152_);
			}
		}
	}
	_tmp153_ = vala_compiler_nostdpkg;
	if (!_tmp153_) {
		ValaCodeContext* _tmp154_;
		ValaCodeContext* _tmp155_;
		_tmp154_ = self->priv->context;
		vala_code_context_add_external_package (_tmp154_, "glib-2.0");
		_tmp155_ = self->priv->context;
		vala_code_context_add_external_package (_tmp155_, "gobject-2.0");
	}
	_tmp156_ = vala_compiler_packages;
	_tmp156__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp156_ != NULL) {
		gchar** _tmp157_;
		gint _tmp157__length1;
		_tmp157_ = vala_compiler_packages;
		_tmp157__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp157_;
			package_collection_length1 = _tmp157__length1;
			for (package_it = 0; package_it < _tmp157__length1; package_it = package_it + 1) {
				gchar* _tmp158_;
				gchar* package = NULL;
				_tmp158_ = g_strdup (package_collection[package_it]);
				package = _tmp158_;
				{
					ValaCodeContext* _tmp159_;
					const gchar* _tmp160_;
					_tmp159_ = self->priv->context;
					_tmp160_ = package;
					vala_code_context_add_external_package (_tmp159_, _tmp160_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp161_ = vala_compiler_fast_vapis;
	_tmp161__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp161_ != NULL) {
		gchar** _tmp162_;
		gint _tmp162__length1;
		ValaCodeContext* _tmp171_;
		_tmp162_ = vala_compiler_fast_vapis;
		_tmp162__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp162_;
			vapi_collection_length1 = _tmp162__length1;
			for (vapi_it = 0; vapi_it < _tmp162__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp163_;
				gchar* vapi = NULL;
				_tmp163_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp163_;
				{
					const gchar* _tmp164_;
					gchar* _tmp165_ = NULL;
					gchar* rpath;
					ValaCodeContext* _tmp166_;
					const gchar* _tmp167_;
					ValaSourceFile* _tmp168_;
					ValaSourceFile* source_file;
					ValaCodeContext* _tmp169_;
					ValaSourceFile* _tmp170_;
					_tmp164_ = vapi;
					_tmp165_ = vala_code_context_realpath (_tmp164_);
					rpath = _tmp165_;
					_tmp166_ = self->priv->context;
					_tmp167_ = rpath;
					_tmp168_ = vala_source_file_new (_tmp166_, VALA_SOURCE_FILE_TYPE_FAST, _tmp167_, NULL, FALSE);
					source_file = _tmp168_;
					_tmp169_ = self->priv->context;
					_tmp170_ = source_file;
					vala_code_context_add_source_file (_tmp169_, _tmp170_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp171_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp171_, TRUE);
	}
	_tmp173_ = self->priv->context;
	_tmp174_ = vala_code_context_get_report (_tmp173_);
	_tmp175_ = _tmp174_;
	_tmp176_ = vala_report_get_errors (_tmp175_);
	if (_tmp176_ > 0) {
		_tmp172_ = TRUE;
	} else {
		gboolean _tmp177_ = FALSE;
		gboolean _tmp178_;
		gboolean _tmp183_;
		_tmp178_ = vala_compiler_fatal_warnings;
		if (_tmp178_) {
			ValaCodeContext* _tmp179_;
			ValaReport* _tmp180_;
			ValaReport* _tmp181_;
			gint _tmp182_ = 0;
			_tmp179_ = self->priv->context;
			_tmp180_ = vala_code_context_get_report (_tmp179_);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_report_get_warnings (_tmp181_);
			_tmp177_ = _tmp182_ > 0;
		} else {
			_tmp177_ = FALSE;
		}
		_tmp183_ = _tmp177_;
		_tmp172_ = _tmp183_;
	}
	_tmp184_ = _tmp172_;
	if (_tmp184_) {
		gint _tmp185_ = 0;
		_tmp185_ = vala_compiler_quit (self);
		result = _tmp185_;
		return result;
	}
	_tmp186_ = self->priv->context;
	_tmp187_ = vala_gd_bus_server_module_new ();
	_tmp188_ = _tmp187_;
	vala_code_context_set_codegen (_tmp186_, (ValaCodeGenerator*) _tmp188_);
	_vala_code_visitor_unref0 (_tmp188_);
	has_c_files = FALSE;
	_tmp189_ = vala_compiler_sources;
	_tmp189__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp189_;
		source_collection_length1 = _tmp189__length1;
		for (source_it = 0; source_it < _tmp189__length1; source_it = source_it + 1) {
			gchar* _tmp190_;
			gchar* source = NULL;
			_tmp190_ = g_strdup (source_collection[source_it]);
			source = _tmp190_;
			{
				ValaCodeContext* _tmp191_;
				const gchar* _tmp192_;
				gboolean _tmp193_;
				gboolean _tmp194_ = FALSE;
				_tmp191_ = self->priv->context;
				_tmp192_ = source;
				_tmp193_ = vala_compiler_run_output;
				_tmp194_ = vala_code_context_add_source_filename (_tmp191_, _tmp192_, _tmp193_, TRUE);
				if (_tmp194_) {
					const gchar* _tmp195_;
					gboolean _tmp196_ = FALSE;
					_tmp195_ = source;
					_tmp196_ = g_str_has_suffix (_tmp195_, ".c");
					if (_tmp196_) {
						has_c_files = TRUE;
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp198_ = self->priv->context;
	_tmp199_ = vala_code_context_get_report (_tmp198_);
	_tmp200_ = _tmp199_;
	_tmp201_ = vala_report_get_errors (_tmp200_);
	if (_tmp201_ > 0) {
		_tmp197_ = TRUE;
	} else {
		gboolean _tmp202_ = FALSE;
		gboolean _tmp203_;
		gboolean _tmp208_;
		_tmp203_ = vala_compiler_fatal_warnings;
		if (_tmp203_) {
			ValaCodeContext* _tmp204_;
			ValaReport* _tmp205_;
			ValaReport* _tmp206_;
			gint _tmp207_ = 0;
			_tmp204_ = self->priv->context;
			_tmp205_ = vala_code_context_get_report (_tmp204_);
			_tmp206_ = _tmp205_;
			_tmp207_ = vala_report_get_warnings (_tmp206_);
			_tmp202_ = _tmp207_ > 0;
		} else {
			_tmp202_ = FALSE;
		}
		_tmp208_ = _tmp202_;
		_tmp197_ = _tmp208_;
	}
	_tmp209_ = _tmp197_;
	if (_tmp209_) {
		gint _tmp210_ = 0;
		_tmp210_ = vala_compiler_quit (self);
		result = _tmp210_;
		return result;
	}
	_tmp211_ = vala_parser_new ();
	parser = _tmp211_;
	_tmp212_ = parser;
	_tmp213_ = self->priv->context;
	vala_parser_parse (_tmp212_, _tmp213_);
	_tmp214_ = vala_genie_parser_new ();
	genie_parser = _tmp214_;
	_tmp215_ = genie_parser;
	_tmp216_ = self->priv->context;
	vala_genie_parser_parse (_tmp215_, _tmp216_);
	_tmp217_ = vala_gir_parser_new ();
	gir_parser = _tmp217_;
	_tmp218_ = gir_parser;
	_tmp219_ = self->priv->context;
	vala_gir_parser_parse (_tmp218_, _tmp219_);
	_tmp221_ = self->priv->context;
	_tmp222_ = vala_code_context_get_report (_tmp221_);
	_tmp223_ = _tmp222_;
	_tmp224_ = vala_report_get_errors (_tmp223_);
	if (_tmp224_ > 0) {
		_tmp220_ = TRUE;
	} else {
		gboolean _tmp225_ = FALSE;
		gboolean _tmp226_;
		gboolean _tmp231_;
		_tmp226_ = vala_compiler_fatal_warnings;
		if (_tmp226_) {
			ValaCodeContext* _tmp227_;
			ValaReport* _tmp228_;
			ValaReport* _tmp229_;
			gint _tmp230_ = 0;
			_tmp227_ = self->priv->context;
			_tmp228_ = vala_code_context_get_report (_tmp227_);
			_tmp229_ = _tmp228_;
			_tmp230_ = vala_report_get_warnings (_tmp229_);
			_tmp225_ = _tmp230_ > 0;
		} else {
			_tmp225_ = FALSE;
		}
		_tmp231_ = _tmp225_;
		_tmp220_ = _tmp231_;
	}
	_tmp232_ = _tmp220_;
	if (_tmp232_) {
		gint _tmp233_ = 0;
		_tmp233_ = vala_compiler_quit (self);
		result = _tmp233_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp234_ = vala_compiler_fast_vapi_filename;
	if (_tmp234_ != NULL) {
		ValaCodeWriter* _tmp235_;
		ValaCodeWriter* interface_writer;
		ValaCodeWriter* _tmp236_;
		ValaCodeContext* _tmp237_;
		const gchar* _tmp238_;
		gint _tmp239_ = 0;
		_tmp235_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp235_;
		_tmp236_ = interface_writer;
		_tmp237_ = self->priv->context;
		_tmp238_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp236_, _tmp237_, _tmp238_);
		_tmp239_ = vala_compiler_quit (self);
		result = _tmp239_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp240_ = self->priv->context;
	vala_code_context_check (_tmp240_);
	_tmp242_ = self->priv->context;
	_tmp243_ = vala_code_context_get_report (_tmp242_);
	_tmp244_ = _tmp243_;
	_tmp245_ = vala_report_get_errors (_tmp244_);
	if (_tmp245_ > 0) {
		_tmp241_ = TRUE;
	} else {
		gboolean _tmp246_ = FALSE;
		gboolean _tmp247_;
		gboolean _tmp252_;
		_tmp247_ = vala_compiler_fatal_warnings;
		if (_tmp247_) {
			ValaCodeContext* _tmp248_;
			ValaReport* _tmp249_;
			ValaReport* _tmp250_;
			gint _tmp251_ = 0;
			_tmp248_ = self->priv->context;
			_tmp249_ = vala_code_context_get_report (_tmp248_);
			_tmp250_ = _tmp249_;
			_tmp251_ = vala_report_get_warnings (_tmp250_);
			_tmp246_ = _tmp251_ > 0;
		} else {
			_tmp246_ = FALSE;
		}
		_tmp252_ = _tmp246_;
		_tmp241_ = _tmp252_;
	}
	_tmp253_ = _tmp241_;
	if (_tmp253_) {
		gint _tmp254_ = 0;
		_tmp254_ = vala_compiler_quit (self);
		result = _tmp254_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp257_ = vala_compiler_ccode_only;
	if (!_tmp257_) {
		gboolean _tmp258_;
		_tmp258_ = vala_compiler_compile_only;
		_tmp256_ = !_tmp258_;
	} else {
		_tmp256_ = FALSE;
	}
	_tmp259_ = _tmp256_;
	if (_tmp259_) {
		const gchar* _tmp260_;
		_tmp260_ = vala_compiler_library;
		_tmp255_ = _tmp260_ == NULL;
	} else {
		_tmp255_ = FALSE;
	}
	_tmp261_ = _tmp255_;
	if (_tmp261_) {
		gboolean _tmp262_ = FALSE;
		gboolean _tmp263_;
		gboolean _tmp267_;
		_tmp263_ = has_c_files;
		if (!_tmp263_) {
			ValaCodeContext* _tmp264_;
			ValaMethod* _tmp265_;
			ValaMethod* _tmp266_;
			_tmp264_ = self->priv->context;
			_tmp265_ = vala_code_context_get_entry_point (_tmp264_);
			_tmp266_ = _tmp265_;
			_tmp262_ = _tmp266_ == NULL;
		} else {
			_tmp262_ = FALSE;
		}
		_tmp267_ = _tmp262_;
		if (_tmp267_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp268_ = vala_compiler_dump_tree;
	if (_tmp268_ != NULL) {
		ValaCodeWriter* _tmp269_;
		ValaCodeWriter* code_writer;
		ValaCodeWriter* _tmp270_;
		ValaCodeContext* _tmp271_;
		const gchar* _tmp272_;
		_tmp269_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp269_;
		_tmp270_ = code_writer;
		_tmp271_ = self->priv->context;
		_tmp272_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp270_, _tmp271_, _tmp272_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp274_ = self->priv->context;
	_tmp275_ = vala_code_context_get_report (_tmp274_);
	_tmp276_ = _tmp275_;
	_tmp277_ = vala_report_get_errors (_tmp276_);
	if (_tmp277_ > 0) {
		_tmp273_ = TRUE;
	} else {
		gboolean _tmp278_ = FALSE;
		gboolean _tmp279_;
		gboolean _tmp284_;
		_tmp279_ = vala_compiler_fatal_warnings;
		if (_tmp279_) {
			ValaCodeContext* _tmp280_;
			ValaReport* _tmp281_;
			ValaReport* _tmp282_;
			gint _tmp283_ = 0;
			_tmp280_ = self->priv->context;
			_tmp281_ = vala_code_context_get_report (_tmp280_);
			_tmp282_ = _tmp281_;
			_tmp283_ = vala_report_get_warnings (_tmp282_);
			_tmp278_ = _tmp283_ > 0;
		} else {
			_tmp278_ = FALSE;
		}
		_tmp284_ = _tmp278_;
		_tmp273_ = _tmp284_;
	}
	_tmp285_ = _tmp273_;
	if (_tmp285_) {
		gint _tmp286_ = 0;
		_tmp286_ = vala_compiler_quit (self);
		result = _tmp286_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp287_ = self->priv->context;
	_tmp288_ = vala_code_context_get_codegen (_tmp287_);
	_tmp289_ = _tmp288_;
	_tmp290_ = self->priv->context;
	vala_code_generator_emit (_tmp289_, _tmp290_);
	_tmp292_ = self->priv->context;
	_tmp293_ = vala_code_context_get_report (_tmp292_);
	_tmp294_ = _tmp293_;
	_tmp295_ = vala_report_get_errors (_tmp294_);
	if (_tmp295_ > 0) {
		_tmp291_ = TRUE;
	} else {
		gboolean _tmp296_ = FALSE;
		gboolean _tmp297_;
		gboolean _tmp302_;
		_tmp297_ = vala_compiler_fatal_warnings;
		if (_tmp297_) {
			ValaCodeContext* _tmp298_;
			ValaReport* _tmp299_;
			ValaReport* _tmp300_;
			gint _tmp301_ = 0;
			_tmp298_ = self->priv->context;
			_tmp299_ = vala_code_context_get_report (_tmp298_);
			_tmp300_ = _tmp299_;
			_tmp301_ = vala_report_get_warnings (_tmp300_);
			_tmp296_ = _tmp301_ > 0;
		} else {
			_tmp296_ = FALSE;
		}
		_tmp302_ = _tmp296_;
		_tmp291_ = _tmp302_;
	}
	_tmp303_ = _tmp291_;
	if (_tmp303_) {
		gint _tmp304_ = 0;
		_tmp304_ = vala_compiler_quit (self);
		result = _tmp304_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp306_ = vala_compiler_vapi_filename;
	if (_tmp306_ == NULL) {
		const gchar* _tmp307_;
		_tmp307_ = vala_compiler_library;
		_tmp305_ = _tmp307_ != NULL;
	} else {
		_tmp305_ = FALSE;
	}
	_tmp308_ = _tmp305_;
	if (_tmp308_) {
		const gchar* _tmp309_;
		gchar* _tmp310_ = NULL;
		_tmp309_ = vala_compiler_library;
		_tmp310_ = g_strdup_printf ("%s.vapi", _tmp309_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp310_;
	}
	_tmp311_ = vala_compiler_library;
	if (_tmp311_ != NULL) {
		const gchar* _tmp312_;
		_tmp312_ = vala_compiler_gir;
		if (_tmp312_ != NULL) {
			const gchar* _tmp313_;
			gint _tmp314_;
			gint _tmp315_;
			glong gir_len;
			const gchar* _tmp316_;
			gint _tmp317_ = 0;
			gint last_hyphen;
			gboolean _tmp318_ = FALSE;
			gint _tmp319_;
			gboolean _tmp322_;
			_tmp313_ = vala_compiler_gir;
			_tmp314_ = strlen (_tmp313_);
			_tmp315_ = _tmp314_;
			gir_len = (glong) _tmp315_;
			_tmp316_ = vala_compiler_gir;
			_tmp317_ = string_last_index_of_char (_tmp316_, (gunichar) '-', 0);
			last_hyphen = _tmp317_;
			_tmp319_ = last_hyphen;
			if (_tmp319_ == (-1)) {
				_tmp318_ = TRUE;
			} else {
				const gchar* _tmp320_;
				gboolean _tmp321_ = FALSE;
				_tmp320_ = vala_compiler_gir;
				_tmp321_ = g_str_has_suffix (_tmp320_, ".gir");
				_tmp318_ = !_tmp321_;
			}
			_tmp322_ = _tmp318_;
			if (_tmp322_) {
				const gchar* _tmp323_;
				gchar* _tmp324_ = NULL;
				gchar* _tmp325_;
				_tmp323_ = vala_compiler_gir;
				_tmp324_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp323_);
				_tmp325_ = _tmp324_;
				vala_report_error (NULL, _tmp325_);
				_g_free0 (_tmp325_);
			} else {
				const gchar* _tmp326_;
				gint _tmp327_;
				gchar* _tmp328_ = NULL;
				gchar* gir_namespace;
				const gchar* _tmp329_;
				gint _tmp330_;
				glong _tmp331_;
				gint _tmp332_;
				gchar* _tmp333_ = NULL;
				gchar* gir_version;
				const gchar* _tmp334_;
				gboolean _tmp335_ = FALSE;
				gboolean _tmp336_ = FALSE;
				gboolean _tmp337_ = FALSE;
				const gchar* _tmp338_;
				gboolean _tmp340_;
				gboolean _tmp344_;
				gboolean _tmp347_;
				_tmp326_ = vala_compiler_gir;
				_tmp327_ = last_hyphen;
				_tmp328_ = string_substring (_tmp326_, (glong) 0, (glong) _tmp327_);
				gir_namespace = _tmp328_;
				_tmp329_ = vala_compiler_gir;
				_tmp330_ = last_hyphen;
				_tmp331_ = gir_len;
				_tmp332_ = last_hyphen;
				_tmp333_ = string_substring (_tmp329_, (glong) (_tmp330_ + 1), (_tmp331_ - _tmp332_) - 5);
				gir_version = _tmp333_;
				_tmp334_ = gir_version;
				g_strcanon (_tmp334_, "0123456789.", '?');
				_tmp338_ = gir_namespace;
				if (g_strcmp0 (_tmp338_, "") == 0) {
					_tmp337_ = TRUE;
				} else {
					const gchar* _tmp339_;
					_tmp339_ = gir_version;
					_tmp337_ = g_strcmp0 (_tmp339_, "") == 0;
				}
				_tmp340_ = _tmp337_;
				if (_tmp340_) {
					_tmp336_ = TRUE;
				} else {
					const gchar* _tmp341_;
					gchar _tmp342_ = '\0';
					gboolean _tmp343_ = FALSE;
					_tmp341_ = gir_version;
					_tmp342_ = string_get (_tmp341_, (glong) 0);
					_tmp343_ = g_ascii_isdigit (_tmp342_);
					_tmp336_ = !_tmp343_;
				}
				_tmp344_ = _tmp336_;
				if (_tmp344_) {
					_tmp335_ = TRUE;
				} else {
					const gchar* _tmp345_;
					gboolean _tmp346_ = FALSE;
					_tmp345_ = gir_version;
					_tmp346_ = string_contains (_tmp345_, "?");
					_tmp335_ = _tmp346_;
				}
				_tmp347_ = _tmp335_;
				if (_tmp347_) {
					const gchar* _tmp348_;
					gchar* _tmp349_ = NULL;
					gchar* _tmp350_;
					_tmp348_ = vala_compiler_gir;
					_tmp349_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp348_);
					_tmp350_ = _tmp349_;
					vala_report_error (NULL, _tmp350_);
					_g_free0 (_tmp350_);
				} else {
					ValaGIRWriter* _tmp351_;
					ValaGIRWriter* gir_writer;
					gchar* _tmp352_;
					gchar* gir_directory;
					const gchar* _tmp353_;
					ValaGIRWriter* _tmp358_;
					ValaCodeContext* _tmp359_;
					const gchar* _tmp360_;
					const gchar* _tmp361_;
					const gchar* _tmp362_;
					const gchar* _tmp363_;
					_tmp351_ = vala_gir_writer_new ();
					gir_writer = _tmp351_;
					_tmp352_ = g_strdup (".");
					gir_directory = _tmp352_;
					_tmp353_ = vala_compiler_directory;
					if (_tmp353_ != NULL) {
						ValaCodeContext* _tmp354_;
						const gchar* _tmp355_;
						const gchar* _tmp356_;
						gchar* _tmp357_;
						_tmp354_ = self->priv->context;
						_tmp355_ = vala_code_context_get_directory (_tmp354_);
						_tmp356_ = _tmp355_;
						_tmp357_ = g_strdup (_tmp356_);
						_g_free0 (gir_directory);
						gir_directory = _tmp357_;
					}
					_tmp358_ = gir_writer;
					_tmp359_ = self->priv->context;
					_tmp360_ = gir_directory;
					_tmp361_ = gir_namespace;
					_tmp362_ = gir_version;
					_tmp363_ = vala_compiler_library;
					vala_gir_writer_write_file (_tmp358_, _tmp359_, _tmp360_, _tmp361_, _tmp362_, _tmp363_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp364_ = vala_compiler_vapi_filename;
	if (_tmp364_ != NULL) {
		ValaCodeWriter* _tmp365_;
		ValaCodeWriter* interface_writer;
		gboolean _tmp366_ = FALSE;
		const gchar* _tmp367_;
		gboolean _tmp370_;
		ValaCodeWriter* _tmp376_;
		ValaCodeContext* _tmp377_;
		const gchar* _tmp378_;
		_tmp365_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp365_;
		_tmp367_ = vala_compiler_directory;
		if (_tmp367_ != NULL) {
			const gchar* _tmp368_;
			gboolean _tmp369_ = FALSE;
			_tmp368_ = vala_compiler_vapi_filename;
			_tmp369_ = g_path_is_absolute (_tmp368_);
			_tmp366_ = !_tmp369_;
		} else {
			_tmp366_ = FALSE;
		}
		_tmp370_ = _tmp366_;
		if (_tmp370_) {
			ValaCodeContext* _tmp371_;
			const gchar* _tmp372_;
			const gchar* _tmp373_;
			const gchar* _tmp374_;
			gchar* _tmp375_ = NULL;
			_tmp371_ = self->priv->context;
			_tmp372_ = vala_code_context_get_directory (_tmp371_);
			_tmp373_ = _tmp372_;
			_tmp374_ = vala_compiler_vapi_filename;
			_tmp375_ = g_strdup_printf ("%s%c%s", _tmp373_, (gint) G_DIR_SEPARATOR, _tmp374_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp375_;
		}
		_tmp376_ = interface_writer;
		_tmp377_ = self->priv->context;
		_tmp378_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp376_, _tmp377_, _tmp378_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp379_ = vala_compiler_internal_vapi_filename;
	if (_tmp379_ != NULL) {
		gboolean _tmp380_ = FALSE;
		const gchar* _tmp381_;
		gboolean _tmp383_;
		ValaCodeWriter* _tmp385_;
		ValaCodeWriter* interface_writer;
		ValaCodeWriter* _tmp386_;
		const gchar* _tmp387_;
		const gchar* _tmp388_;
		const gchar* _tmp389_;
		gchar* _tmp390_;
		gchar* vapi_filename;
		gboolean _tmp391_ = FALSE;
		const gchar* _tmp392_;
		gboolean _tmp395_;
		ValaCodeWriter* _tmp401_;
		ValaCodeContext* _tmp402_;
		const gchar* _tmp403_;
		_tmp381_ = vala_compiler_internal_header_filename;
		if (_tmp381_ == NULL) {
			_tmp380_ = TRUE;
		} else {
			const gchar* _tmp382_;
			_tmp382_ = vala_compiler_header_filename;
			_tmp380_ = _tmp382_ == NULL;
		}
		_tmp383_ = _tmp380_;
		if (_tmp383_) {
			gint _tmp384_ = 0;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp384_ = vala_compiler_quit (self);
			result = _tmp384_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp385_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp385_;
		_tmp386_ = interface_writer;
		_tmp387_ = vala_compiler_header_filename;
		_tmp388_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp386_, _tmp387_, _tmp388_);
		_tmp389_ = vala_compiler_internal_vapi_filename;
		_tmp390_ = g_strdup (_tmp389_);
		vapi_filename = _tmp390_;
		_tmp392_ = vala_compiler_directory;
		if (_tmp392_ != NULL) {
			const gchar* _tmp393_;
			gboolean _tmp394_ = FALSE;
			_tmp393_ = vapi_filename;
			_tmp394_ = g_path_is_absolute (_tmp393_);
			_tmp391_ = !_tmp394_;
		} else {
			_tmp391_ = FALSE;
		}
		_tmp395_ = _tmp391_;
		if (_tmp395_) {
			ValaCodeContext* _tmp396_;
			const gchar* _tmp397_;
			const gchar* _tmp398_;
			const gchar* _tmp399_;
			gchar* _tmp400_ = NULL;
			_tmp396_ = self->priv->context;
			_tmp397_ = vala_code_context_get_directory (_tmp396_);
			_tmp398_ = _tmp397_;
			_tmp399_ = vapi_filename;
			_tmp400_ = g_strdup_printf ("%s%c%s", _tmp398_, (gint) G_DIR_SEPARATOR, _tmp399_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp400_;
		}
		_tmp401_ = interface_writer;
		_tmp402_ = self->priv->context;
		_tmp403_ = vapi_filename;
		vala_code_writer_write_file (_tmp401_, _tmp402_, _tmp403_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp404_ = vala_compiler_dependencies;
	if (_tmp404_ != NULL) {
		ValaCodeContext* _tmp405_;
		const gchar* _tmp406_;
		_tmp405_ = self->priv->context;
		_tmp406_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp405_, _tmp406_);
	}
	_tmp407_ = vala_compiler_ccode_only;
	if (!_tmp407_) {
		ValaCCodeCompiler* _tmp408_;
		ValaCCodeCompiler* ccompiler;
		gboolean _tmp409_ = FALSE;
		const gchar* _tmp410_;
		gboolean _tmp412_;
		gchar** _tmp415_;
		gint _tmp415__length1;
		_tmp408_ = vala_ccode_compiler_new ();
		ccompiler = _tmp408_;
		_tmp410_ = vala_compiler_cc_command;
		if (_tmp410_ == NULL) {
			const gchar* _tmp411_ = NULL;
			_tmp411_ = g_getenv ("CC");
			_tmp409_ = _tmp411_ != NULL;
		} else {
			_tmp409_ = FALSE;
		}
		_tmp412_ = _tmp409_;
		if (_tmp412_) {
			const gchar* _tmp413_ = NULL;
			gchar* _tmp414_;
			_tmp413_ = g_getenv ("CC");
			_tmp414_ = g_strdup (_tmp413_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp414_;
		}
		_tmp415_ = vala_compiler_cc_options;
		_tmp415__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp415_ == NULL) {
			ValaCCodeCompiler* _tmp416_;
			ValaCodeContext* _tmp417_;
			const gchar* _tmp418_;
			gchar** _tmp419_ = NULL;
			gchar** _tmp420_;
			gint _tmp420__length1;
			_tmp416_ = ccompiler;
			_tmp417_ = self->priv->context;
			_tmp418_ = vala_compiler_cc_command;
			_tmp419_ = g_new0 (gchar*, 0 + 1);
			_tmp420_ = _tmp419_;
			_tmp420__length1 = 0;
			vala_ccode_compiler_compile (_tmp416_, _tmp417_, _tmp418_, _tmp420_, 0);
			_tmp420_ = (_vala_array_free (_tmp420_, _tmp420__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp421_;
			ValaCodeContext* _tmp422_;
			const gchar* _tmp423_;
			gchar** _tmp424_;
			gint _tmp424__length1;
			_tmp421_ = ccompiler;
			_tmp422_ = self->priv->context;
			_tmp423_ = vala_compiler_cc_command;
			_tmp424_ = vala_compiler_cc_options;
			_tmp424__length1 = _vala_array_length (vala_compiler_cc_options);
			vala_ccode_compiler_compile (_tmp421_, _tmp422_, _tmp423_, _tmp424_, _tmp424__length1);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp425_ = vala_compiler_quit (self);
	result = _tmp425_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda2_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_;
	GMainLoop* _tmp1_;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda2__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda2_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp8_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gint _tmp31_;
	const gchar* _tmp32_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gint _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar** _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gint _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_;
	gchar* _tmp45_ = NULL;
	const gchar* _tmp46_;
	gint _tmp47_ = 0;
	gint outputfd;
	gint _tmp48_;
	ValaCompiler* _tmp49_;
	ValaCompiler* compiler;
	ValaCompiler* _tmp50_;
	gint _tmp51_ = 0;
	gint ret;
	gint _tmp52_;
	gint _tmp53_;
	const gchar* _tmp54_;
	gint _tmp55_ = 0;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar** _tmp59_ = NULL;
	gchar** target_args;
	gint target_args_length1;
	gint _target_args_size_;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_;
		const gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		gint _tmp29_;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp9_;
			gint _tmp9__length1;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar** _tmp13_ = NULL;
			gint _tmp14_ = 0;
			GOptionContext* _tmp15_;
			GOptionContext* opt_context;
			GOptionContext* _tmp16_;
			GOptionContext* _tmp17_;
			gchar** _tmp18_;
			gint _tmp18__length1;
			gchar** temp_args;
			gint temp_args_length1;
			gint _temp_args_size_;
			GOptionContext* _tmp19_;
			_tmp9_ = args;
			_tmp9__length1 = args_length1;
			_tmp10_ = _tmp9_[1];
			_tmp11_ = g_strconcat ("valac ", _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			g_shell_parse_argv (_tmp12_, &_tmp14_, &_tmp13_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp13_;
			compile_args_length1 = _tmp14_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp12_);
			if (_inner_error_ != NULL) {
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp15_ = g_option_context_new ("- Vala");
			opt_context = _tmp15_;
			_tmp16_ = opt_context;
			g_option_context_set_help_enabled (_tmp16_, TRUE);
			_tmp17_ = opt_context;
			g_option_context_add_main_entries (_tmp17_, VALA_COMPILER_options, NULL);
			_tmp18_ = compile_args;
			_tmp18__length1 = compile_args_length1;
			temp_args = _tmp18_;
			temp_args_length1 = _tmp18__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp19_ = opt_context;
			g_option_context_parse (_tmp19_, &temp_args_length1, &temp_args, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp20_;
			GError* _tmp21_;
			const gchar* _tmp22_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = stdout;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			fprintf (_tmp20_, "%s\n", _tmp22_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp23_;
			GError* _tmp24_;
			const gchar* _tmp25_;
			FILE* _tmp26_;
			gchar** _tmp27_;
			gint _tmp27__length1;
			const gchar* _tmp28_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp23_ = stdout;
			_tmp24_ = e;
			_tmp25_ = _tmp24_->message;
			fprintf (_tmp23_, "%s\n", _tmp25_);
			_tmp26_ = stdout;
			_tmp27_ = args;
			_tmp27__length1 = args_length1;
			_tmp28_ = _tmp27_[0];
			fprintf (_tmp26_, "Run '%s --help' to see a full list of available command line options.\n", _tmp28_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp29_ = i;
		i = _tmp29_ + 1;
	}
	_tmp30_ = args;
	_tmp30__length1 = args_length1;
	_tmp31_ = i;
	_tmp32_ = _tmp30_[_tmp31_];
	if (_tmp32_ == NULL) {
		FILE* _tmp33_;
		_tmp33_ = stderr;
		fprintf (_tmp33_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp34_ = args;
	_tmp34__length1 = args_length1;
	_tmp35_ = i;
	_tmp36_ = _tmp34_[_tmp35_];
	_tmp37_ = g_strdup (_tmp36_);
	_tmp38_ = g_new0 (gchar*, 1 + 1);
	_tmp38_[0] = _tmp37_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp38_;
	_tmp39_ = g_get_tmp_dir ();
	_tmp40_ = args;
	_tmp40__length1 = args_length1;
	_tmp41_ = i;
	_tmp42_ = _tmp40_[_tmp41_];
	_tmp43_ = g_path_get_basename (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp39_, _tmp44_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp45_;
	_g_free0 (_tmp44_);
	_tmp46_ = vala_compiler_output;
	_tmp47_ = g_mkstemp (_tmp46_);
	outputfd = _tmp47_;
	_tmp48_ = outputfd;
	if (_tmp48_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp49_ = vala_compiler_new ();
	compiler = _tmp49_;
	_tmp50_ = compiler;
	_tmp51_ = vala_compiler_run (_tmp50_);
	ret = _tmp51_;
	_tmp52_ = ret;
	if (_tmp52_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp53_ = outputfd;
	close (_tmp53_);
	_tmp54_ = vala_compiler_output;
	_tmp55_ = g_chmod (_tmp54_, 0700);
	if (_tmp55_ != 0) {
		const gchar* _tmp56_;
		_tmp56_ = vala_compiler_output;
		g_unlink (_tmp56_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp57_ = vala_compiler_output;
	_tmp58_ = g_strdup (_tmp57_);
	_tmp59_ = g_new0 (gchar*, 1 + 1);
	_tmp59_[0] = _tmp58_;
	target_args = _tmp59_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp60_;
		gchar** _tmp61_;
		gint _tmp61__length1;
		gchar** _tmp62_;
		gint _tmp62__length1;
		gchar** _tmp63_;
		gint _tmp63__length1;
		gint _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		gint _tmp67_;
		_tmp60_ = i;
		_tmp61_ = args;
		_tmp61__length1 = args_length1;
		if (!(_tmp60_ < _tmp61__length1)) {
			break;
		}
		_tmp62_ = target_args;
		_tmp62__length1 = target_args_length1;
		_tmp63_ = args;
		_tmp63__length1 = args_length1;
		_tmp64_ = i;
		_tmp65_ = _tmp63_[_tmp64_];
		_tmp66_ = g_strdup (_tmp65_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp66_);
		_tmp67_ = i;
		i = _tmp67_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp68_;
		gchar** _tmp69_;
		gint _tmp69__length1;
		GPid _tmp70_ = 0;
		const gchar* _tmp71_;
		GPid _tmp72_;
		GMainLoop* _tmp73_;
		gint _tmp74_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp68_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp68_;
		_data1_->child_status = 0;
		_tmp69_ = target_args;
		_tmp69__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp69_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp70_, &_inner_error_);
		pid = _tmp70_;
		if (_inner_error_ != NULL) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp71_ = vala_compiler_output;
		g_unlink (_tmp71_);
		_tmp72_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp72_, ____lambda2__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp73_ = _data1_->loop;
		g_main_loop_run (_tmp73_);
		_tmp74_ = _data1_->child_status;
		result = _tmp74_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp75_;
		GError* _tmp76_;
		const gchar* _tmp77_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp75_ = stdout;
		_tmp76_ = e;
		_tmp77_ = _tmp76_->message;
		fprintf (_tmp75_, "%s\n", _tmp77_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp10_;
	gboolean _tmp23_;
	gboolean _tmp29_ = FALSE;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gboolean _tmp32_;
	ValaCompiler* _tmp34_;
	ValaCompiler* compiler;
	ValaCompiler* _tmp35_;
	gint _tmp36_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	_tmp10_ = _tmp0_;
	if (_tmp10_) {
		gchar** _tmp11_;
		gint _tmp11__length1;
		gint _tmp12_ = 0;
		_tmp11_ = args;
		_tmp11__length1 = args_length1;
		_tmp12_ = vala_compiler_run_source (_tmp11_, _tmp11__length1);
		result = _tmp12_;
		return result;
	}
	{
		GOptionContext* _tmp13_;
		GOptionContext* opt_context;
		GOptionContext* _tmp14_;
		GOptionContext* _tmp15_;
		GOptionContext* _tmp16_;
		_tmp13_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp13_;
		_tmp14_ = opt_context;
		g_option_context_set_help_enabled (_tmp14_, TRUE);
		_tmp15_ = opt_context;
		g_option_context_add_main_entries (_tmp15_, VALA_COMPILER_options, NULL);
		_tmp16_ = opt_context;
		g_option_context_parse (_tmp16_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		FILE* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "%s\n", _tmp19_);
		_tmp20_ = stdout;
		_tmp21_ = args;
		_tmp21__length1 = args_length1;
		_tmp22_ = _tmp21_[0];
		fprintf (_tmp20_, "Run '%s --help' to see a full list of available command line options.\n", _tmp22_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp23_ = vala_compiler_version;
	if (_tmp23_) {
		FILE* _tmp24_;
		_tmp24_ = stdout;
		fprintf (_tmp24_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp25_;
		_tmp25_ = vala_compiler_api_version;
		if (_tmp25_) {
			FILE* _tmp26_;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			_tmp26_ = stdout;
			_tmp27_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) (-1));
			_tmp28_ = _tmp27_;
			fprintf (_tmp26_, "%s\n", _tmp28_);
			_g_free0 (_tmp28_);
			result = 0;
			return result;
		}
	}
	_tmp30_ = vala_compiler_sources;
	_tmp30__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp30_ == NULL) {
		gchar** _tmp31_;
		gint _tmp31__length1;
		_tmp31_ = vala_compiler_fast_vapis;
		_tmp31__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp29_ = _tmp31_ == NULL;
	} else {
		_tmp29_ = FALSE;
	}
	_tmp32_ = _tmp29_;
	if (_tmp32_) {
		FILE* _tmp33_;
		_tmp33_ = stderr;
		fprintf (_tmp33_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp34_ = vala_compiler_new ();
	compiler = _tmp34_;
	_tmp35_ = compiler;
	_tmp36_ = vala_compiler_run (_tmp35_);
	result = _tmp36_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	VALA_COMPILER_CLASS (klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



