// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_ENUMS_H
#define _GTKMM_ENUMS_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/value.h>
#include <gtk/gtk.h>


namespace Gtk
{


/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/** 
 * 
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%AccelFlags operator|(AccelFlags, AccelFlags)</tt><br>
 * <tt>%AccelFlags operator&(AccelFlags, AccelFlags)</tt><br>
 * <tt>%AccelFlags operator^(AccelFlags, AccelFlags)</tt><br>
 * <tt>%AccelFlags operator~(AccelFlags)</tt><br>
 * <tt>%AccelFlags& operator|=(AccelFlags&, AccelFlags)</tt><br>
 * <tt>%AccelFlags& operator&=(AccelFlags&, AccelFlags)</tt><br>
 * <tt>%AccelFlags& operator^=(AccelFlags&, AccelFlags)</tt><br>
 */
enum AccelFlags
{
  ACCEL_VISIBLE = 1 << 0,
  ACCEL_LOCKED = 1 << 1,
  ACCEL_MASK = 0x07
};

/** @ingroup gtkmmEnums */
inline AccelFlags operator|(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator&(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator^(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator~(AccelFlags flags)
  { return static_cast<AccelFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator|=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator&=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator^=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::AccelFlags> : public Glib::Value_Flags<Gtk::AccelFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** 
 * Controls how a widget deals with extra space in a single (x or y)
 * dimension.
 * 
 * Alignment only matters if the widget receives a "too large" allocation,
 * for example if you packed the widget with the Gtk::Widget::property_expand()
 * flag inside a Gtk::Box, then the widget might get extra space.  If
 * you have for example a 16x16 icon inside a 32x32 space, the icon
 * could be scaled and stretched, it could be centered, or it could be
 * positioned to one side of the space.
 * 
 * Note that in horizontal context @a GTK_ALIGN_START and @a GTK_ALIGN_END
 * are interpreted relative to text direction.
 * @ingroup gtkmmEnums
 */
enum Align
{
  /** stretch to fill all space if possible, center if
   * no meaningful way to stretch
   */
  ALIGN_FILL,
  /** snap to left or top side, leaving space on right
   * or bottom
   */
  ALIGN_START,
  /** snap to right or bottom side, leaving space on left
   * or top
   */
  ALIGN_END,
  /** center natural width of widget inside the
   * allocation
   */
  ALIGN_CENTER
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Align> : public Glib::Value_Enum<Gtk::Align>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/**  Used to indicate the direction in which a Gtk::Arrow should point.
 * Used to indicate the direction in which a Gtk::Arrow should point.
 * @ingroup gtkmmEnums
 */
enum ArrowType
{
  /** Represents an upward pointing arrow.
   */
  ARROW_UP,
  /** Represents a downward pointing arrow.
   */
  ARROW_DOWN,
  /** Represents a left pointing arrow.
   */
  ARROW_LEFT,
  /** Represents a right pointing arrow.
   */
  ARROW_RIGHT,
  /** No arrow. @newin{2,10}
   */
  ARROW_NONE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ArrowType> : public Glib::Value_Enum<Gtk::ArrowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


// TODO: There must be a better way to document the enum values.
//       Extract them from the GTK+ docs as well?

/*! @var ArrowType ARROW_UP
 * Represents an upward pointing arrow.
 */
/*! @var ArrowType ARROW_DOWN
 * Represents a downward pointing arrow.
 */
/*! @var ArrowType ARROW_LEFT
 * Represents a left pointing arrow.
 */
/*! @var ArrowType ARROW_RIGHT
 * Represents a right pointing arrow.
 */

/**  Denotes the expansion properties that a widget will have when it (or its parent) is resized.
 * Denotes the expansion properties that a widget will have when it (or its
 * parent) is resized.
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%AttachOptions operator|(AttachOptions, AttachOptions)</tt><br>
 * <tt>%AttachOptions operator&(AttachOptions, AttachOptions)</tt><br>
 * <tt>%AttachOptions operator^(AttachOptions, AttachOptions)</tt><br>
 * <tt>%AttachOptions operator~(AttachOptions)</tt><br>
 * <tt>%AttachOptions& operator|=(AttachOptions&, AttachOptions)</tt><br>
 * <tt>%AttachOptions& operator&=(AttachOptions&, AttachOptions)</tt><br>
 * <tt>%AttachOptions& operator^=(AttachOptions&, AttachOptions)</tt><br>
 */
enum AttachOptions
{
  /** the widget should expand to take up any extra space in its
   * container that has been allocated.
   */
  EXPAND = 1 << 0,
  /** the widget should shrink as and when possible.
   */
  SHRINK = 1 << 1,
  /** the widget should fill the space allocated to it.
   */
  FILL = 1 << 2
};

/** @ingroup gtkmmEnums */
inline AttachOptions operator|(AttachOptions lhs, AttachOptions rhs)
  { return static_cast<AttachOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AttachOptions operator&(AttachOptions lhs, AttachOptions rhs)
  { return static_cast<AttachOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AttachOptions operator^(AttachOptions lhs, AttachOptions rhs)
  { return static_cast<AttachOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AttachOptions operator~(AttachOptions flags)
  { return static_cast<AttachOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline AttachOptions& operator|=(AttachOptions& lhs, AttachOptions rhs)
  { return (lhs = static_cast<AttachOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AttachOptions& operator&=(AttachOptions& lhs, AttachOptions rhs)
  { return (lhs = static_cast<AttachOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AttachOptions& operator^=(AttachOptions& lhs, AttachOptions rhs)
  { return (lhs = static_cast<AttachOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::AttachOptions> : public Glib::Value_Flags<Gtk::AttachOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/*! @var AttachOptions EXPAND
 * The widget should expand to take up any extra space in its container that has been allocated.
 */
/*! @var AttachOptions SHRINK
 * The widget should shrink as and when possible.
 */
/**  @var AttachOptions FILL
 * The widget should fill the space allocated to it.
 * Used to dictate the style that a Gtk::ButtonBox uses to layout the buttons it
 * contains. (See also: Gtk::VButtonBox and Gtk::HButtonBox).
 * @ingroup gtkmmEnums
 */
enum ButtonBoxStyle
{
  /** Buttons are evenly spread across the box.
   */
  BUTTONBOX_SPREAD = 1,
  /** Buttons are placed at the edges of the box.
   */
  BUTTONBOX_EDGE,
  /** Buttons are grouped towards the start of the box,
   * (on the left for a HBox, or the top for a VBox).
   */
  BUTTONBOX_START,
  /** Buttons are grouped towards the end of the box,
   * (on the right for a HBox, or the bottom for a VBox).
   */
  BUTTONBOX_END,
  /** Buttons are centered in the box. @newin{2,12}
   */
  BUTTONBOX_CENTER
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ButtonBoxStyle> : public Glib::Value_Enum<Gtk::ButtonBoxStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * 
 * @ingroup gtkmmEnums
 */
enum DeleteType
{
  DELETE_CHARS,
  DELETE_WORD_ENDS,
  DELETE_WORDS,
  DELETE_DISPLAY_LINES,
  DELETE_DISPLAY_LINE_ENDS,
  DELETE_PARAGRAPH_ENDS,
  DELETE_PARAGRAPHS,
  DELETE_WHITESPACE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::DeleteType> : public Glib::Value_Enum<Gtk::DeleteType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * 
 * @ingroup gtkmmEnums
 */
enum DirectionType
{
  DIR_TAB_FORWARD,
  DIR_TAB_BACKWARD,
  DIR_UP,
  DIR_DOWN,
  DIR_LEFT,
  DIR_RIGHT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::DirectionType> : public Glib::Value_Enum<Gtk::DirectionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Used to specify the style of the expanders drawn by a Gtk::TreeView.
 * @ingroup gtkmmEnums
 */
enum ExpanderStyle
{
  /** The style used for a collapsed subtree.
   */
  EXPANDER_COLLAPSED,
  /** Intermediate style used during animation.
   */
  EXPANDER_SEMI_COLLAPSED,
  /** Intermediate style used during animation.
   */
  EXPANDER_SEMI_EXPANDED,
  /** The style used for an expanded subtree.
   */
  EXPANDER_EXPANDED
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ExpanderStyle> : public Glib::Value_Enum<Gtk::ExpanderStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * 
 * @ingroup gtkmmEnums
 */
enum BuiltinIconSize
{
  ICON_SIZE_INVALID,
  ICON_SIZE_MENU,
  ICON_SIZE_SMALL_TOOLBAR,
  ICON_SIZE_LARGE_TOOLBAR,
  ICON_SIZE_BUTTON,
  ICON_SIZE_DND,
  ICON_SIZE_DIALOG
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::BuiltinIconSize> : public Glib::Value_Enum<Gtk::BuiltinIconSize>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * 
 * @ingroup gtkmmEnums
 */
enum TextDirection
{
  TEXT_DIR_NONE,
  TEXT_DIR_LTR,
  TEXT_DIR_RTL
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TextDirection> : public Glib::Value_Enum<Gtk::TextDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Used for justifying the text inside a Gtk::Label widget. (See also
 * Gtk::Alignment).
 * @ingroup gtkmmEnums
 */
enum Justification
{
  /** The text is placed at the left edge of the label.
   */
  JUSTIFY_LEFT,
  /** The text is placed at the right edge of the label.
   */
  JUSTIFY_RIGHT,
  /** The text is placed in the center of the label.
   */
  JUSTIFY_CENTER,
  /** The text is placed is distributed across the label.
   */
  JUSTIFY_FILL
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Justification> : public Glib::Value_Enum<Gtk::Justification>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * An enumeration representing directional movements within a menu.
 * @ingroup gtkmmEnums
 */
enum MenuDirectionType
{
  /** To the parent menu shell
   */
  MENU_DIR_PARENT,
  /** To the submenu, if any, associated with the item
   */
  MENU_DIR_CHILD,
  /** To the next menu item
   */
  MENU_DIR_NEXT,
  /** To the previous menu item
   */
  MENU_DIR_PREV
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MenuDirectionType> : public Glib::Value_Enum<Gtk::MenuDirectionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * The type of message being displayed in the dialog.
 * @ingroup gtkmmEnums
 */
enum MessageType
{
  /** Informational message
   */
  MESSAGE_INFO,
  /** Nonfatal warning message
   */
  MESSAGE_WARNING,
  /** Question requiring a choice
   */
  MESSAGE_QUESTION,
  /** Fatal error message
   */
  MESSAGE_ERROR,
  /** None of the above, doesn't get an icon
   */
  MESSAGE_OTHER
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MessageType> : public Glib::Value_Enum<Gtk::MessageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * 
 * @ingroup gtkmmEnums
 */
enum MovementStep
{
  /** Move forward or back by graphemes
   */
  MOVEMENT_LOGICAL_POSITIONS,
  /** Move left or right by graphemes
   */
  MOVEMENT_VISUAL_POSITIONS,
  /** Move forward or back by words
   */
  MOVEMENT_WORDS,
  /** Move up or down lines (wrapped lines)
   */
  MOVEMENT_DISPLAY_LINES,
  /** Move to either end of a line
   */
  MOVEMENT_DISPLAY_LINE_ENDS,
  /** Move up or down paragraphs (newline-ended lines)
   */
  MOVEMENT_PARAGRAPHS,
  /** Move to either end of a paragraph
   */
  MOVEMENT_PARAGRAPH_ENDS,
  /** Move by pages
   */
  MOVEMENT_PAGES,
  /** Move to ends of the buffer
   */
  MOVEMENT_BUFFER_ENDS,
  /** Move horizontally by pages
   */
  MOVEMENT_HORIZONTAL_PAGES
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MovementStep> : public Glib::Value_Enum<Gtk::MovementStep>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Represents the orientation of widgets which can be switched between horizontal
 * and vertical orientation on the fly, like Gtk::Toolbar.
 * @ingroup gtkmmEnums
 */
enum Orientation
{
  /** The widget is in horizontal orientation.
   */
  ORIENTATION_HORIZONTAL,
  /** The widget is in vertical orientation.
   */
  ORIENTATION_VERTICAL
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Orientation> : public Glib::Value_Enum<Gtk::Orientation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Specifies which corner a child widget should be placed in when packed into
 * a Gtk::ScrolledWindow. This is effectively the opposite of where the scroll
 * bars are placed.
 * @ingroup gtkmmEnums
 */
enum CornerType
{
  /** Place the scrollbars on the right and bottom of the
   * widget (default behaviour).
   */
  CORNER_TOP_LEFT,
  /** Place the scrollbars on the top and right of the
   * widget.
   */
  CORNER_BOTTOM_LEFT,
  /** Place the scrollbars on the left and bottom of the
   * widget.
   */
  CORNER_TOP_RIGHT,
  /** Place the scrollbars on the top and left of the
   * widget.
   */
  CORNER_BOTTOM_RIGHT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::CornerType> : public Glib::Value_Enum<Gtk::CornerType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Represents the packing location Gtk::Box children. (See: Gtk::VBox,
 * Gtk::HBox, and Gtk::ButtonBox).
 * @ingroup gtkmmEnums
 */
enum PackType
{
  /** The child is packed into the start of the box
   */
  PACK_START,
  /** The child is packed into the end of the box
   */
  PACK_END
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PackType> : public Glib::Value_Enum<Gtk::PackType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * 
 * @ingroup gtkmmEnums
 */
enum PathPriorityType
{
  PATH_PRIO_LOWEST = 0,
  PATH_PRIO_GTK = 4,
  PATH_PRIO_APPLICATION = 8,
  PATH_PRIO_THEME = 10,
  PATH_PRIO_RC = 12,
  PATH_PRIO_HIGHEST = 15
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PathPriorityType> : public Glib::Value_Enum<Gtk::PathPriorityType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * 
 * @ingroup gtkmmEnums
 */
enum PathType
{
  PATH_WIDGET,
  PATH_WIDGET_CLASS,
  PATH_CLASS
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PathType> : public Glib::Value_Enum<Gtk::PathType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Determines when a scroll bar will be visible.
 * @ingroup gtkmmEnums
 */
enum PolicyType
{
  /** The scrollbar is always visible.
   */
  POLICY_ALWAYS,
  /** The scrollbar will appear and disappear as necessary. For example,
   * when all of a Gtk::CList can not be seen.
   */
  POLICY_AUTOMATIC,
  /** The scrollbar will never appear.
   */
  POLICY_NEVER
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PolicyType> : public Glib::Value_Enum<Gtk::PolicyType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Describes which edge of a widget a certain feature is positioned at, e.g.\ the
 * tabs of a Gtk::Notebook, the handle of a Gtk::HandleBox or the label of a
 * Gtk::Scale.
 * @ingroup gtkmmEnums
 */
enum PositionType
{
  /** The feature is at the left edge.
   */
  POS_LEFT,
  /** The feature is at the right edge.
   */
  POS_RIGHT,
  /** The feature is at the top edge.
   */
  POS_TOP,
  /** The feature is at the bottom edge.
   */
  POS_BOTTOM
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PositionType> : public Glib::Value_Enum<Gtk::PositionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Indicated the relief to be drawn around a Gtk::Button.
 * @ingroup gtkmmEnums
 */
enum ReliefStyle
{
  /** Draw a normal relief.
   */
  RELIEF_NORMAL,
  /** A half relief.
   */
  RELIEF_HALF,
  /** No relief.
   */
  RELIEF_NONE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ReliefStyle> : public Glib::Value_Enum<Gtk::ReliefStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * 
 * @ingroup gtkmmEnums
 */
enum ResizeMode
{
  /** Pass resize request to the parent
   */
  RESIZE_PARENT,
  /** Queue resizes on this widget
   */
  RESIZE_QUEUE,
  /** Resize immediately. Deprecated.
   */
  RESIZE_IMMEDIATE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ResizeMode> : public Glib::Value_Enum<Gtk::ResizeMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * 
 * @ingroup gtkmmEnums
 */
enum ScrollType
{
  SCROLL_NONE,
  SCROLL_JUMP,
  SCROLL_STEP_BACKWARD,
  SCROLL_STEP_FORWARD,
  SCROLL_PAGE_BACKWARD,
  SCROLL_PAGE_FORWARD,
  SCROLL_STEP_UP,
  SCROLL_STEP_DOWN,
  SCROLL_PAGE_UP,
  SCROLL_PAGE_DOWN,
  SCROLL_STEP_LEFT,
  SCROLL_STEP_RIGHT,
  SCROLL_PAGE_LEFT,
  SCROLL_PAGE_RIGHT,
  SCROLL_START,
  SCROLL_END
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ScrollType> : public Glib::Value_Enum<Gtk::ScrollType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Used to control what selections users are allowed to make.
 * @ingroup gtkmmEnums
 */
enum SelectionMode
{
  /** No selection is possible.
   */
  SELECTION_NONE,
  /** Zero or one element may be selected.
   */
  SELECTION_SINGLE,
  /** Exactly one element is selected.
   * In some circumstances, such as initially or during a search
   * operation, it's possible for no element to be selected with
   * Gtk::SELECTION_BROWSE. What is really enforced is that the user
   * can't deselect a currently selected element except by selecting
   * another element.
   */
  SELECTION_BROWSE,
  /** Any number of elements may be selected.
   * The Ctrl key may be used to enlarge the selection, and Shift
   * key to select between the focus and the child pointed to.
   * Some widgets may also allow Click-drag to select a range of elements.
   */
  SELECTION_MULTIPLE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SelectionMode> : public Glib::Value_Enum<Gtk::SelectionMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Used to change the appearance of an outline typically provided by a Gtk::Frame.
 * @ingroup gtkmmEnums
 */
enum ShadowType
{
  /** No outline.
   */
  SHADOW_NONE,
  /** The outline is bevelled inwards.
   */
  SHADOW_IN,
  /** The outline is bevelled outwards like a button.
   */
  SHADOW_OUT,
  /** The outline has a sunken 3d appearance.
   */
  SHADOW_ETCHED_IN,
  /** The outline has a raised 3d appearance.
   */
  SHADOW_ETCHED_OUT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ShadowType> : public Glib::Value_Enum<Gtk::ShadowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * This type indicates the current state of a widget; the state determines how
 * the widget is drawn. The Gtk::StateType enumeration is also used to
 * identify different colors in a Gtk::Style for drawing, so states can be
 * used for subparts of a widget as well as entire widgets.
 * @ingroup gtkmmEnums
 */
enum StateType
{
  /** State during normal operation.
   */
  STATE_NORMAL,
  /** State of a currently active widget, such as a depressed button.
   */
  STATE_ACTIVE,
  /** State indicating that the mouse pointer is over
   * the widget and the widget will respond to mouse clicks.
   */
  STATE_PRELIGHT,
  /** State of a selected item, such the selected row in a list.
   */
  STATE_SELECTED,
  /** State indicating that the widget is
   * unresponsive to user actions.
   */
  STATE_INSENSITIVE,
  /** The widget is inconsistent, such as checkbuttons
   * or radiobuttons that aren't either set to <tt>true</tt> nor <tt>false</tt>,
   * or buttons requiring the user attention.
   */
  STATE_INCONSISTENT,
  /** The widget has the keyboard focus.
   */
  STATE_FOCUSED
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::StateType> : public Glib::Value_Enum<Gtk::StateType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * The Gtk::TargetFlags enumeration is used to specify
 * constraints on an entry in a Gtk::TargetTable.
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%TargetFlags operator|(TargetFlags, TargetFlags)</tt><br>
 * <tt>%TargetFlags operator&(TargetFlags, TargetFlags)</tt><br>
 * <tt>%TargetFlags operator^(TargetFlags, TargetFlags)</tt><br>
 * <tt>%TargetFlags operator~(TargetFlags)</tt><br>
 * <tt>%TargetFlags& operator|=(TargetFlags&, TargetFlags)</tt><br>
 * <tt>%TargetFlags& operator&=(TargetFlags&, TargetFlags)</tt><br>
 * <tt>%TargetFlags& operator^=(TargetFlags&, TargetFlags)</tt><br>
 */
enum TargetFlags
{
  /** If this is set, the target will only be selected
   * for drags within a single application.
   */
  TARGET_SAME_APP = 1 << 0,
  /** If this is set, the target will only be selected
   * for drags within a single widget.
   */
  TARGET_SAME_WIDGET = 1 << 1,
  /** If this is set, the target will not be selected
   * for drags within a single application.
   */
  TARGET_OTHER_APP = 1 << 2,
  /** If this is set, the target will not be selected
   * for drags withing a single widget.
   */
  TARGET_OTHER_WIDGET = 1 << 3
};

/** @ingroup gtkmmEnums */
inline TargetFlags operator|(TargetFlags lhs, TargetFlags rhs)
  { return static_cast<TargetFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TargetFlags operator&(TargetFlags lhs, TargetFlags rhs)
  { return static_cast<TargetFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TargetFlags operator^(TargetFlags lhs, TargetFlags rhs)
  { return static_cast<TargetFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline TargetFlags operator~(TargetFlags flags)
  { return static_cast<TargetFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline TargetFlags& operator|=(TargetFlags& lhs, TargetFlags rhs)
  { return (lhs = static_cast<TargetFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline TargetFlags& operator&=(TargetFlags& lhs, TargetFlags rhs)
  { return (lhs = static_cast<TargetFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline TargetFlags& operator^=(TargetFlags& lhs, TargetFlags rhs)
  { return (lhs = static_cast<TargetFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TargetFlags> : public Glib::Value_Flags<Gtk::TargetFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Used to customize the appearance of a Gtk::Toolbar. Note that
 * setting the toolbar style overrides the user's preferences
 * for the default toolbar style.  Note that if the button has only
 * a label set and GTK_TOOLBAR_ICONS is used, the label will be
 * visible, and vice versa.
 * @ingroup gtkmmEnums
 */
enum ToolbarStyle
{
  /** Buttons display only icons in the toolbar.
   */
  TOOLBAR_ICONS,
  /** Buttons display only text labels in the toolbar.
   */
  TOOLBAR_TEXT,
  /** Buttons display text and icons in the toolbar.
   */
  TOOLBAR_BOTH,
  /** Buttons display icons and text alongside each
   * other, rather than vertically stacked
   */
  TOOLBAR_BOTH_HORIZ
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ToolbarStyle> : public Glib::Value_Enum<Gtk::ToolbarStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Window placement can be influenced using this enumeration. Note that
 * using Gtk::WIN_POS_CENTER_ALWAYS is almost always a bad idea.
 * It won't necessarily work well with all window managers or on all windowing systems.
 * @ingroup gtkmmEnums
 */
enum WindowPosition
{
  /** No influence is made on placement.
   */
  WIN_POS_NONE,
  /** Windows should be placed in the center of the screen.
   */
  WIN_POS_CENTER,
  /** Windows should be placed at the current mouse position.
   */
  WIN_POS_MOUSE,
  /** Keep window centered as it changes size, etc.
   */
  WIN_POS_CENTER_ALWAYS,
  /** Center the window on its transient
   * parent (see Gtk::Window::set_transient_for()).
   */
  WIN_POS_CENTER_ON_PARENT
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WindowPosition> : public Glib::Value_Enum<Gtk::WindowPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * A Gtk::Window can be one of these types. Most things you'd consider a
 * "window" should have type Gtk::WINDOW_TOPLEVEL; windows with this type
 * are managed by the window manager and have a frame by default (call
 * Gtk::Window::set_decorated() to toggle the frame).  Windows with type
 * Gtk::WINDOW_POPUP are ignored by the window manager; window manager
 * keybindings won't work on them, the window manager won't decorate the
 * window with a frame, many GTK+ features that rely on the window
 * manager will not work (e.g. resize grips and
 * maximization/minimization). Gtk::WINDOW_POPUP is used to implement
 * widgets such as Gtk::Menu or tooltips that you normally don't think of
 * as windows per se. Nearly all windows should be Gtk::WINDOW_TOPLEVEL.
 * In particular, do not use Gtk::WINDOW_POPUP just to turn off
 * the window borders; use Gtk::Window::set_decorated() for that.
 * @ingroup gtkmmEnums
 */
enum WindowType
{
  /** A regular window, such as a dialog.
   */
  WINDOW_TOPLEVEL,
  /** A special window such as a tooltip.
   */
  WINDOW_POPUP
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WindowType> : public Glib::Value_Enum<Gtk::WindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Describes a type of line wrapping.
 * @ingroup gtkmmEnums
 */
enum WrapMode
{
  /** do not wrap lines; just make the text area wider
   */
  WRAP_NONE,
  /** wrap text, breaking lines anywhere the cursor can
   * appear (between characters, usually - if you want to be technical,
   * between graphemes, see pango_get_log_attrs())
   */
  WRAP_CHAR,
  /** wrap text, breaking lines in between words
   */
  WRAP_WORD,
  /** wrap text, breaking lines in between words, or if
   * that is not enough, also between graphemes
   */
  WRAP_WORD_CHAR
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WrapMode> : public Glib::Value_Enum<Gtk::WrapMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Determines the direction of a sort.
 * @ingroup gtkmmEnums
 */
enum SortType
{
  /** Sorting is in ascending order.
   */
  SORT_ASCENDING,
  /** Sorting is in descending order.
   */
  SORT_DESCENDING
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SortType> : public Glib::Value_Enum<Gtk::SortType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * 
 * @ingroup gtkmmEnums
 */
enum PageOrientation
{
  PAGE_ORIENTATION_PORTRAIT,
  PAGE_ORIENTATION_LANDSCAPE,
  PAGE_ORIENTATION_REVERSE_PORTRAIT,
  PAGE_ORIENTATION_REVERSE_LANDSCAPE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PageOrientation> : public Glib::Value_Enum<Gtk::PageOrientation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Determines how GTK+ handles the sensitivity of stepper arrows
 * at the end of range widgets.
 * @ingroup gtkmmEnums
 */
enum SensitivityType
{
  /** The arrow is made insensitive if the
   * thumb is at the end
   */
  SENSITIVITY_AUTO,
  /** The arrow is always sensitive
   */
  SENSITIVITY_ON,
  /** The arrow is always insensitive
   */
  SENSITIVITY_OFF
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SensitivityType> : public Glib::Value_Enum<Gtk::SensitivityType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Specifies a preference for height-for-width or
 * width-for-height geometry management.
 * @ingroup gtkmmEnums
 */
enum SizeRequestMode
{
  /** Prefer height-for-width geometry management
   */
  SIZE_REQUEST_HEIGHT_FOR_WIDTH,
  /** Prefer width-for-height geometry management
   */
  SIZE_REQUEST_WIDTH_FOR_HEIGHT,
  /** Dont trade height-for-width or width-for-height
   */
  SIZE_REQUEST_CONSTANT_SIZE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SizeRequestMode> : public Glib::Value_Enum<Gtk::SizeRequestMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Describes a region within a widget.
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%RegionFlags operator|(RegionFlags, RegionFlags)</tt><br>
 * <tt>%RegionFlags operator&(RegionFlags, RegionFlags)</tt><br>
 * <tt>%RegionFlags operator^(RegionFlags, RegionFlags)</tt><br>
 * <tt>%RegionFlags operator~(RegionFlags)</tt><br>
 * <tt>%RegionFlags& operator|=(RegionFlags&, RegionFlags)</tt><br>
 * <tt>%RegionFlags& operator&=(RegionFlags&, RegionFlags)</tt><br>
 * <tt>%RegionFlags& operator^=(RegionFlags&, RegionFlags)</tt><br>
 */
enum RegionFlags
{
  /** Region has an even number within a set.
   */
  REGION_EVEN = 1 << 0,
  /** Region has an odd number within a set.
   */
  REGION_ODD = 1 << 1,
  /** Region is the first one within a set.
   */
  REGION_FIRST = 1 << 2,
  /** Region is the last one within a set.
   */
  REGION_LAST = 1 << 3,
  /** Region is the only one within a set.
   */
  REGION_ONLY = 1 << 4,
  /** Region is part of a sorted area.
   */
  REGION_SORTED = 1 << 5
};

/** @ingroup gtkmmEnums */
inline RegionFlags operator|(RegionFlags lhs, RegionFlags rhs)
  { return static_cast<RegionFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline RegionFlags operator&(RegionFlags lhs, RegionFlags rhs)
  { return static_cast<RegionFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline RegionFlags operator^(RegionFlags lhs, RegionFlags rhs)
  { return static_cast<RegionFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline RegionFlags operator~(RegionFlags flags)
  { return static_cast<RegionFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline RegionFlags& operator|=(RegionFlags& lhs, RegionFlags rhs)
  { return (lhs = static_cast<RegionFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline RegionFlags& operator&=(RegionFlags& lhs, RegionFlags rhs)
  { return (lhs = static_cast<RegionFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline RegionFlags& operator^=(RegionFlags& lhs, RegionFlags rhs)
  { return (lhs = static_cast<RegionFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::RegionFlags> : public Glib::Value_Flags<Gtk::RegionFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Describes how a rendered element connects to adjacent elements.
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%JunctionSides operator|(JunctionSides, JunctionSides)</tt><br>
 * <tt>%JunctionSides operator&(JunctionSides, JunctionSides)</tt><br>
 * <tt>%JunctionSides operator^(JunctionSides, JunctionSides)</tt><br>
 * <tt>%JunctionSides operator~(JunctionSides)</tt><br>
 * <tt>%JunctionSides& operator|=(JunctionSides&, JunctionSides)</tt><br>
 * <tt>%JunctionSides& operator&=(JunctionSides&, JunctionSides)</tt><br>
 * <tt>%JunctionSides& operator^=(JunctionSides&, JunctionSides)</tt><br>
 */
enum JunctionSides
{
  /** No junctions.
   */
  JUNCTION_NONE = 0x0,
  /** Element connects on the top-left corner.
   */
  JUNCTION_CORNER_TOPLEFT = 1 << 0,
  /** Element connects on the top-right corner.
   */
  JUNCTION_CORNER_TOPRIGHT = 1 << 1,
  /** Element connects on the bottom-left corner.
   */
  JUNCTION_CORNER_BOTTOMLEFT = 1 << 2,
  /** Element connects on the bottom-right corner.
   */
  JUNCTION_CORNER_BOTTOMRIGHT = 1 << 3,
  /** Element connects on the top side.
   */
  JUNCTION_TOP = 0x3,
  /** Element connects on the bottom side.
   */
  JUNCTION_BOTTOM = 0xC,
  /** Element connects on the left side.
   */
  JUNCTION_LEFT = 0x5,
  /** Element connects on the right side.
   */
  JUNCTION_RIGHT = 0xA
};

/** @ingroup gtkmmEnums */
inline JunctionSides operator|(JunctionSides lhs, JunctionSides rhs)
  { return static_cast<JunctionSides>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline JunctionSides operator&(JunctionSides lhs, JunctionSides rhs)
  { return static_cast<JunctionSides>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline JunctionSides operator^(JunctionSides lhs, JunctionSides rhs)
  { return static_cast<JunctionSides>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline JunctionSides operator~(JunctionSides flags)
  { return static_cast<JunctionSides>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline JunctionSides& operator|=(JunctionSides& lhs, JunctionSides rhs)
  { return (lhs = static_cast<JunctionSides>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline JunctionSides& operator&=(JunctionSides& lhs, JunctionSides rhs)
  { return (lhs = static_cast<JunctionSides>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline JunctionSides& operator^=(JunctionSides& lhs, JunctionSides rhs)
  { return (lhs = static_cast<JunctionSides>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::JunctionSides> : public Glib::Value_Flags<Gtk::JunctionSides>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Describes a widget state. Widget states are used to match the widget
 * against CSS pseudo-classes. Note that GTK extends the regular CSS
 * classes and sometimes uses different names.
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%StateFlags operator|(StateFlags, StateFlags)</tt><br>
 * <tt>%StateFlags operator&(StateFlags, StateFlags)</tt><br>
 * <tt>%StateFlags operator^(StateFlags, StateFlags)</tt><br>
 * <tt>%StateFlags operator~(StateFlags)</tt><br>
 * <tt>%StateFlags& operator|=(StateFlags&, StateFlags)</tt><br>
 * <tt>%StateFlags& operator&=(StateFlags&, StateFlags)</tt><br>
 * <tt>%StateFlags& operator^=(StateFlags&, StateFlags)</tt><br>
 */
enum StateFlags
{
  /** State during normal operation.
   */
  STATE_FLAG_NORMAL = 0x0,
  /** Widget is active.
   */
  STATE_FLAG_ACTIVE = 1 << 0,
  /** Widget has a mouse pointer over it.
   */
  STATE_FLAG_PRELIGHT = 1 << 1,
  /** Widget is selected.
   */
  STATE_FLAG_SELECTED = 1 << 2,
  /** Widget is insensitive.
   */
  STATE_FLAG_INSENSITIVE = 1 << 3,
  /** Widget is inconsistent.
   */
  STATE_FLAG_INCONSISTENT = 1 << 4,
  /** Widget has the keyboard focus.
   */
  STATE_FLAG_FOCUSED = 1 << 5,
  /** Widget is in a background toplevel window.
   */
  STATE_FLAG_BACKDROP = 1 << 6,
  /** Widget is in left-to-right text direction. @newin{3,8}
   */
  STATE_FLAG_DIR_LTR = 1 << 7,
  /** Widget is in right-to-left text direction. @newin{3,8}
   */
  STATE_FLAG_DIR_RTL = 1 << 8
};

/** @ingroup gtkmmEnums */
inline StateFlags operator|(StateFlags lhs, StateFlags rhs)
  { return static_cast<StateFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline StateFlags operator&(StateFlags lhs, StateFlags rhs)
  { return static_cast<StateFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline StateFlags operator^(StateFlags lhs, StateFlags rhs)
  { return static_cast<StateFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline StateFlags operator~(StateFlags flags)
  { return static_cast<StateFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline StateFlags& operator|=(StateFlags& lhs, StateFlags rhs)
  { return (lhs = static_cast<StateFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline StateFlags& operator&=(StateFlags& lhs, StateFlags rhs)
  { return (lhs = static_cast<StateFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline StateFlags& operator^=(StateFlags& lhs, StateFlags rhs)
  { return (lhs = static_cast<StateFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::StateFlags> : public Glib::Value_Flags<Gtk::StateFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Describes primary purpose of the input widget. This information is
 * useful for on-screen keyboards and similar input methods to decide
 * which keys should be presented to the user.
 * 
 * Note that the purpose is not meant to impose a totally strict rule
 * about allowed characters, and does not replace input validation.
 * It is fine for an on-screen keyboard to let the user override the
 * character set restriction that is expressed by the purpose. The
 * application is expected to validate the entry contents, even if
 * it specified a purpose.
 * 
 * The difference between @a GTK_INPUT_PURPOSE_DIGITS and
 *  @a GTK_INPUT_PURPOSE_NUMBER is that the former accepts only digits
 * while the latter also some punctuation (like commas or points, plus,
 * minus) and 'e' or 'E' as in 3.14E+000.
 * 
 * This enumeration may be extended in the future; input methods should
 * interpret unknown values as 'free form'.
 * 
 * @newin{3,6}
 * @ingroup gtkmmEnums
 */
enum InputPurpose
{
  /** Allow any character
   */
  INPUT_PURPOSE_FREE_FORM,
  /** Allow only alphabetic characters
   */
  INPUT_PURPOSE_ALPHA,
  /** Allow only digits
   */
  INPUT_PURPOSE_DIGITS,
  /** Edited field expects numbers
   */
  INPUT_PURPOSE_NUMBER,
  /** Edited field expects phone number
   */
  INPUT_PURPOSE_PHONE,
  /** Edited field expects URL
   */
  INPUT_PURPOSE_URL,
  /** Edited field expects email address
   */
  INPUT_PURPOSE_EMAIL,
  /** Edited field expects the name of a person
   */
  INPUT_PURPOSE_NAME,
  /** Like @a GTK_INPUT_PURPOSE_FREE_FORM, but characters are hidden
   */
  INPUT_PURPOSE_PASSWORD,
  /** Like @a GTK_INPUT_PURPOSE_DIGITS, but characters are hidden
   */
  INPUT_PURPOSE_PIN
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::InputPurpose> : public Glib::Value_Enum<Gtk::InputPurpose>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/** 
 * Describes hints that might be taken into account by input methods
 * or applications. Note that input methods may already tailor their
 * behaviour according to the Gtk::InputPurpose of the entry.
 * 
 * Some common sense is expected when using these flags - mixing
 *  @a GTK_INPUT_HINT_LOWERCASE with any of the uppercase hints makes no sense.
 * 
 * This enumeration may be extended in the future; input methods should
 * ignore unknown values.
 * 
 * @newin{3,6}
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%InputHints operator|(InputHints, InputHints)</tt><br>
 * <tt>%InputHints operator&(InputHints, InputHints)</tt><br>
 * <tt>%InputHints operator^(InputHints, InputHints)</tt><br>
 * <tt>%InputHints operator~(InputHints)</tt><br>
 * <tt>%InputHints& operator|=(InputHints&, InputHints)</tt><br>
 * <tt>%InputHints& operator&=(InputHints&, InputHints)</tt><br>
 * <tt>%InputHints& operator^=(InputHints&, InputHints)</tt><br>
 */
enum InputHints
{
  /** No special behaviour suggested
   */
  INPUT_HINT_NONE = 0x0,
  /** Suggest checking for typos
   */
  INPUT_HINT_SPELLCHECK = 1 << 0,
  /** Suggest not checking for typos
   */
  INPUT_HINT_NO_SPELLCHECK = 1 << 1,
  /** Suggest word completion
   */
  INPUT_HINT_WORD_COMPLETION = 1 << 2,
  /** Suggest to convert all text to lowercase
   */
  INPUT_HINT_LOWERCASE = 1 << 3,
  /** Suggest to capitalize all text
   */
  INPUT_HINT_UPPERCASE_CHARS = 1 << 4,
  /** Suggest to capitalize the first
   * character of each word
   */
  INPUT_HINT_UPPERCASE_WORDS = 1 << 5,
  /** Suggest to capitalize the
   * first word of each sentence
   */
  INPUT_HINT_UPPERCASE_SENTENCES = 1 << 6,
  /** Suggest to not show an onscreen keyboard
   * (e.g for a calculator that already has all the keys).
   */
  INPUT_HINT_INHIBIT_OSK = 1 << 7
};

/** @ingroup gtkmmEnums */
inline InputHints operator|(InputHints lhs, InputHints rhs)
  { return static_cast<InputHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline InputHints operator&(InputHints lhs, InputHints rhs)
  { return static_cast<InputHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline InputHints operator^(InputHints lhs, InputHints rhs)
  { return static_cast<InputHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline InputHints operator~(InputHints flags)
  { return static_cast<InputHints>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline InputHints& operator|=(InputHints& lhs, InputHints rhs)
  { return (lhs = static_cast<InputHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline InputHints& operator&=(InputHints& lhs, InputHints rhs)
  { return (lhs = static_cast<InputHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline InputHints& operator^=(InputHints& lhs, InputHints rhs)
  { return (lhs = static_cast<InputHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::InputHints> : public Glib::Value_Flags<Gtk::InputHints>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/* We use a class to implement the GtkIconSize enum, because you can register
 * new "enum" values.  The strict type rules of C++ don't allow using an enum
 * like that.  Gtk::BuiltinIconSize is the actual GtkIconSize wrapper enum.
 */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
class Settings;
#endif //DOXYGEN_SHOULD_SKIP_THIS

/**
 * Represents registered icon sizes.
 * You can also use a Gtk::BuiltinIconSize instead of an IconSize.
 */
class IconSize
{
private:
  int size_;

public:
  IconSize()                     : size_ (0)    {}
  IconSize(BuiltinIconSize size) : size_ (size) {}

  // Behave like an ordinary enum.
  explicit IconSize(int size) : size_ (size) {}
  operator int() const { return size_; }

  // These static methods are implemented in iconfactory.ccg. TODO: That's probably unnecessarily obscure. murrayc.

  /** Obtains the pixel size of a semantic icon size, possibly modified by user preferences for the default Gtk::Settings.
   * Normally size would be Gtk::ICON_SIZE_MENU, Gtk::ICON_SIZE_BUTTON, etc.
   * This function isn't normally needed because Gtk::Widget::render_icon() is the usual way to get an icon for
   * rendering - then just look at the size of the rendered pixbuf. The rendered pixbuf may not even correspond
   * to the width/height returned by IconSize::lookup(), because themes are free to render the pixbuf however they
   * like, including changing the usual size.
   *
   * @param size An icon size.
   * @param width Location to store icon width.
   * @param height Location to store icon height.
   * @result true if size was a valid size.
   */
  static bool lookup(IconSize size, int& width, int& height);

  /** Obtains the pixel size of a semantic icon size, possibly modified by user preferences for a particular
   * Gtk::Settings. Normally size would be Gtk::ICON_SIZE_MENU, Gtk::ICON_SIZE_BUTTON, etc.
   * This function isn't normally needed because Gtk::Widget::render_icon() is the usual way to get an icon for
   * rendering - then just look at the size of the rendered pixbuf. The rendered pixbuf may not even correspond
   * to the width/height returned by IconSize::lookup(), because themes are free to render the pixbuf however they
   * like, including changing the usual size.
   *
   * @param size An icon size.
   * @param width Location to store icon width.
   * @param height Location to store icon height.
   * @param settings A Gtk::Settings object, used to determine which set of user preferences to used.
   * @result true if size was a valid size.
   *
   * @newin{2,14}
   */
  static bool lookup(IconSize size, int& width, int& height, const Glib::RefPtr<Gtk::Settings>& settings);

  /** Registers a new icon size, along the same lines as ICON_SIZE_MENU, etc. Returns the integer value for the size.
   *
   * @param	name Name of the icon size.
   * @param width The icon width.
   * @param height The icon height.
   * @result Integer value representing the size.
   */
  static IconSize register_new(const Glib::ustring& name, int width, int height);

  /** Registers @a alias as another name for @a target so calling from_name() with @a alias as argument will return @a target.
   *
   * @param alias An alias for target.
   * @param target An existing icon size.
   */
  static void register_alias(const Glib::ustring& alias, IconSize target);

  /** Looks up the icon size associated with @a name.
   *
   * @param name the name to look up.
   * result The icon size with the given name.
   */
  static IconSize from_name(const Glib::ustring& name);

  /** Gets the canonical name of the given icon size.
   *
   * @param size size AnIconSize.
   * @result The name of the given icon size.
   */
  static Glib::ustring get_name(IconSize size);
};


#ifndef DOXYGEN_SHOULD_SKIP_THIS
struct IconSizeTraits
{
  typedef Gtk::IconSize CppType;
  typedef GtkIconSize   CType;
  typedef GtkIconSize   CTypeNonConst;

  static CType   to_c_type      (CType c_obj)            { return c_obj; }
  static void    release_c_type (CType)                  {}
  static CType   to_c_type      (const CppType& cpp_obj) { int value (cpp_obj); return static_cast<CType> (value); }
  static CppType to_cpp_type    (CType c_obj)            { return CppType (c_obj); }
};
#endif //DOXYGEN_SHOULD_SKIP_THIS

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::IconSize> : public Glib::Value_Enum<Gtk::IconSize>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

#ifndef DOXYGEN_SHOULD_SKIP_THIS
//We need this because we can't just use floats for enum value.
float _gtkmm_align_float_from_enum(Align value);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} //namespace Gtk


#endif /* _GTKMM_ENUMS_H */

