// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_EVENT_H
#define _GDKMM_EVENT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <gdkmm/types.h>
#include <gdkmm/screen.h>

/* Shadow DELETE macro (from winnt.h).
 */
#if defined(DELETE) && !defined(GTKMM_MACRO_SHADOW_DELETE)
enum { GTKMM_MACRO_DEFINITION_DELETE = DELETE };
#undef DELETE
enum { DELETE = GTKMM_MACRO_DEFINITION_DELETE };
#define DELETE DELETE
#define GTKMM_MACRO_SHADOW_DELETE 1
#endif

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef union _GdkEvent GdkEvent; }
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/** @addtogroup gdkmmEnums gdkmm Enums and Flags */

/** 
 * Specifies the type of the event.
 * 
 * Do not confuse these events with the signals that GTK+ widgets emit.
 * Although many of these events result in corresponding signals being emitted,
 * the events are often transformed or filtered along the way.
 * 
 * In some language bindings, the values Gdk::2BUTTON_PRESS and
 * Gdk::3BUTTON_PRESS would translate into something syntactically
 * invalid (eg <tt>Gdk.EventType.2ButtonPress</tt>, where a
 * symbol is not allowed to start with a number). In that case, the
 * aliases Gdk::DOUBLE_BUTTON_PRESS and Gdk::TRIPLE_BUTTON_PRESS can
 * be used instead.
 * @ingroup gdkmmEnums
 */
enum EventType
{
  /** a special code to indicate a null event.
   */
  NOTHING = -1,
  /** the window manager has requested that the toplevel window be
   * hidden or destroyed, usually when the user clicks on a special icon in the
   * title bar.
   */
  DELETE = 0,
  /** the window has been destroyed.
   */
  DESTROY = 1,
  /** all or part of the window has become visible and needs to be
   * redrawn.
   */
  EXPOSE = 2,
  /** the pointer (usually a mouse) has moved.
   */
  MOTION_NOTIFY = 3,
  /** a mouse button has been pressed.
   */
  BUTTON_PRESS = 4,
  /** a mouse button has been double-clicked (clicked twice
   * within a short period of time). Note that each click also generates a
   * Gdk::BUTTON_PRESS event.
   */
  DOUBLE_BUTTON_PRESS = 5,
  /** a mouse button has been clicked 3 times in a short period
   * of time. Note that each click also generates a Gdk::BUTTON_PRESS event.
   */
  TRIPLE_BUTTON_PRESS = 6,
  /** a mouse button has been released.
   */
  BUTTON_RELEASE = 7,
  /** a key has been pressed.
   */
  KEY_PRESS = 8,
  /** a key has been released.
   */
  KEY_RELEASE = 9,
  /** the pointer has entered the window.
   */
  ENTER_NOTIFY = 10,
  /** the pointer has left the window.
   */
  LEAVE_NOTIFY = 11,
  /** the keyboard focus has entered or left the window.
   */
  FOCUS_CHANGE = 12,
  /** the size, position or stacking order of the window has changed.
   * Note that GTK+ discards these events for Gdk::WINDOW_CHILD windows.
   */
  CONFIGURE = 13,
  /** the window has been mapped.
   */
  MAP = 14,
  /** the window has been unmapped.
   */
  UNMAP = 15,
  /** a property on the window has been changed or deleted.
   */
  PROPERTY_NOTIFY = 16,
  /** the application has lost ownership of a selection.
   */
  SELECTION_CLEAR = 17,
  /** another application has requested a selection.
   */
  SELECTION_REQUEST = 18,
  /** a selection has been received.
   */
  SELECTION_NOTIFY = 19,
  /** an input device has moved into contact with a sensing
   * surface (e.g.\ a touchscreen or graphics tablet).
   */
  PROXIMITY_IN = 20,
  /** an input device has moved out of contact with a sensing
   * surface.
   */
  PROXIMITY_OUT = 21,
  /** the mouse has entered the window while a drag is in progress.
   */
  DRAG_ENTER = 22,
  /** the mouse has left the window while a drag is in progress.
   */
  DRAG_LEAVE = 23,
  /** the mouse has moved in the window while a drag is in
   * progress.
   */
  DRAG_MOTION = 24,
  /** the status of the drag operation initiated by the window
   * has changed.
   */
  DRAG_STATUS = 25,
  /** a drop operation onto the window has started.
   */
  DROP_START = 26,
  /** the drop operation initiated by the window has completed.
   */
  DROP_FINISHED = 27,
  /** a message has been received from another application.
   */
  CLIENT_EVENT = 28,
  /** the window visibility status has changed.
   */
  VISIBILITY_NOTIFY = 29,
  /** the scroll wheel was turned
   */
  SCROLL = 31,
  /** the state of a window has changed. See Gdk::WindowState
   * for the possible window states
   */
  WINDOW_STATE = 32,
  /** a setting has been modified.
   */
  SETTING = 33,
  /** the owner of a selection has changed. This event type
   * was added in 2.6
   */
  OWNER_CHANGE = 34,
  /** a pointer or keyboard grab was broken. This event type
   * was added in 2.8.
   */
  GRAB_BROKEN = 35,
  /** the content of the window has been changed. This event type
   * was added in 2.14.
   */
  DAMAGE = 36,
  /** A new touch event sequence has just started. This event
   * type was added in 3.4.
   */
  TOUCH_BEGIN = 37,
  /** A touch event sequence has been updated. This event type
   * was added in 3.4.
   */
  TOUCH_UPDATE = 38,
  /** A touch event sequence has finished. This event type
   * was added in 3.4.
   */
  TOUCH_END = 39,
  /** A touch event sequence has been canceled. This event type
   * was added in 3.4.
   */
  TOUCH_CANCEL = 40,
  /** marks the end of the GdkEventType enumeration. Added in 2.18
   */
  EVENT_LAST = 41
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::EventType> : public Glib::Value_Enum<Gdk::EventType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


/** 
 * An enumeration describing the way in which a device
 * axis (valuator) maps onto the predefined valuator
 * types that GTK+ understands.
 * @ingroup gdkmmEnums
 */
enum AxisUse
{
  /** the axis is ignored.
   */
  AXIS_IGNORE,
  /** the axis is used as the x axis.
   */
  AXIS_X,
  /** the axis is used as the y axis.
   */
  AXIS_Y,
  /** the axis is used for pressure information.
   */
  AXIS_PRESSURE,
  /** the axis is used for x tilt information.
   */
  AXIS_XTILT,
  /** the axis is used for y tilt information.
   */
  AXIS_YTILT,
  /** the axis is used for wheel information.
   */
  AXIS_WHEEL,
  /** a constant equal to the numerically highest axis value.
   */
  AXIS_LAST
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::AxisUse> : public Glib::Value_Enum<Gdk::AxisUse>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


//TODO: Actually use this class instead of GdkEvent?
class Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Event CppObjectType;
  typedef GdkEvent BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  Event();

  explicit Event(GdkEvent* gobject, bool make_a_copy = true);

  Event(const Event& other);
  Event& operator=(const Event& other);

  ~Event();

  void swap(Event& other);

  ///Provides access to the underlying C instance.
  GdkEvent*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GdkEvent* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GdkEvent* gobj_copy() const;

protected:
  GdkEvent* gobject_;

private:

  
public:

  
  /** Checks all open displays for a Gdk::Event to process,to be processed
   * on, fetching events from the windowing system if necessary.
   * See Gdk::Display::get_event().
   * @return The next Gdk::Event to be processed, or <tt>0</tt> if no events
   * are pending. The returned Gdk::Event should be freed with free().
   */
  static Event get();
  
  /** If there is an event waiting in the event queue of some open
   * display, returns a copy of it. See Gdk::Display::peek_event().
   * @return A copy of the first Gdk::Event on some event queue, or <tt>0</tt> if no
   * events are in any queues. The returned Gdk::Event should be freed with
   * free().
   */
  static Event peek();
   //deprecated
  
  /** Appends a copy of the given event onto the front of the event
   * queue for event->any.window's display, or the default event
   * queue if event->any.window is <tt>0</tt>. See Gdk::Display::put_event().
   */
  void put();

  
  /** Checks if any events are ready to be processed for any display.
   * @return <tt>true</tt> if any events are pending.
   */
  static bool events_pending();

  
  /** Returns the time stamp from @a event, if there is one; otherwise
   * returns Gdk::CURRENT_TIME. If @a event is <tt>0</tt>, returns Gdk::CURRENT_TIME.
   * @return Time stamp field from @a event.
   */
  guint32 get_time() const;
  
  /** If the event contains a "state" field, puts that field in @a state. Otherwise
   * stores an empty state (0). Returns <tt>true</tt> if there was a state field
   * in the event. @a event may be <tt>0</tt>, in which case it's treated
   * as if the event had no state field.
   * @param state Return location for state.
   * @return <tt>true</tt> if there was a state field in the event.
   */
  bool get_state(ModifierType& state) const;
  
  /** Extract the event window relative x/y coordinates from an event.
   * @param x_win Location to put event window x coordinate.
   * @param y_win Location to put event window y coordinate.
   * @return <tt>true</tt> if the event delivered event window coordinates.
   */
  bool get_coords(double& x_win, double& y_win) const;
  
  /** Extract the root window relative x/y coordinates from an event.
   * @param x_root Location to put root window x coordinate.
   * @param y_root Location to put root window y coordinate.
   * @return <tt>true</tt> if the event delivered root window coordinates.
   */
  bool get_root_coords(double& x_root, double& y_root) const;
  
  /** Extract the axis value for a particular axis use from
   * an event structure.
   * @param axis_use The axis use to look for.
   * @param value Location to store the value found.
   * @return <tt>true</tt> if the specified axis was found, otherwise <tt>false</tt>.
   */
  bool get_axis(AxisUse axis_use, double& value) const;
  //_WRAP_METHOD(void	gdk_event_handler_set(GdkEventFunc func, gpointer data, GDestroyNotify  notify), gdk_event_handler_set)

  
  /** Sets whether a trace of received events is output.
   * Note that GTK+ must be compiled with debugging (that is,
   * configured using the <tt>--enable-debug</tt> option)
   * to use this option.
   * @param show_events <tt>true</tt> to output event debugging information.
   */
  static void set_show_events(bool show_events);
  
  /** Gets whether event debugging output is enabled.
   * @return <tt>true</tt> if event debugging output is enabled.
   */
  static bool get_show_events();

   //deprecated
  
  /** Returns the screen for the event. The screen is
   * typically the screen for <tt>event->any.window</tt>, but
   * for events such as mouse events, it is the screen
   * where the pointer was when the event occurs -
   * that is, the screen which has the root window 
   * to which <tt>event->motion.x_root</tt> and
   * <tt>event->motion.y_root</tt> are relative.
   * 
   * @newin{2,2}
   * @return The screen for the event.
   */
  Glib::RefPtr<Screen> get_screen();
  
  /** Returns the screen for the event. The screen is
   * typically the screen for <tt>event->any.window</tt>, but
   * for events such as mouse events, it is the screen
   * where the pointer was when the event occurs -
   * that is, the screen which has the root window 
   * to which <tt>event->motion.x_root</tt> and
   * <tt>event->motion.y_root</tt> are relative.
   * 
   * @newin{2,2}
   * @return The screen for the event.
   */
  Glib::RefPtr<const Screen> get_screen() const;


};

} // namespace Gdk


namespace Gdk
{

/** @relates Gdk::Event
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Event& lhs, Event& rhs)
  { lhs.swap(rhs); }

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::Event
 */
Gdk::Event wrap(GdkEvent* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::Event> : public Glib::Value_Boxed<Gdk::Event>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GDKMM_EVENT_H */

