/*
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon-embed-popup-bw.h"
#include "gul-gobject-misc.h"

#include <gtk/gtkmain.h>

enum
{
        PROP_0,
        PROP_BONOBO_WINDOW
};

struct GaleonEmbedPopupBWPrivate
{
	BonoboWindow *window;
	GtkWidget *menu;
};

static void
galeon_embed_popup_bw_class_init (GaleonEmbedPopupBWClass *klass);
static void
galeon_embed_popup_bw_init (GaleonEmbedPopupBW *gep);
static void
galeon_embed_popup_bw_finalize (GObject *object);
static void
galeon_embed_popup_bw_set_property (GObject *object,
				    guint prop_id,
				    const GValue *value,
				    GParamSpec *pspec);
static void
galeon_embed_popup_bw_get_property (GObject *object,
				    guint prop_id,
				    GValue *value,
				    GParamSpec *pspec);
static void
galeon_embed_popup_bw_set_window (GaleonEmbedPopupBW *p, 
				  BonoboWindow *window);
static void
galeon_embed_popup_bw_show_impl (GaleonEmbedPopup *p,
				 GaleonEmbed *embed);

static GaleonEmbedPopupClass *parent_class = NULL;

MAKE_GET_TYPE (galeon_embed_popup_bw, "GaleonEmbedPopupBW", GaleonEmbedPopupBW, 
	       galeon_embed_popup_bw_class_init, galeon_embed_popup_bw_init, GALEON_EMBED_POPUP_TYPE);

static void
galeon_embed_popup_bw_class_init (GaleonEmbedPopupBWClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	
	parent_class = GALEON_EMBED_POPUP_CLASS (g_type_class_peek_parent (klass));
	
        object_class->finalize = galeon_embed_popup_bw_finalize;
	object_class->set_property = galeon_embed_popup_bw_set_property;
        object_class->get_property = galeon_embed_popup_bw_get_property;
	
	g_object_class_install_property (object_class,
                                         PROP_BONOBO_WINDOW,
                                         g_param_spec_object ("BonoboWindow",
                                                              "BonoboWindow",
                                                              "Bonobo window",
                                                              BONOBO_TYPE_WINDOW,
                                                              G_PARAM_READWRITE));
	
	GALEON_EMBED_POPUP_CLASS (klass)->show = galeon_embed_popup_bw_show_impl;
}

static void
galeon_embed_popup_bw_init (GaleonEmbedPopupBW *gep)
{
        gep->priv = g_new0 (GaleonEmbedPopupBWPrivate, 1);
	gep->priv->window = NULL;
	gep->priv->menu = NULL;
}

static void
galeon_embed_popup_bw_finalize (GObject *object)
{
	GaleonEmbedPopupBW *gep;
	
        g_return_if_fail (object != NULL);
        g_return_if_fail (IS_GALEON_EMBED_POPUP_BW (object));
	
        gep = GALEON_EMBED_POPUP_BW (object);
	
        g_return_if_fail (gep->priv != NULL);
	
        g_free (gep->priv);
	
        G_OBJECT_CLASS (parent_class)->finalize (object);
}

static void
galeon_embed_popup_bw_set_property (GObject *object,
				    guint prop_id,
				    const GValue *value,
				    GParamSpec *pspec)
{
        GaleonEmbedPopupBW *p = GALEON_EMBED_POPUP_BW (object);
	
        switch (prop_id)
        {
	case PROP_BONOBO_WINDOW:
		galeon_embed_popup_bw_set_window (p, g_value_get_object (value));
		break;
        }
}

static void
galeon_embed_popup_bw_get_property (GObject *object,
				    guint prop_id,
				    GValue *value,
				    GParamSpec *pspec)
{
        GaleonEmbedPopupBW *p = GALEON_EMBED_POPUP_BW (object);
	
        switch (prop_id)
        {
	case PROP_BONOBO_WINDOW:
		g_value_set_object (value, p->priv->window);
		break;
        }
}

static void
galeon_embed_popup_bw_set_window (GaleonEmbedPopupBW *p, 
				  BonoboWindow *window)
{
	p->priv->window = window;
}

GaleonEmbedPopupBW *
galeon_embed_popup_bw_new (BonoboWindow *window)
{
	GaleonEmbedPopupBW *p;
	
        p = GALEON_EMBED_POPUP_BW (g_object_new (GALEON_EMBED_POPUP_BW_TYPE, 
						 "BonoboWindow", window,
						 NULL));
	
        g_return_val_if_fail (p->priv != NULL, NULL);
	
        return p;
}

static void
galeon_embed_popup_bw_show_impl (GaleonEmbedPopup *pp,
				 GaleonEmbed *embed)
{
	GaleonEmbedPopupBW *p = GALEON_EMBED_POPUP_BW (pp);
	GaleonEmbedEvent *event = galeon_embed_popup_get_event (pp);
	guint button;

	galeon_embed_popup_set_embed (pp, embed);
	
	galeon_embed_event_get_mouse_button (event, &button);
	
	p->priv->menu = gtk_menu_new ();
        gtk_widget_show (p->priv->menu);
	
	bonobo_window_add_popup (p->priv->window,
				 GTK_MENU (p->priv->menu),
				 galeon_embed_popup_get_popup_path (GALEON_EMBED_POPUP (p)));
	
	gtk_menu_popup (GTK_MENU (p->priv->menu),
	 		NULL, NULL, NULL, NULL,
			button, gtk_get_current_event_time ());
}

