/*
 *  Copyright (C) 2002 Jorn Baayen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef JAVASCRIPT_CONSOLE_H
#define JAVASCRIPT_CONSOLE_H

#include "galeon-embed-dialog.h"
#include "galeon-dialog.h"

#include <glib-object.h>
#include <glib.h>

G_BEGIN_DECLS

typedef struct JavascriptConsole JavascriptConsole;
typedef struct JavascriptConsoleClass JavascriptConsoleClass;

#define JAVASCRIPT_CONSOLE_TYPE             (javascript_console_get_type ())
#define JAVASCRIPT_CONSOLE(obj)             (GTK_CHECK_CAST ((obj), JAVASCRIPT_CONSOLE_TYPE, JavascriptConsole))
#define JAVASCRIPT_CONSOLE_CLASS(klass)     (GTK_CHECK_CLASS_CAST ((klass), JAVASCRIPT_CONSOLE, JavascriptConsoleClass))
#define IS_JAVASCRIPT_CONSOLE(obj)          (GTK_CHECK_TYPE ((obj), JAVASCRIPT_CONSOLE_TYPE))
#define IS_JAVASCRIPT_CONSOLE_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), JAVASCRIPT_CONSOLE))

typedef struct JavascriptConsolePrivate JavascriptConsolePrivate;

typedef enum
{
        JS_CONSOLE_ERROR   = 1,
        JS_CONSOLE_WARNING = 2,
        JS_CONSOLE_MESSAGE = 3
} JSConsoleMessageType;

struct JavascriptConsole
{
        GaleonEmbedDialog parent;
        JavascriptConsolePrivate *priv;
};

struct JavascriptConsoleClass
{
        GaleonEmbedDialogClass parent_class;

	void (* evaluate)    (JavascriptConsole *dialog, char *command);
};

GType           javascript_console_get_type           	(void);

GaleonDialog   *js_console_new                	      	(void);

void            javascript_console_append             	(JavascriptConsole *jc, 
			   				const gchar *text, 
							JSConsoleMessageType type, 
							guint column);

G_END_DECLS

#endif

