/*
 *  Copyright (C) 2000-2002 Marco Pesenti Gritti, Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#if NOT_PORTED

#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <libgnome/gnome-help.h>
#include <libgnome/gnome-config.h>

#include "prefs.h"

gboolean
prefs_galeon_used_by_gnome_for_protocol (const char *protocol)
{
        gboolean uses_galeon;

        gchar *path = g_strconcat ("/Gnome/URL Handlers/", protocol,
                                   "-show", NULL);
        gchar *handler = gnome_config_get_string (path);
        g_free (path);

        if (handler == NULL)
        {
                handler = gnome_config_get_string
                        ("/Gnome/URL Handlers/default-show");
        }
        if (handler == NULL)
        {
                uses_galeon = FALSE;
        }
        else
        {
                uses_galeon = (strstr (handler, "galeon") != NULL);
                free (handler);
        }
                
        return uses_galeon;
}

#endif

