#include <config.h>
#include <gnome.h>
#include <dirent.h>
#include <gconf/gconf-client.h>
#include <games-gconf.h>
#include <games-clock.h>

#include "properties.h"
#include "gnothello.h"
#include "othello.h"

static GtkWidget *propbox = NULL;

extern GtkWidget *window;
extern GtkWidget *time_display;
extern guint black_computer_level;
extern guint white_computer_level;
extern guint computer_speed;
extern gint timer_valid;
extern guint black_computer_id;
extern guint white_computer_id;
extern gchar *tile_set;
extern gchar *tile_set_tmp;
extern gint8 pixmaps[8][8];
extern gint animate;
extern gint animate_stagger;
extern gint flip_pixmaps_id;
extern gint flip_final;
extern gint grid;

guint t_black_computer_level;
guint t_white_computer_level;
gint t_animate;
gint t_quick_moves;
gint t_animate_stagger;
gint t_flip_final;
gint t_grid;

int mapped = 0;

/*
 * FIXME:
 * 	This was only a quick port to gconf.
 *	It doesn't abide by the HIG.
 */

void load_properties ()
{
	GConfClient *client;
	GError      *error = NULL;

	client = gconf_client_get_default ();
	if (!games_gconf_sanity_check_string (client, "/apps/iagno/tileset")) {
		exit(1);
	}
	black_computer_level = gconf_client_get_int (client, "/apps/iagno/black-level", &error);
	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	white_computer_level = gconf_client_get_int (client, "/apps/iagno/white-level", &error);
	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	if (gconf_client_get_bool (client, "/apps/iagno/quick-moves", &error))
		computer_speed = COMPUTER_MOVE_DELAY / 2;
	else
		computer_speed = COMPUTER_MOVE_DELAY;

	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	if (tile_set)
		g_free (tile_set);

	tile_set = gconf_client_get_string (client, "/apps/iagno/tileset", &error);
	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	animate = gconf_client_get_int (client, "/apps/iagno/animate", &error);
	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	animate_stagger = gconf_client_get_bool (client, "/apps/iagno/animate-stagger", &error);
	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	grid = gconf_client_get_bool (client, "/apps/iagno/show-grid", &error);
	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	flip_final = gconf_client_get_bool (client, "/apps/iagno/flip-final-results", &error);
	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	switch (animate) {
	case 0:
		flip_pixmaps_id = g_timeout_add (100, flip_pixmaps, &error);
		break;
	case 1:
		flip_pixmaps_id = g_timeout_add (PIXMAP_FLIP_DELAY * 8, flip_pixmaps, NULL);
		break;
	default:
	case 2:
		flip_pixmaps_id = g_timeout_add (PIXMAP_FLIP_DELAY, flip_pixmaps, NULL);
		break;
	}
}

void reset_properties ()
{
	GConfClient *client;
	GError      *error = NULL;

	client = gconf_client_get_default ();

	t_black_computer_level = black_computer_level =
		gconf_client_get_int (client, "/apps/iagno/black-level", &error);
	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	t_white_computer_level = white_computer_level =
		gconf_client_get_int (client, "/apps/iagno/white-level", &error);
	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	t_quick_moves = gconf_client_get_bool (client, "/apps/iagno/quick-moves", &error);
	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	if (tile_set_tmp)
		g_free (tile_set_tmp);

	tile_set_tmp = gconf_client_get_string (client, "/apps/iagno/tileset", &error);
	if (error) {
		g_warning (G_STRLOC ": gconf error: %s\n", error->message);
		g_error_free (error);
		error = NULL;
	}

	t_animate         = animate;
	t_animate_stagger = animate_stagger;
	t_grid            = grid;
	t_flip_final      = flip_final;
}

void black_computer_level_select (GtkWidget *widget, gpointer data)
{
	if (((guint) data != t_black_computer_level) &&
		       (GTK_TOGGLE_BUTTON (widget)->active)) {
		t_black_computer_level = (guint) data;
	}
}

void white_computer_level_select (GtkWidget *widget, gpointer data)
{
	if (((guint) data != t_white_computer_level) &&
		       (GTK_TOGGLE_BUTTON (widget)->active)) {
		t_white_computer_level = (guint) data;
	}
}

void quick_moves_select (GtkWidget *widget, gpointer data)
{
	if (GTK_TOGGLE_BUTTON (widget)->active)
		t_quick_moves = 1;
	else
		t_quick_moves = 0;
}

void flip_final_select (GtkWidget *widget, gpointer data)
{
	if (GTK_TOGGLE_BUTTON (widget)->active)
		t_flip_final = 1;
	else
		t_flip_final = 0;
}

void animate_stagger_select (GtkWidget *widget, gpointer data)
{
	if (GTK_TOGGLE_BUTTON (widget)->active)
		t_animate_stagger = 1;
	else
		t_animate_stagger = 0;
}

void grid_select (GtkWidget *widget, gpointer data)
{
	if (GTK_TOGGLE_BUTTON (widget)->active)
		t_grid = 1;
	else
		t_grid = 0;
}

void animate_select (GtkWidget *widget, gpointer data)
{
	if (GTK_TOGGLE_BUTTON (widget)->active) {
		t_animate = (gint) data;
	}
}

void apply_changes ()
{
	guint i, j;
	
	if ((black_computer_level != t_black_computer_level) ||
			(white_computer_level != t_white_computer_level)) {
		games_clock_stop (GAMES_CLOCK (time_display));
		gtk_widget_set_sensitive (time_display, FALSE);
		games_clock_set_seconds (GAMES_CLOCK (time_display), 0);
		timer_valid = 0;
	}

	black_computer_level = t_black_computer_level;
	white_computer_level = t_white_computer_level;
	
	if (black_computer_id) {
		gtk_timeout_remove (black_computer_id);
		black_computer_id = 0;
	}
	
	if (white_computer_id) {
		gtk_timeout_remove (white_computer_id);
		white_computer_id = 0;
	}
	
	if (t_quick_moves)
		computer_speed = COMPUTER_MOVE_DELAY / 2;
	else
		computer_speed = COMPUTER_MOVE_DELAY;
	
	if (strcmp (tile_set, tile_set_tmp)) {
		g_free (tile_set);
		tile_set = g_strdup (tile_set_tmp);
		load_pixmaps ();
	    set_bg_color();
		for (i = 0; i < 8; i++)
			for (j = 0; j < 8; j++)
				if (pixmaps [i][j] >= BLACK_TURN &&
						pixmaps[i][j] <= WHITE_TURN)
					gui_draw_pixmap_buffer (pixmaps[i][j], i, j);
				else
					gui_draw_pixmap_buffer (0, i, j);
		gui_draw_grid();
	}
	
	animate = t_animate;
	
	if (flip_pixmaps_id) {
		gtk_timeout_remove (flip_pixmaps_id);
		flip_pixmaps_id = 0;
	}
	
	switch (animate) {
		case 0:
			flip_pixmaps_id = gtk_timeout_add (100, flip_pixmaps,
					NULL);
			break;
		case 1:
			flip_pixmaps_id = gtk_timeout_add (PIXMAP_FLIP_DELAY *
					8, flip_pixmaps, NULL);
			break;
		case 2: flip_pixmaps_id = gtk_timeout_add (PIXMAP_FLIP_DELAY,
					flip_pixmaps, NULL);
			break;
	}
	
	animate_stagger = t_animate_stagger;

	flip_final = t_flip_final;

	if (grid!=t_grid) {
			grid = t_grid;
			gui_draw_grid();
	}

	check_computer_players ();
}

void save_properties ()
{
	GConfClient *client;

	client = gconf_client_get_default ();

	gconf_client_set_int (client, "/apps/iagno/black-level",
			      black_computer_level, NULL);
	gconf_client_set_int (client, "/apps/iagno/white-level",
			      white_computer_level, NULL);

	gconf_client_set_bool (client, "/apps/iagno/quick-moves",
			       t_quick_moves, NULL);

	gconf_client_set_string (client, "/apps/iagno/tileset",
				 tile_set_tmp, NULL);

	gconf_client_set_int (client, "/apps/iagno/animate",
			      animate, NULL);

	gconf_client_set_bool (client, "/apps/iagno/animate-stagger",
			       animate_stagger, NULL);
	gconf_client_set_bool (client, "/apps/iagno/show-grid",
			       grid, NULL);
	gconf_client_set_bool (client, "/apps/iagno/flip-final-results",
			       flip_final, NULL);
}

void apply_cb (GtkWidget *widget, gint arg1, gpointer data)
{
	gtk_widget_hide (widget);
	mapped = 0;

	if (arg1 == GTK_RESPONSE_REJECT)
		return;

	apply_changes();
	
	save_properties ();
}

void destroy_cb (GtkWidget *widget, gpointer data)
{
	mapped = 0;
}

void set_selection(GtkWidget *widget, gpointer data)
{
	if (strcmp ((gchar *)data, tile_set_tmp) != 0) {
		g_free (tile_set_tmp);
		tile_set_tmp = g_strdup (data);
	}
}

void free_str(GtkWidget *widget, void *data)
{
        g_free(data);
}

void fill_menu(GtkWidget *menu)
{
        struct dirent *e;
        char *dname = NULL;
        DIR *dir;
        int itemno = 0;

	dname = gnome_program_locate_file (NULL,
			GNOME_FILE_DOMAIN_APP_PIXMAP,  "iagno", FALSE, NULL);
        dir = opendir(dname);

        if(!dir)
                return;

        while((e = readdir(dir)) != NULL) {
                GtkWidget *item;
                char *s = g_strdup(e->d_name);
                if(strstr(e->d_name, ".png") == 0) {
                        g_free(s);
                        continue;
                }

                item = gtk_menu_item_new_with_label(s);
                gtk_widget_show(item);
                gtk_menu_shell_append(GTK_MENU_SHELL(menu), item);

		if (strcmp(tile_set, s) == 0) {
			gtk_menu_set_active(GTK_MENU(menu), itemno);
		}

                g_signal_connect(GTK_OBJECT(item), "activate",
				(GtkSignalFunc)set_selection, s);
                g_signal_connect(GTK_OBJECT(item), "destroy",
				(GtkSignalFunc)free_str, s);

                itemno++;
        }
        closedir(dir);
	g_free (dname);
}

void
dialog_help_callback (GtkWidget *box, gint page_num)
{
#if 0
  GnomeHelpMenuEntry settings_entry = { "iagno", "settings.html" };
  GnomeHelpMenuEntry animation_entry = { "iagno", "animations.html" };

  switch (page_num) {
  case 0:
    gnome_help_display (0, &settings_entry);
    break;
  case 1:
    gnome_help_display (0, &animation_entry);
    break;
  default:
    break;
  }
#endif
}

void show_properties_dialog ()
{
	GtkWidget *notebook;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *label2;
	GtkWidget *table;
	GtkWidget *button;
	GtkWidget *frame;
	GtkWidget *vbox;
	GtkWidget *option_menu;
	GtkWidget *menu;

	if (propbox)
	{
		if (mapped == 0)
		{
			gtk_widget_show(propbox);
			mapped = 1;
			reset_properties ();
		} else {
			gdk_window_raise (GTK_WIDGET(propbox)->window);
		}
		return;
	}

	reset_properties ();
	
	propbox = gtk_dialog_new_with_buttons (NULL,
			GTK_WINDOW (window),
			0,
			GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
			GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL);

	notebook = gtk_notebook_new();
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (propbox)->vbox),
			notebook);
	gtk_widget_show (notebook);

	vbox = gtk_vbox_new(FALSE, 8);
	gtk_widget_show (vbox);

	label = gtk_label_new (_("Players"));
	gtk_widget_show (label);

	table = gtk_table_new (2, 2, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), GNOME_PAD);
	gtk_table_set_row_spacings (GTK_TABLE (table), GNOME_PAD);
	gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD);
	gtk_widget_show (table);

	button = gtk_check_button_new_with_label (_("Quick Moves"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
			(computer_speed == COMPUTER_MOVE_DELAY / 2));
	g_signal_connect (GTK_OBJECT (button), "toggled", GTK_SIGNAL_FUNC
			(quick_moves_select), NULL);
	gtk_widget_show (button);
	
	gtk_table_attach (GTK_TABLE (table), button, 0, 2, 1, 2,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
	
	frame = gtk_frame_new (_("Dark"));
	gtk_widget_show (frame);

	vbox = gtk_vbox_new (TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), GNOME_PAD);
	gtk_widget_show (vbox);

	button = gtk_radio_button_new_with_label (NULL, _("Human"));
	if (black_computer_level == 0)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				TRUE);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (black_computer_level_select),
			(gpointer) 0);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	button = gtk_radio_button_new_with_label (gtk_radio_button_get_group
			(GTK_RADIO_BUTTON (button)), _("Level one"));
	if (black_computer_level == 1)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				TRUE);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (black_computer_level_select),
			(gpointer) 1);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	button = gtk_radio_button_new_with_label (gtk_radio_button_get_group
			(GTK_RADIO_BUTTON (button)), _("Level two"));
	if (black_computer_level == 2)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				TRUE);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (black_computer_level_select),
			(gpointer) 2);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	button = gtk_radio_button_new_with_label (gtk_radio_button_get_group
			(GTK_RADIO_BUTTON (button)), _("Level three"));
	if (black_computer_level == 3)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				TRUE);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (black_computer_level_select),
			(gpointer) 3);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	gtk_table_attach (GTK_TABLE (table), frame, 0, 1, 0, 1,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
	
	frame = gtk_frame_new (_("Light"));
	gtk_widget_show (frame);
	
	vbox = gtk_vbox_new (TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), GNOME_PAD);
	gtk_widget_show (vbox);
	
	button = gtk_radio_button_new_with_label (NULL, _("Human"));
	if (white_computer_level == 0)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				TRUE);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (white_computer_level_select),
			(gpointer) 0);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	button = gtk_radio_button_new_with_label (gtk_radio_button_get_group
			(GTK_RADIO_BUTTON (button)), _("Level one"));
	if (white_computer_level == 1)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				TRUE);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (white_computer_level_select),
			(gpointer) 1);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	button = gtk_radio_button_new_with_label (gtk_radio_button_get_group
			(GTK_RADIO_BUTTON (button)), _("Level two"));
	if (white_computer_level == 2)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				TRUE);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (white_computer_level_select),
			(gpointer) 2);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	button = gtk_radio_button_new_with_label (gtk_radio_button_get_group
			(GTK_RADIO_BUTTON (button)), _("Level three"));
	if (white_computer_level == 3)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				TRUE);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (white_computer_level_select),
			(gpointer) 3);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	gtk_table_attach (GTK_TABLE (table), frame, 1, 2, 0, 1,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

	gtk_notebook_append_page (GTK_NOTEBOOK(notebook),
			table, label);

	label = gtk_label_new (_("Animation"));
	gtk_widget_show (label);

	table = gtk_table_new (1, 2, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), GNOME_PAD);
	gtk_table_set_row_spacings (GTK_TABLE (table), GNOME_PAD);
	gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD);
	gtk_widget_show (table);
	
	frame = gtk_frame_new (NULL);
	gtk_widget_show (frame);
	
	vbox = gtk_vbox_new (TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), GNOME_PAD);
	gtk_widget_show (vbox);
	
	button = gtk_radio_button_new_with_label (NULL, _("None"));
	if (animate == 0)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				TRUE);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (animate_select), (gpointer) 0);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	button = gtk_radio_button_new_with_label (gtk_radio_button_get_group
			(GTK_RADIO_BUTTON (button)), _("Partial"));
	if (animate == 1)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				TRUE);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (animate_select), (gpointer) 1);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	button = gtk_radio_button_new_with_label (gtk_radio_button_get_group
			(GTK_RADIO_BUTTON (button)), _("Complete"));
	if (animate == 2)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
				TRUE);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (animate_select), (gpointer) 2);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	gtk_table_attach (GTK_TABLE (table), frame, 0, 1, 0, 1,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
	
	vbox = gtk_vbox_new (TRUE, GNOME_PAD);
	gtk_widget_show (vbox);
	
	button = gtk_check_button_new_with_label (_("Stagger flips"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
			t_animate_stagger);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (animate_stagger_select), NULL);
	gtk_widget_show (button);
	
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);

	button = gtk_check_button_new_with_label (_("Show grid"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
			t_grid);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (grid_select), NULL);
	gtk_widget_show (button);
	
	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);

	button = gtk_check_button_new_with_label (_("Flip final results"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button),
			t_flip_final);
	g_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (flip_final_select), NULL);
	gtk_widget_show (button);

	gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
	
	hbox = gtk_hbox_new (FALSE, GNOME_PAD);
	gtk_widget_show (hbox);
	
	label2 = gtk_label_new (_("Tile set:"));
	gtk_widget_show (label2);
	
	gtk_box_pack_start (GTK_BOX (hbox), label2, FALSE, FALSE, 0);
	
	option_menu = gtk_option_menu_new ();
	menu = gtk_menu_new ();
	fill_menu (menu);
	gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
	gtk_widget_show (option_menu);
	
	gtk_box_pack_start (GTK_BOX (hbox), option_menu, TRUE, TRUE, 0);
	
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	
	gtk_table_attach (GTK_TABLE (table), vbox, 1, 2, 0, 1,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), table,
			label);

	g_signal_connect (GTK_OBJECT (propbox), "response", GTK_SIGNAL_FUNC
			(apply_cb), NULL);
	g_signal_connect (GTK_OBJECT (propbox), "destroy", GTK_SIGNAL_FUNC
			(destroy_cb), NULL);
	g_signal_connect (GTK_OBJECT (propbox), "close", GTK_SIGNAL_FUNC
			(destroy_cb), NULL);

	gtk_widget_show (propbox);
	mapped = 1;
}
