/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_DEBUGGER_H_
#define _IANJUTA_DEBUGGER_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-message-view.h>
#include <libanjuta/anjuta-error.h>
#include <sys/types.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_DEBUGGER (ianjuta_debugger_get_type ())
#define IANJUTA_DEBUGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_DEBUGGER, IAnjutaDebugger))
#define IANJUTA_IS_DEBUGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_DEBUGGER))
#define IANJUTA_DEBUGGER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_DEBUGGER, IAnjutaDebuggerIface))

#define IANJUTA_TYPE_DEBUGGER_DATA (ianjuta_debugger_data_get_type())
#define IANJUTA_TYPE_DEBUGGER_ERROR (ianjuta_debugger_error_get_type())
#define IANJUTA_TYPE_DEBUGGER_OUTPUT_TYPE (ianjuta_debugger_output_type_get_type())
#define IANJUTA_TYPE_DEBUGGER_STATE (ianjuta_debugger_state_get_type())

#define IANJUTA_DEBUGGER_ERROR ianjuta_debugger_error_quark()

typedef struct _IAnjutaDebugger IAnjutaDebugger;
typedef struct _IAnjutaDebuggerIface IAnjutaDebuggerIface;

typedef enum {
	IANJUTA_DEBUGGER_INFORMATION,
	IANJUTA_DEBUGGER_BREAKPOINT,
	IANJUTA_DEBUGGER_FRAME,
	IANJUTA_DEBUGGER_VARIABLE,
	IANJUTA_DEBUGGER_REGISTER
} IAnjutaDebuggerData;

/* Types */
typedef enum {
	IANJUTA_DEBUGGER_OK              =  0,
	IANJUTA_DEBUGGER_NOT_READY,
	IANJUTA_DEBUGGER_NOT_RUNNING,
	IANJUTA_DEBUGGER_NOT_STOPPED,
	IANJUTA_DEBUGGER_NOT_LOADED,
	IANJUTA_DEBUGGER_NOT_STARTED,
	IANJUTA_DEBUGGER_NOT_CONNECTED,
	IANJUTA_DEBUGGER_NOT_IMPLEMENTED,
	IANJUTA_DEBUGGER_CANCEL,
	IANJUTA_DEBUGGER_UNABLE_TO_CREATE_VARIABLE,
	IANJUTA_DEBUGGER_UNABLE_TO_ACCESS_MEMORY,
	IANJUTA_DEBUGGER_UNABLE_TO_OPEN_FILE,
	IANJUTA_DEBUGGER_UNSUPPORTED_FILE_TYPE,
	IANJUTA_DEBUGGER_UNSUPPORTED_VERSION,
	IANJUTA_DEBUGGER_UNABLE_TO_FIND_DEBUGGER,
	IANJUTA_DEBUGGER_ALREADY_DONE,
	IANJUTA_DEBUGGER_PROGRAM_NOT_FOUND,
	IANJUTA_DEBUGGER_UNKNOWN_ERROR,
	IANJUTA_DEBUGGER_OTHER_ERROR
} IAnjutaDebuggerError;

typedef enum {
	IANJUTA_DEBUGGER_OUTPUT,
	IANJUTA_DEBUGGER_WARNING_OUTPUT,
	IANJUTA_DEBUGGER_ERROR_OUTPUT,
	IANJUTA_DEBUGGER_INFO_OUTPUT
} IAnjutaDebuggerOutputType;

typedef enum {
	IANJUTA_DEBUGGER_BUSY,
	IANJUTA_DEBUGGER_STOPPED,
	IANJUTA_DEBUGGER_STARTED,
	IANJUTA_DEBUGGER_PROGRAM_LOADED,
	IANJUTA_DEBUGGER_PROGRAM_STOPPED,
	IANJUTA_DEBUGGER_PROGRAM_RUNNING
} IAnjutaDebuggerState;

typedef struct _IAnjutaDebuggerFrame IAnjutaDebuggerFrame;
struct _IAnjutaDebuggerFrame {
	gint thread;
	guint level;
	gchar *args;
	gchar *file;
	guint line;
	gchar *function;
	gchar *library;
	gulong address;
};

typedef void (*IAnjutaDebuggerCallback) (const gpointer data, gpointer user_data, GError* err);
typedef void (*IAnjutaDebuggerGListCallback) (const GList* list, gpointer user_data, GError* err);
typedef void (*IAnjutaDebuggerGCharCallback) (const gchar *value, gpointer user_data, GError* err);
typedef void (*IAnjutaDebuggerOutputCallback) (IAnjutaDebuggerOutputType type, const gchar *output, gpointer user_data);
typedef void (*IAnjutaDebuggerMemoryCallback) (gulong address, guint length, const gchar *data, gpointer user_data, GError *err);


struct _IAnjutaDebuggerIface {
	GTypeInterface g_iface;
	
	/* Signal */
	void (*debugger_ready) (IAnjutaDebugger *obj, IAnjutaDebuggerState state);
	/* Signal */
	void (*debugger_started) (IAnjutaDebugger *obj);
	/* Signal */
	void (*debugger_stopped) (IAnjutaDebugger *obj, GError *err);
	/* Signal */
	void (*frame_changed) (IAnjutaDebugger *obj, guint frame,  gint thread);
	/* Signal */
	void (*program_exited) (IAnjutaDebugger *obj);
	/* Signal */
	void (*program_loaded) (IAnjutaDebugger *obj);
	/* Signal */
	void (*program_moved) (IAnjutaDebugger *obj, gint pid,  gint tid,  gulong address,  const gchar* file,  guint line);
	/* Signal */
	void (*program_running) (IAnjutaDebugger *obj);
	/* Signal */
	void (*program_stopped) (IAnjutaDebugger *obj);
	/* Signal */
	void (*sharedlib_event) (IAnjutaDebugger *obj);
	/* Signal */
	void (*signal_received) (IAnjutaDebugger *obj, const gchar* name,  const gchar* description);

	gboolean (*abort) (IAnjutaDebugger *obj, GError **err);
	gboolean (*attach) (IAnjutaDebugger *obj, pid_t pid, const GList* source_search_directories, GError **err);
	gboolean (*callback) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	void (*disable_log) (IAnjutaDebugger *obj, GError **err);
	void (*enable_log) (IAnjutaDebugger *obj, IAnjutaMessageView *log, GError **err);
	gboolean (*evaluate) (IAnjutaDebugger *obj, const gchar* name,  const gchar* value,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*exit) (IAnjutaDebugger *obj, GError **err);
	IAnjutaDebuggerState (*get_state) (IAnjutaDebugger *obj, GError **err);
	gboolean (*handle_signal) (IAnjutaDebugger *obj, const gchar *name,  gboolean stop,  gboolean print,  gboolean ignore, GError **err);
	gboolean (*info_args) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_frame) (IAnjutaDebugger *obj, guint frame,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_program) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_sharedlib) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_signal) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_target) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_thread) (IAnjutaDebugger *obj, gint thread,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_udot) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*info_variables) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*inspect) (IAnjutaDebugger *obj, const gchar* name,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*interrupt) (IAnjutaDebugger *obj, GError **err);
	gboolean (*list_argument) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*list_frame) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*list_local) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*list_register) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*list_thread) (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*load) (IAnjutaDebugger *obj, const gchar *file,  const gchar *mime_type, const GList* source_search_directories, GError **err);
	gboolean (*print) (IAnjutaDebugger *obj, const gchar *variable,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*quit) (IAnjutaDebugger *obj, GError **err);
	gboolean (*run) (IAnjutaDebugger *obj, GError **err);
	gboolean (*run_to) (IAnjutaDebugger *obj, const gchar *uri,  gint line, GError **err);
	gboolean (*send_command) (IAnjutaDebugger *obj, const gchar *command, GError **err);
	gboolean (*set_environment) (IAnjutaDebugger *obj, gchar **env, GError **err);
	gboolean (*set_frame) (IAnjutaDebugger *obj, guint frame, GError **err);
	gboolean (*set_thread) (IAnjutaDebugger *obj, gint thread, GError **err);
	gboolean (*set_working_directory) (IAnjutaDebugger *obj, const gchar *dir, GError **err);
	gboolean (*start) (IAnjutaDebugger *obj, const gchar *args,  gboolean terminal,  gboolean stop, GError **err);
	gboolean (*step_in) (IAnjutaDebugger *obj, GError **err);
	gboolean (*step_out) (IAnjutaDebugger *obj, GError **err);
	gboolean (*step_over) (IAnjutaDebugger *obj, GError **err);
	gboolean (*unload) (IAnjutaDebugger *obj, GError **err);

};
GType ianjuta_debugger_data_get_type (void);
GType ianjuta_debugger_error_get_type (void);
GType ianjuta_debugger_output_type_get_type (void);
GType ianjuta_debugger_state_get_type (void);

GQuark ianjuta_debugger_error_quark     (void);
GType  ianjuta_debugger_get_type        (void);

gboolean ianjuta_debugger_abort (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_attach (IAnjutaDebugger *obj, pid_t pid, const GList* source_search_directories, GError **err);

gboolean ianjuta_debugger_callback (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

void ianjuta_debugger_disable_log (IAnjutaDebugger *obj, GError **err);

void ianjuta_debugger_enable_log (IAnjutaDebugger *obj, IAnjutaMessageView *log, GError **err);

gboolean ianjuta_debugger_evaluate (IAnjutaDebugger *obj, const gchar* name,  const gchar* value,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_exit (IAnjutaDebugger *obj, GError **err);

IAnjutaDebuggerState ianjuta_debugger_get_state (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_handle_signal (IAnjutaDebugger *obj, const gchar *name,  gboolean stop,  gboolean print,  gboolean ignore, GError **err);

gboolean ianjuta_debugger_info_args (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_frame (IAnjutaDebugger *obj, guint frame,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_program (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_sharedlib (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_signal (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_target (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_thread (IAnjutaDebugger *obj, gint thread,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_udot (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_info_variables (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_inspect (IAnjutaDebugger *obj, const gchar* name,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_interrupt (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_list_argument (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_list_frame (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_list_local (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_list_register (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_list_thread (IAnjutaDebugger *obj, IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_load (IAnjutaDebugger *obj, const gchar *file,  const gchar *mime_type, const GList* source_search_directories, GError **err);

gboolean ianjuta_debugger_print (IAnjutaDebugger *obj, const gchar *variable,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_debugger_quit (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_run (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_run_to (IAnjutaDebugger *obj, const gchar *uri,  gint line, GError **err);

gboolean ianjuta_debugger_send_command (IAnjutaDebugger *obj, const gchar *command, GError **err);

gboolean ianjuta_debugger_set_environment (IAnjutaDebugger *obj, gchar **env, GError **err);

gboolean ianjuta_debugger_set_frame (IAnjutaDebugger *obj, guint frame, GError **err);

gboolean ianjuta_debugger_set_thread (IAnjutaDebugger *obj, gint thread, GError **err);

gboolean ianjuta_debugger_set_working_directory (IAnjutaDebugger *obj, const gchar *dir, GError **err);

gboolean ianjuta_debugger_start (IAnjutaDebugger *obj, const gchar *args,  gboolean terminal,  gboolean stop, GError **err);

gboolean ianjuta_debugger_step_in (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_step_out (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_step_over (IAnjutaDebugger *obj, GError **err);

gboolean ianjuta_debugger_unload (IAnjutaDebugger *obj, GError **err);


G_END_DECLS

#endif
