/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-project-backend.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-project-backend
 * @title: IAnjutaProjectBackend
 * @short_description: Interface for creating new project
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-project-backend.h
 * 
 */

#include "ianjuta-project-backend.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_project_backend_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-project-backend-quark");
	}
	
	return quark;
}

/**
 * ianjuta_project_backend_new_project:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Get a new GbfProject
 *
 * Return value: An object derived from GbfProject
 */
GbfProject*
ianjuta_project_backend_new_project (IAnjutaProjectBackend *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT_BACKEND(obj), NULL);
	return IANJUTA_PROJECT_BACKEND_GET_IFACE (obj)->new_project (obj, err);
}

/* Default implementation */
static GbfProject*
ianjuta_project_backend_new_project_default (IAnjutaProjectBackend *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

static void
ianjuta_project_backend_base_init (IAnjutaProjectBackendIface* klass)
{
	static gboolean initialized = FALSE;

	klass->new_project = ianjuta_project_backend_new_project_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_project_backend_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaProjectBackendIface),
			(GBaseInitFunc) ianjuta_project_backend_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaProjectBackend", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
