/* This is -*- C -*- */
/* $Id: guppi-axis-state.h,v 1.12 2001/01/16 23:35:56 trow Exp $ */

/*
 * guppi-axis-state.h
 *
 * Copyright (C) 2000 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@gnu.org> and
 * Havoc Pennington <hp@pobox.com>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _INC_GUPPI_AXIS_STATE_H
#define _INC_GUPPI_AXIS_STATE_H

/* #include <gnome.h> */
#include <guppi-defs.h>
#include <libgnomeprint/gnome-font.h>
#include <guppi-data.h>
#include <guppi-axis-markers.h>

#include <guppi-enums.h>
#include <guppi-element-state.h>

BEGIN_GUPPI_DECLS

typedef struct _GuppiAxisState GuppiAxisState;
typedef struct _GuppiAxisStateClass GuppiAxisStateClass;

struct _GuppiAxisState {
  GuppiElementState parent;

  guppi_compass_t position;

  gboolean show_edge;
  guint32 edge_color;
  double edge_thickness;

  gboolean show_legend;
  gchar *legend;
  guint32 legend_color;
  GnomeFont *legend_font;
  double legend_offset;

  double label_offset;
  gboolean rotate_labels;
  gboolean shrink_labels_to_fit;

  gboolean show_lone_labels;
  double extra_lone_label_offset;
  guint32 lone_label_color;
  GnomeFont *lone_label_font;

  gboolean show_major_ticks;
  guint32 major_tick_color;
  double major_tick_thickness, major_tick_length;
  gboolean show_major_labels;
  guint32 major_label_color;
  GnomeFont *major_label_font;

  gboolean show_minor_ticks;
  guint32 minor_tick_color;
  double minor_tick_thickness, minor_tick_length;
  gboolean show_minor_labels;
  guint32 minor_label_color;
  GnomeFont *minor_label_font;

  gboolean show_micro_ticks;
  guint32 micro_tick_color;
  double micro_tick_thickness, micro_tick_length;
  gboolean show_micro_labels;
  guint32 micro_label_color;
  GnomeFont *micro_label_font;
};

struct _GuppiAxisStateClass {
  GuppiElementStateClass parent_class;
};

#define GUPPI_TYPE_AXIS_STATE (guppi_axis_state_get_type())
#define GUPPI_AXIS_STATE(obj) (GTK_CHECK_CAST((obj),GUPPI_TYPE_AXIS_STATE,GuppiAxisState))
#define GUPPI_AXIS_STATE0(obj) ((obj) ? (GUPPI_AXIS_STATE(obj)) : NULL)
#define GUPPI_AXIS_STATE_CLASS(klass) (GTK_CHECK_CLASS_CAST((klass),GUPPI_TYPE_AXIS_STATE,GuppiAxisStateClass))
#define GUPPI_IS_AXIS_STATE(obj) (GTK_CHECK_TYPE((obj), GUPPI_TYPE_AXIS_STATE))
#define GUPPI_IS_AXIS_STATE0(obj) (((obj) == NULL) || (GUPPI_IS_AXIS_STATE(obj)))
#define GUPPI_IS_AXIS_STATE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GUPPI_TYPE_AXIS_STATE))

GtkType guppi_axis_state_get_type (void);

GuppiElementState *guppi_axis_state_new (void);

GuppiData *guppi_axis_state_data (GuppiAxisState *);

#define guppi_axis_state_position(x) ((x)->position)
#define guppi_axis_state_horizontal(x) \
  ((x)->position == GUPPI_NORTH || (x)->position == GUPPI_SOUTH)
#define guppi_axis_state_vertical(x) \
  ((x)->position == GUPPI_WEST || (x)->position == GUPPI_EAST)

#define guppi_axis_state_show_edge(x) ((x)->show_edge)
#define guppi_axis_state_edge_color(x) ((x)->edge_color)
#define guppi_axis_state_edge_thickness(x) ((x)->edge_thickness)

#define guppi_axis_state_show_legend(x) ((x)->show_legend)
#define guppi_axis_state_legend(x) ((const gchar*)((x)->legend))
#define guppi_axis_state_legend_color(x) ((x)->legend_color)
#define guppi_axis_state_legend_font(x) ((x)->legend_font)
#define guppi_axis_state_legend_offset(x) ((x)->legend_offset)

#define guppi_axis_state_label_offset(x) ((x)->label_offset)
#define guppi_axis_state_extra_lone_label_offset(x) ((x)->extra_lone_label_offset)
#define guppi_axis_state_rotate_labels(x) ((x)->rotate_labels)
#define guppi_axis_state_shrink_labels_to_fit(x) ((x)->shrink_labels_to_fit)

#define guppi_axis_state_show_lone_labels(x) ((x)->show_lone_labels)
#define guppi_axis_state_lone_label_color(x) ((x)->lone_label_color)
#define guppi_axis_state_lone_label_font(x) ((x)->lone_label_font)

#define guppi_axis_state_show_major_ticks(x) ((x)->show_major_ticks)
#define guppi_axis_state_major_tick_color(x) ((x)->major_tick_color)
#define guppi_axis_state_major_tick_thickness(x) ((x)->major_tick_thickness)
#define guppi_axis_state_major_tick_length(x) ((x)->major_tick_length)
#define guppi_axis_state_show_major_labels(x) ((x)->show_major_labels)
#define guppi_axis_state_major_label_color(x) ((x)->major_label_color)
#define guppi_axis_state_major_label_font(x) ((x)->major_label_font)

#define guppi_axis_state_show_minor_ticks(x) ((x)->show_minor_ticks)
#define guppi_axis_state_minor_tick_color(x) ((x)->minor_tick_color)
#define guppi_axis_state_minor_tick_thickness(x) ((x)->minor_tick_thickness)
#define guppi_axis_state_minor_tick_length(x) ((x)->minor_tick_length)
#define guppi_axis_state_show_minor_labels(x) ((x)->show_minor_labels)
#define guppi_axis_state_minor_label_color(x) ((x)->minor_label_color)
#define guppi_axis_state_minor_label_font(x) ((x)->minor_label_font)

#define guppi_axis_state_show_micro_ticks(x) ((x)->show_micro_ticks)
#define guppi_axis_state_micro_tick_color(x) ((x)->micro_tick_color)
#define guppi_axis_state_micro_tick_thickness(x) ((x)->micro_tick_thickness)
#define guppi_axis_state_micro_tick_length(x) ((x)->micro_tick_length)
#define guppi_axis_state_show_micro_labels(x) ((x)->show_micro_labels)
#define guppi_axis_state_micro_label_color(x) ((x)->micro_label_color)
#define guppi_axis_state_micro_label_font(x) ((x)->micro_label_font)



void guppi_axis_state_set_data (GuppiAxisState *, GuppiData *);

void guppi_axis_state_set_position (GuppiAxisState *, guppi_compass_t);

void guppi_axis_state_set_show_edge (GuppiAxisState *, gboolean);
void guppi_axis_state_set_edge_color (GuppiAxisState *, guint32);
void guppi_axis_state_set_edge_thickness (GuppiAxisState *, double);

void guppi_axis_state_set_show_legend (GuppiAxisState *, gboolean);
void guppi_axis_state_set_legend (GuppiAxisState *, const gchar *);
void guppi_axis_state_set_legend_color (GuppiAxisState *, guint32);
void guppi_axis_state_set_legend_font (GuppiAxisState *, GnomeFont *);
void guppi_axis_state_set_legend_offset (GuppiAxisState *, double);

void guppi_axis_state_set_label_offset (GuppiAxisState *, double);
void guppi_axis_state_set_rotate_labels (GuppiAxisState *, gboolean);
void guppi_axis_state_set_shrink_labels_to_fit (GuppiAxisState *, gboolean);

void guppi_axis_state_set_show_lone_labels (GuppiAxisState *, gboolean);
void guppi_axis_state_set_lone_label_color (GuppiAxisState *, guint32);
void guppi_axis_state_set_lone_label_font (GuppiAxisState *, GnomeFont *);

void guppi_axis_state_set_show_major_ticks (GuppiAxisState *, gboolean);
void guppi_axis_state_set_major_tick_color (GuppiAxisState *, guint32);
void guppi_axis_state_set_major_tick_thickness (GuppiAxisState *, double);
void guppi_axis_state_set_major_tick_length (GuppiAxisState *, double);
void guppi_axis_state_set_show_major_labels (GuppiAxisState *, gboolean);
void guppi_axis_state_set_major_label_color (GuppiAxisState *, guint32);
void guppi_axis_state_set_major_label_font (GuppiAxisState *, GnomeFont *);

void guppi_axis_state_set_show_minor_ticks (GuppiAxisState *, gboolean);
void guppi_axis_state_set_minor_tick_color (GuppiAxisState *, guint32);
void guppi_axis_state_set_minor_tick_thickness (GuppiAxisState *, double);
void guppi_axis_state_set_minor_tick_length (GuppiAxisState *, double);
void guppi_axis_state_set_show_minor_labels (GuppiAxisState *, gboolean);
void guppi_axis_state_set_minor_label_color (GuppiAxisState *, guint32);
void guppi_axis_state_set_minor_label_font (GuppiAxisState *, GnomeFont *);

void guppi_axis_state_set_show_micro_ticks (GuppiAxisState *, gboolean);
void guppi_axis_state_set_micro_tick_color (GuppiAxisState *, guint32);
void guppi_axis_state_set_micro_tick_thickness (GuppiAxisState *, double);
void guppi_axis_state_set_micro_tick_length (GuppiAxisState *, double);
void guppi_axis_state_set_show_micro_labels (GuppiAxisState *, gboolean);
void guppi_axis_state_set_micro_label_color (GuppiAxisState *, guint32);
void guppi_axis_state_set_micro_label_font (GuppiAxisState *, GnomeFont *);



void guppi_axis_state_tick_properties (const GuppiAxisState *,
				       const GuppiTick *,
				       gboolean * show_tick,
				       guint32 * color,
				       double *thickness,
				       double *length,
				       gboolean * show_label,
				       double *label_offset,
				       guint32 * label_color,
				       GnomeFont ** label_font);

const gchar *guppi_axis_state_displayed_legend (GuppiAxisState *);
double guppi_axis_state_legend_span (GuppiAxisState *);

double guppi_axis_state_maximum_span (GuppiAxisState *, GuppiAxisMarkers *);

double guppi_axis_state_label_shrink_to_fit_factor (GuppiAxisState *,
						    GuppiAxisMarkers *,
						    double span);

END_GUPPI_DECLS

#endif /* _INC_GUPPI_AXIS_STATE_H */

/* $Id: guppi-axis-state.h,v 1.12 2001/01/16 23:35:56 trow Exp $ */
