'''Wrappers for Guppi's plotting plug-ins. Most of this file is autogenerated.
'''

import _guppi
from Guppi import *

class LazyModule:
    '''This class is needed to implement lazy loading of plugins.
    To facilitate the use of a module M, we create a LazyModule with name
    "M". When someone tries to access object M.x, the LazyModule instance
    imports the _real_ module M, gives up its ownership of the name M to 
    the new module M, and then fulfills the original request.

    Note that this only works in the same namespace, so you can't
    import this module and then use LazyModule in another namespace 
    and expect it to work.
        
    name = name of the real module.'''
        
    def __init__(self, name):
	self.name = name
    def __getattr__(self, attr):
        self.initModule()
	exec ('''import %(m)s
_x=%(m)s
global %(m)s
%(m)s = _x''' % {'m' : self.name})
	return getattr(_x, attr)

    def initModule(self):
        '''overload this method to initialize the module'''
        pass


class LazyPluginModule(LazyModule):
    '''A LazyModule which initializes a Guppi plugin and loads its module.'''
    def __init__(self, name, plugin_type, plugin_code):
        LazyModule.__init__(self, name)
        self.plugin_type = plugin_type
        self.plugin_code = plugin_code
        
    def initModule(self):
        _guppi.load_plug_in(self.plugin_type, self.plugin_code)
